/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.common.model.advertexplore.expcontroller;

import cn.com.duiba.nezha.alg.common.model.advertexplore.ExpHourData;
import cn.com.duiba.nezha.alg.common.model.advertexplore.HourDto;
import cn.com.duiba.nezha.alg.common.model.advertexplore.WeightDimEnum;
import cn.com.duiba.nezha.alg.common.model.advertexplore.WeightInfo;
import cn.com.duiba.nezha.alg.common.util.DataUtil;

class ConsumePIDController {
    ConsumePIDController() {
    }

    public static WeightInfo calcControlFactor(ExpHourData expHourData, Double upperBound, Double lowerBound, Double kp, Double ki, WeightDimEnum dim) {
        HourDto lastHourDto = expHourData.getHourDtoMap().get(expHourData.getLastHour());
        double errorCurrent = ConsumePIDController.errorDiff(lastHourDto);
        double errorIntegral = ConsumePIDController.errorIntegral(expHourData);
        double kt = kp * errorCurrent + ki * errorIntegral;
        double unboundK = ConsumePIDController.responseFunc(kt);
        double k = ConsumePIDController.bound(unboundK, upperBound, lowerBound);
        return new WeightInfo(dim.getId(), 0L, DataUtil.formatDouble(errorCurrent, 5), DataUtil.formatDouble(k, 5));
    }

    private static double errorDiff(HourDto lastHourDto) {
        double result = lastHourDto.getAFee() - lastHourDto.getOcpcChargeFees();
        return result;
    }

    private static double errorIntegral(ExpHourData expHourData) {
        double result = 0.0;
        for (HourDto hourDto : expHourData.getHourDtoMap().values()) {
            result = result + (double)hourDto.getAFee().longValue() - (double)hourDto.getOcpcChargeFees().longValue();
        }
        return result;
    }

    private static double responseFunc(double kt) {
        return Math.exp(kt);
    }

    private static double bound(Double value, Double upperBound, Double lowerBound) {
        if (value > upperBound) {
            return upperBound;
        }
        if (value < lowerBound) {
            return lowerBound;
        }
        return value;
    }
}

