package cn.com.duiba.nezha.alg.common.util;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class MathUtil {

    public static double[] reciprocalOfNCache = {
            1.0,
            1.0000,
            0.5000,
            0.3333,
            0.2500,
            0.2000,
            0.1667,
            0.1429,
            0.1250,
            0.1111,
            0.1000,// 1/10
            0.0909,
            0.0833,
            0.0769,
            0.0714,
            0.0667,
            0.0625,
            0.0588,
            0.0556,
            0.0526,
            0.0500,// 1/20
            0.0476,
            0.0455,
            0.0435,
            0.0417,
            0.0400,
            0.0385,
            0.0370,
            0.0357,
            0.0345,
            0.0333,// 1/30
            0.0323,
            0.0313,
            0.0303,
            0.0294,
            0.0286,
            0.0278,
            0.0270,
            0.0263,
            0.0256,
            0.0250  //   1/40
    };

    public static double reciprocalOfN(Integer n) {
        double ret = 1.0;
        if (n != null && n <= 40) {
            ret = reciprocalOfNCache[n];
        } else if (n != null) {
            ret = division(1.0, n, 4);
        }
        return ret;
    }


    // sigmoid function: 1 / (1 + exp(-z))
    public static double sigmoid(double value) {
        return 1 / (1 + Math.exp(-1 * value));
    }

    public static double stdwithBoundary(double value, double lowB, double upB) {

        return value < lowB ? lowB : (value > upB ? upB : value);


    }

    public static Long dot(Long v1, Double v2) {
        Long ret = 0L;
        if (v1 != null && v2 != null) {
            Double tmp = v1 * v2;
            ret = double2long(tmp);
        }
        return ret;
    }


    public static Double dot(Double v1, Double v2, int newScala) {
        Double ret = 0.0;
        if (v1 != null && v2 != null) {
            Double tmp = v1 * v2;
            ret = formatDouble(tmp, newScala);
        }
        return ret;
    }


    public static Double dotPow(Double price, Double Ctr, Double ctrFactor, Double Lower,Double Upper, int newScala) {
        double ret = 0.0;
        if (ctrFactor == null) {
            ctrFactor = 1.0;
        }
        if (price != null && Ctr != null) {
            double tmp = price * Math.pow(Ctr, ctrFactor);
            ret = formatDouble(tmp, newScala);
        }
        return ret;
    }


    public static Double division(Long v1, Long v2, int newScala) {
        Double ret = null;
        if (v1 != null && v2 != null && v2 >= 1) {
            ret = division(toDouble(v1), toDouble(v2), newScala);
        }
        return ret;
    }


    public static double division(double v1, int v2, int newScala) {
        double ret = 0;
        if (v2 >= 1) {
            ret = v1 / v2;
            ret = formatDouble(ret, newScala);
        }
        return ret;
    }


    public static Double division(Double v1, Double v2, int newScala) {
        Double ret = null;
        if (v1 != null && v2 != null && v2 >= 1) {
            ret = v1 / v2;
            if (ret != null) {
                ret = formatDouble(ret.doubleValue(), newScala);
            }
        }
        return ret;
    }


    public static Double division(Long v1, Double v2, int newScala) {
        Double ret = null;
        if (v1 != null && v2 != null && v2 >= 1) {
            ret = v1 / v2;
            if (ret != null) {
                ret = formatDouble(ret.doubleValue(), newScala);
            }
        }
        return ret;
    }

    public static Double division(Double v1, Long v2, int newScala) {
        Double ret = null;
        if (v1 != null && v2 != null && v2 >= 1) {
            ret = division(v1, toDouble(v2), newScala);
        }
        return ret;
    }


    public static Long division(Long v1, Long v2) {
        Long ret = null;
        if (v1 != null && v2 != null && v2 >= 1) {
            Double d = toDouble(v1) / toDouble(v2);
            if (d != null) {
                ret = Math.round(d);
            }
        }
        return ret;
    }

    public static Double add(Double v1, Double v2) {
        if (v1 != null && v2 != null) {
            return v1 + v2;
        } else if (v1 != null) {
            return v1;
        } else {
            return v2;
        }
    }

    public static Long double2long(Double value) {
        Long ret = 0L;

        if (value != null) {
            ret = value.longValue();
        }
        return ret;
    }

    /**
     * 数据类型转换
     *
     * @param v1
     * @return
     */
    public static Double toDouble(Long v1) {
        Double ret = 0.0;
        if (v1 != null) {
            ret = v1 + 0.0;
        }
        return ret;
    }

    /**
     * 数据类型转换
     *
     * @param v1
     * @return
     */
    public static double toddouble(Double v1) {
        double ret = 0.0;
        if (v1 != null) {
            ret = v1 + 0.0;
        }
        return ret;
    }


    /**
     * DecimalFormat is a concrete subclass of NumberFormat that formats decimal numbers.
     *
     * @param d
     * @return
     */
    public static double formatDouble(double d, int newScala) {
        BigDecimal bg = new BigDecimal(d).setScale(newScala, RoundingMode.UP);

        return bg.doubleValue();
    }

    public static void main(String[] args) {


        for (int i = 0; i < 50; i++) {
            System.out.println(i + "," + reciprocalOfN(i));
        }
    }
}