/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.common.model.advertexplore.expcontroller;

import cn.com.duiba.nezha.alg.common.model.advertexplore.ExpHourData;
import cn.com.duiba.nezha.alg.common.model.advertexplore.HourDto;
import cn.com.duiba.nezha.alg.common.model.advertexplore.WeightDimEnum;
import cn.com.duiba.nezha.alg.common.model.advertexplore.WeightInfo;
import cn.com.duiba.nezha.alg.common.util.DataUtil;

class InverseController {
    InverseController() {
    }

    public static WeightInfo calcControlFactor(ExpHourData advertPkExpV1, Integer convertSubType, Double upperBound, Double lowerBound, Long controlClickCntThreshold, WeightDimEnum dim) {
        double avgMergeCvr = advertPkExpV1.getMergeCvr24Hour();
        double statCvr = advertPkExpV1.getCvr24Hour(convertSubType);
        long cumClickCnt = 0L;
        for (HourDto hourDto : advertPkExpV1.getHourDtoMap().values()) {
            cumClickCnt += hourDto.getClickCnt().longValue();
        }
        double result = 1.0;
        if (cumClickCnt < controlClickCntThreshold) {
            result = 1.0;
        } else {
            double controlFactor = statCvr / (avgMergeCvr + 1.0E-6);
            result = InverseController.bound(controlFactor, upperBound, lowerBound);
        }
        return new WeightInfo(dim.getId(), 0L, 0.0, DataUtil.formatDouble(result, 5));
    }

    private static double bound(Double value, Double upperBound, Double lowerBound) {
        if (value > upperBound) {
            return upperBound;
        }
        if (value < lowerBound) {
            return lowerBound;
        }
        return value;
    }
}

