package cn.com.duiba.nezha.alg.common.model.feedback;

import cn.com.duiba.nezha.alg.common.model.pacing.OrientInfo;
import cn.com.duiba.nezha.alg.common.model.pacing.TrusteeshipParams;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeedBack {

    private static final Logger logger = LoggerFactory.getLogger(FeedBack.class);

    public static String autoManageFeedBack(OrientInfo orient, TrusteeshipParams trusteeshipParams,Double blackRealse) {
        Long targetAfee=orient.getTarget()!=0?orient.getTarget():1;
        Long importantAppAfee=orient.getImportantAppAfee();
        Long target=importantAppAfee!=null?importantAppAfee:targetAfee;
        Double orientCostG1d = orient.getOrientCostG1d() != null ? orient.getOrientCostG1d() : 0.0;             //配置消耗
        Double orientConvert = orient.getOrientConvertG1d();
        Double orientConfidence = orientCostG1d/(target*5);  //配置置信度
        Double orientCostConvert = (orientConvert != 0 && orientCostG1d != 0) ? orientCostG1d / orientConvert : target;       //配置当天实际成本
        Double orientCostConvertbias = (orientConvert != 0) ? orientCostConvert / target : orientCostG1d / target;        //配置当天实际成本与目标成本偏差
        Integer releaseTarget=orient.getReleaseTarget();

        Double slotOrientationCost=orient.getSlotOrientationCost()!=null?orient.getSlotOrientationCost():0.0;          //广告位+配置粒度消耗
        Double slotOrientationConvert=orient.getSlotOrientationConvert()!=null?orient.getSlotOrientationConvert():0.0;   //广告位+配置粒度转化量
        Double slotOrientationConfidence=slotOrientationCost/(target*5);  //广告位+配置粒度置信度
        Double slotOrientationCostConvert=(slotOrientationCost!=0 && slotOrientationConvert!=0)?slotOrientationCost/slotOrientationConvert:target;  //广告位+配置粒度实时成本
        Double slotOrientationCostConvertBias=(slotOrientationConvert!=0) ? slotOrientationCostConvert / target : slotOrientationCost / target;  //广告位+配置粒度实时成本偏差

        Double slotAdvertCost=orient.getSlotAdvertCost()!=null?orient.getSlotAdvertCost():0.0;          //广告位+广告粒度消耗
        Double slotAdvertConvert=orient.getSlotAdvertConvert()!=null?orient.getSlotAdvertConvert():0.0;   //广告位+广告粒度转化量
        Double slotAdvertConfidence=slotAdvertCost/(target*5);  //广告位+广告粒度置信度
        Double slotAdvertCostConvert=(slotAdvertCost!=0 && slotAdvertConvert!=0)?slotAdvertCost/slotAdvertConvert:target;  //广告位+广告粒度实时成本
        Double slotAdvertCostConvertBias=(slotAdvertConvert!=0) ? slotAdvertCostConvert / target : slotAdvertCost / target;  //广告位+广告粒度实时成本偏差

        String label="";
        Long currentTime = DataUtil.string2Long(LocalDateUtil.getCurrentLocalDateTime("HH"));
        if (releaseTarget==1) {
            //熔断
            TrusteeshipParams.ReleaseTarget1FeedBackParams feedBackparams1=trusteeshipParams.getReleaseTarget1feedBackParams();
            if (currentTime >= 8L && orientCostG1d > feedBackparams1.getFuse1OrientCostG1dFactor() && orientCostG1d > 5 * target && orientConvert == 0) {
                label = "fuse1";
            } else if (currentTime >= 8L && orientCostG1d > feedBackparams1.getFuse2OrientCostG1dFactor() && orientCostConvertbias > feedBackparams1.getFuseOrientCostConvertBiasFactor()) {
                label = "fuse2";
            } else if (currentTime < 8L && orientCostG1d > feedBackparams1.getFuse1OrientCostG1dFactor() && orientCostG1d > 8 * target && orientConvert == 0) {
                label = "fuse1";
            } else if (currentTime < 8L && orientCostG1d > feedBackparams1.getFuse2OrientCostG1dFactor() && orientCostConvertbias > 1.5 * feedBackparams1.getFuseOrientCostConvertBiasFactor()) {
                label = "fuse2";
            } else {
                //黑白名单
                //根据广告位+配置粒度
                if (slotAdvertConfidence >= feedBackparams1.getwSlotOrientationConfidenceFactor() && slotAdvertCostConvertBias <= Math.max(feedBackparams1.getwSlotOrientationCostConvertBiasFactor() / orientCostConvertbias, 1.0)) {
                    label = "w";
                }
                if (slotOrientationConfidence >= feedBackparams1.getwSlotOrientationConfidenceFactor() && slotOrientationCostConvertBias <= Math.max(feedBackparams1.getwSlotOrientationCostConvertBiasFactor() / orientCostConvertbias, 1.0)) {
                    label = "w";
                }
                if (orientConfidence >= feedBackparams1.getbOrientConfidenceFactor() && orientCostConvertbias > feedBackparams1.getbOrientCostConvertBiasFactor() && slotOrientationConfidence >= feedBackparams1.getbSlotOrientationConfidenceFactor() && slotOrientationCostConvertBias > blackRealse * Math.max(1.2, feedBackparams1.getbSlotOrientationCostConvertBiasFactor() / (orientCostConvertbias * orientCostConvertbias))) {
                    label = "b";
                }

            }
        } else if (releaseTarget==2){
            TrusteeshipParams.ReleaseTarget2FeedBackParams feedBackparams2=trusteeshipParams.getReleaseTarget2feedBackParams();
            //熔断
            if (currentTime >= 8L && orientCostG1d > feedBackparams2.getFuse1OrientCostG1dFactor() && orientCostG1d > 5 * target && orientConvert == 0) {
                label = "fuse1";
            } else if (currentTime >= 8L && orientCostG1d > feedBackparams2.getFuse2OrientCostG1dFactor() && orientCostConvertbias > feedBackparams2.getFuseOrientCostConvertBiasFactor()) {
                label = "fuse2";
            } else if (currentTime < 8L && orientCostG1d > feedBackparams2.getFuse1OrientCostG1dFactor() && orientCostG1d > 8 * target && orientConvert == 0) {
                label = "fuse1";
            } else if (currentTime < 8L && orientCostG1d > feedBackparams2.getFuse2OrientCostG1dFactor() && orientCostConvertbias > 1.5 * feedBackparams2.getFuseOrientCostConvertBiasFactor()) {
                label = "fuse2";
            } else {
                //黑白名单
                //根据广告位+配置粒度
                if (slotOrientationConfidence >= feedBackparams2.getwSlotOrientationConfidenceFactor() && slotOrientationCostConvertBias <= Math.max(feedBackparams2.getwSlotOrientationCostConvertBiasFactor() / orientCostConvertbias, 1.0)) {
                    label = "w";
                }
                if (slotAdvertConfidence >= feedBackparams2.getwSlotOrientationConfidenceFactor() && slotAdvertCostConvertBias <= Math.max(feedBackparams2.getwSlotOrientationCostConvertBiasFactor() / orientCostConvertbias, 1.0)) {
                    label = "w";
                }
                if (orientConfidence >= feedBackparams2.getbOrientConfidenceFactor() && orientCostConvertbias > feedBackparams2.getbOrientCostConvertBiasFactor() && slotOrientationConfidence >= feedBackparams2.getbSlotOrientationConfidenceFactor() && slotOrientationCostConvertBias > blackRealse * Math.max(1.2, feedBackparams2.getbSlotOrientationCostConvertBiasFactor() / (orientCostConvertbias * orientCostConvertbias))) {
                    label = "b";
                }
            }
        } else{
            TrusteeshipParams.ReleaseTarget3FeedBackParams feedBackparams3=trusteeshipParams.getReleaseTarget3feedBackParams();
            //熔断
            if (currentTime >= 8L && orientCostG1d > feedBackparams3.getFuse1OrientCostG1dFactor() && orientCostG1d > 5 * target && orientConvert == 0) {
                label = "fuse1";
            } else if (currentTime >= 8L && orientCostG1d > feedBackparams3.getFuse2OrientCostG1dFactor() && orientCostConvertbias > feedBackparams3.getFuseOrientCostConvertBiasFactor()) {
                label = "fuse2";
            } else if (currentTime < 8L && orientCostG1d > feedBackparams3.getFuse1OrientCostG1dFactor() && orientCostG1d > 8 * target && orientConvert == 0) {
                label = "fuse1";
            } else if (currentTime < 8L && orientCostG1d > feedBackparams3.getFuse2OrientCostG1dFactor() && orientCostConvertbias > 1.5 * feedBackparams3.getFuseOrientCostConvertBiasFactor()) {
                label = "fuse2";
            } else {
                //黑白名单
                //根据广告位+配置粒度
                if (slotOrientationConfidence >= feedBackparams3.getwSlotOrientationConfidenceFactor() && slotOrientationCostConvertBias <= Math.max(feedBackparams3.getwSlotOrientationCostConvertBiasFactor() / orientCostConvertbias, 1.0)) {
                    label = "w";
                }
                if (slotAdvertConfidence >= feedBackparams3.getwSlotOrientationConfidenceFactor() && slotAdvertCostConvertBias <= Math.max(feedBackparams3.getwSlotOrientationCostConvertBiasFactor() / orientCostConvertbias, 1.0)) {
                    label = "w";
                }
                if (orientConfidence >= feedBackparams3.getbOrientConfidenceFactor() && orientCostConvertbias > feedBackparams3.getbOrientCostConvertBiasFactor() && slotOrientationConfidence >= feedBackparams3.getbSlotOrientationConfidenceFactor() && slotOrientationCostConvertBias > blackRealse * Math.max(1.2, feedBackparams3.getbSlotOrientationCostConvertBiasFactor() / (orientCostConvertbias * orientCostConvertbias))) {
                    label = "b";
                }
            }
        }
        return label;
    }
}
