/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.common.model.mainmeetselect;

import cn.com.duiba.nezha.alg.common.model.mainmeetselect.ActivityInfo;
import cn.com.duiba.nezha.alg.common.model.mainmeetselect.BetaDistribution;
import cn.com.duiba.nezha.alg.common.model.mainmeetselect.MainMeet;
import cn.com.duiba.nezha.alg.common.model.mainmeetselect.WilsonInterval;
import cn.com.duiba.nezha.alg.common.model.mainmeetselect.WilsonPair;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivitySelector {
    private static final Logger logger = LoggerFactory.getLogger(ActivitySelector.class);
    public static Comparator<MatchInfo> iComparator = new Comparator<MatchInfo>(){

        @Override
        public int compare(MatchInfo c1, MatchInfo c2) {
            return c2.score - c1.score >= 0.0 ? 1 : -1;
        }
    };

    public static int getCoef(double hisRequest, double request, double hisClick, double click) {
        int coef = 1;
        int i = 1;
        int j = 1;
        if (request < 0.0) {
            for (i = 1; i < 144 && !((request += hisRequest / 144.0) > 0.0); ++i) {
            }
        }
        if (click < 0.0) {
            for (j = 1; j < 144 && !((click += hisClick / 144.0) > 0.0); ++j) {
            }
        }
        return coef += Math.max(i, j);
    }

    public static List<ActivityInfo> match(List<ActivityInfo> activityInfos, int topn) {
        ArrayList<ActivityInfo> result = new ArrayList<ActivityInfo>();
        PriorityQueue<MatchInfo> candis = new PriorityQueue<MatchInfo>(activityInfos.size(), iComparator);
        PriorityQueue<MatchInfo> slotCandis = new PriorityQueue<MatchInfo>(activityInfos.size(), iComparator);
        PriorityQueue<MatchInfo> appCandis = new PriorityQueue<MatchInfo>(activityInfos.size(), iComparator);
        PriorityQueue<MatchInfo> globalCandis = new PriorityQueue<MatchInfo>(activityInfos.size(), iComparator);
        for (ActivityInfo activity : activityInfos) {
            try {
                MatchInfo info2;
                if (activity.source != 1L || !activity.valid) continue;
                activity.hisClick.globalVal = activity.click.globalVal;
                activity.hisClick.appVal = activity.click.appVal;
                activity.hisClick.slotVal = activity.directClick.slotVal;
                activity.hisCost.globalVal = activity.cost.globalVal;
                activity.hisCost.appVal = activity.cost.appVal;
                activity.hisCost.slotVal = activity.directCost.slotVal;
                activity.hisRequest.globalVal = activity.request.globalVal;
                activity.hisRequest.appVal = activity.request.appVal;
                activity.hisRequest.slotVal = activity.directRequest.slotVal;
                int limit = topn--;
                if (activity.hisRequest.globalVal < 100.0) {
                    System.out.println(activity.activityId + "************************");
                    if (System.currentTimeMillis() - activity.createTime < 259200000L) {
                        if (!(Math.random() < 1.0E-4)) continue;
                        result.add(activity);
                        continue;
                    }
                    if (activityInfos.size() <= limit || !(Math.random() < 1.0E-5)) continue;
                    result.add(activity);
                    --topn;
                    continue;
                }
                double slotScore = WilsonInterval.wilsonCalc((long)((long)activity.hisClick.slotVal), (long)((long)activity.hisRequest.slotVal * 3L)).lowerBound;
                double globalScore = WilsonInterval.wilsonCalc((long)((long)activity.hisClick.globalVal), (long)((long)activity.hisRequest.globalVal * 3L)).lowerBound;
                double appScore = WilsonInterval.wilsonCalc((long)((long)activity.hisClick.appVal), (long)((long)activity.hisRequest.appVal * 3L)).lowerBound;
                double coef = 0.0;
                double matchscore = 0.0;
                double sconfidence = Math.min(activity.hisRequest.slotVal / 100.0, 1.0);
                double aconfidence = Math.min(activity.hisRequest.appVal / 100.0, 1.0);
                double gconfidence = Math.min(activity.hisRequest.globalVal / 1000.0, 1.0);
                matchscore = sconfidence * slotScore + (1.0 - sconfidence) * aconfidence * appScore * 0.9 + (1.0 - sconfidence - (1.0 - sconfidence) * aconfidence) * globalScore * Math.max(0.5, gconfidence);
                System.out.println("activity.activityId=" + activity.activityId + " mainMeetId=" + activity.mainMeetId + " matchscore=" + matchscore);
                System.out.println(activity.hisClick.slotVal + " " + activity.hisClick.globalVal + " " + activity.hisRequest.globalVal + " ");
                MatchInfo info = new MatchInfo();
                info.act = activity;
                info.score = matchscore;
                candis.add(info);
                if (sconfidence > 0.99 || activity.hisClick.slotVal > 5.0) {
                    info2 = new MatchInfo();
                    info2.act = activity;
                    info2.score = activity.hisRequest.slotVal > 0.0 ? activity.hisCost.slotVal / activity.hisRequest.slotVal : 0.0;
                    slotCandis.add(info2);
                }
                if (!(aconfidence > 0.99) && !(activity.hisClick.slotVal > 5.0)) continue;
                info2 = new MatchInfo();
                info2.act = activity;
                info2.score = activity.hisRequest.appVal > 0.0 ? activity.hisCost.appVal / activity.hisRequest.appVal : 0.0;
                appCandis.add(info2);
            }
            catch (Exception e) {
                logger.error("error, act:{}", (Object)JSON.toJSONString((Object)activity));
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        HashSet<Long> idset = new HashSet<Long>();
        int size1 = slotCandis.size();
        for (int i = 0; i < 10 && i < size1; ++i) {
            ActivityInfo act = ((MatchInfo)slotCandis.poll()).act;
            result.add(act);
            idset.add(act.activityId);
        }
        if (result.size() < topn) {
            int count = topn;
            for (ActivityInfo activity : activityInfos) {
                if (activity.source != 1L || !activity.valid || idset.contains(activity.activityId)) continue;
                idset.add(activity.activityId);
                activity.hisClick.globalVal = activity.click.globalVal;
                activity.hisClick.appVal = activity.click.appVal;
                activity.hisClick.slotVal = activity.directClick.slotVal;
                activity.hisCost.globalVal = activity.cost.globalVal;
                activity.hisCost.appVal = activity.cost.appVal;
                activity.hisCost.slotVal = activity.directCost.slotVal;
                activity.hisRequest.globalVal = activity.request.globalVal;
                activity.hisRequest.appVal = activity.request.appVal;
                activity.hisRequest.slotVal = activity.directRequest.slotVal;
                result.add(activity);
                if (++count < topn) continue;
                break;
            }
        }
        return result;
    }

    public static MainMeet select(MainMeet mainMeet) {
        List<ActivityInfo> activityInfos = mainMeet.activityInfo;
        ArrayList<Double> rewards = new ArrayList<Double>();
        ArrayList<Double> counts = new ArrayList<Double>();
        ArrayList<Double> alphas = new ArrayList<Double>();
        ArrayList<Double> betas = new ArrayList<Double>();
        ArrayList<ActivityInfo> candiList = new ArrayList<ActivityInfo>();
        double decay = Constant.DECAY;
        int size = 0;
        HashMap<Long, RankInfo> mMap = new HashMap<Long, RankInfo>();
        double maxG = Constant.MIN_REWARD;
        double maxH = Constant.MIN_REWARD;
        double maxA = Constant.MIN_REWARD;
        ArrayList totalResult = new ArrayList();
        ActivityInfo result = new ActivityInfo();
        MainMeet mainmeet = new MainMeet();
        try {
            List<ActivityInfo> MainMeetAndActivityInfos = ActivitySelector.mainMeettoActivity(activityInfos, mainMeet.mainMeetActivitysList);
            List<ActivityInfo> matchActivityInfos = ActivitySelector.match(MainMeetAndActivityInfos, Constant.SEARANK_TOPN);
            size = MainMeetAndActivityInfos.size();
            for (ActivityInfo act : matchActivityInfos) {
                double hrpm;
                double grpm;
                RankInfo info = mMap.containsKey(act.activityId) ? (RankInfo)mMap.get(act.activityId) : new RankInfo();
                info.grpm = grpm = act.hisRequest.globalVal > 0.0 ? act.hisClick.globalVal / act.hisRequest.globalVal : 0.0;
                info.gexp = act.hisRequest.globalVal;
                maxG = Math.max(grpm, maxG);
                System.out.println(act.mainMeetId + " " + act.activityId + " hisClick.globalVal=" + act.hisClick.globalVal + " hisRequest.globalVal=" + act.hisRequest.globalVal + " grpm=" + grpm);
                double arpm = act.hisRequest.appVal > 0.0 ? act.hisCost.appVal / act.hisRequest.appVal : 0.0;
                System.out.println(act.mainMeetId + " " + act.activityId + " hisCost.appVal=" + act.hisCost.appVal + " hisRequest.appVal=" + act.hisRequest.appVal + " arpm=" + arpm);
                info.arpm = arpm;
                info.aexp = act.hisRequest.appVal;
                if (info.hexp > 50.0) {
                    maxA = Math.max(arpm, maxA);
                }
                info.hrpm = hrpm = act.hisRequest.slotVal > 0.0 ? act.hisCost.slotVal / act.hisRequest.slotVal : 0.0;
                info.hexp = act.hisRequest.slotVal;
                if (info.hexp > 50.0) {
                    maxH = Math.max(hrpm, maxH);
                }
                System.out.println(act.mainMeetId + " " + act.activityId + " hisCost.slotVal=" + act.hisCost.slotVal + " hisRequest.slotVal=" + act.hisRequest.slotVal + " hrpm=" + hrpm);
                mMap.put(act.activityId, info);
            }
            for (ActivityInfo act : matchActivityInfos) {
                if (act.request.globalVal > 0.0) {
                    double reward = Constant.MIN_REWARD;
                    double sconfidence = Math.min(act.hisRequest.slotVal / 60.0, 1.0);
                    double aconfidence = Math.min(act.hisRequest.appVal / 60.0, 1.0);
                    reward = sconfidence * ActivitySelector.normlize(((RankInfo)mMap.get((Object)Long.valueOf((long)act.activityId))).hrpm * 0.8, maxH, 0.8) + (1.0 - sconfidence) * aconfidence * ActivitySelector.normlize(((RankInfo)mMap.get((Object)Long.valueOf((long)act.activityId))).arpm * 0.7, maxA, 0.7) + (1.0 - sconfidence - (1.0 - sconfidence) * aconfidence) * ActivitySelector.normlize(((RankInfo)mMap.get((Object)Long.valueOf((long)act.activityId))).grpm * 0.5, maxG, 0.6);
                    reward *= reward;
                    reward = Math.max(reward, Constant.MIN_REWARD);
                    act.reward = act.reward * decay + reward;
                    act.count = act.count * decay + 1.0;
                    System.out.println("mainMeetId=" + act.mainMeetId + " activityId=" + act.activityId + " " + act.reward / act.count);
                    long oneday = 86400000L;
                    if ((sconfidence > 0.99 || System.currentTimeMillis() - act.updateTime > oneday) && (act.reward / act.count < 0.6 * reward || act.reward / act.count > 1.6 * reward)) {
                        act.reward = 10.0 * reward;
                        act.count = 10.0;
                    }
                    act.alpha = 1.5 + act.reward;
                    act.beta = 2.0 + (act.count - act.reward);
                }
                rewards.add(act.reward);
                counts.add(act.count);
                alphas.add(act.alpha);
                betas.add(act.beta);
                candiList.add(act);
            }
            int numMachines = candiList.size();
            result = (ActivityInfo)candiList.get(ActivitySelector.selectMachine(alphas, betas, numMachines));
            if (System.currentTimeMillis() - result.updateTime > 60000L) {
                result.isUpdate = true;
            }
            mMap.clear();
            result.lastRequest.appVal = result.request.appVal;
            result.lastRequest.slotVal = result.request.slotVal;
            result.lastRequest.globalVal = result.request.globalVal;
            result.lastClick.appVal = result.click.appVal;
            result.lastClick.slotVal = result.click.slotVal;
            result.lastClick.globalVal = result.click.globalVal;
            result.lastCost.appVal = result.cost.appVal;
            result.lastCost.slotVal = result.cost.slotVal;
            result.lastCost.globalVal = result.cost.globalVal;
            ActivityInfo saveAct = new ActivityInfo();
            if (result.mainMeetId != -1L) {
                mainmeet.activityInfo = ActivitySelector.setParam(ActivitySelector.getAllMainMeet(activityInfos).get(result.mainMeetId), result);
            } else {
                ArrayList<ActivityInfo> actSelect = new ArrayList<ActivityInfo>();
                actSelect.add(result);
                mainmeet.activityInfo = actSelect;
            }
            mainmeet.mainMeetActivitysList = ActivitySelector.getNewMainMeetRelation(activityInfos);
            return mainmeet;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            logger.error("error, size:{},candi:{},list:{},", new Object[]{size, JSON.toJSONString(candiList), JSON.toJSONString(activityInfos)});
            return mainmeet;
        }
    }

    public static void print(ActivityInfo act) {
        System.out.println("-----------" + act.mainMeetId + "-----------");
        System.out.println("-----------" + act.activityId + "-----------");
        System.out.println("request = " + act.directRequest.slotVal + "\t" + act.request.appVal + "\t" + act.request.globalVal);
        System.out.println("click = " + act.directClick.slotVal + "\t" + act.click.appVal + "\t" + act.click.globalVal);
        System.out.println("cost = " + act.directCost.slotVal + "\t" + act.cost.appVal + "\t" + act.cost.globalVal);
        System.out.println("lastRequest = " + act.lastRequest.slotVal + "\t" + act.lastRequest.appVal + "\t" + act.lastRequest.globalVal);
        System.out.println("lastClick = " + act.lastClick.slotVal + "\t" + act.lastClick.appVal + "\t" + act.lastClick.globalVal);
        System.out.println("hisRequest = " + act.hisRequest.slotVal + "\t" + act.hisRequest.appVal + "\t" + act.hisRequest.globalVal);
    }

    public static double normlize(double val, double max, double limit) {
        double norm = Math.min(val * limit / max, limit);
        return norm;
    }

    public static List<ActivityInfo> setParam(List<ActivityInfo> activityInfos, ActivityInfo result) {
        ArrayList<ActivityInfo> temp = new ArrayList<ActivityInfo>();
        for (ActivityInfo act : activityInfos) {
            temp.add(ActivitySelector.actClone(result));
        }
        return temp;
    }

    public static List<List<Long>> getNewMainMeetRelation(List<ActivityInfo> activityInfos) {
        HashMap<Long, List> newMainMeetActivitysList = new HashMap<Long, List>();
        for (ActivityInfo activity : activityInfos) {
            if (activity.mainMeetId == -1L || activity.mainMeetId == 0L) continue;
            if (!newMainMeetActivitysList.containsKey(activity.mainMeetId)) {
                ArrayList<ActivityInfo> newMainArr = new ArrayList<ActivityInfo>();
                newMainArr.add(activity);
                newMainMeetActivitysList.put(activity.mainMeetId, newMainArr);
                continue;
            }
            List olfMainArr = (List)newMainMeetActivitysList.get(activity.mainMeetId);
            olfMainArr.add(activity);
            newMainMeetActivitysList.put(activity.mainMeetId, olfMainArr);
        }
        ArrayList<List<Long>> newMainMeetSave = new ArrayList<List<Long>>();
        for (Map.Entry entry : newMainMeetActivitysList.entrySet()) {
            ArrayList<Object> acts = new ArrayList<Object>();
            acts.add(entry.getKey());
            for (ActivityInfo activity : (List)entry.getValue()) {
                acts.add(activity.activityId);
            }
            newMainMeetSave.add(acts);
        }
        return newMainMeetSave;
    }

    public static Map<Long, List<ActivityInfo>> getAllMainMeet(List<ActivityInfo> activityInfos) {
        Object oldMainMeetActivitysList = null;
        HashMap<Long, List<ActivityInfo>> newMainMeetActivitysList = new HashMap<Long, List<ActivityInfo>>();
        ArrayList noMainMeetactivityInfos = new ArrayList();
        for (ActivityInfo activity : activityInfos) {
            if (activity.activityId == -100L || activity.mainMeetId == -1L || activity.mainMeetId == 0L) continue;
            if (!newMainMeetActivitysList.containsKey(activity.mainMeetId)) {
                ArrayList<ActivityInfo> newMainArr = new ArrayList<ActivityInfo>();
                newMainArr.add(activity);
                newMainMeetActivitysList.put(activity.mainMeetId, newMainArr);
                continue;
            }
            List olfMainArr = (List)newMainMeetActivitysList.get(activity.mainMeetId);
            olfMainArr.add(activity);
            newMainMeetActivitysList.put(activity.mainMeetId, olfMainArr);
        }
        return newMainMeetActivitysList;
    }

    public static List<ActivityInfo> mainMeettoActivity(List<ActivityInfo> activityInfos, List<List<Long>> mainMeetActivitysList) {
        List<List<Long>> oldMainMeetActivitysList = null;
        HashMap<Long, List> newMainMeetActivitysList = new HashMap<Long, List>();
        ArrayList<ActivityInfo> noMainMeetactivityInfos = new ArrayList<ActivityInfo>();
        oldMainMeetActivitysList = mainMeetActivitysList;
        for (ActivityInfo activity : activityInfos) {
            if (activity.mainMeetId != -1L && activity.mainMeetId != 0L) {
                if (!newMainMeetActivitysList.containsKey(activity.mainMeetId)) {
                    ArrayList<ActivityInfo> newMainArr = new ArrayList<ActivityInfo>();
                    newMainArr.add(activity);
                    newMainMeetActivitysList.put(activity.mainMeetId, newMainArr);
                    continue;
                }
                List olfMainArr = (List)newMainMeetActivitysList.get(activity.mainMeetId);
                olfMainArr.add(activity);
                newMainMeetActivitysList.put(activity.mainMeetId, olfMainArr);
                continue;
            }
            noMainMeetactivityInfos.add(activity);
        }
        boolean initFlag = true;
        ArrayList newMainMeetSave = new ArrayList();
        for (Map.Entry entry : newMainMeetActivitysList.entrySet()) {
            ArrayList<Object> acts = new ArrayList<Object>();
            acts.add(entry.getKey());
            for (ActivityInfo activity : (List)entry.getValue()) {
                acts.add(activity.activityId);
            }
            newMainMeetSave.add(acts);
        }
        if (oldMainMeetActivitysList == null) {
            initFlag = false;
            oldMainMeetActivitysList = new ArrayList<List<Long>>();
            oldMainMeetActivitysList.addAll(newMainMeetSave);
        }
        for (List list : newMainMeetSave) {
            boolean first;
            long mainMeetId = (Long)list.get(0);
            List tempMainMeet = (List)newMainMeetActivitysList.get(mainMeetId);
            long ClickGlobalVal = 0L;
            long ClickSlotVal = 0L;
            long ClickAppVal = 0L;
            long CostGlobalVal = 0L;
            long CostAppVal = 0L;
            long CostSlotVal = 0L;
            long RequestGlobalVal = 0L;
            long RequestAppVal = 0L;
            long RequestSlotVal = 0L;
            ActivityInfo mainMeetCastActivity = ActivitySelector.actClone((ActivityInfo)tempMainMeet.get(0));
            double missRequest = 0.0;
            if (ActivitySelector.equalMainMeet(list, tempMainMeet) && initFlag) {
                first = true;
                for (ActivityInfo activityInfo : tempMainMeet) {
                    System.out.println(activityInfo.mainMeetId + " " + activityInfo.activityId);
                    if (activityInfo.missRequest != null && (activityInfo.missRequest.slotVal != 0.0 || activityInfo.missRequest.appVal != 0.0 || activityInfo.missRequest.globalVal != 0.0) && first) {
                        RequestSlotVal = (long)((double)RequestSlotVal + activityInfo.missRequest.slotVal);
                        RequestAppVal = (long)((double)RequestAppVal + activityInfo.missRequest.appVal);
                        RequestGlobalVal = (long)((double)RequestGlobalVal + activityInfo.missRequest.globalVal);
                        first = false;
                    }
                    ClickGlobalVal = (long)((double)ClickGlobalVal + activityInfo.click.globalVal);
                    ClickAppVal = (long)((double)ClickAppVal + activityInfo.click.appVal);
                    ClickSlotVal = (long)((double)ClickSlotVal + activityInfo.click.slotVal);
                    CostGlobalVal = (long)((double)CostGlobalVal + activityInfo.cost.globalVal);
                    CostAppVal = (long)((double)CostAppVal + activityInfo.cost.appVal);
                    CostSlotVal = (long)((double)CostSlotVal + activityInfo.cost.slotVal);
                    RequestGlobalVal = (long)((double)RequestGlobalVal + activityInfo.request.globalVal);
                    RequestAppVal = (long)((double)RequestAppVal + activityInfo.request.appVal);
                    RequestSlotVal = (long)((double)RequestSlotVal + activityInfo.request.slotVal);
                }
            } else {
                first = true;
                for (ActivityInfo activityInfo : tempMainMeet) {
                    if (list.indexOf(activityInfo.activityId) != -1 && initFlag) {
                        if (activityInfo.missRequest != null && (activityInfo.missRequest.slotVal != 0.0 || activityInfo.missRequest.appVal != 0.0 || activityInfo.missRequest.globalVal != 0.0) && first) {
                            RequestSlotVal = (long)((double)RequestSlotVal + activityInfo.missRequest.slotVal);
                            RequestAppVal = (long)((double)RequestAppVal + activityInfo.missRequest.appVal);
                            RequestGlobalVal = (long)((double)RequestGlobalVal + activityInfo.missRequest.globalVal);
                            first = false;
                        }
                        ClickGlobalVal = (long)((double)ClickGlobalVal + activityInfo.click.globalVal);
                        ClickAppVal = (long)((double)ClickAppVal + activityInfo.click.appVal);
                        ClickSlotVal = (long)((double)ClickSlotVal + activityInfo.click.slotVal);
                        CostGlobalVal = (long)((double)CostGlobalVal + activityInfo.cost.globalVal);
                        CostAppVal = (long)((double)CostAppVal + activityInfo.cost.appVal);
                        CostSlotVal = (long)((double)CostSlotVal + activityInfo.cost.slotVal);
                        RequestGlobalVal = (long)((double)RequestGlobalVal + activityInfo.request.globalVal);
                        RequestAppVal = (long)((double)RequestAppVal + activityInfo.request.appVal);
                        RequestSlotVal = (long)((double)RequestSlotVal + activityInfo.request.slotVal);
                        continue;
                    }
                    RequestSlotVal += 6L;
                    RequestAppVal = (long)((double)RequestAppVal + 8.5);
                    RequestGlobalVal = (long)((double)RequestGlobalVal + 198.16666666666666);
                    ++ClickSlotVal;
                    ClickAppVal += 2L;
                    ClickGlobalVal = (long)((double)ClickGlobalVal + 31.833333333333332);
                    CostSlotVal += 61L;
                    CostAppVal = (long)((double)CostAppVal + 80.5);
                    CostGlobalVal += 431L;
                }
            }
            mainMeetCastActivity.mainMeetId = mainMeetId;
            mainMeetCastActivity.click.globalVal = ClickGlobalVal;
            mainMeetCastActivity.click.appVal = ClickAppVal;
            mainMeetCastActivity.directClick.slotVal = ClickSlotVal;
            mainMeetCastActivity.cost.globalVal = CostGlobalVal;
            mainMeetCastActivity.cost.appVal = CostAppVal;
            mainMeetCastActivity.directCost.slotVal = CostSlotVal;
            mainMeetCastActivity.request.globalVal = RequestGlobalVal;
            mainMeetCastActivity.request.appVal = RequestAppVal;
            mainMeetCastActivity.directRequest.slotVal = RequestSlotVal;
            noMainMeetactivityInfos.add(mainMeetCastActivity);
        }
        return noMainMeetactivityInfos;
    }

    public static boolean equalMainMeet(List<Long> oldMainMeetActivity, List<ActivityInfo> newMainMeetActivitys) {
        boolean flag = true;
        if (oldMainMeetActivity.size() - 1 != newMainMeetActivitys.size()) {
            return false;
        }
        int count = 0;
        for (int i = 1; i < oldMainMeetActivity.size(); ++i) {
            for (int j = 0; j < newMainMeetActivitys.size(); ++j) {
                if (oldMainMeetActivity.get(i) != newMainMeetActivitys.get((int)j).activityId) continue;
                ++count;
            }
        }
        flag = count == newMainMeetActivitys.size();
        return flag;
    }

    private static int selectMachine(List<Double> alphas, List<Double> betas, int numMachines) {
        int selectMachine = 0;
        double maxTheta = 0.0;
        for (int i = 0; i < numMachines; ++i) {
            double theta = BetaDistribution.BetaDist(alphas.get(i), betas.get(i));
            if (!(theta > maxTheta)) continue;
            maxTheta = theta;
            selectMachine = i;
        }
        return selectMachine;
    }

    private double getCtr(double exp, double clk) {
        return exp > 0.0 ? clk / exp : 0.0;
    }

    private double sum(List<Long> list) {
        double sum = 0.0;
        for (Long val : list) {
            sum += (double)val.longValue();
        }
        return sum;
    }

    public static double wilsonRoofLeft(Double ratio, Double num) {
        if (ratio == null || num == null) {
            return 0.0;
        }
        long fenzi = (long)(ratio * num);
        long fenmu = num.longValue();
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi, fenmu);
        return pair.upperBound;
    }

    public double wilsonRoofRight(Double num, Double ratio) {
        if (ratio == null || num == null) {
            return 0.0;
        }
        if (ratio == 0.0) {
            ratio = 1.0E-8;
        }
        long fenmu = (long)(num / ratio);
        long fenzi = num.longValue();
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi, fenmu);
        return pair.upperBound;
    }

    public double wilsonBottom(Long fenzi, Long fenmu) {
        if (fenzi == null || fenmu == null) {
            return 0.0;
        }
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi, fenmu);
        return pair.lowerBound;
    }

    private static ActivitySelector getInstance() {
        return SingletonHolder.instance;
    }

    private static ActivityInfo actClone(ActivityInfo originAct) {
        ActivityInfo act = new ActivityInfo();
        act.mainMeetId = originAct.mainMeetId;
        act.activityId = originAct.activityId;
        act.source = originAct.source;
        act.alpha = originAct.alpha;
        act.beta = originAct.beta;
        act.reward = originAct.reward;
        act.count = originAct.count;
        act.slotId = originAct.slotId;
        ActivityInfo.Val val = act.getVal();
        val = act.getVal();
        val.globalVal = originAct.hisRequest.globalVal;
        val.appVal = originAct.hisRequest.appVal;
        val.slotVal = originAct.hisRequest.slotVal;
        act.hisRequest = val;
        val = act.getVal();
        val.globalVal = originAct.hisSend.globalVal;
        val.appVal = originAct.hisSend.appVal;
        val.slotVal = originAct.hisSend.slotVal;
        act.hisSend = val;
        val = act.getVal();
        val.globalVal = originAct.hisClick.globalVal;
        val.appVal = originAct.hisClick.appVal;
        val.slotVal = originAct.hisClick.slotVal;
        act.hisClick = val;
        val = act.getVal();
        val.globalVal = originAct.hisCost.globalVal;
        val.appVal = originAct.hisCost.appVal;
        val.slotVal = originAct.hisCost.slotVal;
        act.hisCost = val;
        val = act.getVal();
        val.globalVal = originAct.send.globalVal;
        val.appVal = originAct.send.appVal;
        val.slotVal = originAct.send.slotVal;
        act.send = val;
        val = act.getVal();
        val.globalVal = originAct.directSend.globalVal;
        val.appVal = originAct.directSend.appVal;
        val.slotVal = originAct.directSend.slotVal;
        act.directSend = val;
        val = act.getVal();
        val.globalVal = originAct.request.globalVal;
        val.appVal = originAct.request.appVal;
        val.slotVal = originAct.request.slotVal;
        act.request = val;
        val = act.getVal();
        val.globalVal = originAct.directRequest.globalVal;
        val.appVal = originAct.directRequest.appVal;
        val.slotVal = originAct.directRequest.slotVal;
        act.directRequest = val;
        val = act.getVal();
        val.globalVal = originAct.click.globalVal;
        val.appVal = originAct.click.appVal;
        val.slotVal = originAct.click.slotVal;
        act.click = val;
        val = act.getVal();
        val.globalVal = originAct.directClick.globalVal;
        val.appVal = originAct.directClick.appVal;
        val.slotVal = originAct.directClick.slotVal;
        act.directClick = val;
        val = act.getVal();
        val.globalVal = originAct.cost.globalVal;
        val.appVal = originAct.cost.appVal;
        val.slotVal = originAct.cost.slotVal;
        act.cost = val;
        val = act.getVal();
        val.globalVal = originAct.directCost.globalVal;
        val.appVal = originAct.directCost.appVal;
        val.slotVal = originAct.directCost.slotVal;
        act.directCost = val;
        val = act.getVal();
        val.globalVal = originAct.lastSend.globalVal;
        val.appVal = originAct.lastSend.appVal;
        val.slotVal = originAct.lastSend.slotVal;
        act.lastSend = val;
        val = act.getVal();
        val.globalVal = originAct.lastRequest.globalVal;
        val.appVal = originAct.lastRequest.appVal;
        val.slotVal = originAct.lastRequest.slotVal;
        act.lastRequest = val;
        val = act.getVal();
        val.globalVal = originAct.lastClick.globalVal;
        val.appVal = originAct.lastClick.appVal;
        val.slotVal = originAct.lastClick.slotVal;
        act.lastClick = val;
        val = act.getVal();
        val.globalVal = originAct.lastCost.globalVal;
        val.appVal = originAct.lastCost.appVal;
        val.slotVal = originAct.lastCost.slotVal;
        act.lastCost = val;
        act.updateTime = originAct.updateTime;
        act.isUpdate = originAct.isUpdate;
        act.missRequest = originAct.missRequest;
        act.valid = originAct.valid;
        act.createTime = originAct.createTime;
        act.updateTime = originAct.updateTime;
        act.isUpdate = originAct.isUpdate;
        return act;
    }

    public static class SingletonHolder {
        private static final ActivitySelector instance = new ActivitySelector();
    }

    static class MatchInfo {
        double score;
        ActivityInfo act;

        MatchInfo() {
        }
    }

    static class RankInfo {
        double grpm;
        double gexp;
        double hrpm;
        double hexp;
        double arpm;
        double aexp;

        RankInfo() {
        }
    }

    static class Constant {
        static double MIN_REWARD = 0.1;
        static long DISCOUNT = 2L;
        static int MAX_HIS_VAL = 10000;
        static double DECAY = 0.99;
        static int SEARANK_TOPN = 30;

        Constant() {
        }
    }
}

