/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.common.model.deeptarget;

import cn.com.duiba.nezha.alg.api.vo.PreDcvrStatInfo;
import cn.com.duiba.nezha.alg.common.model.deeptarget.DeepTargetControl;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeepAdjustFactor {
    private static final Logger logger = LoggerFactory.getLogger(DeepAdjustFactor.class);

    public static double deepAdjustFactor(PreDcvrStatInfo preDcvrStatInfo, Double preDcvr, Double preCvr, Long adDeepConvert, Double minFactor, Double maxFactor) {
        double factor = 1.0;
        if (AssertUtil.isAnyEmpty(preDcvrStatInfo, preDcvr)) {
            return factor;
        }
        if (adDeepConvert == null || (double)adDeepConvert.longValue() < Constant.THRESHOLD) {
            return factor;
        }
        Double mergeMean = preDcvrStatInfo.getMergeMean();
        Double mergeSD = preDcvrStatInfo.getMergeSD();
        minFactor = minFactor != null ? minFactor : 0.85;
        maxFactor = maxFactor != null ? maxFactor : 1.2;
        if (mergeMean != null && mergeSD != null && preDcvr != null && preDcvr > 0.0) {
            double level1 = Math.max(mergeMean * 0.2, 0.0);
            double level2 = Math.max(mergeMean * 0.4, 0.0);
            double level3 = Math.max(mergeMean * 0.8, 0.0);
            double level4 = Math.min(mergeMean * 1.2, 1.0);
            double level5 = Math.min(mergeMean * 1.6, 1.0);
            double level6 = Math.min(mergeMean * 2.0, 1.0);
            double step_0 = (1.0 - minFactor) / 3.0;
            double step_1 = (maxFactor - 1.0) / 3.0;
            double[] bucket = new double[]{0.0, level1, level2, level3, mergeMean, level4, level5, level6, 1.0};
            double[] weight = new double[]{minFactor, minFactor, minFactor + step_0, minFactor + step_0 * 2.0, 1.0, 1.0 + step_1, 1.0 + step_1 * 2.0, maxFactor, maxFactor};
            factor = DeepTargetControl.getConfidenceWeight2(preDcvr, bucket, weight, 1.0);
        }
        return factor;
    }

    public static void main(String[] args) {
        PreDcvrStatInfo preDcvrStatInfo = new PreDcvrStatInfo();
        preDcvrStatInfo.setMergeMean(Double.valueOf(0.2));
        preDcvrStatInfo.setMergeSD(Double.valueOf(0.05));
        double ret = DeepAdjustFactor.deepAdjustFactor(preDcvrStatInfo, 0.1, 0.2, 5000L, 0.85, null);
        System.out.println(ret);
    }

    static class Constant {
        static double THRESHOLD = 0.0;

        Constant() {
        }
    }
}

