/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.common.model.pacing;

import cn.com.duiba.nezha.alg.common.model.feedback.FeedBack;
import cn.com.duiba.nezha.alg.common.model.pacing.AdvertOrientInfo;
import cn.com.duiba.nezha.alg.common.model.pacing.OrientInfo;
import cn.com.duiba.nezha.alg.common.model.pacing.ResultType;
import cn.com.duiba.nezha.alg.common.model.pacing.TrusteeshipParams;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlotRecommender {
    private static final Logger logger = LoggerFactory.getLogger(SlotRecommender.class);

    public static Map<ResultType, Collection<AdvertOrientInfo>> recommend(Collection<OrientInfo> orientlist, Long slotId, TrusteeshipParams trusteeshipParams) {
        HashSet<AdvertOrientInfo> orientSet = new HashSet<AdvertOrientInfo>();
        HashSet<AdvertOrientInfo> fuseSet1 = new HashSet<AdvertOrientInfo>();
        HashSet<AdvertOrientInfo> fuseSet2 = new HashSet<AdvertOrientInfo>();
        HashSet<AdvertOrientInfo> recommendListSet = new HashSet<AdvertOrientInfo>();
        HashSet<AdvertOrientInfo> shieldListSet = new HashSet<AdvertOrientInfo>();
        TrusteeshipParams.ReleaseTarget1SlotRecommendParams releaseTarget1slotRecommendParams = trusteeshipParams.getReleaseTarget1slotRecommendParams();
        TrusteeshipParams.ReleaseTarget2SlotRecommendParams releaseTarget2slotRecommendParams = trusteeshipParams.getReleaseTarget2slotRecommendParams();
        TrusteeshipParams.ReleaseTarget3SlotRecommendParams releaseTarget3slotRecommendParams = trusteeshipParams.getReleaseTarget3slotRecommendParams();
        if (Math.random() < 1.0E-5) {
            logger.info("params slotRecommendParams:{}", (Object)trusteeshipParams);
        }
        for (OrientInfo orientInfo : orientlist) {
            Integer manageType = orientInfo.manageType;
            Integer releaseTarget = orientInfo.releaseTarget != null ? orientInfo.releaseTarget : 3;
            Integer chargeType = orientInfo.chargeType;
            Integer cvrType = orientInfo.cvrType;
            Long target = orientInfo.target != 0L ? orientInfo.target : 1L;
            Long importantAppAfee = orientInfo.importantAppAfee;
            Long fee = orientInfo.fee;
            HashMap<String, Double> recommendParamsMap = new HashMap<String, Double>();
            if (releaseTarget == 1) {
                recommendParamsMap.put("startFactor", releaseTarget1slotRecommendParams.getStartFactor());
                recommendParamsMap.put("cpaBiasRatioFactor", releaseTarget1slotRecommendParams.getCpaBiasRatioFactor());
                recommendParamsMap.put("cpaOrientRatioFactor", releaseTarget1slotRecommendParams.getCpaOrientRatioFactor());
                recommendParamsMap.put("cpaBiasThresholdFactor", releaseTarget1slotRecommendParams.getCpaBiasThresholdFactor());
                recommendParamsMap.put("cpcTargetRatioFactor", releaseTarget1slotRecommendParams.getCpcTargetRatioFactor());
                recommendParamsMap.put("cpcOrientRatioFactor", releaseTarget1slotRecommendParams.getCpcOrientRatioFactor());
                recommendParamsMap.put("cpcBiasThresholdFactor", releaseTarget1slotRecommendParams.getCpcBiasThresholdFactor());
            } else if (releaseTarget == 2 || manageType == 3) {
                recommendParamsMap.put("startFactor", releaseTarget2slotRecommendParams.getStartFactor());
                recommendParamsMap.put("cpaBiasRatioFactor", releaseTarget2slotRecommendParams.getCpaBiasRatioFactor());
                recommendParamsMap.put("cpaOrientRatioFactor", releaseTarget2slotRecommendParams.getCpaOrientRatioFactor());
                recommendParamsMap.put("cpaBiasThresholdFactor", releaseTarget2slotRecommendParams.getCpaBiasThresholdFactor());
                recommendParamsMap.put("cpcTargetRatioFactor", releaseTarget2slotRecommendParams.getCpcTargetRatioFactor());
                recommendParamsMap.put("cpcOrientRatioFactor", releaseTarget2slotRecommendParams.getCpcOrientRatioFactor());
                recommendParamsMap.put("cpcBiasThresholdFactor", releaseTarget2slotRecommendParams.getCpcBiasThresholdFactor());
            } else {
                recommendParamsMap.put("startFactor", releaseTarget3slotRecommendParams.getStartFactor());
                recommendParamsMap.put("cpaBiasRatioFactor", releaseTarget3slotRecommendParams.getCpaBiasRatioFactor());
                recommendParamsMap.put("cpaOrientRatioFactor", releaseTarget3slotRecommendParams.getCpaOrientRatioFactor());
                recommendParamsMap.put("cpaBiasThresholdFactor", releaseTarget3slotRecommendParams.getCpaBiasThresholdFactor());
                recommendParamsMap.put("cpcTargetRatioFactor", releaseTarget3slotRecommendParams.getCpcTargetRatioFactor());
                recommendParamsMap.put("cpcOrientRatioFactor", releaseTarget3slotRecommendParams.getCpcOrientRatioFactor());
                recommendParamsMap.put("cpcBiasThresholdFactor", releaseTarget3slotRecommendParams.getCpcBiasThresholdFactor());
            }
            HashMap<String, Double> candidateMap = new HashMap<String, Double>();
            if (orientInfo.cvrSet != null && orientInfo.biasSet != null) {
                candidateMap.put("statCvr0", orientInfo.cvrSet.get(0));
                candidateMap.put("statCvr1", orientInfo.cvrSet.get(1));
                candidateMap.put("statCvr2", orientInfo.cvrSet.get(2));
                candidateMap.put("statCvr3", orientInfo.cvrSet.get(3));
                candidateMap.put("statCvr4", orientInfo.cvrSet.get(4));
                candidateMap.put("cvrBias0", orientInfo.biasSet.get(0));
                candidateMap.put("cvrBias1", orientInfo.biasSet.get(1));
                candidateMap.put("cvrBias2", orientInfo.biasSet.get(2));
                candidateMap.put("cvrBias3", orientInfo.biasSet.get(3));
                candidateMap.put("cvrBias4", orientInfo.biasSet.get(4));
            }
            if (Math.random() < 0.001) {
                logger.info("OrientInfo slotId:{} advertId:{} orientId:{} OrientInfo:{}", new Object[]{slotId, orientInfo.advertId, orientInfo.orientId, orientInfo});
            }
            Double orientCostG1d = orientInfo.orientCostG1d != null ? orientInfo.orientCostG1d : 0.0;
            Double orientCostG7d = orientInfo.orientCostG7d != null ? orientInfo.orientCostG7d : 0.0;
            Double orientConvert = orientInfo.orientConvertG1d;
            Double orientCostConvert = orientConvert != 0.0 && orientCostG1d != 0.0 ? orientCostG1d / orientConvert : (double)target.longValue();
            Double orientCostConvertbias = orientConvert != 0.0 ? orientCostConvert / (double)target.longValue() : orientCostG1d / (double)target.longValue();
            Double orientConfidence = orientCostG1d / (double)(target * 5L);
            Double slotOrientationCost = orientInfo.slotOrientationCost != null ? orientInfo.slotOrientationCost : 0.0;
            Double slotOrientationConvert = orientInfo.slotOrientationConvert != null ? orientInfo.slotOrientationConvert : 0.0;
            Double slotOrientationConfidence = slotOrientationCost / (double)(target * 5L);
            Double slotOrientationCostConvert = slotOrientationCost != 0.0 && slotOrientationConvert != 0.0 ? slotOrientationCost / slotOrientationConvert : (double)target.longValue();
            Double slotOrientationCostConvertBias = slotOrientationConvert != 0.0 ? slotOrientationCostConvert / (double)target.longValue() : slotOrientationCost / (double)target.longValue();
            Double slotAdvertCost = orientInfo.slotAdvertCost != null ? orientInfo.slotAdvertCost : 0.0;
            Double slotAdvertConvert = orientInfo.slotAdvertConvert != null ? orientInfo.slotAdvertConvert : 0.0;
            Double slotAdvertConfidence = slotAdvertCost / (double)(target * 5L);
            Double slotAdvertCostConvert = slotAdvertCost != 0.0 && slotAdvertConvert != 0.0 ? slotAdvertCost / slotAdvertConvert : (double)target.longValue();
            Double slotAdvertCostConvertBias = slotAdvertConvert != 0.0 ? slotAdvertCostConvert / (double)target.longValue() : slotAdvertCost / (double)target.longValue();
            Double appOrientationCost = orientInfo.appOrientationCost != null ? orientInfo.appOrientationCost : 0.0;
            Double appOrientationConvert = orientInfo.appOrientationConvert != null ? orientInfo.appOrientationConvert : 0.0;
            Double appOrientationConfidence = appOrientationCost / (double)(target * 5L);
            Double appOrientationCostConvert = appOrientationCost != 0.0 && appOrientationConvert != 0.0 ? appOrientationCost / appOrientationConvert : (double)target.longValue();
            Double appOrientationCostConvertBias = appOrientationConvert != 0.0 ? appOrientationCostConvert / (double)target.longValue() : appOrientationCost / (double)target.longValue();
            Double appOrientCvrDay = orientInfo.appOrientCvrDay != null ? orientInfo.appOrientCvrDay : 0.0;
            Random r = new Random();
            Double x = r.nextDouble();
            double p_convert_cost = 0.0;
            double biasRatio = 0.0;
            double biasThreshold = 0.0;
            double orientRatio = 0.0;
            double targetRatio = 0.0;
            double startRatio = orientCostG7d < (double)(5L * target) ? (Double)recommendParamsMap.get("startFactor") : 1.0;
            String feedBackLabel = FeedBack.autoManageFeedBack(orientInfo, trusteeshipParams);
            if (!"".equals(feedBackLabel) && Math.random() < 0.02) {
                logger.info("slot_blackset slotId:{} advertId:{} orientId:{} feedBackLabel:{}", new Object[]{slotId, orientInfo.advertId, orientInfo.orientId, feedBackLabel});
            }
            Boolean isFuse = ("fuse1".equals(feedBackLabel) || "fuse2".equals(feedBackLabel)) & orientInfo.fuseWhite == false;
            if ("fuse1".equals(feedBackLabel)) {
                fuseSet1.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId));
            } else if ("fuse2".equals(feedBackLabel)) {
                fuseSet2.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId));
            }
            if (isFuse.booleanValue()) {
                logger.info("fuseInfo fuseOrientInfo:{}", (Object)orientInfo);
            }
            Double cost20d = orientInfo.cost20d != null ? orientInfo.cost20d : 0.0;
            Double confidence = cost20d / (double)(5L * target);
            Double cvr = (Double)candidateMap.get("statCvr" + cvrType);
            Double bias = (Double)candidateMap.get("cvrBias" + cvrType);
            if (chargeType == 2 && confidence != null && bias != null && !isFuse.booleanValue()) {
                biasRatio = orientCostConvertbias != 0.0 ? (Double)recommendParamsMap.get("cpaBiasRatioFactor") / (orientCostConvertbias * orientCostConvertbias) : (Double)recommendParamsMap.get("cpaBiasRatioFactor");
                orientRatio = orientCostConvertbias != 0.0 ? (Double)recommendParamsMap.get("cpaOrientRatioFactor") / (orientCostConvertbias * orientCostConvertbias * orientCostConvertbias) : (Double)recommendParamsMap.get("cpaOrientRatioFactor");
                orientRatio = orientCostConvertbias > 1.7 ? 0.0 : orientRatio;
                biasThreshold = Math.max(((Double)recommendParamsMap.get("cpaBiasThresholdFactor") * confidence + 1.0) * biasRatio * startRatio, 1.0);
                if (importantAppAfee != null && importantAppAfee != target) {
                    orientSet.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId));
                }
                if (confidence > 0.0 && bias > 0.0 && bias <= biasThreshold) {
                    orientSet.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId));
                    if (manageType == 3) {
                        recommendListSet.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId, slotOrientationCostConvertBias, slotOrientationCost));
                    }
                }
                if (confidence == 0.0 && x < orientRatio) {
                    orientSet.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId));
                    if (manageType == 3) {
                        recommendListSet.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId, slotOrientationCostConvertBias, slotOrientationCost));
                    }
                }
            } else if (chargeType == 1 && confidence != null && cvr != null && !isFuse.booleanValue()) {
                recommendParamsMap.put("startFactor", releaseTarget1slotRecommendParams.getStartFactor());
                recommendParamsMap.put("cpcTargetRatioFactor", releaseTarget1slotRecommendParams.getCpcTargetRatioFactor());
                recommendParamsMap.put("cpcOrientRatioFactor", releaseTarget1slotRecommendParams.getCpcOrientRatioFactor());
                recommendParamsMap.put("cpcBiasThresholdFactor", releaseTarget1slotRecommendParams.getCpcBiasThresholdFactor());
                targetRatio = orientCostConvertbias != 0.0 ? (Double)recommendParamsMap.get("cpcTargetRatioFactor") / (orientCostConvertbias * orientCostConvertbias) : (Double)recommendParamsMap.get("cpcTargetRatioFactor");
                orientRatio = orientCostConvertbias != 0.0 ? (Double)recommendParamsMap.get("cpcOrientRatioFactor") / (orientCostConvertbias * orientCostConvertbias * orientCostConvertbias) : (Double)recommendParamsMap.get("cpcOrientRatioFactor");
                orientRatio = orientCostConvertbias > 1.5 ? 0.0 : orientRatio;
                biasThreshold = Math.max(((Double)recommendParamsMap.get("cpcBiasThresholdFactor") * confidence + 1.0) * targetRatio * startRatio, 1.0);
                double d = p_convert_cost = cvr != 0.0 ? (double)fee.longValue() / cvr : 1000000.0;
                if (confidence > 0.0 && p_convert_cost <= biasThreshold * (double)target.longValue()) {
                    orientSet.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId));
                    if (manageType == 3) {
                        recommendListSet.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId, slotOrientationCostConvertBias, slotOrientationCost));
                    }
                }
                if (confidence == 0.0 && p_convert_cost < biasThreshold * (double)target.longValue() && x < orientRatio) {
                    orientSet.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId));
                    if (manageType == 3) {
                        recommendListSet.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId, slotOrientationCostConvertBias, slotOrientationCost));
                    }
                }
            }
            if ("w".equals(feedBackLabel)) {
                orientSet.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId));
                if (manageType == 3) {
                    recommendListSet.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId, appOrientationCostConvertBias, appOrientationCost));
                }
            }
            if (!"b".equals(feedBackLabel)) continue;
            orientSet.remove(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId));
            if (manageType != 2 || !(appOrientationConfidence > 1.0) || !(appOrientationCostConvertBias > 2.0)) continue;
            shieldListSet.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId, appOrientationCostConvertBias, appOrientationCost));
        }
        HashSet<AdvertOrientInfo> orientPackageList = new HashSet<AdvertOrientInfo>();
        for (OrientInfo orientInfo : orientlist) {
            orientPackageList.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId));
        }
        orientPackageList.removeAll(orientSet);
        orientPackageList.removeAll(shieldListSet);
        HashMap<ResultType, Collection<AdvertOrientInfo>> hashMap = new HashMap<ResultType, Collection<AdvertOrientInfo>>();
        hashMap.put(ResultType.ONTARGET, orientSet);
        hashMap.put(ResultType.GIVEUP, orientPackageList);
        hashMap.put(ResultType.FUSE1, fuseSet1);
        hashMap.put(ResultType.FUSE2, fuseSet2);
        hashMap.put(ResultType.ORIENT, recommendListSet);
        hashMap.put(ResultType.SHIELD, shieldListSet);
        if (Math.random() < 0.002) {
            logger.info("ResultType ResultType:{} slotId:{}", hashMap, (Object)slotId);
        }
        return hashMap;
    }
}

