package cn.com.duiba.nezha.alg.common.model.deeptarget;

import lombok.Data;

import java.util.HashMap;
import java.util.Map;

@Data
public class DeepTargetInfo {
    private Long advertId = 0L;

    private Long planId = 0L;

    private Long appId = 0L;

    /**
     * 配置过去7天的出单率
     */
    private Double adDCvr = 0.0;

    /**
     * 配置过去7天的出单量
     */
    private Long adDeepConvert = 0L;

    /**
     * 配置过去7天的预估CVR分层总量
     */
    private Map<Double,Long> preDcvrSum = new HashMap<>();

    /**
     * 配置过去7天的预估CVR分层出单数量
     */
    private Map<Double,Long> preDcvrPost = new HashMap<>();
//
//    /**
//     *广告媒体后端转化率
//     */
//    private Double adAppDCvr;


//    /**
//     * 前端目标出价
//     */
//    private Long aFee;

    /**
     * 目标出单率
     */
    private Double targetCvr = 0.0;

    /**
     * 调节因子
     */
    private Double selectFactor = 0.0;


    /**
     * sdk流量的调节因子
     */
    private Double sdkSelectFactor = 0.0;

    /**
     * 上次调节因子
     */
    private Double lastSelectFactor  = 0.0;

    /**
     * 上次调节因子
     */
    private Double lastSdkSelectFactor = 0.0;

    /**
     * 更新时间
     */
    private String updateTime;

}
