/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.common.model.slotmaterialselect;

import cn.com.duiba.nezha.alg.common.model.slotmaterialselect.BetaDistribution;
import cn.com.duiba.nezha.alg.common.model.slotmaterialselect.MatchInfo;
import cn.com.duiba.nezha.alg.common.model.slotmaterialselect.SlotMaterialInfo;
import cn.com.duiba.nezha.alg.common.model.slotmaterialselect.SlotMaterialModel;
import cn.com.duiba.nezha.alg.common.model.slotmaterialselect.WilsonInterval;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlotMaterialSelect {
    private static final Logger logger = LoggerFactory.getLogger(SlotMaterialSelect.class);
    ArrayList<Double> rewards = new ArrayList();
    ArrayList<Double> counts = new ArrayList();
    ArrayList<Double> alphas = new ArrayList();
    ArrayList<Double> betas = new ArrayList();
    public static Comparator<MatchInfo> iComparator = new Comparator<MatchInfo>(){

        @Override
        public int compare(MatchInfo c1, MatchInfo c2) {
            return c2.matchScore - c1.matchScore >= 0.0 ? 1 : -1;
        }
    };

    private double getCtr(double exposure, double click) {
        return exposure > 0.0 ? click / exposure : 0.0;
    }

    public static double normlize(double val, double max, double limit) {
        double norm = Math.min(val * limit / max, limit);
        return norm;
    }

    public List<MatchInfo> matchMaterial(List<SlotMaterialInfo> materialList, double prob, long exposureThreshold) {
        if (materialList.size() == 0) {
            System.out.println("materialList is null !");
            return null;
        }
        PriorityQueue<MatchInfo> candis = new PriorityQueue<MatchInfo>(materialList.size(), iComparator);
        PriorityQueue<MatchInfo> slotCandis = new PriorityQueue<MatchInfo>(materialList.size(), iComparator);
        PriorityQueue<MatchInfo> appCandis = new PriorityQueue<MatchInfo>(materialList.size(), iComparator);
        PriorityQueue<MatchInfo> globalCandis = new PriorityQueue<MatchInfo>(materialList.size(), iComparator);
        ArrayList<MatchInfo> result = new ArrayList<MatchInfo>();
        int topn = Constant.SEARANK_TOPN;
        HashSet<Long> idset = new HashSet<Long>();
        int limitTopn = topn;
        HashMap<Long, MatchInfo> mMap = new HashMap<Long, MatchInfo>();
        double maxG = 0.01;
        double maxH = 0.01;
        for (SlotMaterialInfo m : materialList) {
            try {
                double slotClick = m.getClickCnt().getSlotVal();
                double appClick = m.getClickCnt().getAppVal();
                double globalClick = m.getClickCnt().getGlobalVal();
                double slotExposure = m.getExposureCnt().getSlotVal();
                double appExposure = m.getExposureCnt().getAppVal();
                double globalExposure = m.getExposureCnt().getGlobalVal();
                double slotCtr = this.getCtr(slotExposure, slotClick);
                double appCtr = this.getCtr(appExposure, appClick);
                double globalCtr = this.getCtr(globalExposure, globalClick);
                MatchInfo info = mMap.containsKey(m.materialId) ? (MatchInfo)mMap.get(m.materialId) : new MatchInfo();
                info.setMaterailId(m.materialId);
                info.setSlotCtr(slotCtr);
                info.setAppCtr(appCtr);
                info.setGlobalCtr(globalCtr);
                info.setSlotExposure(slotExposure);
                info.setAppExposure(appExposure);
                info.setGlobalExposure(globalExposure);
                if (globalExposure < (double)exposureThreshold) {
                    if (System.currentTimeMillis() - m.getCreateTime() < 259200000L) {
                        if (Math.random() < prob) {
                            result.add(info);
                            --topn;
                            idset.add(info.materailId);
                        }
                    } else if (materialList.size() > limitTopn && Math.random() < 0.1 * prob) {
                        result.add(info);
                        --topn;
                        idset.add(info.materailId);
                    }
                }
                double slotScore = WilsonInterval.wilsonCalc((long)((long)slotClick), (long)((long)slotExposure * 3L)).lowerBound;
                double globalScore = WilsonInterval.wilsonCalc((long)((long)globalClick), (long)((long)globalExposure * 3L)).lowerBound;
                double appScore = WilsonInterval.wilsonCalc((long)((long)appClick), (long)((long)appExposure * 3L)).lowerBound;
                double coef = 0.0;
                double matchscore = 0.0;
                double sconfidence = Math.min(slotExposure / 100.0, 1.0);
                double aconfidence = Math.min(appExposure / 100.0, 1.0);
                double gconfidence = Math.min(globalExposure / 1000.0, 1.0);
                matchscore = sconfidence * slotScore + (1.0 - sconfidence) * aconfidence * appScore * 0.9 + (1.0 - sconfidence - (1.0 - sconfidence) * aconfidence) * globalScore * Math.max(0.5, gconfidence);
                info.setMatchScore(matchscore);
                candis.add(info);
                mMap.put(m.materialId, info);
                if (aconfidence > 0.99 || appClick > 10.0) {
                    double matchScore2 = appExposure > 0.0 ? appClick / appExposure : 0.0;
                    MatchInfo info2 = new MatchInfo();
                    info2.setMaterailId(m.materialId);
                    info2.setSlotCtr(slotCtr);
                    info2.setAppCtr(appCtr);
                    info2.setGlobalCtr(globalCtr);
                    info2.setSlotExposure(slotExposure);
                    info2.setAppExposure(appExposure);
                    info2.setGlobalExposure(globalExposure);
                    info2.setMatchScore(matchScore2);
                    appCandis.add(info2);
                }
                if (!(sconfidence > 0.99) && !(slotClick > 10.0)) continue;
                double matchScore3 = slotExposure > 0.0 ? slotClick / slotExposure : 0.0;
                MatchInfo info3 = new MatchInfo();
                info3.setMaterailId(m.materialId);
                info3.setSlotCtr(slotCtr);
                info3.setAppCtr(appCtr);
                info3.setGlobalCtr(globalCtr);
                info3.setSlotExposure(slotExposure);
                info3.setAppExposure(appExposure);
                info3.setGlobalExposure(globalExposure);
                info3.setMatchScore(matchScore3);
                slotCandis.add(info3);
            }
            catch (Exception e) {
                logger.error("error,materialId: m.materialId= " + m.materialId);
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        int slotCandiSize = slotCandis.size();
        for (int i = 0; i < 10 && i < slotCandiSize; ++i) {
            MatchInfo infoSlot = (MatchInfo)slotCandis.poll();
            if (idset.contains(infoSlot.materailId)) continue;
            result.add(infoSlot);
            idset.add(infoSlot.materailId);
            --topn;
            if (result.size() >= limitTopn) break;
        }
        int candiSize = candis.size();
        int resultSize = result.size();
        for (int i = 0; resultSize < limitTopn && i < candiSize; ++i) {
            MatchInfo candisInfo = (MatchInfo)candis.poll();
            if (idset.contains(candisInfo.materailId)) continue;
            result.add(candisInfo);
            idset.add(candisInfo.materailId);
            resultSize = result.size();
            --topn;
        }
        return result;
    }

    public SlotMaterialModel selectMaterial(List<MatchInfo> matchInfoList, List<SlotMaterialModel> materialModelList) {
        if (matchInfoList.size() == 0 || materialModelList.size() == 0) {
            System.out.println("matchInfoList or materialModelList is null !");
            return null;
        }
        if (matchInfoList.size() != materialModelList.size()) {
            System.out.println("matchInfoList and materialModelList are not same size !");
            return null;
        }
        for (int i = 0; i < matchInfoList.size(); ++i) {
            long modelMaterailId;
            long intoMaterialId = matchInfoList.get(i).getMaterailId();
            if (intoMaterialId == (modelMaterailId = materialModelList.get(i).getMaterialId())) continue;
            System.out.println("matchInfoList and materialModelList not put materialId in same order !");
            return null;
        }
        this.clear();
        double decay = Constant.DECAY;
        double maxG = 0.01;
        double maxH = 0.01;
        ArrayList<Double> rewards = new ArrayList<Double>();
        ArrayList<Double> counts = new ArrayList<Double>();
        ArrayList<Double> alphas = new ArrayList<Double>();
        ArrayList<Double> betas = new ArrayList<Double>();
        List<SlotMaterialModel> modeCopyList = materialModelList;
        SlotMaterialModel result = null;
        ArrayList candiList = new ArrayList();
        double maxSlot = Constant.MIN_REWARD;
        double maxApp = Constant.MIN_REWARD;
        double maxGlobal = Constant.MIN_REWARD;
        try {
            for (int i = 0; i < matchInfoList.size(); ++i) {
                MatchInfo info = matchInfoList.get(i);
                SlotMaterialModel model = materialModelList.get(i);
                SlotMaterialModel modelCopy = modeCopyList.get(i);
                if (!(info.getGlobalExposure() > 0.0)) continue;
                double reward = Constant.MIN_REWARD;
                double slotConfidence = Math.min(info.getSlotExposure() / 100.0, 1.0);
                double appConfidence = Math.min(info.getAppExposure() / 100.0, 1.0);
                double globalConfidence = Math.min(info.getGlobalExposure() / 1000.0, 1.0);
                reward = slotConfidence * SlotMaterialSelect.normlize(info.getSlotCtr(), maxSlot, 0.8) + (1.0 - slotConfidence) * appConfidence * SlotMaterialSelect.normlize(info.getAppCtr(), maxApp, 0.7) + (1.0 - slotConfidence - (1.0 - slotConfidence) * appConfidence) * globalConfidence * SlotMaterialSelect.normlize(info.getGlobalCtr(), maxGlobal, 0.5);
                System.out.println(info.getMaterailId() + ": reward= " + reward);
                reward *= reward;
                reward = Math.max(reward, Constant.MIN_REWARD);
                modeCopyList.get((int)i).reward = modeCopyList.get((int)i).reward * decay + reward;
                modeCopyList.get((int)i).count = modeCopyList.get((int)i).count * decay + 1.0;
                modeCopyList.get((int)i).alpha = 1.5 + modeCopyList.get((int)i).reward;
                modeCopyList.get((int)i).beta = 2.0 + (modeCopyList.get((int)i).count - modeCopyList.get((int)i).reward);
                rewards.add(modeCopyList.get((int)i).reward);
                counts.add(modeCopyList.get((int)i).count);
                alphas.add(modeCopyList.get((int)i).alpha);
                betas.add(modeCopyList.get((int)i).beta);
            }
            int numMachines = matchInfoList.size();
            int selectMachineId = this.selectMachine(alphas, betas, numMachines);
            result = modeCopyList.get(selectMachineId);
            return result;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            logger.error("error, size:{},candi:{},list:{},", new Object[]{matchInfoList.size(), JSON.toJSONString(candiList), JSON.toJSONString((Object)result)});
            return null;
        }
    }

    private void clear() {
        this.rewards = new ArrayList();
        this.counts = new ArrayList();
        this.alphas = new ArrayList();
        this.betas = new ArrayList();
    }

    private int selectMachine(List<Double> alphas, List<Double> betas, int numMachines) {
        int selectMachine = 0;
        double maxTheta = 0.0;
        for (int i = 0; i < numMachines; ++i) {
            double theta = BetaDistribution.BetaDist(alphas.get(i), betas.get(i));
            System.out.println("theta= " + theta);
            if (!(theta > maxTheta)) continue;
            maxTheta = theta;
            selectMachine = i;
        }
        return selectMachine;
    }

    static class Constant {
        static double MIN_REWARD = 0.1;
        static long DISCOUNT = 2L;
        static int MAX_HIS_VAL = 10000;
        static double DECAY = 0.99;
        static int SEARANK_TOPN = 30;

        Constant() {
        }
    }
}

