package cn.com.duiba.nezha.alg.common.model.activityrecommend;

/**
 *功能描述 消耗分相近活动列表
 * @author lijingzhe
 * @date 2019/9/4
 * @param
 * @return
 */
public class SimilarCostActivitiesInfo {
    /**
     * 活动id
     */
    long activityId;
    /**
     * 消耗相似活动个数
     */
    int sameActivityCnt;
    /**
     * 活动类型
     */
    long activityType;
    /**
     * 优选是否推出
     */
    int ifSelected;
    /**
     * 索引
     */
    int index;
    /**
     * 最大收益
     */
    double mabReward;
    /**
     * 转化分
     */
    double changeScore;
    /**
     * 与最高转化分差值
     */
    double diffChangeScore;
    /**
     * 与最高收益差值
     */
    double diffReward;
    /**
     * 广告位维度每pv消耗
     */
    double hrpm;
    /**
     * 媒体维度每pv消耗
     */
    double arpm;
    /**
     * 全局维度每pv消耗
     */
    double grpm;
    /**
     * v4.0 皮肤含有ops或vm新活动 1;否则老活动 0
     */
    int subType = 0;
    /**
     * 是否是优质活动
     */
    boolean isExcellent;
    /**
     * 归一化得分
     */
    double score;
    /**
     * v4.0 1-扶持，2-兜底(top2~5)，3-兜底(top5~20)，4-公平竞争
     */
    int strategyType;

    public long getActivityId() {
        return activityId;
    }

    public void setActivityId(long activityId) {
        this.activityId = activityId;
    }

    public int getSameActivityCnt() {
        return sameActivityCnt;
    }

    public void setSameActivityCnt(int sameActivityCnt) {
        this.sameActivityCnt = sameActivityCnt;
    }

    public long getActivityType() {
        return activityType;
    }

    public void setActivityType(long activityType) {
        this.activityType = activityType;
    }

    public int getIfSelected() {
        return ifSelected;
    }

    public void setIfSelected(int ifSelected) {
        this.ifSelected = ifSelected;
    }

    public int getIndex() {
        return index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public double getMabReward() {
        return mabReward;
    }

    public void setMabReward(double mabReward) {
        this.mabReward = mabReward;
    }

    public double getChangeScore() {
        return changeScore;
    }

    public void setChangeScore(double changeScore) {
        this.changeScore = changeScore;
    }

    public double getDiffChangeScore() {
        return diffChangeScore;
    }

    public void setDiffChangeScore(double diffChangeScore) {
        this.diffChangeScore = diffChangeScore;
    }

    public double getDiffReward() {
        return diffReward;
    }

    public void setDiffReward(double diffReward) {
        this.diffReward = diffReward;
    }

    public double getHrpm() {
        return hrpm;
    }

    public void setHrpm(double hrpm) {
        this.hrpm = hrpm;
    }

    public double getArpm() {
        return arpm;
    }

    public void setArpm(double arpm) {
        this.arpm = arpm;
    }

    public double getGrpm() {
        return grpm;
    }

    public void setGrpm(double grpm) {
        this.grpm = grpm;
    }

    public int getSubType() {
        return subType;
    }

    public void setSubType(int subType) {
        this.subType = subType;
    }

    public boolean isExcellent() {
        return isExcellent;
    }

    public void setExcellent(boolean excellent) {
        isExcellent = excellent;
    }

    public double getScore() {
        return score;
    }

    public void setScore(double score) {
        this.score = score;
    }

    public int getStrategyType() {
        return strategyType;
    }

    public void setStrategyType(int strategyType) {
        this.strategyType = strategyType;
    }

    @Override
    public String toString() {
        return "SimilarCostActivitiesInfo{" +
                "activityId=" + activityId +
                ", sameActivityCnt=" + sameActivityCnt +
                ", activityType=" + activityType +
                ", ifSelected=" + ifSelected +
                ", index=" + index +
                ", mabReward=" + mabReward +
                ", changeScore=" + changeScore +
                ", diffChangeScore=" + diffChangeScore +
                ", diffReward=" + diffReward +
                ", hrpm=" + hrpm +
                ", arpm=" + arpm +
                ", grpm=" + grpm +
                ", subType=" + subType +
                ", isExcellent=" + isExcellent +
                ", score=" + score +
                ", strategyType=" + strategyType +
                '}';
    }
}
