/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.common.model.advertexplore.expcontroller;

import cn.com.duiba.nezha.alg.common.model.advertexplore.OrientExpInfo;
import java.util.ArrayList;

class PIDController {
    PIDController() {
    }

    double calcControlFactor(OrientExpInfo orientExpInfo, Double upperBound, Double lowerBound, Double kp, Double ki) {
        ArrayList<Long> realConsumeList = orientExpInfo.getRealConsume();
        ArrayList<Long> targetConsumeList = orientExpInfo.getTargetConsume();
        double errorCurrent = this.errorDiff(realConsumeList.get(realConsumeList.size() - 1), targetConsumeList.get(targetConsumeList.size() - 1));
        double errorIntegral = this.errorIntegral(realConsumeList, targetConsumeList);
        double kt = kp * errorCurrent + ki * errorIntegral;
        double unboundK = this.responseFunc(kt);
        double k = this.bound(unboundK, upperBound, lowerBound);
        return k;
    }

    private double errorDiff(Long realConsume, Long targetConsume) {
        return new Double(targetConsume - realConsume);
    }

    private double errorIntegral(ArrayList<Long> realConsumeList, ArrayList<Long> targetConsumeList) {
        Long realConsumeSum = realConsumeList.stream().reduce(0L, Long::sum);
        Long targetConsumeSum = targetConsumeList.stream().reduce(0L, Long::sum);
        return new Double(targetConsumeSum - realConsumeSum);
    }

    private double responseFunc(double kt) {
        return Math.exp(kt);
    }

    private double bound(Double value, Double upperBound, Double lowerBound) {
        if (value > upperBound) {
            return upperBound;
        }
        if (value < lowerBound) {
            return lowerBound;
        }
        return value;
    }
}

