package cn.com.duiba.nezha.alg.common.model.activityselectconversionforms;


import cn.com.duiba.nezha.alg.common.util.DateUtil;
import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;

/**
 *功能描述 热点活动推荐
 * @author lijingzhe
 * @date 2019/5/20
 * @param
 * @return
 */
public class HotActivitySelector {

    private static final Logger logger = LoggerFactory.getLogger(HotActivitySelector.class);

    static class Constant {
        static double MIN_REWARD = 0.1;
        static long DISCOUNT = 2;
        static int MAX_HIS_VAL = 10000;
        static double DECAY = 0.99;  //100次以前的观察，无效
        static int SEARANK_TOPN = 30;
        static List<Long> FESTIVAL = Arrays.asList(1559836800000l, 1568304000000l, 1569859200000l);
    }

    static class RankInfo {
        double grpm;
        double gexp;
        double gchange;
        double hrpm;
        double hexp;
        double hchange;
        double arpm;
        double aexp;
        double achange;
        double changeScore;

    }

    static class SelectInfo {
        double reward;
        long activityType;
        int index;
        long activityId;
        double changeScore;
    }

    static class SelectInfoDetail {
        int index;
        ArrayList<SelectInfo> condi;
    }


    static class MatchInfo {
        double score;
        ActivityInfoModel act;
    }


    public static  int getCoef(double hisRequest, double request, double hisClick, double click)
    {
        int coef = 1;
        int i = 1,j=1;
        if(request < 0)
        {
            for(i = 1;i<144;i++)
            {
                request += hisRequest/144;
                if(request > 0)
                    break;
            }
        }
        if(click < 0)
        {
            for(j = 1;j<144;j++)
            {
                click += hisClick/144;
                if(click > 0)
                    break;
            }
        }
        coef = coef + Math.max(i,j);
        return coef;
    }

    public static Comparator<MatchInfo> iComparator = new Comparator<MatchInfo>() {

        @Override
        public int compare(MatchInfo c1, MatchInfo c2) {
            return (int) (c2.score - c1.score >= 0 ? 1 : -1); //按score大小排序
        }
    };

    private static List<ActivityInfoModel> sortByIdAndSourceModel(List<ActivityInfoModel> acts){

        List<ActivityInfoModel> actCopy = acts;
        Collections.sort(actCopy, new Comparator<ActivityInfoModel>() {
            public int compare(ActivityInfoModel act1, ActivityInfoModel act2) {
                if(act1.activityId > act2.activityId) {
                    return -1;
                }
                else {
                    return 1;

                }
            }
        });
        return actCopy;
    }

    private static List<ActivityInfoData> sortByIdAndSourceData(List<ActivityInfoData> acts){

        List<ActivityInfoData> actCopy = acts;
        Collections.sort(actCopy, new Comparator<ActivityInfoData>() {
            public int compare(ActivityInfoData act1, ActivityInfoData act2) {
                if(act1.activityId > act2.activityId) {
                    return -1;
                }
                else {
                    return 1;

                }
            }
        });
        return actCopy;
    }

    //改写
    private static List<ActivityInfoAdWithType> sortByIdAndSourceAd(List<ActivityInfoAdWithType> acts){

        List<ActivityInfoAdWithType> actCopy = acts;
        Collections.sort(actCopy,  new Comparator<ActivityInfoAdWithType>() {
            public int compare(ActivityInfoAdWithType act1, ActivityInfoAdWithType act2) {
                if(act1.activityId > act2.activityId) {
                    return -1;
                }
                else {
                    return 1;

                }
            }
        });
        return actCopy;
    }


    private static List<ActivityModel> sortByIdAndSourceModelBack(List<ActivityModel> acts){
        List<ActivityModel> actCopy = acts;
        Collections.sort(actCopy, new Comparator<ActivityModel>() {
            public int compare(ActivityModel act1, ActivityModel act2) {
                if(act1.activityId > act2.activityId) {
                    return -1;
                }
                else {
                    return 1;

                }
            }
        });
        return actCopy;

    }

    private static List<ActivityData> sortByIdAndSourceDataBack(List<ActivityData> acts){

        List<ActivityData> actCopy = acts;
        Collections.sort(actCopy, new Comparator<ActivityData>() {
            public int compare(ActivityData act1, ActivityData act2) {
                if(act1.activityId > act2.activityId) {
                    return -1;
                }
                else {
                    return 1;

                }
            }
        });
        return actCopy;
    }




    //recall
    //外部调用
    public static List<ActivityInfoModel> match (List<ActivityInfoModel> actModel, List<ActivityInfoData> actData, List<ActivityInfoAdWithType> actAd) { //TODO 命名不规范

        int topn = Constant.SEARANK_TOPN;
        List<ActivityInfoModel> result = new ArrayList<ActivityInfoModel>();
        List<ActivityInfoModel> actModelCopy = new ArrayList<ActivityInfoModel>();

        Queue<MatchInfo> candis = new PriorityQueue<>(actData.size(), iComparator);
        Queue<MatchInfo> slotCandis = new PriorityQueue<>(actData.size(), iComparator);
        Queue<MatchInfo> appCandis = new PriorityQueue<>(actData.size(), iComparator);
        Queue<MatchInfo> globalCandis = new PriorityQueue<>(actData.size(), iComparator);


        //排序
        List<ActivityInfoData> actDataCopy =  sortByIdAndSourceData(actData);//广告id大的在前面
        HashMap<Long,ActivityInfoAdWithType> adHashMap = new HashMap<Long,ActivityInfoAdWithType>();

        for(int i = 0;i < actAd.size();++i){
            adHashMap.put(actAd.get(i).activityId,actAd.get(i));
        }


        long size_act = actDataCopy.size();

        //判断列表是否相等，不相等抛异常

        HashSet<Long> idset = new HashSet();  //提前
        int limit = topn;  //提前
        //同时遍历
        for (int i = 0;i < size_act;++i) {
            try {
                ActivityInfoModel actM = new ActivityInfoModel();
                actM.activityId = actDataCopy.get(i).activityId;
                actM.slotId = actDataCopy.get(i).slotId;
                actM.appId = actDataCopy.get(i).appId;


                //更新历史数据
                actM.hisClick = new Val();
                actM.hisClick.globalVal = actDataCopy.get(i).click.globalVal;
                actM.hisClick.appVal = actDataCopy.get(i).click.appVal;
                actM.hisClick.slotVal = actDataCopy.get(i).click.slotVal;

                actM.hisCost = new Val();
                actM.hisCost.globalVal = actDataCopy.get(i).cost.globalVal;
                actM.hisCost.appVal = actDataCopy.get(i).cost.appVal;
                actM.hisCost.slotVal = actDataCopy.get(i).cost.slotVal;
//                System.out.println("actModelCopy.get("+actM.activityId+").hisCost.appVal="+actM.hisCost.appVal);

                actM.hisRequest = new Val();
                actM.hisRequest.globalVal = actDataCopy.get(i).request.globalVal;
                actM.hisRequest.appVal = actDataCopy.get(i).request.appVal;
                actM.hisRequest.slotVal = actDataCopy.get(i).request.slotVal;
                actM.isHot = actDataCopy.get(i).isHot;
                actM.uploadTime = actDataCopy.get(i).uploadTime;
                actModelCopy.add(actM);

//                System.out.println("actDataCopy.get(i).request.globalVal="+actDataCopy.get(i).request.globalVal);
                //新活动试投

                // 热点活动直接进入海选池
                if(actM.isHot && System.currentTimeMillis() - actM.uploadTime < 60 * 1000 * 60 * 24 * 3){
                    for (int j = 0; j < Constant.FESTIVAL.size(); j++) {
                        long festival = Constant.FESTIVAL.get(i);
                        boolean isInFestival =
                            System.currentTimeMillis() - festival < 60 * 1000 * 60 * 24 * 3 && System.currentTimeMillis() - festival >= 0;
                        if(isInFestival){
                            result.add(actM);
                            topn--;
                            idset.add(actM.activityId);
                            break;
                        }
                    }
                }

                if (actM.hisRequest.globalVal < 100) { //全局活动请求数少于100
                    //continue;
                    if(System.currentTimeMillis() - actDataCopy.get(i).createTime < 60 * 1000 * 60 * 24 * 3) //上架时间小于三天
                    {
                        if (Math.random() < 0.0001) { //小于0.0001进行试投
                            result.add(actM);
                            topn--; //占用一个名额
                            idset.add(actM.activityId) ;
                        }
                    }
                    else if (actDataCopy.size() > limit) { //为什么
                        if (Math.random() < 0.00001) {  //小于0.00001进行试投
                            result.add(actM);
                            topn--;//占用一个名额
                            idset.add(actM.activityId) ;
                        }
                    }

                } else {
                    //计算matchscore
                    double slotScore = WilsonInterval.wilsonCalc((long) actM.hisClick.slotVal, (long) actM.hisRequest.slotVal * 3).lowerBound;
                    double globalScore = WilsonInterval.wilsonCalc((long) actM.hisClick.globalVal, (long) actM.hisRequest.globalVal * 3).lowerBound;
                    double appScore = WilsonInterval.wilsonCalc((long) actM.hisClick.appVal, (long) actM.hisRequest.appVal * 3).lowerBound;
                    //为什么乘以3
                    double coef = 0, matchscore = 0;

                    double sconfidence = Math.min(actM.hisRequest.slotVal / 100, 1);
                    double aconfidence = Math.min(actM.hisRequest.appVal / 100, 1);
                    double gconfidence = Math.min(actM.hisRequest.globalVal / 1000, 1);


                    matchscore = sconfidence * slotScore
                            + (1 - sconfidence) * aconfidence * appScore * 0.9
                            + (1 - sconfidence - (1 - sconfidence) * aconfidence) * globalScore * Math.max(0.5, gconfidence);

                    double changeScore = 0.0d;
                    ActivityChangeVal  activityChangeValNew= new ActivityChangeVal() ;

                    if(adHashMap.containsKey(actDataCopy.get(i).activityId)) {
                        //changeScore = calChangeScore(adHashMap.get(actDataCopy.get(i).activityId).getAdverts()); //TODO
                        //changeScore = calChangeScoreMerge(adHashMap.get(actDataCopy.get(i).activityId).getAdvertsWithType()); //计算广告转化综合得分
                        activityChangeValNew= calChangeScoreMergeAbsolute(adHashMap.get(actDataCopy.get(i).activityId).getAdvertsWithType()); //计算广告转化综合得分
                        changeScore = activityChangeValNew.changeScoreMerge ;
                    }

//                    System.out.println(actM.activityId+" changeScore="+changeScore);

                    actM.changeScore = changeScore;
                    actM.activityChangeVal= activityChangeValNew ;

                    //当slotScore<100的时候，才会启用appScore和globalScore

                    //计算 changeScore


                    MatchInfo info = new MatchInfo();
                    info.act = actM;
                    info.score = matchscore;  //威尔逊点击置信区间得分
                    candis.add(info);

                    if (sconfidence > 0.99 || actM.hisClick.slotVal > 5) { //广告位请求数大于99 或点击大于5
                        MatchInfo info2 = new MatchInfo();
                        info2.act = actM;
                        //分数是消耗除以请求数
                        info2.score = actM.hisRequest.slotVal > 0 ? actM.hisCost.slotVal / actM.hisRequest.slotVal : 0;

                        slotCandis.add(info2);
                    }

                    if (aconfidence > 0.99 || actM.hisClick.appVal > 5) { //app请求数大于99 或点击大于5  //bug 应该是appVal>5
                        MatchInfo info3 = new MatchInfo();
                        info3.act = actM;
                        //分数是消耗除以请求数
                        info3.score = actM.hisRequest.appVal > 0 ? actM.hisCost.appVal / actM.hisRequest.appVal : 0;
                        appCandis.add(info3);
                    }

                }
            }catch (Exception e)
            {
//                logger.error("error, act:{}", JSON.toJSONString(actM));
                logger.error(e.getMessage(), e);
//                System.out.println(e.getMessage());
            }
        }


        int size1 = slotCandis.size();
        for (int i = 0; i < 10 && i < size1; i++) {
            ActivityInfoModel act =  slotCandis.poll().act;
            if(idset.contains(act.activityId))
                continue;
            result.add(act);   //未判断去重 可能重复
            idset.add(act.activityId);
            topn-- ;
        }

        int size = candis.size();
        int resultSize=result.size() ;

        //for (int i = 0; i < topn && i < size; i++) {
        for (int i = 0; resultSize < limit && i < size; i++) {
            ActivityInfoModel act =  candis.poll().act;
            if(idset.contains(act.activityId))
                continue;
            result.add(act);
            idset.add(act.activityId);   //凑齐topn个活动
            resultSize = result.size() ;
            topn-- ;
        }

        if (result.size() < limit)
        {
            int count = topn;
            for (int i = 0;i < size_act;++i){

                if(idset.contains(actDataCopy.get(i).activityId))
                    continue;
                idset.add(actDataCopy.get(i).activityId);
                actModelCopy.get(i).hisClick.globalVal = actDataCopy.get(i).click.globalVal;
                actModelCopy.get(i).hisClick.appVal = actDataCopy.get(i).click.appVal;
                actModelCopy.get(i).hisClick.slotVal = actDataCopy.get(i).click.slotVal;

                actModelCopy.get(i).hisCost.globalVal = actDataCopy.get(i).cost.globalVal;
                actModelCopy.get(i).hisCost.appVal = actDataCopy.get(i).cost.appVal;
                actModelCopy.get(i).hisCost.slotVal = actDataCopy.get(i).cost.slotVal;

                actModelCopy.get(i).hisRequest.globalVal = actDataCopy.get(i).request.globalVal;
                actModelCopy.get(i).hisRequest.appVal = actDataCopy.get(i).request.appVal;
                actModelCopy.get(i).hisRequest.slotVal = actDataCopy.get(i).request.slotVal;

                result.add( actModelCopy.get(i));
                count++;
                if(count >= topn)
                    break;

            }
        }
        return result;
    }

    //100 - 10 - 1
    //后端调用  //实时数据端传递过来的是海选后的活动模型列表
    public static SelectActivityResult select(List<ActivityModel> actModelCopy, List<ActivityData> actDataCopy, double gama) {

        SelectActivityResult  SelectActivityResult=new SelectActivityResult();

        //1、init
        ArrayList<Double> rewards = new ArrayList<>();
        ArrayList<Double> counts = new ArrayList<>();
        ArrayList<Double> alphas = new ArrayList<>();
        ArrayList<Double> betas = new ArrayList<>();
        ArrayList<Double> changeScores = new ArrayList<>();
        ArrayList<Long> activityIds = new ArrayList<>();
        ArrayList<Long> activityTypes = new ArrayList<>();

        List<ActivityModel> candiList = new ArrayList<>();

        double decay = Constant.DECAY;

        int size = 0;

        HashMap<Long, RankInfo> mMap = new HashMap();
        double maxG = Constant.MIN_REWARD, maxH = Constant.MIN_REWARD, maxA = Constant.MIN_REWARD;
        double maxGchange = Constant.MIN_REWARD, maxHchange = Constant.MIN_REWARD, maxAchange = Constant.MIN_REWARD;
        ActivityModel result = null;

        try {

            //2、match

            //3、rank
            //3.1 get info
            for (int i = 0;i<actDataCopy.size();++i) {
                //get global data Click
                RankInfo info = mMap.containsKey(actDataCopy.get(i).activityId) ? mMap.get(actDataCopy.get(i).activityId) : new RankInfo();
                double grpm = actDataCopy.get(i).hisRequest.globalVal > 0 ? actDataCopy.get(i).hisCost.globalVal / actDataCopy.get(i).hisRequest.globalVal : 0;

                info.grpm = grpm;
                info.gexp = actDataCopy.get(i).hisRequest.globalVal;
                maxG = Math.max(grpm, maxG);


                //get app data Cost
                double arpm = actDataCopy.get(i).hisRequest.appVal > 0 ? actDataCopy.get(i).hisCost.appVal / actDataCopy.get(i).hisRequest.appVal : 0;

                info.arpm = arpm;
                info.aexp = actDataCopy.get(i).hisRequest.appVal;
                if (info.hexp > 50) {
                    maxA = Math.max(arpm, maxA);

                }


                //get slot data Cost
                double hrpm = actDataCopy.get(i).hisRequest.slotVal > 0 ? actDataCopy.get(i).hisCost.slotVal / actDataCopy.get(i).hisRequest.slotVal : 0;

                info.hrpm = hrpm;
                info.hexp = actDataCopy.get(i).hisRequest.slotVal;



                //System.out.println(hrpm+"\t"+maxH);

                mMap.put(actDataCopy.get(i).activityId, info);
            }

            for (int i = 0;i<actDataCopy.size();++i) {

                    double reward = Constant.MIN_REWARD;
                    double sconfidence = Math.min(actDataCopy.get(i).hisRequest.slotVal / 60, 1);
                    double aconfidence = Math.min(actDataCopy.get(i).hisRequest.appVal / 60, 1);

                    reward = sconfidence * normlize(mMap.get(actDataCopy.get(i).activityId).hrpm * 0.8, maxH, 0.8) +
                            (1 - sconfidence) * aconfidence * normlize(mMap.get(actDataCopy.get(i).activityId).arpm * 0.7, maxA, 0.7) +
                            (1 - sconfidence - (1 - sconfidence) * aconfidence) * normlize(mMap.get(actDataCopy.get(i).activityId).grpm * 0.5, maxG, 0.6);

                    System.out.println(actDataCopy.get(i)+" reward="+reward);
                    reward = reward * reward;

                    reward = Math.max(reward, Constant.MIN_REWARD);

                    actModelCopy.get(i).reward = actModelCopy.get(i).reward * decay + reward;
                    actModelCopy.get(i).count = actModelCopy.get(i).count * decay + 1.0;
                    actModelCopy.get(i).alpha = 1.5 + actModelCopy.get(i).reward;
                    actModelCopy.get(i).beta = 2.0 + (actModelCopy.get(i).count - actModelCopy.get(i).reward);


                rewards.add(actModelCopy.get(i).reward);
                counts.add(actModelCopy.get(i).count);
                alphas.add(actModelCopy.get(i).alpha);
                betas.add(actModelCopy.get(i).beta);
                activityTypes.add(actModelCopy.get(i).activityType);
                activityIds.add(actModelCopy.get(i).activityId);
                changeScores.add(actModelCopy.get(i).changeScore);
                candiList.add(actModelCopy.get(i));
            }

            //4、select

            int numMachines = candiList.size();

            SelectInfoDetail selectInfoDetail = selectMachineWithChangeScore(alphas, betas,activityTypes, activityIds,changeScores,numMachines,gama);

            int selectedActivityIndex = selectInfoDetail.index;
            result = candiList.get(selectedActivityIndex);  //筛选出来的活动及对应的模型参数


            //消耗分相近的活动信息
            ArrayList<SelectInfo> sameCostcondi = selectInfoDetail.condi;
            Double selectedActivityChangeScore=result.changeScore;
            int sameCostActivityCnt=sameCostcondi.size();

            //System.out.println("selectedActivityIndex: " +selectedActivityIndex);
            //System.out.println("selectedActivityChangeScore: " +selectedActivityChangeScore);

            List<SameCostActivitiesInfo> sameCostActivitiesInfoList = new ArrayList<>();

            for (SelectInfo  selectInfo:sameCostcondi){

                SameCostActivitiesInfo sameCostActivitiesInfo=new SameCostActivitiesInfo();

                Long  activityId=selectInfo.activityId;
                Long activityType=selectInfo.activityType;

                int ifSelected=0;
                if (selectInfo.index==selectedActivityIndex){
                    ifSelected=1;
                }

                int index=selectInfo.index;

                Double mabReward=selectInfo.reward;
                Double changeScore=selectInfo.changeScore;

                //计算与最优的差异
                Double diffChangeScore=selectInfo.changeScore-selectedActivityChangeScore;

                //封装
                sameCostActivitiesInfo.activityId=activityId;
                sameCostActivitiesInfo.sameActivityCnt=sameCostActivityCnt;
                sameCostActivitiesInfo.activityType=activityType;
                sameCostActivitiesInfo.ifSelected=ifSelected;
                sameCostActivitiesInfo.mabReward=mabReward;   //带转化筛选时重新计算了reward，与前面的reward计算不一致
                sameCostActivitiesInfo.changeScore=changeScore;
                sameCostActivitiesInfo.index=index;
                sameCostActivitiesInfo.diffChangeScore=diffChangeScore;
                sameCostActivitiesInfoList.add(sameCostActivitiesInfo);
                //System.out.println("sameCostInfo: " +sameCostInfo);
            }


            //result = candiList.get(selectMachineWithChangeScore(alphas, betas,activityTypes, activityIds,changeScores,numMachines,gama));


            SelectActivityResult.activityModel=result;
            SelectActivityResult.sameCostActivitiesInfoList=sameCostActivitiesInfoList;

            mMap.clear();

            //System.out.println(result.activityId);
            return SelectActivityResult;
            //return result;
        }catch (Exception e)
        {
            logger.error(e.getMessage(), e);
            logger.error("error, size:{},candi:{},list:{},", size, JSON.toJSONString(candiList), JSON.toJSONString(result));
        }

        return null;
    }

    public static  void print(ActivityInfo act)
    {
        System.out.println("-----------"+act.activityId+"-----------");
        System.out.println("request = "+act.request.slotVal+"\t"+act.request.appVal+"\t"+act.request.globalVal);
        System.out.println("click = "+act.click.slotVal+"\t"+act.click.appVal+"\t"+act.click.globalVal);
        System.out.println("lastRequest = "+act.lastRequest.slotVal+"\t"+act.lastRequest.appVal+"\t"+act.lastRequest.globalVal);
        System.out.println("lastClick = "+act.lastClick.slotVal+"\t"+act.lastClick.appVal+"\t"+act.lastClick.globalVal);
        System.out.println("hisRequest = "+act.hisRequest.slotVal+"\t"+act.hisRequest.appVal+"\t"+act.hisRequest.globalVal);
        System.out.println("hisClick = "+act.hisClick.slotVal+"\t"+act.hisClick.appVal+"\t"+act.hisClick.globalVal);
    }

    public static double normlize(double val, double max, double limit) {
        double norm = Math.min(val * limit / max, limit);
        return norm;
    }


    /*
     *功能描述
     * 热点活动和普通活动分组，并评价对比每组最优活动效果
     * 评价准则：
     * 热点活动收益>普通活动收益*pv_consume时段加权因子*0.95且热点活动cvr>普通活动cvr*cvr时段加权因子*0.95，热点活动胜出
     * 热点活动收益<普通活动收益*pv_consume时段加权因子*0.95且热点活动cvr<cvr时段加权因子*普通活动cvr*0.95 || 热点活动收益<普通活动收益*pv_consume时段加权因子*0.92或热点活动cvr<普通活动cvr*cvr时段加权因子*0.92,热点活动效果差，按节日第一天、第二天分别以5%、1%概率投放，否则不再给热点活动额外加权概率投放
     * 其他，普通活动胜出
     * @author lijingzhe
     * @date 2019/5/15
     * @param [actModel, actData, gama]
     * @return cn.com.duiba.nezha.alg.common.model.activityselectconversionforms.SelectActivityResult
     */
    public static SelectActivityResult hotSelect(List<ActivityModel> actModel, List<ActivityData> actData, double gama) {
        SelectActivityResult selectActivityResult=new SelectActivityResult();
        Map<Long,ActivityData> mMap = new HashMap();
        //1.判断列表长度，不一致抛异常
        if(actModel.size() == 0|| actData.size() ==0){
            return null;
        }
        if(actModel.size() != actData.size()){
            selectActivityResult.activityModel=actModel.get(0);
            selectActivityResult.sameCostActivitiesInfoList=null;
            return selectActivityResult; //todo 抛异常
        }
        List<ActivityModel> actModelCopy =  sortByIdAndSourceModelBack(actModel);  //广告id倒排
        List<ActivityData> actDataCopy =  sortByIdAndSourceDataBack(actData);
        // 热点活动组
        List<ActivityModel> hotActivityModels = new ArrayList<>();
        List<ActivityData> hotActivityData = new ArrayList<>();
        // 普通活动组
        List<ActivityModel> activityModels = new ArrayList<>();
        List<ActivityData> activityData = new ArrayList<>();
        //活动 id 对不上返回空或 热点类型不同返回空
        for(int i = 0; i< actModelCopy.size();++i) {
            long activityIdMode = actModelCopy.get(i).activityId;
            long activityIdData = actDataCopy.get(i).activityId;
            boolean isSameHotActivity = actModelCopy.get(i).isHot==actData.get(i).isHot;
            if (activityIdMode != activityIdData || !isSameHotActivity) {
                selectActivityResult.activityModel=actModel.get(0);
                selectActivityResult.sameCostActivitiesInfoList=null;
                return selectActivityResult; // todo 抛异常
            }
            actModelCopy.get(i).changeScore = actDataCopy.get(i).changeScore;
            //热点和普通活动分组
            ActivityModel ham = actModelCopy.get(i);
            ActivityData had = actDataCopy.get(i);
            if(ham.isHot){
                hotActivityModels.add(ham);
                hotActivityData.add(had);
                mMap.put(had.activityId,had);
            }else{
                activityModels.add(ham);
                activityData.add(had);
            }
        }
        SelectActivityResult  shar = select(hotActivityModels,hotActivityData, gama);
        SelectActivityResult sar = select(activityModels,activityData,gama);
        long diffTime =
            System.currentTimeMillis() - mMap.get(shar.activityModel.getActivityId()).uploadTime;
        if(diffTime >= 60 * 1000 * 60 * 24 * 3){
            return sar;
        }
        if(mMap.get(shar.activityModel.activityId).hisRequest.slotVal < 50){
            if(Math.random()<0.5){
                return shar;
            }
        }else{
            int currentHour = DateUtil.getHour(new Date());
            // cvr分时段加权因子
            double hourCvrWeight = 1.0;
            // pv_consume分时段加权因子
            double hourRewardWeight = 1.0;
            switch (currentHour){
                case 0:hourCvrWeight = 1.2;hourRewardWeight = 0.93;break;
                case 1:hourCvrWeight = 1.24;hourRewardWeight = 0.95;break;
                case 2:hourCvrWeight = 1.22;hourRewardWeight = 0.84;break;
                case 3:hourCvrWeight = 1.48;hourRewardWeight = 0.65;break;
                case 4:hourCvrWeight = 1.68;hourRewardWeight = 0.46;break;
                case 5:hourCvrWeight = 1.67;hourRewardWeight = 0.47;break;
                case 6:hourCvrWeight = 1.34;hourRewardWeight = 0.74;break;
                case 7:hourCvrWeight = 1.23;hourRewardWeight = 0.82;break;
                case 8:hourCvrWeight = 0.98;hourRewardWeight = 1.06;break;
                case 9:hourCvrWeight = 0.92;hourRewardWeight = 1.24;break;
                case 10:hourCvrWeight = 0.91;hourRewardWeight = 1.22;break;
                case 11:hourCvrWeight = 0.78;hourRewardWeight = 1.21;break;
                case 12:hourCvrWeight = 0.78;hourRewardWeight = 1.14;break;
                case 13:hourCvrWeight = 0.88;hourRewardWeight = 1.25;break;
                case 14:hourCvrWeight = 0.87;hourRewardWeight = 1.26;break;
                case 15:hourCvrWeight = 0.87;hourRewardWeight = 1.25;break;
                case 16:hourCvrWeight = 0.82;hourRewardWeight = 1.18;break;
                case 17:hourCvrWeight = 0.96;hourRewardWeight = 1.03;break;
                case 18:hourCvrWeight = 1.01;hourRewardWeight = 0.91;break;
                case 19:hourCvrWeight = 0.96;hourRewardWeight = 0.95;break;
                case 20:hourCvrWeight = 0.92;hourRewardWeight = 0.96;break;
                case 21:hourCvrWeight = 0.88;hourRewardWeight = 0.88;break;
                case 22:hourCvrWeight = 0.91;hourRewardWeight = 0.81;break;
                case 23:hourCvrWeight = 1.02;hourRewardWeight = 0.68;break;
                default:hourCvrWeight = 1.0;hourRewardWeight = 1.0;
            }

            if(shar.activityModel.reward>=sar.activityModel.reward*hourRewardWeight*0.95 && shar.activityModel.changeScore>=sar.activityModel.changeScore*hourCvrWeight*0.95){
                return shar;
            }else if(shar.activityModel.reward<sar.activityModel.reward*hourRewardWeight*0.95 && shar.activityModel.changeScore<sar.activityModel.changeScore*hourCvrWeight*0.95 || shar.activityModel.reward<sar.activityModel.reward*hourRewardWeight*0.92 && shar.activityModel.changeScore>=sar.activityModel.changeScore*hourCvrWeight*0.92 || shar.activityModel.changeScore<sar.activityModel.changeScore*hourCvrWeight*0.92 && shar.activityModel.reward>=sar.activityModel.reward*hourRewardWeight*0.95){
                if(mMap.get(shar.activityModel.getActivityId()).hisRequest.slotVal <= 200){
                    System.out.println("diffTIme:"+diffTime);
                    if( diffTime>=0 && diffTime<60 * 1000 * 60 * 24 * 1){
                        if(Math.random()<0.05){
                            return shar;
                        }
                    }else if(diffTime>=60 * 1000 * 60 * 24 * 1 && diffTime<60 * 1000 * 60 * 24 * 2){
                        if(Math.random()<0.01){
                            return shar;
                        }
                    }
                }
            }
        }
        return sar;
    }

    //融合表单和非表单类广告的综合得分
    public static double calChangeScoreMerge(List<AdvertWithType> ads) {

        double changeScoreMerge = 0.0d;

        double changeScoreForms = 0.0d;
        double changeScoreNotForms = 0.0d;

        double sumClick = 0.0d;
        double sumEffectPV = 0.0d;

        //表单类广告
        double sumClickForms = 0.0d;
        double sumEffectPVForms = 0.0d;

        //非表单类广告
        double sumClickNotForms = 0.0d;
        double sumEffectPVNotForms = 0.0d;

        //表单类广告个数


        for(AdvertWithType ad:ads){
            if (ad.ifForms==1){
                sumClickForms +=ad.getClick();
                sumEffectPVForms +=ad.getEffectPV();
            }
            else{
                sumClickNotForms +=ad.getClick();
                sumEffectPVNotForms +=ad.getEffectPV();
            }


            sumClick += ad.click;
            sumEffectPV += ad.effectPV;
        }
        for(AdvertWithType ad:ads){//计算转化分 ,考虑个数问题，比如表单类10个，非表单类50个

            if (ad.ifForms==1){
                double changeMoreForms = ad.getClick() > 0 ? (double) ad.getEffectPV() / (double) ad.getClick() : 0 ;
                double globalCvr = ad.getGlobalClick() >0 ? ad.getGlobalEffectPV() / ad.getGlobalClick(): 0 ;

                changeMoreForms = globalCvr > 0 ? changeMoreForms/globalCvr :0;  //广告个数影响
                changeMoreForms -= 1;
                double ratio = sumClickForms > 0 ? ad.getClick()/sumClickForms:0; //导致：在当前广告位下点击次数越多的活动（广告），分值越高。活动配广告是不是配死的？
                changeScoreForms += ratio * changeMoreForms;
            }

            else{
                double changeMoreNotForms = ad.getClick() > 0 ? (double) ad.getEffectPV() / (double) ad.getClick() : 0 ;

                double globalCvr = ad.getGlobalClick() >0 ? ad.getGlobalEffectPV() / ad.getGlobalClick(): 0 ;

                changeMoreNotForms = globalCvr > 0 ? changeMoreNotForms/globalCvr :0;
                changeMoreNotForms -= 1;
                double ratio = sumClickNotForms > 0 ? ad.getClick()/sumClickNotForms:0; //导致：在当前广告位下点击次数越多的活动（广告），分值越高。活动配广告是不是配死的？
                changeScoreNotForms += ratio * changeMoreNotForms;
            }
            }


            if (sumEffectPVForms >=1){
                changeScoreMerge = changeScoreForms*0.999 + changeScoreNotForms*0.001;
            }
            else{
                changeScoreMerge=-99;
            }
        return changeScoreMerge;
    }

    private static int selectMachine(List<Double> alphas, List<Double> betas, int numMachines) {
        int selectMachine = 0;
        double maxTheta = 0;

        for (int i = 0; i < numMachines; i++) {
            double theta = BetaDistribution.BetaDist(alphas.get(i), betas.get(i));

            if (theta > maxTheta) {
                maxTheta = theta;
                selectMachine = i;
            }
        }
        return selectMachine;
    }


    //融合表单和非表单类广告，用绝对值的cvr分数
    public static ActivityChangeVal calChangeScoreMergeAbsolute(List<AdvertWithType> ads) {

        double changeScoreMerge = 0.0;

        double changeScoreForms = 0.0;  //该活动下
        double changeScoreNotForms = 0.0;


        double changeScoreFormsGlobal = 0.0;  //全局
        double changeScoreNotFormsGlobal = 0.0;

        double sumClick = 0.0;
        double sumEffectPV = 0.0;

        double sumClickGlobal = 0.0;
        double sumEffectPVGlobal = 0.0;

        //该活动下表单类广告
        double sumClickForms = 0.0;
        double sumEffectPVForms = 0.0;

        //该活动下非表单类广告
        double sumClickNotForms = 0.0;
        double sumEffectPVNotForms = 0.0;



        //全局表单类广告
        double sumGlobalClickForms = 0.0;
        double sumGlobalEffectPVForms = 0.0;

        //全局非表单类广告
        double sumGlobalClickNotForms = 0.0;
        double sumGlobalEffectPVNotForms = 0.0;

        Long formsAdvertCnt=0L; //表单类广告个数
        Long notFormsAdvertCnt=0L; //非表单类广告个数


        for(AdvertWithType ad:ads){
            if (ad.ifForms==1){
                sumClickForms +=ad.getClick();
                sumEffectPVForms +=ad.getEffectPV();

                sumGlobalClickForms += ad.getGlobalClick();
                sumGlobalEffectPVForms += ad.getGlobalEffectPV();
                formsAdvertCnt += 1L;


            }
            else{
                sumClickNotForms +=ad.getClick();
                sumEffectPVNotForms +=ad.getEffectPV();

                sumGlobalClickNotForms += ad.getGlobalClick();
                sumGlobalEffectPVNotForms  += ad.getGlobalEffectPV();
                notFormsAdvertCnt += 1L;

            }

            sumClick += ad.getClick();
            sumEffectPV += ad.getEffectPV();

            sumClickGlobal += ad.getGlobalClick();
            sumEffectPVGlobal += ad.getGlobalEffectPV();
        }

        //直接用总转化除以总点击

         changeScoreForms =sumClickForms > 0 ? sumEffectPVForms/sumClickForms: 0 ;
         changeScoreNotForms = sumClickNotForms > 0 ? sumEffectPVNotForms/sumClickNotForms: 0 ;


        changeScoreFormsGlobal = sumGlobalClickForms >0 ? sumGlobalEffectPVForms / sumGlobalClickForms : 0;
        changeScoreNotFormsGlobal = sumGlobalClickNotForms >0 ? sumGlobalEffectPVNotForms / sumGlobalClickNotForms :0 ;


/*
        for(AdvertWithType ad:ads){//计算转化分 ,考虑个数问题，比如表单类10个，非表单类50个

            if (ad.ifForms==1){
                double changeMoreForms = ad.getClick() > 0 ? (double) ad.getEffectPV() / (double) ad.getClick() : 0 ;

                changeMoreForms = ad.getGlobalCvr() > 0 ? changeMoreForms/ad.getGlobalCvr() :0;  //广告个数影响
                changeMoreForms -= 1;
                double ratio = sumClickForms > 0 ? ad.getClick()/sumClickForms:0; //导致：在当前广告位下点击次数越多的活动（广告），分值越高。活动配广告是不是配死的？
                changeScoreForms += ratio * changeMoreForms;
            }

            else{
                double changeMoreNotForms = ad.getClick() > 0 ? (double) ad.getEffectPV() / (double) ad.getClick() : 0 ;

                changeMoreNotForms = ad.getGlobalCvr() > 0 ? changeMoreNotForms/ad.getGlobalCvr() :0;
                changeMoreNotForms -= 1;
                double ratio = sumClickNotForms > 0 ? ad.getClick()/sumClickNotForms:0; //导致：在当前广告位下点击次数越多的活动（广告），分值越高。活动配广告是不是配死的？
                changeScoreNotForms += ratio * changeMoreNotForms;
            }
        }

*/
        double effctFormsWeight = Math.min(sumEffectPVForms/3.0,1.0);
        double globalEffectFormsWeight= Math.min(sumGlobalEffectPVForms/100.0,1.0);

        double  effctNotFormsWeight=Math.min(sumEffectPVNotForms/30.0,1.0);
        double globalEffectNotFormsWeight= Math.min(sumGlobalEffectPVNotForms/100.0,1.0);


        double rand = Math.random();

//本广告位表单类和全局表单类数据加权  对表单类点击和转化做限制  不考虑非表单数据
        if ( sumEffectPVForms >=1 ) {
            changeScoreMerge = changeScoreForms;

        } else if ( 0 <= sumClickForms && sumClickForms < 100  && changeScoreFormsGlobal >0 ) {
            int w1 = (int) (sumClickForms / 100.0 / 0.2);
            int w2 = 5 - w1;
            changeScoreMerge = 0.01 * w2 * changeScoreFormsGlobal;

        } else if (sumClickForms >= 100 && changeScoreFormsGlobal >0 ) {
            changeScoreMerge = changeScoreFormsGlobal * 1.0 / sumClickForms;

        } else if ( changeScoreNotForms >0 ) {
            changeScoreMerge = changeScoreNotForms * 1.0 / 10000;

        }  else if (rand <= 0.001 ) {
            changeScoreMerge = Math.random();
        }


      /*
        if ( sumEffectPVForms >=1   ) {

            changeScoreMerge = changeScoreForms * effctFormsWeight +
                    changeScoreFormsGlobal * (1-effctFormsWeight);

        } else if (sumGlobalEffectPVForms >=1) {

            changeScoreMerge = changeScoreFormsGlobal * globalEffectFormsWeight +
                    changeScoreNotFormsGlobal * (1-globalEffectFormsWeight);

        } else if (sumClickNotForms >=1 ) {
            changeScoreMerge = changeScoreNotForms * effctNotFormsWeight * 0.7 ;

        } else if (sumGlobalClickNotForms >=100 ) {
            changeScoreMerge= changeScoreNotFormsGlobal * globalEffectNotFormsWeight * 0.5;
        }
        else if ( rand <= 0.001) {
            changeScoreMerge=Math.random();
        }
       */
        //输出 转化得分明细
        ActivityChangeVal  activityChangeVal= new ActivityChangeVal() ;

        activityChangeVal.sumClickForms=sumClickForms;
        activityChangeVal.sumEffectPVForms=sumEffectPVForms;

        activityChangeVal.sumClickNotForms=sumClickNotForms;
        activityChangeVal.sumEffectPVNotForms=sumEffectPVNotForms;

        activityChangeVal.sumGlobalClickForms=sumGlobalClickForms ;
        activityChangeVal.sumGlobalEffectPVForms= sumGlobalEffectPVForms;

        activityChangeVal.sumGlobalClickNotForms= sumGlobalClickNotForms;
        activityChangeVal.sumGlobalEffectPVNotForms= sumGlobalEffectPVNotForms;

        activityChangeVal.changeScoreForms= changeScoreForms;
        activityChangeVal.changeScoreNotForms= changeScoreNotForms;

        activityChangeVal.changeScoreFormsGlobal= changeScoreFormsGlobal ;
        activityChangeVal.changeScoreNotFormsGlobal=  changeScoreNotFormsGlobal ;

        activityChangeVal.formsAdvertCnt= formsAdvertCnt;
        activityChangeVal.notFormsAdvertCnt= notFormsAdvertCnt;
        activityChangeVal.changeScoreMerge=changeScoreMerge;
        //结果输出
      return activityChangeVal ;

    }


    //卡包分版本
    private static SelectInfoDetail selectMachineWithChangeScore(List<Double> alphas, List<Double> betas,List<Long> activityTypes,List<Long> activityIds,List<Double> changeScores, int numMachines,double gama) {
        int selectMachine = 0;
        ArrayList<SelectInfo> sinfos = new  ArrayList<SelectInfo>();
        for (int i = 0; i < numMachines; i++) {
            double theta = BetaDistribution.BetaDist(alphas.get(i), betas.get(i));
            SelectInfo sinfo = new SelectInfo();
//            System.out.println(activityIds.get(i)+"= "+theta);
            sinfo.reward = theta;
            sinfo.activityType = activityTypes.get(i);
            sinfo.index = i;
            sinfo.activityId = activityIds.get(i);
            sinfo.changeScore = changeScores.get(i);
            sinfos.add(sinfo);
        }

        Collections.sort(sinfos, new Comparator<SelectInfo>() {
            public int compare(SelectInfo sinfo1, SelectInfo sinfo2) {
                if(sinfo1.reward > sinfo2.reward) {
                    return -1;
                }
                else {
                    return 1;

                }
            }
        });


        ArrayList<SelectInfo> condi = new ArrayList<SelectInfo>();

        for(int i = 0;i < sinfos.size();++i) {
            if(sinfos.get(0).reward - sinfos.get(i).reward <= gama) { //生成消耗分接近的候选集
                System.out.println("condi "+i+" activityId="+sinfos.get(i).activityId+" theta="+sinfos.get(i).reward+" "+" activityType="+sinfos.get(i).activityType+" changeScore="+changeScores.get(i));
                condi.add(sinfos.get(i));
            }
        }
        Collections.sort(condi, new Comparator<SelectInfo>() {
            public int compare(SelectInfo sinfo1, SelectInfo sinfo2) {
                if(sinfo1.changeScore > sinfo2.changeScore) {
                    return -1;
                }
                else {
                    return 1;

                }
            }
        });
//        System.out.println(condi.get(0).activityId+"="+condi.get(0).changeScore);
//        System.out.println(condi.get(1).activityId+"="+condi.get(1).changeScore);
        selectMachine = condi.get(0).index; //选取一定范围内转化最高的

        for(int i = 0; i < condi.size();++i) {
            if(condi.get(i).activityType != 21){
                selectMachine = condi.get(i).index; //选取消耗分最大的非卡包
                break;
            }
        }

//        System.out.println("sinfos="+sinfos.get(0).activityId);
//        System.out.println("sinfos="+sinfos.get(1).activityId);
//        return  sinfos.get(0).index;
//        System.out.println("selectMachine="+selectMachine);

      //打印消耗分相近的活动的所有信息
        SelectInfoDetail selectInfoDetail=new SelectInfoDetail();
        selectInfoDetail.condi=condi;  //消耗分相近的每个活动信息
        selectInfoDetail.index=selectMachine;  //最优活动索引

        return selectInfoDetail;
        //return selectMachine;

    }




    private double getCtr(double exp, double clk) {
        return exp > 0 ? clk / exp : 0;
    }

    private double sum(List<Long> list) {
        double sum = 0;
        for (Long val : list) {
            sum += val;
        }
        return sum;
    }

    public static double wilsonRoofLeft(Double ratio, Double num) {
        if (ratio == null || num == null)
            return 0;
        long fenzi = (long) (ratio * num);
        long fenmu = num.longValue();
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi, fenmu);
        return pair.upperBound;
    }

    public double wilsonRoofRight(Double num, Double ratio) {
        if (ratio == null || num == null)
            return 0;
        if (ratio == 0) {
            ratio = 0.00000001;
        }
        long fenmu = (long) (num / ratio);
        long fenzi = num.longValue();
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi, fenmu);
        return pair.upperBound;
    }

    public double wilsonBottom(Long fenzi, Long fenmu) {
        if (fenzi == null || fenmu == null)
            return 0;
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi.longValue(), fenmu.longValue());
        return pair.lowerBound;
    }

    public static class SingletonHolder {
        private static final HotActivitySelector instance = new HotActivitySelector();
    }

    private static HotActivitySelector getInstance() {
        return SingletonHolder.instance;
    }
}