package cn.com.duiba.nezha.alg.common.model.pacing;

import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;

import java.text.SimpleDateFormat;
import java.util.*;

public class HelpBySelf {
    /**
     *
     * @param helpBySelfInfo
     * @param helpBySelfParams
     * @return
     */
    private static final Logger logger = LoggerFactory.getLogger(HelpBySelf.class);
    public static HelpMeasureResult helpBySelf(HelpBySelfInfo helpBySelfInfo,HelpBySelfParams helpBySelfParams){
        if (AssertUtil.isAnyEmpty(helpBySelfInfo, helpBySelfParams)) {
            return null;
        }
        HelpMeasureResult helpMeasureResult = new HelpMeasureResult();
        helpMeasureResult.setAdvertId(helpBySelfInfo.advertId);
        helpMeasureResult.setOrientId(helpBySelfInfo.orientId);
        helpMeasureResult.setAppId(helpBySelfInfo.appId);
        helpMeasureResult.setSlotId(helpBySelfInfo.slotId);

        Double orientCostConvertHour = (helpBySelfInfo.orientConvertHour != 0) ? (helpBySelfInfo.orientCostHour/helpBySelfInfo.orientConvertHour):helpBySelfInfo.orientCostHour;

        if (helpBySelfInfo.orientCostHour >= 100000.0 && orientCostConvertHour/helpBySelfInfo.afee >= 1.5) {
            helpMeasureResult.setCostConvertException(2.0);//放弃自救
            return helpMeasureResult;
        }
        Date date = new Date();

        date.getTime();

        /***获取参数***/
        Double reduceRate = helpBySelfParams.reduceRate;//消耗及数据下降多少0.7
        Double dayHourRatio = helpBySelfParams.dayHourRatio;//天和小时数据的权重分配0.7
        Double feeWeight0 = helpBySelfParams.feeWeight0;//广告位出价加权的权重=(1-reduceRate)*0.8+1
        Double feeWeight1 = helpBySelfParams.feeWeight1;//媒体出价加权的权重=0.2*0.8+1
        Double stableFactorThred = helpBySelfParams.stableFactorThred;//维稳因子阈值0.8
        Double touchBaseRate = helpBySelfParams.touchBaseRate;//触发底价消耗占比0.3
        Double orientRatioWeight = helpBySelfParams.orientRatioWeight;//拓量无历史数据定向率加权因子orient
        Double isReorientWeight = helpBySelfParams.isReorientWeight;//拓量-未定向重新定向orient
        Double isBlackRealseWeight = helpBySelfParams.isBlackRealseWeight; //拓量-黑名单orient

        if (Math.random()<0.00001) {
            logger.info("params helpBySelf:{}", helpBySelfParams);
        }


        /****消耗异常***/
        Double orientCostRatio0 = 1.0;
        Double orientCostRatio1 = 1.0;

        if (helpBySelfInfo.orientCostYeshour == 0 && helpBySelfInfo.orientCostYestoday != 0) {
            orientCostRatio0 = helpBySelfInfo.orientCostToday/helpBySelfInfo.orientCostYestoday;
        }
        if (helpBySelfInfo.orientCostAvg7hour == 0 && helpBySelfInfo.orientCostAvg7day != 0) {
            orientCostRatio1 = helpBySelfInfo.orientCostToday/helpBySelfInfo.orientCostAvg7day;
        }
        if (helpBySelfInfo.orientCostYeshour != 0 && helpBySelfInfo.orientCostYestoday != 0 ) {
            orientCostRatio0 = dayHourRatio * helpBySelfInfo.orientCostToday/helpBySelfInfo.orientCostYestoday + (1-dayHourRatio)* helpBySelfInfo.orientCostHour/helpBySelfInfo.orientCostYeshour;
        }
        if (helpBySelfInfo.orientCostAvg7hour != 0 && helpBySelfInfo.orientCostAvg7day != 0 ) {
            orientCostRatio1 = dayHourRatio * helpBySelfInfo.orientCostToday/helpBySelfInfo.orientCostAvg7day + (1-dayHourRatio) * helpBySelfInfo.orientCostHour/helpBySelfInfo.orientCostAvg7hour;
        }

        Date now = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH");//可以方便地修改日期格式
        String nowHour = dateFormat.format(now);

        if (orientCostRatio0 <= reduceRate || orientCostRatio1 <= reduceRate) {

            helpMeasureResult.setCostException(1.0);//待确定

            Integer count = 0;

            /****点击单价***/
            Double costClickRatio0 = 1.0;
            Double costClickRatio1 = 1.0;

            if (helpBySelfInfo.orientSlotCostYeshour == 0 && helpBySelfInfo.orientSlotClickYestoday != 0 && helpBySelfInfo.orientSlotClickToday != 0){
                costClickRatio0 = (helpBySelfInfo.orientSlotCostToday/helpBySelfInfo.orientSlotClickToday) / (helpBySelfInfo.orientSlotCostYestoday/helpBySelfInfo.orientSlotClickYestoday);
            }
            if (helpBySelfInfo.orientSlotCostAvg7hour == 0 && helpBySelfInfo.orientSlotClickAvg7day != 0 && helpBySelfInfo.orientSlotClickToday != 0){
                costClickRatio1 = (helpBySelfInfo.orientSlotCostToday/helpBySelfInfo.orientSlotClickToday) / (helpBySelfInfo.orientSlotCostAvg7day/helpBySelfInfo.orientSlotClickAvg7day);
            }
            if (helpBySelfInfo.orientSlotCostYeshour != 0  && helpBySelfInfo.orientSlotClickYeshour != 0 && helpBySelfInfo.orientSlotClickHour != 0){
                Double r1 = (helpBySelfInfo.orientSlotCostToday/helpBySelfInfo.orientSlotClickToday) / (helpBySelfInfo.orientSlotCostYestoday/helpBySelfInfo.orientSlotClickYestoday);
                Double r2 = (helpBySelfInfo.orientSlotCostHour/helpBySelfInfo.orientSlotClickHour) / (helpBySelfInfo.orientSlotCostYeshour/helpBySelfInfo.orientSlotClickYeshour);
                costClickRatio0 = dayHourRatio * r1 + (1 - dayHourRatio) * r2;
            }
            if (helpBySelfInfo.orientSlotCostAvg7hour !=0  && helpBySelfInfo.orientSlotClickAvg7hour !=0 && helpBySelfInfo.orientSlotClickHour != 0) {
                Double r3 = (helpBySelfInfo.orientSlotCostToday/helpBySelfInfo.orientSlotClickToday) / (helpBySelfInfo.orientSlotCostAvg7day/helpBySelfInfo.orientSlotClickAvg7day);
                Double r4 = (helpBySelfInfo.orientSlotCostHour/helpBySelfInfo.orientSlotClickHour) / (helpBySelfInfo.orientSlotCostAvg7hour/helpBySelfInfo.orientSlotClickAvg7hour);
                costClickRatio1 = dayHourRatio * r3 + (1 - dayHourRatio) * r4;
            }

           if (costClickRatio0  <= reduceRate || costClickRatio1 <= reduceRate){
                helpMeasureResult.getHelpBySelfType().add(1);
                double f0 = 1.0;
                if (Integer.valueOf(nowHour)> 6){
                    f0 = helpBySelfInfo.orientSlotFeeToday != 0 ? Math.max(1,Math.min(1.1*helpBySelfInfo.orientSlotFeeYestoday/helpBySelfInfo.orientSlotFeeToday,feeWeight0)):1.0;

                    helpMeasureResult.setFeeWeightFactor0(f0);
                }

                count ++ ;
            }

            if (helpBySelfInfo.orientFactor != null && helpBySelfInfo.orientFactor != 0 && (helpBySelfInfo.orientFactor < stableFactorThred)){
                helpMeasureResult.getHelpBySelfType().add(1);
                helpMeasureResult.setResetStableFactor(true);//广告_配置维度
                count ++ ;
            }

            /****底价消耗***/
            Double touchBaseRatio = 0.0;
            if (helpBySelfInfo.orientCostHour == 0 && helpBySelfInfo.orientCostToday != 0) {
                touchBaseRatio = helpBySelfInfo.orientSlotTouchBaseCostToday/helpBySelfInfo.orientCostToday;
            }
            if (helpBySelfInfo.orientCostHour !=0 && helpBySelfInfo.orientCostToday != 0) {
                touchBaseRatio = dayHourRatio * helpBySelfInfo.orientSlotTouchBaseCostToday/helpBySelfInfo.orientCostToday + (1 - dayHourRatio)* helpBySelfInfo.orientSlotTouchBaseCostHour/helpBySelfInfo.orientCostHour;
            }
            if (touchBaseRatio > touchBaseRate){
                helpMeasureResult.getHelpBySelfType().add(1);
                helpMeasureResult.setBasePriceException(true);//广告_配置维度
                count ++ ;
            }

            /****竞价次数***/
            Double biddingTimesRatio0 = 1.0;
            Double biddingTimesRatio1 = 1.0;

            if (helpBySelfInfo.orientBiddingTimesYeshour == 0  && helpBySelfInfo.orientBiddingTimesYestoday != 0 ) {
                biddingTimesRatio0 = 1.0 * helpBySelfInfo.orientBiddingTimesToday/helpBySelfInfo.orientBiddingTimesYestoday;

            }
            if (helpBySelfInfo.orientBiddingTimesAvg7hour == 0 && helpBySelfInfo.orientBiddingTimesAvg7day != 0){
                biddingTimesRatio1 = 1.0 * helpBySelfInfo.orientBiddingTimesToday/helpBySelfInfo.orientBiddingTimesAvg7day;
            }
            if (helpBySelfInfo.orientBiddingTimesYeshour != 0 && helpBySelfInfo.orientBiddingTimesYestoday != 0 ){
                biddingTimesRatio0 = dayHourRatio * helpBySelfInfo.orientBiddingTimesToday/helpBySelfInfo.orientBiddingTimesYestoday + (1-dayHourRatio)* helpBySelfInfo.orientBiddingTimesHour/helpBySelfInfo.orientBiddingTimesYeshour;
            };
            if (helpBySelfInfo.orientBiddingTimesAvg7hour != 0 && helpBySelfInfo.orientBiddingTimesAvg7day != 0 ){
                biddingTimesRatio1 = dayHourRatio * helpBySelfInfo.orientBiddingTimesToday/helpBySelfInfo.orientBiddingTimesAvg7day + (1-dayHourRatio) * helpBySelfInfo.orientBiddingTimesHour/helpBySelfInfo.orientBiddingTimesAvg7hour;
            }

            if (biddingTimesRatio0 <= reduceRate || biddingTimesRatio1 <= reduceRate) {
//                helpMeasureResult.getHelpBySelfType().add(2);
//                Double orientCostConvert = (helpBySelfInfo.orientConvertToday != 0) ? (helpBySelfInfo.orientCostToday/helpBySelfInfo.orientConvertToday): helpBySelfInfo.orientCostToday;
                if (helpBySelfInfo.orientCostToday > 3 * helpBySelfInfo.afee && helpBySelfInfo.orientConvertToday >= 1 && (helpBySelfInfo.orientCostToday/helpBySelfInfo.orientConvertToday)/helpBySelfInfo.afee < 1.3) {
                    helpMeasureResult.getHelpBySelfType().add(2);
                    helpMeasureResult.setExpand(true);//配置维度
                    helpMeasureResult.setIsBlackRealse(isBlackRealseWeight);
                    helpMeasureResult.setIsReorient(isReorientWeight);
                    helpMeasureResult.setOrientRatioWeight(orientRatioWeight);
                }
                helpMeasureResult.getHelpBySelfType().add(3);
                helpMeasureResult.getRemindAE1().add(1);
                count ++ ;
            }

            /****PreCtr***/
            Double PreCtrRatio0 = 1.0;
            Double PreCtrRatio1 = 1.0;
            if (helpBySelfInfo.orientSlotPreCtrYeshour == 0 && helpBySelfInfo.orientSlotPreCtrYestoday != 0) {
                PreCtrRatio0 = helpBySelfInfo.orientSlotPreCtrToday/helpBySelfInfo.orientSlotPreCtrYestoday;

            }
            if (helpBySelfInfo.orientSlotPreCtrAvg7hour == 0  && helpBySelfInfo.orientSlotPreCtrAvg7day != 0 ){
                PreCtrRatio1 = helpBySelfInfo.orientSlotPreCtrToday/helpBySelfInfo.orientSlotPreCtrAvg7day;
            }
            if (helpBySelfInfo.orientSlotPreCtrYestoday != 0 && helpBySelfInfo.orientSlotPreCtrYeshour != 0 ){
                PreCtrRatio0 = dayHourRatio * helpBySelfInfo.orientSlotPreCtrToday/helpBySelfInfo.orientSlotPreCtrYestoday + (1-dayHourRatio)* helpBySelfInfo.orientSlotPreCtrHour/helpBySelfInfo.orientSlotPreCtrYeshour;
            };
            if (helpBySelfInfo.orientSlotPreCtrAvg7day != 0 && helpBySelfInfo.orientSlotPreCtrAvg7hour != 0 ){
                PreCtrRatio1 = dayHourRatio * helpBySelfInfo.orientSlotPreCtrToday/helpBySelfInfo.orientSlotPreCtrAvg7day + (1-dayHourRatio) * helpBySelfInfo.orientSlotPreCtrHour/helpBySelfInfo.orientSlotPreCtrAvg7hour;
            }

            if (PreCtrRatio0 <= reduceRate || PreCtrRatio1 <= reduceRate) {
                helpMeasureResult.getHelpBySelfType().add(3);
                helpMeasureResult.getRemindAE2().add(2);
                count ++ ;
            }

            /****出价***/
            Double feeRatio0 = 1.0;
            Double feeRatio1 = 1.0;
            if (helpBySelfInfo.orientSlotFeeYeshour == 0 && helpBySelfInfo.orientSlotFeeYestoday != 0 ) {
                feeRatio0 = 1.0 * helpBySelfInfo.orientSlotFeeToday/helpBySelfInfo.orientSlotFeeYestoday;
            }
            if (helpBySelfInfo.orientSlotFeeAvg7hour == 0 && helpBySelfInfo.orientSlotFeeAvg7day != 0 ){
                feeRatio1 = 1.0 * helpBySelfInfo.orientSlotFeeToday/helpBySelfInfo.orientSlotFeeAvg7day;
            }
            if (helpBySelfInfo.orientSlotFeeYestoday != 0 && helpBySelfInfo.orientSlotPreCtrYeshour != 0 ){
                feeRatio0 = dayHourRatio * helpBySelfInfo.orientSlotFeeToday/helpBySelfInfo.orientSlotFeeYestoday + (1-dayHourRatio)* helpBySelfInfo.orientSlotFeeHour/helpBySelfInfo.orientSlotFeeYeshour;
            }
            if (helpBySelfInfo.orientSlotFeeAvg7day != 0 && helpBySelfInfo.orientSlotFeeAvg7hour != 0 ){
                feeRatio1 = dayHourRatio * helpBySelfInfo.orientSlotFeeToday/helpBySelfInfo.orientSlotFeeAvg7day + (1-dayHourRatio) * helpBySelfInfo.orientSlotFeeHour/helpBySelfInfo.orientSlotFeeAvg7hour;
            }

            if (feeRatio0 <= reduceRate || feeRatio1 <= reduceRate) {
                helpMeasureResult.getHelpBySelfType().add(3);
                helpMeasureResult.getRemindAE2().add(3);
                count ++ ;
            }

//            /****目标出价***/
//            Double afeeRatio0 = 1.0;
//            Double afeeRatio1 = 1.0;
//            if (helpBySelfInfo.orientAfeeYeshour == 0  && helpBySelfInfo.orientAfeeYestoday != 0 ) {
//                biddingTimesRatio0 = 1.0 * helpBySelfInfo.orientSlotFeeToday/helpBySelfInfo.orientSlotFeeYestoday;
//            }
//            if (helpBySelfInfo.orientAfeeAvg7hour == 0 && helpBySelfInfo.orientAfeeAvg7day != 0 ) {
//                biddingTimesRatio1 = 1.0 * helpBySelfInfo.orientSlotFeeToday/helpBySelfInfo.orientSlotFeeAvg7day;
//            }
//            if (helpBySelfInfo.orientAfeeYestoday != 0 && helpBySelfInfo.orientAfeeYeshour != 0 ) {
//                afeeRatio0 = dayHourRatio * helpBySelfInfo.orientAfeeToday/helpBySelfInfo.orientAfeeYestoday + (1 - dayHourRatio) * helpBySelfInfo.orientAfeeHour/helpBySelfInfo.orientAfeeYeshour;
//            }
//
//            if (helpBySelfInfo.orientAfeeAvg7day != 0 && helpBySelfInfo.orientAfeeAvg7hour != 0 ) {
//                afeeRatio1 = dayHourRatio * helpBySelfInfo.orientAfeeToday/helpBySelfInfo.orientAfeeAvg7day + (1 - dayHourRatio) * helpBySelfInfo.orientAfeeHour/helpBySelfInfo.orientAfeeAvg7hour;
//            }
//            if ( afeeRatio0 <= reduceRate || afeeRatio1 <= reduceRate) {
//                helpMeasureResult.getHelpBySelfType().add(3);
//                helpMeasureResult.getRemindAE().add(4);
//                count ++ ;
//            }

            /****原因未知***/
            if (count == 0) {
//                Double orientCostConvert = (helpBySelfInfo.orientConvertToday != 0) ? (helpBySelfInfo.orientCostToday/helpBySelfInfo.orientConvertToday): helpBySelfInfo.orientCostToday;
                if (helpBySelfInfo.orientCostToday > 3 * helpBySelfInfo.afee && helpBySelfInfo.orientConvertToday >= 1 && (helpBySelfInfo.orientCostToday/helpBySelfInfo.orientConvertToday)/helpBySelfInfo.afee < 1.4) {
                    helpMeasureResult.getHelpBySelfType().add(2);
                    helpMeasureResult.setExpand(true);//广告_配置维度
                    helpMeasureResult.setIsBlackRealse(orientRatioWeight);
                    helpMeasureResult.setIsReorient(isReorientWeight);
                    helpMeasureResult.setOrientRatioWeight(isBlackRealseWeight);

                }

            }

        }

        /****成本异常***/
        Double costCovBiasThred = helpBySelfParams.costCovBiasThred;

        Double orientCostConvertToday = (helpBySelfInfo.orientConvertToday != 0) ? (helpBySelfInfo.orientCostToday/helpBySelfInfo.orientConvertToday):helpBySelfInfo.orientCostToday;
//        Double orientCostConvertHour = (helpBySelfInfo.orientConvertHour != 0) ? (helpBySelfInfo.orientCostHour/helpBySelfInfo.orientConvertHour):helpBySelfInfo.orientCostHour;

        Double orientAppCostConvertToday =  (helpBySelfInfo.orientAppConvertToday != 0) ? (helpBySelfInfo.orientAppCostToday/helpBySelfInfo.orientAppConvertToday):helpBySelfInfo.orientAppCostToday;
        Double orientAppCostConvertAvg7day = (helpBySelfInfo.orientAppConvertAvg7day != 0)? (helpBySelfInfo.orientAppCostAvg7day/helpBySelfInfo.orientAppConvertAvg7day):helpBySelfInfo.orientAppCostAvg7day;

        Double orientCostConvertRatio = (orientCostConvertHour !=0 )? (dayHourRatio * orientCostConvertToday/helpBySelfInfo.afee + (1 - dayHourRatio) * orientCostConvertHour/helpBySelfInfo.afee) : orientCostConvertToday/helpBySelfInfo.afee;

        Double orientAppCostConvertRatio = orientAppCostConvertToday/helpBySelfInfo.appAfee;
        Double orientAppCostConvertLast7dayRatio = orientAppCostConvertAvg7day/helpBySelfInfo.appAfee;

        if (((helpBySelfInfo.orientConvertToday != 0) && (orientCostConvertRatio > costCovBiasThred))
                || ((helpBySelfInfo.orientConvertToday == 0) && (helpBySelfInfo.orientCostToday > 5 * helpBySelfInfo.afee))) {

            helpMeasureResult.setCostConvertException(1.0);
//            Double touchBaseRatio = (helpBySelfInfo.orientCostToday !=0 && helpBySelfInfo.orientCostHour != 0)?(dayHourRatio * helpBySelfInfo.orientSlotTouchBaseCostToday/helpBySelfInfo.orientCostToday + (1 - dayHourRatio)* helpBySelfInfo.orientSlotTouchBaseCostHour/helpBySelfInfo.orientCostHour):0.0;
            Double touchBaseRatio = 0.0;

            /****底价消耗***/
            if (helpBySelfInfo.orientCostHour == 0 && helpBySelfInfo.orientCostToday != 0) {
                touchBaseRatio = helpBySelfInfo.orientSlotTouchBaseCostToday/helpBySelfInfo.orientCostToday;
            }
            if (helpBySelfInfo.orientCostHour != 0 && helpBySelfInfo.orientCostToday != 0) {
                touchBaseRatio = dayHourRatio * helpBySelfInfo.orientSlotTouchBaseCostToday/helpBySelfInfo.orientCostToday + (1 - dayHourRatio)* helpBySelfInfo.orientSlotTouchBaseCostHour/helpBySelfInfo.orientCostHour;
            }
            if (touchBaseRatio > touchBaseRate) {
                helpMeasureResult.getHelpBySelfType().add(1);
                helpMeasureResult.setBasePriceException(true);//广告_配置维度

            }

            /****优质媒体***/
            if ((helpBySelfInfo.orientAppConvertToday != 0 && orientAppCostConvertRatio < 1.2)
                    || (helpBySelfInfo.orientAppConvertAvg7day != 0 && orientAppCostConvertLast7dayRatio < 1.2 )) {
                helpMeasureResult.getHelpBySelfType().add(1);

                helpMeasureResult.setFeeWeightFactor1(1 + 0.2 * feeWeight1);//广告_配置_媒体维度
                helpMeasureResult.setCancelStableRelate(true);//广告_配置_媒体_维度

            }

        }


        /****消耗和成本非常异常***/
        if ((helpBySelfInfo.orientCostToday >= 30000.0 && (orientCostRatio0 <= 0.5 * reduceRate || orientCostRatio1 <= 0.5 *reduceRate)  && orientCostConvertRatio > 1.2 * costCovBiasThred)
                || helpBySelfInfo.orientCostToday <= 30000.0 && helpBySelfInfo.orientFactor < 0.7 && Integer.valueOf(nowHour)> 6){

            helpMeasureResult.setFatalException(1.0);
            helpMeasureResult.getHelpBySelfType().add(1);
            helpMeasureResult.getHelpBySelfType().add(2);

            helpMeasureResult.setExpand(true);//广告_配置维度
            helpMeasureResult.setIsBlackRealse(isBlackRealseWeight);
            helpMeasureResult.setIsReorient(isReorientWeight);
            helpMeasureResult.setOrientRatioWeight(orientRatioWeight);
            helpMeasureResult.setResetStableFactor(true);//广告_配置维度
            double f0 = helpBySelfInfo.orientSlotFeeToday != 0 ? Math.max(1,Math.min(1.1*helpBySelfInfo.orientSlotFeeYestoday/helpBySelfInfo.orientSlotFeeToday,feeWeight0)):1.0;
            helpMeasureResult.setFeeWeightFactor0(f0);//广告_配置_广告位维度

        }

        if (helpMeasureResult.getCostException() == 1.0 || helpMeasureResult.getCostConvertException() == 1.0 || helpMeasureResult.getFatalException() == 1.0){
            return helpMeasureResult;
        }

        else {return null;}

    }

    /**
     *
     * @param helpBySelfInfoList
     * @param helpBySelfParams
     * @return
     */

    public static ArrayList<HelpMeasureResult> helpBySelf(ArrayList<HelpBySelfInfo> helpBySelfInfoList,HelpBySelfParams helpBySelfParams) {

        if (AssertUtil.isAnyEmpty(helpBySelfInfoList, helpBySelfParams)) {

            return null;
        }
        ArrayList<HelpMeasureResult> result = new ArrayList<>();
        for (HelpBySelfInfo helpBySelfInfo: helpBySelfInfoList) {
            HelpMeasureResult ret = helpBySelf(helpBySelfInfo,helpBySelfParams);
            if (ret != null) {
                result.add(ret);
            }

        }

        return result;


    }

    /**
     * nezha得到出价后调用该接口
     * @param fee
     * @param isBasePriceException
     * @return
     */
    public static boolean isGiveUpBaseFlow(Long fee,Boolean isBasePriceException,HelpBySelfParams helpBySelfParams){
        boolean isGiveUp = false;

        if (fee <= helpBySelfParams.basePrice && isBasePriceException == true) {
            isGiveUp = true;
        }
        return isGiveUp;
    }


    public static void main(String[] args) {
        HelpMeasureResult result = new HelpMeasureResult();
        result.setCostException(1.0);
        System.out.println(JSON.toJSONString(result));
        Date now = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH");//可以方便地修改日期格式


        String hehe = dateFormat.format(now);
        System.out.println(hehe);
        if ( Integer.valueOf(hehe)==21){
            System.out.println("aaaaaaaaaa");
        }

    }
}
