package cn.com.duiba.nezha.alg.common.model.pacing;

public class TrusteeshipParams {
    //投放目标  1：消耗优先  2：成本优先  3：均衡   默认为均衡模式
    private ReleaseTarget1FeedBackParams releaseTarget1feedBackParams;
    private ReleaseTarget2FeedBackParams releaseTarget2feedBackParams;
    private ReleaseTarget3FeedBackParams releaseTarget3feedBackParams;

    private ReleaseTarget1SlotRecommendParams releaseTarget1slotRecommendParams;
    private ReleaseTarget2SlotRecommendParams releaseTarget2slotRecommendParams;
    private ReleaseTarget3SlotRecommendParams releaseTarget3slotRecommendParams;

    //自救参数

    @Override
    public String toString() {
        return "TrusteeshipParams{" +
                "releaseTarget1feedBackParams=" + releaseTarget1feedBackParams +
                ", releaseTarget2feedBackParams=" + releaseTarget2feedBackParams +
                ", releaseTarget3feedBackParams=" + releaseTarget3feedBackParams +
                ", releaseTarget1slotRecommendParams=" + releaseTarget1slotRecommendParams +
                ", releaseTarget2slotRecommendParams=" + releaseTarget2slotRecommendParams +
                ", releaseTarget3slotRecommendParams=" + releaseTarget3slotRecommendParams +
                '}';
    }

    public ReleaseTarget1FeedBackParams getReleaseTarget1feedBackParams() {
        return releaseTarget1feedBackParams==null?new ReleaseTarget1FeedBackParams():releaseTarget1feedBackParams;
    }

    public void setReleaseTarget1feedBackParams(ReleaseTarget1FeedBackParams releaseTarget1feedBackParams) {
        this.releaseTarget1feedBackParams = releaseTarget1feedBackParams;
    }

    public ReleaseTarget2FeedBackParams getReleaseTarget2feedBackParams() {
        return releaseTarget2feedBackParams==null?new ReleaseTarget2FeedBackParams():releaseTarget2feedBackParams;
    }

    public void setReleaseTarget2feedBackParams(ReleaseTarget2FeedBackParams releaseTarget2feedBackParams) {
        this.releaseTarget2feedBackParams = releaseTarget2feedBackParams;
    }

    public ReleaseTarget3FeedBackParams getReleaseTarget3feedBackParams() {
        return releaseTarget3feedBackParams==null?new ReleaseTarget3FeedBackParams():releaseTarget3feedBackParams;
    }

    public void setReleaseTarget3feedBackParams(ReleaseTarget3FeedBackParams releaseTarget3feedBackParams) {
        this.releaseTarget3feedBackParams = releaseTarget3feedBackParams;
    }

    public ReleaseTarget1SlotRecommendParams getReleaseTarget1slotRecommendParams() {
        return releaseTarget1slotRecommendParams==null?new ReleaseTarget1SlotRecommendParams():releaseTarget1slotRecommendParams;
    }

    public void setReleaseTarget1slotRecommendParams(ReleaseTarget1SlotRecommendParams releaseTarget1slotRecommendParams) {
        this.releaseTarget1slotRecommendParams = releaseTarget1slotRecommendParams;
    }

    public ReleaseTarget2SlotRecommendParams getReleaseTarget2slotRecommendParams() {
        return releaseTarget2slotRecommendParams==null?new ReleaseTarget2SlotRecommendParams():releaseTarget2slotRecommendParams;
    }

    public void setReleaseTarget2slotRecommendParams(ReleaseTarget2SlotRecommendParams releaseTarget2slotRecommendParams) {
        this.releaseTarget2slotRecommendParams = releaseTarget2slotRecommendParams;
    }

    public ReleaseTarget3SlotRecommendParams getReleaseTarget3slotRecommendParams() {
        return releaseTarget3slotRecommendParams==null?new ReleaseTarget3SlotRecommendParams():releaseTarget3slotRecommendParams;
    }

    public void setReleaseTarget3slotRecommendParams(ReleaseTarget3SlotRecommendParams releaseTarget3slotRecommendParams) {
        this.releaseTarget3slotRecommendParams = releaseTarget3slotRecommendParams;
    }

    //定向推荐方法参数
    public class ReleaseTarget1SlotRecommendParams {
        private Double startFactor;//启动因子，刚开启托管防止消耗太快 0.5
        private Double cpaBiasRatioFactor;//
        private Double cpaOrientRatioFactor;
        private Double cpaBiasThresholdFactor;
        private Double cpcTargetRatioFactor;
        private Double cpcOrientRatioFactor;
        private Double cpcBiasThresholdFactor;

        @Override
        public String toString() {
            return "ReleaseTarget1SlotRecommendParams{" +
                    "startFactor=" + startFactor +
                    ", cpaBiasRatioFactor=" + cpaBiasRatioFactor +
                    ", cpaOrientRatioFactor=" + cpaOrientRatioFactor +
                    ", cpaBiasThresholdFactor=" + cpaBiasThresholdFactor +
                    ", cpcTargetRatioFactor=" + cpcTargetRatioFactor +
                    ", cpcOrientRatioFactor=" + cpcOrientRatioFactor +
                    ", cpcBiasThresholdFactor=" + cpcBiasThresholdFactor +
                    '}';
        }

        public ReleaseTarget1SlotRecommendParams() {
        }

        public ReleaseTarget1SlotRecommendParams(Double startFactor, Double cpaBiasRatioFactor, Double cpaOrientRatioFactor, Double cpaBiasThresholdFactor, Double cpcTargetRatioFactor, Double cpcOrientRatioFactor, Double cpcBiasThresholdFactor) {
            this.startFactor = startFactor;
            this.cpaBiasRatioFactor = cpaBiasRatioFactor;
            this.cpaOrientRatioFactor = cpaOrientRatioFactor;
            this.cpaBiasThresholdFactor = cpaBiasThresholdFactor;
            this.cpcTargetRatioFactor = cpcTargetRatioFactor;
            this.cpcOrientRatioFactor = cpcOrientRatioFactor;
            this.cpcBiasThresholdFactor = cpcBiasThresholdFactor;
        }

        public Double getStartFactor() {
            return startFactor!=null?startFactor:0.5;
        }

        public void setStartFactor(Double startFactor) {
            this.startFactor = startFactor;
        }

        public Double getCpaBiasRatioFactor() {
            return cpaBiasRatioFactor!=null?cpaBiasRatioFactor:1.0;
        }

        public void setCpaBiasRatioFactor(Double cpaBiasRatioFactor) {
            this.cpaBiasRatioFactor = cpaBiasRatioFactor;
        }

        public Double getCpaOrientRatioFactor() {
            return cpaOrientRatioFactor!=null?cpaOrientRatioFactor:0.6;
        }

        public void setCpaOrientRatioFactor(Double cpaOrientRatioFactor) {
            this.cpaOrientRatioFactor = cpaOrientRatioFactor;
        }

        public Double getCpaBiasThresholdFactor() {
            return cpaBiasThresholdFactor!=null?cpaBiasThresholdFactor:2.0;
        }

        public void setCpaBiasThresholdFactor(Double cpaBiasThresholdFactor) {
            this.cpaBiasThresholdFactor = cpaBiasThresholdFactor;
        }

        public Double getCpcTargetRatioFactor() {
            return cpcTargetRatioFactor!=null?cpcTargetRatioFactor:0.5;
        }

        public void setCpcTargetRatioFactor(Double cpcTargetRatioFactor) {
            this.cpcTargetRatioFactor = cpcTargetRatioFactor;
        }

        public Double getCpcOrientRatioFactor() {
            return cpcOrientRatioFactor!=null?cpcOrientRatioFactor:0.1;
        }

        public void setCpcOrientRatioFactor(Double cpcOrientRatioFactor) {
            this.cpcOrientRatioFactor = cpcOrientRatioFactor;
        }

        public Double getCpcBiasThresholdFactor() {
            return cpcBiasThresholdFactor!=null?cpcBiasThresholdFactor:1.0;
        }

        public void setCpcBiasThresholdFactor(Double cpcBiasThresholdFactor) {
            this.cpcBiasThresholdFactor = cpcBiasThresholdFactor;
        }
    }

    public class ReleaseTarget2SlotRecommendParams {
        private Double startFactor;
        private Double cpaBiasRatioFactor;
        private Double cpaOrientRatioFactor;
        private Double cpaBiasThresholdFactor;
        private Double cpcTargetRatioFactor;
        private Double cpcOrientRatioFactor;
        private Double cpcBiasThresholdFactor;

        @Override
        public String toString() {
            return "ReleaseTarget2SlotRecommendParams{" +
                    "startFactor=" + startFactor +
                    ", cpaBiasRatioFactor=" + cpaBiasRatioFactor +
                    ", cpaOrientRatioFactor=" + cpaOrientRatioFactor +
                    ", cpaBiasThresholdFactor=" + cpaBiasThresholdFactor +
                    ", cpcTargetRatioFactor=" + cpcTargetRatioFactor +
                    ", cpcOrientRatioFactor=" + cpcOrientRatioFactor +
                    ", cpcBiasThresholdFactor=" + cpcBiasThresholdFactor +
                    '}';
        }

        public ReleaseTarget2SlotRecommendParams() {
        }

        public ReleaseTarget2SlotRecommendParams(Double startFactor, Double cpaBiasRatioFactor, Double cpaOrientRatioFactor, Double cpaBiasThresholdFactor, Double cpcTargetRatioFactor, Double cpcOrientRatioFactor, Double cpcBiasThresholdFactor) {
            this.startFactor = startFactor;
            this.cpaBiasRatioFactor = cpaBiasRatioFactor;
            this.cpaOrientRatioFactor = cpaOrientRatioFactor;
            this.cpaBiasThresholdFactor = cpaBiasThresholdFactor;
            this.cpcTargetRatioFactor = cpcTargetRatioFactor;
            this.cpcOrientRatioFactor = cpcOrientRatioFactor;
            this.cpcBiasThresholdFactor = cpcBiasThresholdFactor;
        }

        public Double getStartFactor() {
            return startFactor!=null?startFactor:0.5;
        }

        public void setStartFactor(Double startFactor) {
            this.startFactor = startFactor;
        }

        public Double getCpaBiasRatioFactor() {
            return cpaBiasRatioFactor!=null?cpaBiasRatioFactor:1.0;
        }

        public void setCpaBiasRatioFactor(Double cpaBiasRatioFactor) {
            this.cpaBiasRatioFactor = cpaBiasRatioFactor;
        }

        public Double getCpaOrientRatioFactor() {
            return cpaOrientRatioFactor!=null?cpaOrientRatioFactor:0.6;
        }

        public void setCpaOrientRatioFactor(Double cpaOrientRatioFactor) {
            this.cpaOrientRatioFactor = cpaOrientRatioFactor;
        }

        public Double getCpaBiasThresholdFactor() {
            return cpaBiasThresholdFactor!=null?cpaBiasThresholdFactor:2.0;
        }

        public void setCpaBiasThresholdFactor(Double cpaBiasThresholdFactor) {
            this.cpaBiasThresholdFactor = cpaBiasThresholdFactor;
        }

        public Double getCpcTargetRatioFactor() {
            return cpcTargetRatioFactor!=null?cpcTargetRatioFactor:0.5;
        }

        public void setCpcTargetRatioFactor(Double cpcTargetRatioFactor) {
            this.cpcTargetRatioFactor = cpcTargetRatioFactor;
        }

        public Double getCpcOrientRatioFactor() {
            return cpcOrientRatioFactor!=null?cpcOrientRatioFactor:0.1;
        }

        public void setCpcOrientRatioFactor(Double cpcOrientRatioFactor) {
            this.cpcOrientRatioFactor = cpcOrientRatioFactor;
        }

        public Double getCpcBiasThresholdFactor() {
            return cpcBiasThresholdFactor!=null?cpcBiasThresholdFactor:1.0;
        }

        public void setCpcBiasThresholdFactor(Double cpcBiasThresholdFactor) {
            this.cpcBiasThresholdFactor = cpcBiasThresholdFactor;
        }
    }

    public class ReleaseTarget3SlotRecommendParams {
        private Double startFactor;
        private Double cpaBiasRatioFactor;
        private Double cpaOrientRatioFactor;
        private Double cpaBiasThresholdFactor;
        private Double cpcTargetRatioFactor;
        private Double cpcOrientRatioFactor;
        private Double cpcBiasThresholdFactor;

        @Override
        public String toString() {
            return "ReleaseTarget3SlotRecommendParams{" +
                    "startFactor=" + startFactor +
                    ", cpaBiasRatioFactor=" + cpaBiasRatioFactor +
                    ", cpaOrientRatioFactor=" + cpaOrientRatioFactor +
                    ", cpaBiasThresholdFactor=" + cpaBiasThresholdFactor +
                    ", cpcTargetRatioFactor=" + cpcTargetRatioFactor +
                    ", cpcOrientRatioFactor=" + cpcOrientRatioFactor +
                    ", cpcBiasThresholdFactor=" + cpcBiasThresholdFactor +
                    '}';
        }

        public ReleaseTarget3SlotRecommendParams() {
        }

        public ReleaseTarget3SlotRecommendParams(Double startFactor, Double cpaBiasRatioFactor, Double cpaOrientRatioFactor, Double cpaBiasThresholdFactor, Double cpcTargetRatioFactor, Double cpcOrientRatioFactor, Double cpcBiasThresholdFactor) {
            this.startFactor = startFactor;
            this.cpaBiasRatioFactor = cpaBiasRatioFactor;
            this.cpaOrientRatioFactor = cpaOrientRatioFactor;
            this.cpaBiasThresholdFactor = cpaBiasThresholdFactor;
            this.cpcTargetRatioFactor = cpcTargetRatioFactor;
            this.cpcOrientRatioFactor = cpcOrientRatioFactor;
            this.cpcBiasThresholdFactor = cpcBiasThresholdFactor;
        }

        public Double getStartFactor() {
            return startFactor!=null?startFactor:0.5;
        }

        public void setStartFactor(Double startFactor) {
            this.startFactor = startFactor;
        }

        public Double getCpaBiasRatioFactor() {
            return cpaBiasRatioFactor!=null?cpaBiasRatioFactor:1.0;
        }

        public void setCpaBiasRatioFactor(Double cpaBiasRatioFactor) {
            this.cpaBiasRatioFactor = cpaBiasRatioFactor;
        }

        public Double getCpaOrientRatioFactor() {
            return cpaOrientRatioFactor!=null?cpaOrientRatioFactor:0.6;
        }

        public void setCpaOrientRatioFactor(Double cpaOrientRatioFactor) {
            this.cpaOrientRatioFactor = cpaOrientRatioFactor;
        }

        public Double getCpaBiasThresholdFactor() {
            return cpaBiasThresholdFactor!=null?cpaBiasThresholdFactor:2.0;
        }

        public void setCpaBiasThresholdFactor(Double cpaBiasThresholdFactor) {
            this.cpaBiasThresholdFactor = cpaBiasThresholdFactor;
        }

        public Double getCpcTargetRatioFactor() {
            return cpcTargetRatioFactor!=null?cpcTargetRatioFactor:0.5;
        }

        public void setCpcTargetRatioFactor(Double cpcTargetRatioFactor) {
            this.cpcTargetRatioFactor = cpcTargetRatioFactor;
        }

        public Double getCpcOrientRatioFactor() {
            return cpcOrientRatioFactor!=null?cpcOrientRatioFactor:0.1;
        }

        public void setCpcOrientRatioFactor(Double cpcOrientRatioFactor) {
            this.cpcOrientRatioFactor = cpcOrientRatioFactor;
        }

        public Double getCpcBiasThresholdFactor() {
            return cpcBiasThresholdFactor!=null?cpcBiasThresholdFactor:1.0;
        }

        public void setCpcBiasThresholdFactor(Double cpcBiasThresholdFactor) {
            this.cpcBiasThresholdFactor = cpcBiasThresholdFactor;
        }
    }

    //正负反馈参数
    public class ReleaseTarget1FeedBackParams {
        private Double fuse1OrientCostG1dFactor;
        private Double fuse2OrientCostG1dFactor;
        private Double fuseOrientCostConvertBiasFactor;
        private Double wSlotOrientationConfidenceFactor;
        private Double wSlotOrientationCostConvertBiasFactor;
        private Double bOrientConfidenceFactor;
        private Double bOrientCostConvertBiasFactor;
        private Double bSlotOrientationConfidenceFactor;
        private Double bSlotOrientationCostConvertBiasFactor;

        @Override
        public String toString() {
            return "ReleaseTarget1FeedBackParams{" +
                    "fuse1OrientCostG1dFactor=" + fuse1OrientCostG1dFactor +
                    ", fuse2OrientCostG1dFactor=" + fuse2OrientCostG1dFactor +
                    ", fuseOrientCostConvertBiasFactor=" + fuseOrientCostConvertBiasFactor +
                    ", wSlotOrientationConfidenceFactor=" + wSlotOrientationConfidenceFactor +
                    ", wSlotOrientationCostConvertBiasFactor=" + wSlotOrientationCostConvertBiasFactor +
                    ", bOrientConfidenceFactor=" + bOrientConfidenceFactor +
                    ", bOrientCostConvertBiasFactor=" + bOrientCostConvertBiasFactor +
                    ", bSlotOrientationConfidenceFactor=" + bSlotOrientationConfidenceFactor +
                    ", bSlotOrientationCostConvertBiasFactor=" + bSlotOrientationCostConvertBiasFactor +
                    '}';
        }

        public ReleaseTarget1FeedBackParams() {
        }

        public ReleaseTarget1FeedBackParams(Double fuse1OrientCostG1dFactor, Double fuse2OrientCostG1dFactor, Double fuseOrientCostConvertBiasFactor, Double wSlotOrientationConfidenceFactor, Double wSlotOrientationCostConvertBiasFactor, Double bOrientConfidenceFactor, Double bOrientCostConvertBiasFactor, Double bSlotOrientationConfidenceFactor, Double bSlotOrientationCostConvertBiasFactor) {
            this.fuse1OrientCostG1dFactor = fuse1OrientCostG1dFactor;
            this.fuse2OrientCostG1dFactor = fuse2OrientCostG1dFactor;
            this.fuseOrientCostConvertBiasFactor = fuseOrientCostConvertBiasFactor;
            this.wSlotOrientationConfidenceFactor = wSlotOrientationConfidenceFactor;
            this.wSlotOrientationCostConvertBiasFactor = wSlotOrientationCostConvertBiasFactor;
            this.bOrientConfidenceFactor = bOrientConfidenceFactor;
            this.bOrientCostConvertBiasFactor = bOrientCostConvertBiasFactor;
            this.bSlotOrientationConfidenceFactor = bSlotOrientationConfidenceFactor;
            this.bSlotOrientationCostConvertBiasFactor = bSlotOrientationCostConvertBiasFactor;
        }

        public Double getFuse1OrientCostG1dFactor() {
            return fuse1OrientCostG1dFactor!=null?fuse1OrientCostG1dFactor:20000.0;
        }

        public void setFuse1OrientCostG1dFactor(Double fuse1OrientCostG1dFactor) {
            this.fuse1OrientCostG1dFactor = fuse1OrientCostG1dFactor;
        }

        public Double getFuse2OrientCostG1dFactor() {
            return fuse2OrientCostG1dFactor!=null?fuse2OrientCostG1dFactor:50000;
        }

        public void setFuse2OrientCostG1dFactor(Double fuse2OrientCostG1dFactor) {
            this.fuse2OrientCostG1dFactor = fuse2OrientCostG1dFactor;
        }

        public Double getFuseOrientCostConvertBiasFactor() {
            return fuseOrientCostConvertBiasFactor!=null?fuseOrientCostConvertBiasFactor:2.0;
        }

        public void setFuseOrientCostConvertBiasFactor(Double fuseOrientCostConvertBiasFactor) {
            this.fuseOrientCostConvertBiasFactor = fuseOrientCostConvertBiasFactor;
        }

        public Double getwSlotOrientationConfidenceFactor() {
            return wSlotOrientationConfidenceFactor!=null?wSlotOrientationConfidenceFactor:0.2;
        }

        public void setwSlotOrientationConfidenceFactor(Double wSlotOrientationConfidenceFactor) {
            this.wSlotOrientationConfidenceFactor = wSlotOrientationConfidenceFactor;
        }

        public Double getwSlotOrientationCostConvertBiasFactor() {
            return wSlotOrientationCostConvertBiasFactor!=null?wSlotOrientationCostConvertBiasFactor:1.2;
        }

        public void setwSlotOrientationCostConvertBiasFactor(Double wSlotOrientationCostConvertBiasFactor) {
            this.wSlotOrientationCostConvertBiasFactor = wSlotOrientationCostConvertBiasFactor;
        }

        public Double getbOrientConfidenceFactor() {
            return bOrientConfidenceFactor!=null?bOrientConfidenceFactor:1.0;
        }

        public void setbOrientConfidenceFactor(Double bOrientConfidenceFactor) {
            this.bOrientConfidenceFactor = bOrientConfidenceFactor;
        }

        public Double getbOrientCostConvertBiasFactor() {
            return bOrientCostConvertBiasFactor!=null?bOrientCostConvertBiasFactor:1.2;
        }

        public void setbOrientCostConvertBiasFactor(Double bOrientCostConvertBiasFactor) {
            this.bOrientCostConvertBiasFactor = bOrientCostConvertBiasFactor;
        }

        public Double getbSlotOrientationConfidenceFactor() {
            return bSlotOrientationConfidenceFactor!=null?bSlotOrientationConfidenceFactor:0.5;
        }

        public void setbSlotOrientationConfidenceFactor(Double bSlotOrientationConfidenceFactor) {
            this.bSlotOrientationConfidenceFactor = bSlotOrientationConfidenceFactor;
        }

        public Double getbSlotOrientationCostConvertBiasFactor() {
            return bSlotOrientationCostConvertBiasFactor!=null?bSlotOrientationCostConvertBiasFactor:3.5;
        }

        public void setbSlotOrientationCostConvertBiasFactor(Double bSlotOrientationCostConvertBiasFactor) {
            this.bSlotOrientationCostConvertBiasFactor = bSlotOrientationCostConvertBiasFactor;
        }
    }

    public class ReleaseTarget2FeedBackParams {
        private Double fuse1OrientCostG1dFactor;
        private Double fuse2OrientCostG1dFactor;
        private Double fuseOrientCostConvertBiasFactor;
        private Double wSlotOrientationConfidenceFactor;
        private Double wSlotOrientationCostConvertBiasFactor;
        private Double bOrientConfidenceFactor;
        private Double bOrientCostConvertBiasFactor;
        private Double bSlotOrientationConfidenceFactor;
        private Double bSlotOrientationCostConvertBiasFactor;

        @Override
        public String toString() {
            return "ReleaseTarget2FeedBackParams{" +
                    "fuse1OrientCostG1dFactor=" + fuse1OrientCostG1dFactor +
                    ", fuse2OrientCostG1dFactor=" + fuse2OrientCostG1dFactor +
                    ", fuseOrientCostConvertBiasFactor=" + fuseOrientCostConvertBiasFactor +
                    ", wSlotOrientationConfidenceFactor=" + wSlotOrientationConfidenceFactor +
                    ", wSlotOrientationCostConvertBiasFactor=" + wSlotOrientationCostConvertBiasFactor +
                    ", bOrientConfidenceFactor=" + bOrientConfidenceFactor +
                    ", bOrientCostConvertBiasFactor=" + bOrientCostConvertBiasFactor +
                    ", bSlotOrientationConfidenceFactor=" + bSlotOrientationConfidenceFactor +
                    ", bSlotOrientationCostConvertBiasFactor=" + bSlotOrientationCostConvertBiasFactor +
                    '}';
        }

        public ReleaseTarget2FeedBackParams() {
        }

        public ReleaseTarget2FeedBackParams(Double fuse1OrientCostG1dFactor, Double fuse2OrientCostG1dFactor, Double fuseOrientCostConvertBiasFactor, Double wSlotOrientationConfidenceFactor, Double wSlotOrientationCostConvertBiasFactor, Double bOrientConfidenceFactor, Double bOrientCostConvertBiasFactor, Double bSlotOrientationConfidenceFactor, Double bSlotOrientationCostConvertBiasFactor) {
            this.fuse1OrientCostG1dFactor = fuse1OrientCostG1dFactor;
            this.fuse2OrientCostG1dFactor = fuse2OrientCostG1dFactor;
            this.fuseOrientCostConvertBiasFactor = fuseOrientCostConvertBiasFactor;
            this.wSlotOrientationConfidenceFactor = wSlotOrientationConfidenceFactor;
            this.wSlotOrientationCostConvertBiasFactor = wSlotOrientationCostConvertBiasFactor;
            this.bOrientConfidenceFactor = bOrientConfidenceFactor;
            this.bOrientCostConvertBiasFactor = bOrientCostConvertBiasFactor;
            this.bSlotOrientationConfidenceFactor = bSlotOrientationConfidenceFactor;
            this.bSlotOrientationCostConvertBiasFactor = bSlotOrientationCostConvertBiasFactor;
        }

        public Double getFuse1OrientCostG1dFactor() {
            return fuse1OrientCostG1dFactor!=null?fuse1OrientCostG1dFactor:20000.0;
        }

        public void setFuse1OrientCostG1dFactor(Double fuse1OrientCostG1dFactor) {
            this.fuse1OrientCostG1dFactor = fuse1OrientCostG1dFactor;
        }

        public Double getFuse2OrientCostG1dFactor() {
            return fuse2OrientCostG1dFactor!=null?fuse2OrientCostG1dFactor:50000;
        }

        public void setFuse2OrientCostG1dFactor(Double fuse2OrientCostG1dFactor) {
            this.fuse2OrientCostG1dFactor = fuse2OrientCostG1dFactor;
        }

        public Double getFuseOrientCostConvertBiasFactor() {
            return fuseOrientCostConvertBiasFactor!=null?fuseOrientCostConvertBiasFactor:2.0;
        }

        public void setFuseOrientCostConvertBiasFactor(Double fuseOrientCostConvertBiasFactor) {
            this.fuseOrientCostConvertBiasFactor = fuseOrientCostConvertBiasFactor;
        }

        public Double getwSlotOrientationConfidenceFactor() {
            return wSlotOrientationConfidenceFactor!=null?wSlotOrientationConfidenceFactor:0.2;
        }

        public void setwSlotOrientationConfidenceFactor(Double wSlotOrientationConfidenceFactor) {
            this.wSlotOrientationConfidenceFactor = wSlotOrientationConfidenceFactor;
        }

        public Double getwSlotOrientationCostConvertBiasFactor() {
            return wSlotOrientationCostConvertBiasFactor!=null?wSlotOrientationCostConvertBiasFactor:1.2;
        }

        public void setwSlotOrientationCostConvertBiasFactor(Double wSlotOrientationCostConvertBiasFactor) {
            this.wSlotOrientationCostConvertBiasFactor = wSlotOrientationCostConvertBiasFactor;
        }

        public Double getbOrientConfidenceFactor() {
            return bOrientConfidenceFactor!=null?bOrientConfidenceFactor:1.0;
        }

        public void setbOrientConfidenceFactor(Double bOrientConfidenceFactor) {
            this.bOrientConfidenceFactor = bOrientConfidenceFactor;
        }

        public Double getbOrientCostConvertBiasFactor() {
            return bOrientCostConvertBiasFactor!=null?bOrientCostConvertBiasFactor:1.2;
        }

        public void setbOrientCostConvertBiasFactor(Double bOrientCostConvertBiasFactor) {
            this.bOrientCostConvertBiasFactor = bOrientCostConvertBiasFactor;
        }

        public Double getbSlotOrientationConfidenceFactor() {
            return bSlotOrientationConfidenceFactor!=null?bSlotOrientationConfidenceFactor:0.5;
        }

        public void setbSlotOrientationConfidenceFactor(Double bSlotOrientationConfidenceFactor) {
            this.bSlotOrientationConfidenceFactor = bSlotOrientationConfidenceFactor;
        }

        public Double getbSlotOrientationCostConvertBiasFactor() {
            return bSlotOrientationCostConvertBiasFactor!=null?bSlotOrientationCostConvertBiasFactor:3.5;
        }

        public void setbSlotOrientationCostConvertBiasFactor(Double bSlotOrientationCostConvertBiasFactor) {
            this.bSlotOrientationCostConvertBiasFactor = bSlotOrientationCostConvertBiasFactor;
        }
    }

    public class ReleaseTarget3FeedBackParams {
        private Double fuse1OrientCostG1dFactor;
        private Double fuse2OrientCostG1dFactor;
        private Double fuseOrientCostConvertBiasFactor;
        private Double wSlotOrientationConfidenceFactor;
        private Double wSlotOrientationCostConvertBiasFactor;
        private Double bOrientConfidenceFactor;
        private Double bOrientCostConvertBiasFactor;
        private Double bSlotOrientationConfidenceFactor;
        private Double bSlotOrientationCostConvertBiasFactor;

        @Override
        public String toString() {
            return "ReleaseTarget3FeedBackParams{" +
                    "fuse1OrientCostG1dFactor=" + fuse1OrientCostG1dFactor +
                    ", fuse2OrientCostG1dFactor=" + fuse2OrientCostG1dFactor +
                    ", fuseOrientCostConvertBiasFactor=" + fuseOrientCostConvertBiasFactor +
                    ", wSlotOrientationConfidenceFactor=" + wSlotOrientationConfidenceFactor +
                    ", wSlotOrientationCostConvertBiasFactor=" + wSlotOrientationCostConvertBiasFactor +
                    ", bOrientConfidenceFactor=" + bOrientConfidenceFactor +
                    ", bOrientCostConvertBiasFactor=" + bOrientCostConvertBiasFactor +
                    ", bSlotOrientationConfidenceFactor=" + bSlotOrientationConfidenceFactor +
                    ", bSlotOrientationCostConvertBiasFactor=" + bSlotOrientationCostConvertBiasFactor +
                    '}';
        }

        public ReleaseTarget3FeedBackParams() {
        }

        public ReleaseTarget3FeedBackParams(Double fuse1OrientCostG1dFactor, Double fuse2OrientCostG1dFactor, Double fuseOrientCostConvertBiasFactor, Double wSlotOrientationConfidenceFactor, Double wSlotOrientationCostConvertBiasFactor, Double bOrientConfidenceFactor, Double bOrientCostConvertBiasFactor, Double bSlotOrientationConfidenceFactor, Double bSlotOrientationCostConvertBiasFactor) {
            this.fuse1OrientCostG1dFactor = fuse1OrientCostG1dFactor;
            this.fuse2OrientCostG1dFactor = fuse2OrientCostG1dFactor;
            this.fuseOrientCostConvertBiasFactor = fuseOrientCostConvertBiasFactor;
            this.wSlotOrientationConfidenceFactor = wSlotOrientationConfidenceFactor;
            this.wSlotOrientationCostConvertBiasFactor = wSlotOrientationCostConvertBiasFactor;
            this.bOrientConfidenceFactor = bOrientConfidenceFactor;
            this.bOrientCostConvertBiasFactor = bOrientCostConvertBiasFactor;
            this.bSlotOrientationConfidenceFactor = bSlotOrientationConfidenceFactor;
            this.bSlotOrientationCostConvertBiasFactor = bSlotOrientationCostConvertBiasFactor;
        }

        public Double getFuse1OrientCostG1dFactor() {
            return fuse1OrientCostG1dFactor!=null?fuse1OrientCostG1dFactor:20000.0;
        }

        public void setFuse1OrientCostG1dFactor(Double fuse1OrientCostG1dFactor) {
            this.fuse1OrientCostG1dFactor = fuse1OrientCostG1dFactor;
        }

        public Double getFuse2OrientCostG1dFactor() {
            return fuse2OrientCostG1dFactor!=null?fuse2OrientCostG1dFactor:50000;
        }

        public void setFuse2OrientCostG1dFactor(Double fuse2OrientCostG1dFactor) {
            this.fuse2OrientCostG1dFactor = fuse2OrientCostG1dFactor;
        }

        public Double getFuseOrientCostConvertBiasFactor() {
            return fuseOrientCostConvertBiasFactor!=null?fuseOrientCostConvertBiasFactor:2.0;
        }

        public void setFuseOrientCostConvertBiasFactor(Double fuseOrientCostConvertBiasFactor) {
            this.fuseOrientCostConvertBiasFactor = fuseOrientCostConvertBiasFactor;
        }

        public Double getwSlotOrientationConfidenceFactor() {
            return wSlotOrientationConfidenceFactor!=null?wSlotOrientationConfidenceFactor:0.2;
        }

        public void setwSlotOrientationConfidenceFactor(Double wSlotOrientationConfidenceFactor) {
            this.wSlotOrientationConfidenceFactor = wSlotOrientationConfidenceFactor;
        }

        public Double getwSlotOrientationCostConvertBiasFactor() {
            return wSlotOrientationCostConvertBiasFactor!=null?wSlotOrientationCostConvertBiasFactor:1.2;
        }

        public void setwSlotOrientationCostConvertBiasFactor(Double wSlotOrientationCostConvertBiasFactor) {
            this.wSlotOrientationCostConvertBiasFactor = wSlotOrientationCostConvertBiasFactor;
        }

        public Double getbOrientConfidenceFactor() {
            return bOrientConfidenceFactor!=null?bOrientConfidenceFactor:1.0;
        }

        public void setbOrientConfidenceFactor(Double bOrientConfidenceFactor) {
            this.bOrientConfidenceFactor = bOrientConfidenceFactor;
        }

        public Double getbOrientCostConvertBiasFactor() {
            return bOrientCostConvertBiasFactor!=null?bOrientCostConvertBiasFactor:1.2;
        }

        public void setbOrientCostConvertBiasFactor(Double bOrientCostConvertBiasFactor) {
            this.bOrientCostConvertBiasFactor = bOrientCostConvertBiasFactor;
        }

        public Double getbSlotOrientationConfidenceFactor() {
            return bSlotOrientationConfidenceFactor!=null?bSlotOrientationConfidenceFactor:0.5;
        }

        public void setbSlotOrientationConfidenceFactor(Double bSlotOrientationConfidenceFactor) {
            this.bSlotOrientationConfidenceFactor = bSlotOrientationConfidenceFactor;
        }

        public Double getbSlotOrientationCostConvertBiasFactor() {
            return bSlotOrientationCostConvertBiasFactor!=null?bSlotOrientationCostConvertBiasFactor:3.5;
        }

        public void setbSlotOrientationCostConvertBiasFactor(Double bSlotOrientationCostConvertBiasFactor) {
            this.bSlotOrientationCostConvertBiasFactor = bSlotOrientationCostConvertBiasFactor;
        }
    }
}