/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.common.model.activityselectconversionforms;

import cn.com.duiba.nezha.alg.common.model.activityselectconversionforms.ActivityChangeVal;
import cn.com.duiba.nezha.alg.common.model.activityselectconversionforms.ActivityData;
import cn.com.duiba.nezha.alg.common.model.activityselectconversionforms.ActivityInfoAdWithType;
import cn.com.duiba.nezha.alg.common.model.activityselectconversionforms.ActivityInfoData;
import cn.com.duiba.nezha.alg.common.model.activityselectconversionforms.ActivityInfoModel;
import cn.com.duiba.nezha.alg.common.model.activityselectconversionforms.ActivityModel;
import cn.com.duiba.nezha.alg.common.model.activityselectconversionforms.ActivitySelector;
import cn.com.duiba.nezha.alg.common.model.activityselectconversionforms.AdvertWithType;
import cn.com.duiba.nezha.alg.common.model.activityselectconversionforms.BetaDistribution;
import cn.com.duiba.nezha.alg.common.model.activityselectconversionforms.ExcellentActivity;
import cn.com.duiba.nezha.alg.common.model.activityselectconversionforms.SameCostActivitiesInfo;
import cn.com.duiba.nezha.alg.common.model.activityselectconversionforms.SelectActivityResult;
import cn.com.duiba.nezha.alg.common.model.activityselectconversionforms.SelectPoolInfo;
import cn.com.duiba.nezha.alg.common.model.activityselectconversionforms.Val;
import cn.com.duiba.nezha.alg.common.model.activityselectconversionforms.WilsonInterval;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivitySelectorPoolCvr {
    private static final Logger logger = LoggerFactory.getLogger(ActivitySelector.class);
    public static Comparator<MatchInfo> iComparator = new Comparator<MatchInfo>(){

        @Override
        public int compare(MatchInfo c1, MatchInfo c2) {
            return c2.score - c1.score >= 0.0 ? 1 : -1;
        }
    };
    public static Comparator<MatchInfo> normComparator = new Comparator<MatchInfo>(){

        @Override
        public int compare(MatchInfo m1, MatchInfo m2) {
            return m2.act.score - m1.act.score >= 0.0 ? 1 : -1;
        }
    };

    public static List<ActivityInfoModel> match(List<ActivityInfoData> actData, List<ActivityInfoAdWithType> actAd, List<ExcellentActivity> exActs) {
        int topn = Constant.SEARANK_TOPN;
        int exTopN = Constant.EXCELLENT_TOPN;
        ArrayList<ActivityInfoModel> result = new ArrayList<ActivityInfoModel>();
        ArrayList<ActivityInfoModel> actModel = new ArrayList<ActivityInfoModel>();
        PriorityQueue<MatchInfo> candis = new PriorityQueue<MatchInfo>(actData.size(), iComparator);
        PriorityQueue<MatchInfo> slotCandis = new PriorityQueue<MatchInfo>(actData.size(), iComparator);
        PriorityQueue<MatchInfo> normCandis = new PriorityQueue<MatchInfo>(exTopN, normComparator);
        HashMap<Long, ActivityInfoAdWithType> adHashMap = new HashMap<Long, ActivityInfoAdWithType>();
        double form_click_cnt = 0.0;
        double notForm_click_cnt = 0.0;
        double click_cnt = 0.0;
        double form_effect_cnt = 0.0;
        double notForm_effect_cnt = 0.0;
        double effect_cnt = 0.0;
        for (ActivityInfoAdWithType ad : actAd) {
            adHashMap.put(ad.getActivityId(), ad);
            for (AdvertWithType adv : ad.getAdvertsWithType()) {
                if (adv.getIfForms() == 1) {
                    form_click_cnt += (double)adv.getClick();
                    form_effect_cnt += (double)adv.getEffectPV();
                } else {
                    notForm_click_cnt += (double)adv.getClick();
                    notForm_effect_cnt += (double)adv.getEffectPV();
                }
                click_cnt += (double)adv.getClick();
                effect_cnt += (double)adv.getEffectPV();
            }
        }
        double cvr = click_cnt > 0.0 ? effect_cnt / click_cnt : 0.0;
        double formCvrBias = form_effect_cnt < form_click_cnt ? WilsonInterval.wilsonCalc((double)form_effect_cnt, (double)form_click_cnt).lowerBound : WilsonInterval.wilsonCalc((double)form_click_cnt, (double)form_click_cnt).lowerBound;
        double notFormCvrBias = notForm_effect_cnt < notForm_click_cnt ? WilsonInterval.wilsonCalc((double)notForm_effect_cnt, (double)notForm_click_cnt).lowerBound : WilsonInterval.wilsonCalc((double)notForm_click_cnt, (double)notForm_click_cnt).lowerBound;
        double cvrBias = formCvrBias + 0.2 * notFormCvrBias;
        HashMap<Long, ExcellentActivity> exHashMap = new HashMap<Long, ExcellentActivity>();
        if (exActs != null) {
            for (ExcellentActivity exAct : exActs) {
                exHashMap.put(exAct.getActivityId(), exAct);
            }
        }
        HashSet<Long> actIds = new HashSet<Long>(exHashMap.keySet());
        HashSet hisActIds = new HashSet(actData.stream().map(ActivityInfoData::getActivityId).collect(Collectors.toSet()));
        long size_act = actData.size();
        HashSet<Long> idset = new HashSet<Long>();
        for (ActivityInfoData act : actData) {
            try {
                ActivityInfoModel actM = ActivitySelectorPoolCvr.fillData(act, actIds, exHashMap);
                actM.setCvrBias(cvrBias);
                actModel.add(actM);
                if (actM.hisRequest.globalVal < 100.0) {
                    if (System.currentTimeMillis() - act.createTime < 259200000L) {
                        if (Math.random() < 1.0E-4) {
                            result.add(actM);
                            --topn;
                            idset.add(actM.activityId);
                        }
                    } else if (actData.size() > topn && Math.random() < 1.0E-5) {
                        result.add(actM);
                        --topn;
                        idset.add(actM.activityId);
                    }
                }
                double slotScore = actM.hisCost.slotVal / 100.0 < actM.hisRequest.slotVal ? WilsonInterval.wilsonCalc((double)(actM.hisCost.slotVal / 100.0), (double)actM.hisRequest.slotVal).lowerBound : WilsonInterval.wilsonCalc((double)actM.hisRequest.slotVal, (double)actM.hisRequest.slotVal).lowerBound;
                double globalScore = actM.hisCost.globalVal / 100.0 < actM.hisRequest.globalVal ? WilsonInterval.wilsonCalc((double)(actM.hisCost.globalVal / 100.0), (double)actM.hisRequest.globalVal).lowerBound : WilsonInterval.wilsonCalc((double)actM.hisRequest.globalVal, (double)actM.hisRequest.globalVal).lowerBound;
                double appScore = actM.hisCost.appVal / 100.0 < actM.hisRequest.appVal ? WilsonInterval.wilsonCalc((double)(actM.hisCost.appVal / 100.0), (double)actM.hisRequest.appVal).lowerBound : WilsonInterval.wilsonCalc((double)actM.hisRequest.appVal, (double)actM.hisRequest.appVal).lowerBound;
                double coef = 0.0;
                double matchscore = 0.0;
                double sconfidence = Math.min(actM.hisRequest.slotVal / 100.0, 1.0);
                double aconfidence = Math.min(actM.hisRequest.appVal / 100.0, 1.0);
                double gconfidence = Math.min(actM.hisRequest.globalVal / 1000.0, 1.0);
                matchscore = sconfidence * slotScore + (1.0 - sconfidence) * aconfidence * appScore * 0.9 + (1.0 - sconfidence - (1.0 - sconfidence) * aconfidence) * globalScore * Math.max(0.5, gconfidence);
                double changeScore = 0.0;
                ActivityChangeVal activityChangeValNew = new ActivityChangeVal();
                if (adHashMap.containsKey(act.activityId)) {
                    activityChangeValNew = ActivitySelectorPoolCvr.calChangeScoreMergeAbsolute(((ActivityInfoAdWithType)adHashMap.get(act.activityId)).getAdvertsWithType(), cvr);
                    changeScore = activityChangeValNew.changeScoreMerge;
                }
                actM.changeScore = changeScore;
                actM.activityChangeVal = activityChangeValNew;
                MatchInfo info = new MatchInfo();
                info.act = actM;
                info.score = matchscore;
                if (actM.isExcellent) {
                    normCandis.add(info);
                    continue;
                }
                candis.add(info);
                if (!(sconfidence > 0.99) && !(actM.hisClick.slotVal > 5.0)) continue;
                MatchInfo info2 = new MatchInfo();
                info2.act = actM;
                info2.score = actM.hisRequest.slotVal > 0.0 ? actM.hisCost.slotVal / (100.0 * actM.hisRequest.slotVal) : 0.0;
                slotCandis.add(info2);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        int slotSize = slotCandis.size();
        for (int i = 0; i < 10 && i < slotSize; ++i) {
            ActivityInfoModel act = ((MatchInfo)slotCandis.poll()).act;
            if (idset.contains(act.activityId)) continue;
            result.add(act);
            idset.add(act.activityId);
            --topn;
        }
        int size = candis.size();
        int resultSize = result.size();
        for (int i = 0; resultSize < topn && i < size; ++i) {
            ActivityInfoModel act = ((MatchInfo)candis.poll()).act;
            if (idset.contains(act.activityId)) continue;
            result.add(act);
            idset.add(act.activityId);
            resultSize = result.size();
            --topn;
        }
        if (exActs != null) {
            for (ExcellentActivity exAct : exActs) {
                if (hisActIds.contains(exAct.getActivityId())) continue;
                MatchInfo mci = new MatchInfo();
                ActivityInfoModel aim = new ActivityInfoModel();
                aim.setAppId(actData.get(0).getAppId());
                aim.setSlotId(actData.get(0).getSlotId());
                aim.setActivityId(exAct.getActivityId());
                aim.setnPvClick(exAct.getnPvClick());
                aim.setnPvCost(exAct.getnPvCost());
                aim.setnCvrForm(exAct.getnFormCvr());
                aim.setnCvrNotForm(exAct.getnNotFormCvr());
                aim.setnCvr(exAct.getnCvr());
                aim.setScore(exAct.getScore());
                aim.setExcellent(true);
                mci.score = exAct.getScore();
                mci.act = aim;
                normCandis.add(mci);
            }
            for (int i = 0; i < exTopN && i < normCandis.size(); ++i) {
                MatchInfo candisInfo = (MatchInfo)normCandis.poll();
                if (idset.contains(candisInfo.act.activityId)) continue;
                result.add(candisInfo.act);
                idset.add(candisInfo.act.activityId);
                --topn;
            }
        }
        return result;
    }

    public static SelectActivityResult select(List<ActivityModel> actModel, List<ActivityData> actData) {
        SelectActivityResult selectActivityResult = new SelectActivityResult();
        if (actModel.size() == 0 || actData.size() == 0) {
            return null;
        }
        if (actModel.size() != actData.size()) {
            selectActivityResult.activityModel = actModel.get(0);
            selectActivityResult.sameCostActivitiesInfoList = null;
            return selectActivityResult;
        }
        List actModelCopy = actModel.stream().sorted(Comparator.comparing(ActivityModel::getActivityId).reversed()).collect(Collectors.toList());
        List actDataCopy = actData.stream().sorted(Comparator.comparing(ActivityData::getActivityId).reversed()).collect(Collectors.toList());
        for (int i = 0; i < actModelCopy.size(); ++i) {
            long activityIdMode = ((ActivityModel)actModelCopy.get((int)i)).activityId;
            long activityIdData = ((ActivityData)actDataCopy.get((int)i)).activityId;
            if (activityIdMode != activityIdData) {
                selectActivityResult.activityModel = actModel.get(0);
                selectActivityResult.sameCostActivitiesInfoList = null;
                return selectActivityResult;
            }
            ((ActivityModel)actModelCopy.get((int)i)).changeScore = ((ActivityData)actDataCopy.get((int)i)).changeScore;
            ((ActivityModel)actModelCopy.get((int)i)).isExcellent = ((ActivityData)actDataCopy.get((int)i)).isExcellent;
            ((ActivityModel)actModelCopy.get((int)i)).nPvClick = ((ActivityData)actDataCopy.get((int)i)).nPvClick;
            ((ActivityModel)actModelCopy.get((int)i)).nPvCost = ((ActivityData)actDataCopy.get((int)i)).nPvCost;
            ((ActivityModel)actModelCopy.get((int)i)).score = ((ActivityData)actDataCopy.get((int)i)).score;
            ((ActivityModel)actModelCopy.get((int)i)).subType = ((ActivityData)actDataCopy.get((int)i)).subType;
            ((ActivityModel)actModelCopy.get((int)i)).cvrBias = ((ActivityData)actDataCopy.get((int)i)).cvrBias;
        }
        ArrayList<Double> requests = new ArrayList<Double>();
        ArrayList<Double> rewards = new ArrayList<Double>();
        ArrayList<Double> counts = new ArrayList<Double>();
        ArrayList<Double> alphas = new ArrayList<Double>();
        ArrayList<Double> betas = new ArrayList<Double>();
        ArrayList<Double> changeScores = new ArrayList<Double>();
        ArrayList<Double> cvrBiass = new ArrayList<Double>();
        ArrayList<Long> activityIds = new ArrayList<Long>();
        ArrayList<Long> activityTypes = new ArrayList<Long>();
        ArrayList<Double> grpms = new ArrayList<Double>();
        ArrayList<Double> arpms = new ArrayList<Double>();
        ArrayList<Double> hrpms = new ArrayList<Double>();
        ArrayList<Boolean> excellents = new ArrayList<Boolean>();
        ArrayList<Integer> subTypes = new ArrayList<Integer>();
        ArrayList<Double> scores = new ArrayList<Double>();
        ArrayList candiList = new ArrayList();
        double decay = Constant.DECAY;
        int size = 0;
        HashMap<Long, RankInfo> mMap = new HashMap<Long, RankInfo>();
        double maxG = Constant.MIN_REWARD;
        double maxH = Constant.MIN_REWARD;
        double maxA = Constant.MIN_REWARD;
        double minG = 0.0;
        double minH = Constant.MIN_REWARD;
        double minA = Constant.MIN_REWARD;
        ActivityModel result = new ActivityModel();
        try {
            int i;
            for (i = 0; i < actDataCopy.size(); ++i) {
                double hrpm;
                double arpm;
                double grpm;
                RankInfo info = mMap.containsKey(((ActivityData)actDataCopy.get((int)i)).activityId) ? (RankInfo)mMap.get(((ActivityData)actDataCopy.get((int)i)).activityId) : new RankInfo();
                info.grpm = grpm = ((ActivityData)actDataCopy.get((int)i)).hisRequest.globalVal > 0.0 ? ((ActivityData)actDataCopy.get((int)i)).hisCost.globalVal / ((ActivityData)actDataCopy.get((int)i)).hisRequest.globalVal : 0.0;
                info.gexp = ((ActivityData)actDataCopy.get((int)i)).hisRequest.globalVal;
                maxG = Math.max(grpm, maxG);
                info.arpm = arpm = ((ActivityData)actDataCopy.get((int)i)).hisRequest.appVal > 0.0 ? ((ActivityData)actDataCopy.get((int)i)).hisCost.appVal / ((ActivityData)actDataCopy.get((int)i)).hisRequest.appVal : 0.0;
                info.aexp = ((ActivityData)actDataCopy.get((int)i)).hisRequest.appVal;
                if (info.aexp > 100.0) {
                    maxA = Math.max(arpm, maxA);
                }
                minA = Math.min(arpm, minA);
                info.hrpm = hrpm = ((ActivityData)actDataCopy.get((int)i)).hisRequest.slotVal > 0.0 ? ((ActivityData)actDataCopy.get((int)i)).hisCost.slotVal / ((ActivityData)actDataCopy.get((int)i)).hisRequest.slotVal : 0.0;
                info.hexp = ((ActivityData)actDataCopy.get((int)i)).hisRequest.slotVal;
                if (info.hexp > 100.0) {
                    maxH = Math.max(hrpm, maxH);
                }
                minH = Math.min(hrpm, minH);
                mMap.put(((ActivityData)actDataCopy.get((int)i)).activityId, info);
            }
            for (i = 0; i < actDataCopy.size(); ++i) {
                requests.add(((ActivityData)actDataCopy.get((int)i)).hisRequest.slotVal);
                double hrpm = ((RankInfo)mMap.get((Object)Long.valueOf((long)((ActivityData)actDataCopy.get((int)i)).activityId))).hrpm;
                double arpm = ((RankInfo)mMap.get((Object)Long.valueOf((long)((ActivityData)actDataCopy.get((int)i)).activityId))).arpm;
                double grpm = ((RankInfo)mMap.get((Object)Long.valueOf((long)((ActivityData)actDataCopy.get((int)i)).activityId))).grpm;
                hrpms.add(hrpm);
                arpms.add(arpm);
                grpms.add(grpm);
                excellents.add(((ActivityData)actDataCopy.get((int)i)).isExcellent);
                subTypes.add(((ActivityData)actDataCopy.get((int)i)).subType);
                scores.add(((ActivityData)actDataCopy.get((int)i)).score);
                cvrBiass.add(((ActivityData)actDataCopy.get((int)i)).cvrBias);
                double reward = Constant.MIN_REWARD;
                double sconfidence = Math.min(((ActivityData)actDataCopy.get((int)i)).hisRequest.slotVal / 100.0, 1.0);
                double aconfidence = Math.min(((ActivityData)actDataCopy.get((int)i)).hisRequest.appVal / 100.0, 1.0);
                reward = sconfidence * ActivitySelectorPoolCvr.normlize(hrpm * 0.8, maxH, 0.8) + (1.0 - sconfidence) * aconfidence * ActivitySelectorPoolCvr.normlize(arpm * 0.7, maxA, 0.7) + (1.0 - sconfidence - (1.0 - sconfidence) * aconfidence) * ActivitySelectorPoolCvr.normlize(grpm * 0.5, maxG, 0.6);
                reward *= reward;
                reward = Math.max(reward, 0.0);
                ((ActivityModel)actModelCopy.get((int)i)).reward = ((ActivityModel)actModelCopy.get((int)i)).reward * decay + reward;
                ((ActivityModel)actModelCopy.get((int)i)).count = ((ActivityModel)actModelCopy.get((int)i)).count * decay + 1.0;
                ((ActivityModel)actModelCopy.get((int)i)).alpha = 1.5 + ((ActivityModel)actModelCopy.get((int)i)).reward;
                ((ActivityModel)actModelCopy.get((int)i)).beta = 2.0 + (((ActivityModel)actModelCopy.get((int)i)).count - ((ActivityModel)actModelCopy.get((int)i)).reward);
                rewards.add(((ActivityModel)actModelCopy.get((int)i)).reward);
                counts.add(((ActivityModel)actModelCopy.get((int)i)).count);
                alphas.add(((ActivityModel)actModelCopy.get((int)i)).alpha);
                betas.add(((ActivityModel)actModelCopy.get((int)i)).beta);
                activityIds.add(((ActivityModel)actModelCopy.get((int)i)).activityId);
                activityTypes.add(((ActivityModel)actModelCopy.get((int)i)).activityType);
                changeScores.add(((ActivityModel)actModelCopy.get((int)i)).changeScore);
                candiList.add(actModelCopy.get(i));
            }
            int numMachines = candiList.size();
            SelectInfoDetail selectInfoDetail = ActivitySelectorPoolCvr.selectMachineWithChangeScore(alphas, betas, activityTypes, activityIds, changeScores, numMachines, hrpms, arpms, grpms, requests, excellents, subTypes, scores, cvrBiass);
            int selectedActivityIndex = selectInfoDetail.index;
            result = (ActivityModel)candiList.get(selectedActivityIndex);
            result.strategyType = selectInfoDetail.strategyType;
            double maxChangeScore = selectInfoDetail.maxChangeScore;
            ArrayList<SameCostActivitiesInfo> sameCostActivitiesInfoList = new ArrayList<SameCostActivitiesInfo>();
            ArrayList<SelectPoolInfo> sameCostcondi = selectInfoDetail.condi;
            if (sameCostcondi.size() > 0) {
                double selectedActivityReward = sameCostcondi.get(0).getReward();
                int sameCostActivityCnt = sameCostcondi.size();
                for (SelectPoolInfo selectInfo : sameCostcondi) {
                    SameCostActivitiesInfo sameCostActivitiesInfo = new SameCostActivitiesInfo();
                    Long activityId = selectInfo.getActivityId();
                    Long activityType = selectInfo.getActivityType();
                    int ifSelected = 0;
                    if (selectInfo.getIndex() == selectedActivityIndex) {
                        ifSelected = 1;
                    }
                    int index = selectInfo.getIndex();
                    double mabReward = selectInfo.getReward();
                    double changeScore = selectInfo.getChangeScore();
                    double hrpm = selectInfo.getHrpm();
                    double arpm = selectInfo.getArpm();
                    double grpm = selectInfo.getGrpm();
                    int subType = selectInfo.getSubType();
                    boolean excellent = selectInfo.isExcellent();
                    double diffReward = selectInfo.getReward() - selectedActivityReward;
                    double diffChangeScore = selectInfo.getChangeScore() - maxChangeScore;
                    sameCostActivitiesInfo.activityId = activityId;
                    sameCostActivitiesInfo.sameActivityCnt = sameCostActivityCnt;
                    sameCostActivitiesInfo.activityType = activityType;
                    sameCostActivitiesInfo.ifSelected = ifSelected;
                    sameCostActivitiesInfo.mabReward = mabReward;
                    sameCostActivitiesInfo.changeScore = changeScore;
                    sameCostActivitiesInfo.index = index;
                    sameCostActivitiesInfo.hrpm = hrpm;
                    sameCostActivitiesInfo.arpm = arpm;
                    sameCostActivitiesInfo.grpm = grpm;
                    sameCostActivitiesInfo.diffReward = diffReward;
                    sameCostActivitiesInfo.diffChangeScore = diffChangeScore;
                    sameCostActivitiesInfo.subType = subType;
                    sameCostActivitiesInfo.isExcellent = excellent;
                    sameCostActivitiesInfoList.add(sameCostActivitiesInfo);
                }
            }
            selectActivityResult.activityModel = result;
            selectActivityResult.sameCostActivitiesInfoList = sameCostActivitiesInfoList;
            mMap.clear();
            return selectActivityResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("error:", (Throwable)e);
            logger.error(e.getMessage(), (Throwable)e);
            logger.error("error, size:{},candi:{},list:{},", new Object[]{size, JSON.toJSONString(candiList), JSON.toJSONString((Object)result)});
            return null;
        }
    }

    public static ActivityChangeVal calChangeScoreMergeAbsolute(List<AdvertWithType> ads, double cvr) {
        double changeScoreBias = 0.06;
        double changeScoreMerge = 0.0;
        double changeScoreForms = 0.0;
        double changeScoreNotForms = 0.0;
        double changeScoreFormsGlobal = 0.0;
        double changeScoreNotFormsGlobal = 0.0;
        double sumClickForms = 0.0;
        double sumEffectPVForms = 0.0;
        double sumClickNotForms = 0.0;
        double sumEffectPVNotForms = 0.0;
        double sumGlobalClickForms = 0.0;
        double sumGlobalEffectPVForms = 0.0;
        double sumGlobalClickNotForms = 0.0;
        double sumGlobalEffectPVNotForms = 0.0;
        Long formsAdvertCnt = 0L;
        Long notFormsAdvertCnt = 0L;
        for (AdvertWithType ad : ads) {
            if (ad.ifForms == 1) {
                sumClickForms += (double)ad.getClick();
                sumEffectPVForms += (double)ad.getEffectPV();
                sumGlobalClickForms += (double)ad.getGlobalClick().longValue();
                sumGlobalEffectPVForms += (double)ad.getGlobalEffectPV().longValue();
                formsAdvertCnt = formsAdvertCnt + 1L;
                continue;
            }
            sumClickNotForms += (double)ad.getClick();
            sumEffectPVNotForms += (double)ad.getEffectPV();
            sumGlobalClickNotForms += (double)ad.getGlobalClick().longValue();
            sumGlobalEffectPVNotForms += (double)ad.getGlobalEffectPV().longValue();
            notFormsAdvertCnt = notFormsAdvertCnt + 1L;
        }
        changeScoreForms = sumClickForms > sumEffectPVForms ? WilsonInterval.wilsonCalc((double)sumEffectPVForms, (double)sumClickForms).lowerBound.doubleValue() : WilsonInterval.wilsonCalc((double)sumClickForms, (double)sumClickForms).lowerBound.doubleValue();
        changeScoreNotForms = sumClickNotForms > sumEffectPVNotForms ? WilsonInterval.wilsonCalc((double)sumEffectPVNotForms, (double)sumClickNotForms).lowerBound.doubleValue() : WilsonInterval.wilsonCalc((double)sumClickNotForms, (double)sumClickNotForms).lowerBound.doubleValue();
        changeScoreFormsGlobal = sumGlobalClickForms > 0.0 ? sumGlobalEffectPVForms / sumGlobalClickForms : 0.0;
        changeScoreNotFormsGlobal = sumGlobalClickNotForms > 0.0 ? sumGlobalEffectPVNotForms / sumGlobalClickNotForms : 0.0;
        double wcvr = cvr > 0.0 ? changeScoreBias / cvr : 1.0;
        changeScoreMerge = changeScoreForms + changeScoreNotForms * 0.2 * Math.min(2.5, wcvr);
        ActivityChangeVal activityChangeVal = new ActivityChangeVal();
        activityChangeVal.sumClickForms = sumClickForms;
        activityChangeVal.sumEffectPVForms = sumEffectPVForms;
        activityChangeVal.sumClickNotForms = sumClickNotForms;
        activityChangeVal.sumEffectPVNotForms = sumEffectPVNotForms;
        activityChangeVal.sumGlobalClickForms = sumGlobalClickForms;
        activityChangeVal.sumGlobalEffectPVForms = sumGlobalEffectPVForms;
        activityChangeVal.sumGlobalClickNotForms = sumGlobalClickNotForms;
        activityChangeVal.sumGlobalEffectPVNotForms = sumGlobalEffectPVNotForms;
        activityChangeVal.changeScoreForms = changeScoreForms;
        activityChangeVal.changeScoreNotForms = changeScoreNotForms;
        activityChangeVal.changeScoreFormsGlobal = changeScoreFormsGlobal;
        activityChangeVal.changeScoreNotFormsGlobal = changeScoreNotFormsGlobal;
        activityChangeVal.formsAdvertCnt = formsAdvertCnt;
        activityChangeVal.notFormsAdvertCnt = notFormsAdvertCnt;
        activityChangeVal.changeScoreMerge = changeScoreMerge;
        return activityChangeVal;
    }

    public static double normlize(double val, double max, double limit) {
        double norm = Math.min(val * limit / max, limit);
        return norm;
    }

    public static double normlize(double val, double min, double max, double lower, double upper) {
        double norm = upper > lower && upper <= 1.0 && lower >= 0.0 ? (upper - lower) * (val - min) / (max - min) + lower : 0.6 * (val - min) / (max - min) + 0.2;
        return norm;
    }

    private static SelectInfoDetail selectMachineWithChangeScore(List<Double> alphas, List<Double> betas, List<Long> activityTypes, List<Long> activityIds, List<Double> changeScores, int numMachines, List<Double> hrpms, List<Double> arpms, List<Double> grpms, List<Double> requests, List<Boolean> excellents, List<Integer> subTypes, List<Double> scores, List<Double> cvrBiass) {
        SelectInfoDetail selectInfoDetail = new SelectInfoDetail();
        ArrayList<SelectPoolInfo> sinfos = new ArrayList<SelectPoolInfo>();
        for (int i = 0; i < numMachines; ++i) {
            if (activityTypes.get(i) == 21L) continue;
            double theta = BetaDistribution.BetaDist(alphas.get(i), betas.get(i));
            SelectPoolInfo sinfo = new SelectPoolInfo();
            sinfo.setReward(theta);
            sinfo.setActivityType(activityTypes.get(i));
            sinfo.setIndex(i);
            sinfo.setActivityId(activityIds.get(i));
            sinfo.setChangeScore(changeScores.get(i));
            sinfo.setHrpm(hrpms.get(i));
            sinfo.setArpm(arpms.get(i));
            sinfo.setGrpm(grpms.get(i));
            sinfo.setRequest(requests.get(i));
            sinfo.setExcellent(excellents.get(i));
            sinfo.setScores(scores.get(i));
            sinfo.setExcellent(excellents.get(i));
            sinfo.setSubType(subTypes.get(i));
            sinfo.setCvrBias(cvrBiass.get(i));
            sinfos.add(sinfo);
        }
        if (sinfos.size() > 0) {
            double maxChangeScore = ((SelectPoolInfo)sinfos.stream().sorted(Comparator.comparing(SelectPoolInfo::getChangeScore).reversed()).collect(Collectors.toList()).get(0)).getChangeScore();
            List ranks = sinfos.stream().sorted(Comparator.comparing(SelectPoolInfo::getReward).reversed()).collect(Collectors.toList());
            for (int i = 0; i < ranks.size(); ++i) {
                if (((SelectPoolInfo)ranks.get(i)).getRequest() < 100.0) {
                    if (((SelectPoolInfo)ranks.get(i)).isExcellent() && Math.random() < 0.02) {
                        selectInfoDetail.condi = new ArrayList(ranks.subList(0, Math.min(ranks.size(), 5)));
                        selectInfoDetail.index = ((SelectPoolInfo)ranks.get(i)).getIndex();
                        selectInfoDetail.maxChangeScore = maxChangeScore;
                        selectInfoDetail.strategyType = 1;
                        break;
                    }
                    if (!(((SelectPoolInfo)ranks.get(i)).getChangeScore() < 0.8 * ((SelectPoolInfo)ranks.get(i)).getCvrBias()) || !(Math.random() < 0.001)) continue;
                    selectInfoDetail.condi = new ArrayList(ranks.subList(0, Math.min(ranks.size(), 5)));
                    selectInfoDetail.index = ((SelectPoolInfo)ranks.get(i)).getIndex();
                    selectInfoDetail.maxChangeScore = maxChangeScore;
                    selectInfoDetail.strategyType = -1;
                    break;
                }
                if (((SelectPoolInfo)ranks.get(i)).getRequest() >= 100.0 && ((SelectPoolInfo)ranks.get(i)).getRequest() <= 500.0) {
                    if (((SelectPoolInfo)ranks.get(i)).isExcellent() && i > 0 && i < 5 && Math.random() < 0.01) {
                        selectInfoDetail.condi = new ArrayList(ranks.subList(0, Math.min(ranks.size(), 5)));
                        selectInfoDetail.index = ((SelectPoolInfo)ranks.get(i)).getIndex();
                        selectInfoDetail.maxChangeScore = maxChangeScore;
                        selectInfoDetail.strategyType = 2;
                        break;
                    }
                    if (((SelectPoolInfo)ranks.get(i)).isExcellent() && i < 20 && Math.random() < 0.001) {
                        selectInfoDetail.condi = new ArrayList(ranks.subList(0, Math.min(ranks.size(), 5)));
                        selectInfoDetail.index = ((SelectPoolInfo)ranks.get(i)).getIndex();
                        selectInfoDetail.maxChangeScore = maxChangeScore;
                        selectInfoDetail.strategyType = 3;
                        break;
                    }
                    if (!(((SelectPoolInfo)ranks.get(i)).getChangeScore() < 0.8 * ((SelectPoolInfo)ranks.get(i)).getCvrBias()) || !(Math.random() < 2.0E-4)) continue;
                    selectInfoDetail.condi = new ArrayList(ranks.subList(0, Math.min(ranks.size(), 5)));
                    selectInfoDetail.index = ((SelectPoolInfo)ranks.get(i)).getIndex();
                    selectInfoDetail.maxChangeScore = maxChangeScore;
                    selectInfoDetail.strategyType = -2;
                    break;
                }
                if (!(((SelectPoolInfo)ranks.get(i)).getChangeScore() >= 0.8 * ((SelectPoolInfo)ranks.get(i)).getCvrBias())) continue;
                if (((SelectPoolInfo)ranks.get(i)).getActivityId() == 12554L) {
                    System.out.println(((SelectPoolInfo)ranks.get(i)).getChangeScore() + "," + ((SelectPoolInfo)ranks.get(i)).getCvrBias());
                }
                selectInfoDetail.condi = new ArrayList(ranks.subList(0, Math.min(ranks.size(), 5)));
                selectInfoDetail.index = ((SelectPoolInfo)ranks.get(i)).getIndex();
                selectInfoDetail.maxChangeScore = maxChangeScore;
                selectInfoDetail.strategyType = 4;
                break;
            }
            if (selectInfoDetail == null || selectInfoDetail.strategyType == 0) {
                selectInfoDetail.index = ((SelectPoolInfo)ranks.get(0)).getIndex();
                selectInfoDetail.maxChangeScore = changeScores.get(0);
                selectInfoDetail.condi = new ArrayList(ranks.subList(0, Math.min(ranks.size(), 5)));
                selectInfoDetail.strategyType = 5;
            }
        } else {
            selectInfoDetail.index = 0;
            selectInfoDetail.maxChangeScore = changeScores.get(0);
            selectInfoDetail.condi = new ArrayList();
            selectInfoDetail.strategyType = 0;
        }
        return selectInfoDetail;
    }

    private static ActivityInfoModel fillData(ActivityInfoData act, Set<Long> actIds, Map<Long, ExcellentActivity> exHashMap) {
        ActivityInfoModel actM = new ActivityInfoModel();
        actM.activityId = act.activityId;
        actM.slotId = act.slotId;
        actM.appId = act.appId;
        actM.hisClick = new Val();
        actM.hisClick.globalVal = act.click.globalVal;
        actM.hisClick.appVal = act.click.appVal;
        actM.hisClick.slotVal = act.click.slotVal;
        actM.hisCost = new Val();
        actM.hisCost.globalVal = act.cost.globalVal;
        actM.hisCost.appVal = act.cost.appVal;
        actM.hisCost.slotVal = act.cost.slotVal;
        actM.hisRequest = new Val();
        actM.hisRequest.globalVal = act.request.globalVal;
        actM.hisRequest.appVal = act.request.appVal;
        actM.hisRequest.slotVal = act.request.slotVal;
        actM.subType = act.subType;
        actM.isExcellent = actIds.contains(act.activityId);
        actM.nPvClick = exHashMap.getOrDefault(act.activityId, new ExcellentActivity()).getnPvClick();
        actM.nPvCost = exHashMap.getOrDefault(act.activityId, new ExcellentActivity()).getnPvCost();
        actM.nCvrForm = exHashMap.getOrDefault(act.activityId, new ExcellentActivity()).getnFormCvr();
        actM.nCvrNotForm = exHashMap.getOrDefault(act.activityId, new ExcellentActivity()).getnNotFormCvr();
        actM.nCvr = exHashMap.getOrDefault(act.activityId, new ExcellentActivity()).getnCvr();
        actM.score = exHashMap.getOrDefault(act.activityId, new ExcellentActivity()).getScore();
        return actM;
    }

    static class SelectInfoDetail {
        int index;
        ArrayList<SelectPoolInfo> condi;
        double maxChangeScore;
        int strategyType;

        SelectInfoDetail() {
        }
    }

    static class MatchInfo {
        double score = 0.0;
        ActivityInfoModel act;

        MatchInfo() {
        }
    }

    static class RankInfo {
        double grpm;
        double gexp;
        double hrpm;
        double hexp;
        double arpm;
        double aexp;

        RankInfo() {
        }
    }

    static class Constant {
        static double MIN_REWARD = 0.1;
        static double DECAY = 0.99;
        static int SEARANK_TOPN = 30;
        static int EXCELLENT_TOPN = 20;

        Constant() {
        }
    }
}

