package cn.com.duiba.nezha.alg.common.model.activityrecommend;

import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;

/**
 *功能描述 活动推荐：海选+优选
 * 海选match：1000->30
 * 优选select：30->1
 * @author lijingzhe
 * @date 2019/9/3
 * @param
 * @return
 */
public class ActivityRec30 {

    private static final Logger logger = LoggerFactory.getLogger(ActivityRec30.class);

    static class Constant {
        static double MIN_REWARD = 0.1;
        static double DECAY = 0.99;
        // 海选召回数量
        static int SEARANK_TOPN = 30;
    }

    static class RankInfo {
        double grpm;
        double gexp;
        double hrpm;
        double hexp;
        double arpm;
        double aexp;
    }

    static class SelectInfo {
        double reward;
        long activityType;
        int index;
        long activityId;
        double changeScore;
    }

    static class SelectInfoDetail {
        int index;
        ArrayList<SelectInfo> condi;
    }


    static class MatchInfo {
        double score;
        ActivityMatchInfo act;
    }

    public static Comparator<MatchInfo> iComparator = new Comparator<MatchInfo>() {

        @Override
        public int compare(MatchInfo c1, MatchInfo c2) {
            return (int) (c2.score - c1.score >= 0 ? 1 : -1); //按score大小排序
        }
    };

    private static List<ActivityInfoData> sortByIdAndSourceData(List<ActivityInfoData> acts){

        List<ActivityInfoData> actCopy = acts;
        Collections.sort(actCopy, new Comparator<ActivityInfoData>() {
            public int compare(ActivityInfoData act1, ActivityInfoData act2) {
                if(act1.activityId > act2.activityId) {
                    return -1;
                }
                else {
                    return 1;

                }
            }
        });
        return actCopy;
    }

    private static List<ActivityRankInfo> sortByIdAndSourceModelBack(List<ActivityRankInfo> acts){
        List<ActivityRankInfo> actCopy = acts;
        Collections.sort(actCopy, new Comparator<ActivityRankInfo>() {
            public int compare(ActivityRankInfo act1, ActivityRankInfo act2) {
                if(act1.activityId > act2.activityId) {
                    return -1;
                }
                else {
                    return 1;

                }
            }
        });
        return actCopy;

    }

    private static List<ActivityMatchInfo> sortByIdAndSourceDataBack(List<ActivityMatchInfo> acts){

        List<ActivityMatchInfo> actCopy = acts;
        Collections.sort(actCopy, new Comparator<ActivityMatchInfo>() {
            public int compare(ActivityMatchInfo act1, ActivityMatchInfo act2) {
                if(act1.activityId > act2.activityId) {
                    return -1;
                }
                else {
                    return 1;

                }
            }
        });
        return actCopy;
    }
    /**
     *功能描述 海选主要考虑可投活动吞吐量和批处理性能，采用威尔逊排序法，从1000+活动池中召回top 30
     * @author lijingzhe
     * @date 2019/9/3
     * @param actData, actAds
     * @return java.util.List<cn.com.duiba.nezha.alg.common.model.activityrecommend.ActivityMatchInfo>
     */
    public static List<ActivityMatchInfo> match (List<ActivityInfoData> actData, List<ActivityInfoAd> actAds) {

        int topn = Constant.SEARANK_TOPN;
        List<ActivityMatchInfo> result = new ArrayList<ActivityMatchInfo>();
        List<ActivityMatchInfo> actModelCopy = new ArrayList<ActivityMatchInfo>();

        Queue<MatchInfo> candis = new PriorityQueue<>(actData.size(), iComparator);
        Queue<MatchInfo> slotCandis = new PriorityQueue<>(actData.size(), iComparator);

        //排序
        List<ActivityInfoData> actDataCopy =  sortByIdAndSourceData(actData);
        HashMap<Long,ActivityInfoAd> adHashMap = new HashMap<Long,ActivityInfoAd>();

        for(int i = 0;i < actAds.size();++i){
            adHashMap.put(actAds.get(i).activityId,actAds.get(i));
        }
        long size_act = actDataCopy.size();

        HashSet<Long> idset = new HashSet();
        int limit = topn;
        //同时遍历
        for (int i = 0;i < size_act;++i) {
            try {
                ActivityMatchInfo actM = new ActivityMatchInfo();
                actM.activityId = actDataCopy.get(i).activityId;
                actM.slotId = actDataCopy.get(i).slotId;
                actM.appId = actDataCopy.get(i).appId;

                //更新历史数据
                actM.hisClick = new ActivityVal();
                actM.hisClick.globalVal = actDataCopy.get(i).click.globalVal;
                actM.hisClick.appVal = actDataCopy.get(i).click.appVal;
                actM.hisClick.slotVal = actDataCopy.get(i).click.slotVal;

                actM.hisCost = new ActivityVal();
                actM.hisCost.globalVal = actDataCopy.get(i).cost.globalVal;
                actM.hisCost.appVal = actDataCopy.get(i).cost.appVal;
                actM.hisCost.slotVal = actDataCopy.get(i).cost.slotVal;

                actM.hisRequest = new ActivityVal();
                actM.hisRequest.globalVal = actDataCopy.get(i).request.globalVal;
                actM.hisRequest.appVal = actDataCopy.get(i).request.appVal;
                actM.hisRequest.slotVal = actDataCopy.get(i).request.slotVal;

                actM.activityType = actDataCopy.get(i).activityType;
                actM.subType = actDataCopy.get(i).subType;
                actModelCopy.add(actM);

                if (actM.hisRequest.globalVal < 100) { //全局活动请求数少于100
                    if(System.currentTimeMillis() - actDataCopy.get(i).createTime < 60 * 1000 * 60 * 24 * 3) //上架时间小于三天
                    {
                        if (Math.random() < 0.0001) { //小于0.0001进行试投
                            result.add(actM);
                            topn--; //占用一个名额
                            idset.add(actM.activityId) ;
                        }
                    }
                    else if (actDataCopy.size() > limit) { //为什么
                        if (Math.random() < 0.00001) {  //小于0.00001进行试投
                            result.add(actM);
                            topn--;//占用一个名额
                            idset.add(actM.activityId) ;
                        }
                    }

                } else {
                    //计算matchscore
                    double slotScore = WilsonInterval.wilsonCalc((long) actM.hisClick.slotVal, (long) actM.hisRequest.slotVal * 3).lowerBound;
                    double globalScore = WilsonInterval.wilsonCalc((long) actM.hisClick.globalVal, (long) actM.hisRequest.globalVal * 3).lowerBound;
                    double appScore = WilsonInterval.wilsonCalc((long) actM.hisClick.appVal, (long) actM.hisRequest.appVal * 3).lowerBound;
                    //为什么乘以3
                    double coef = 0, matchscore = 0;

                    double sconfidence = Math.min(actM.hisRequest.slotVal / 100, 1);
                    double aconfidence = Math.min(actM.hisRequest.appVal / 100, 1);
                    double gconfidence = Math.min(actM.hisRequest.globalVal / 1000, 1);


                    matchscore = sconfidence * slotScore
                            + (1 - sconfidence) * aconfidence * appScore * 0.9
                            + (1 - sconfidence - (1 - sconfidence) * aconfidence) * globalScore * Math.max(0.5, gconfidence);

                    double changeScore = 0.0d;
                    ActivityCvrInfo activityChangeValNew= new ActivityCvrInfo() ;

                    activityChangeValNew= calChangeScoreMergeAbsolute(adHashMap.getOrDefault(actDataCopy.get(i).activityId, new ActivityInfoAd()));
                    //计算广告转化综合得分
                    changeScore = activityChangeValNew.changeScoreMerge ;

                    actM.changeScore = changeScore;
                    actM.activityChangeVal= activityChangeValNew ;

                    MatchInfo info = new MatchInfo();
                    info.act = actM;
                    info.score = matchscore;  //威尔逊点击置信区间得分
                    candis.add(info);

                    if (sconfidence > 0.99 || actM.hisClick.slotVal > 5) { //广告位请求数大于99 或点击大于5
                        MatchInfo info2 = new MatchInfo();
                        info2.act = actM;
                        //分数是消耗除以请求数
                        info2.score = actM.hisRequest.slotVal > 0 ? actM.hisCost.slotVal / actM.hisRequest.slotVal : 0;

                        slotCandis.add(info2);
                    }
                }
            }catch (Exception e)
            {
                logger.error(e.getMessage(), e);
            }
        }

        int size1 = slotCandis.size();
        for (int i = 0; i < 10 && i < size1; i++) {
            ActivityMatchInfo act =  slotCandis.poll().act;
            if(idset.contains(act.activityId))
                continue;
            result.add(act);   //未判断去重 可能重复
            idset.add(act.activityId);
            topn-- ;
        }

        int size = candis.size();
        int resultSize=result.size() ;

        for (int i = 0; resultSize < limit && i < size; i++) {
            ActivityMatchInfo act =  candis.poll().act;
            if(idset.contains(act.activityId))
                continue;
            result.add(act);
            idset.add(act.activityId);   //凑齐topn个活动
            resultSize = result.size() ;
            topn-- ;
        }

        if (result.size() < limit)
        {
            int count = topn;
            for (int i = 0;i < size_act;++i){

                if(idset.contains(actDataCopy.get(i).activityId))
                    continue;
                idset.add(actDataCopy.get(i).activityId);
                actModelCopy.get(i).hisClick.globalVal = actDataCopy.get(i).click.globalVal;
                actModelCopy.get(i).hisClick.appVal = actDataCopy.get(i).click.appVal;
                actModelCopy.get(i).hisClick.slotVal = actDataCopy.get(i).click.slotVal;

                actModelCopy.get(i).hisCost.globalVal = actDataCopy.get(i).cost.globalVal;
                actModelCopy.get(i).hisCost.appVal = actDataCopy.get(i).cost.appVal;
                actModelCopy.get(i).hisCost.slotVal = actDataCopy.get(i).cost.slotVal;

                actModelCopy.get(i).hisRequest.globalVal = actDataCopy.get(i).request.globalVal;
                actModelCopy.get(i).hisRequest.appVal = actDataCopy.get(i).request.appVal;
                actModelCopy.get(i).hisRequest.slotVal = actDataCopy.get(i).request.slotVal;

                actModelCopy.get(i).activityType = actDataCopy.get(i).activityType;
                actModelCopy.get(i).subType = actDataCopy.get(i).subType;

                result.add( actModelCopy.get(i));
                count++;
                if(count >= topn)
                    break;

            }
        }
        return result;
    }

    /**
     *功能描述 优选主要考虑线上服务时延性，采用thomson采样的bandit算法对海选top 30进行精排，挑选最好的top 1
     * @author lijingzhe
     * @date 2019/9/3
     * @param actModel, actData
     * @return RankResult
     */
    public static RankResult select(List<ActivityRankInfo> actModel, List<ActivityMatchInfo> actData) {
        double gama = 0.1;
        RankResult selectActivityResult=new RankResult();

        //1.判断列表长度，不一致抛异常
        if(actModel.size() == 0|| actData.size() ==0){
            return null;
        }
        if(actModel.size() != actData.size()){
            selectActivityResult.activityModel=actModel.get(0);
            selectActivityResult.similarCostActivitiesInfo=null;
            return selectActivityResult; //todo 抛异常
        }
        List<ActivityRankInfo> actModelCopy =  sortByIdAndSourceModelBack(actModel);  //广告id倒排
        List<ActivityMatchInfo> actDataCopy = sortByIdAndSourceDataBack(actData);
        //活动 id 对不上返回空
        for(int i = 0; i< actModelCopy.size();++i) {
            long activityIdMode = actModelCopy.get(i).activityId;
            long activityIdData = actDataCopy.get(i).activityId;
            if (activityIdMode != activityIdData) {
                selectActivityResult.activityModel=actModel.get(0);
                selectActivityResult.similarCostActivitiesInfo=null;
                return selectActivityResult; // todo 抛异常
            }
            actModelCopy.get(i).changeScore = actDataCopy.get(i).changeScore;
            actModelCopy.get(i).activityType = actDataCopy.get(i).activityType;
            actModelCopy.get(i).subType = actDataCopy.get(i).subType;
        }

        ArrayList<Double> rewards = new ArrayList<>();
        ArrayList<Double> counts = new ArrayList<>();
        ArrayList<Double> alphas = new ArrayList<>();
        ArrayList<Double> betas = new ArrayList<>();
        ArrayList<Double> changeScores = new ArrayList<>();
        ArrayList<Long> activityIds = new ArrayList<>();
        ArrayList<Long> activityTypes = new ArrayList<>();

        List<ActivityRankInfo> candiList = new ArrayList<>();

        double decay = Constant.DECAY;

        int size = 0;

        HashMap<Long, RankInfo> mMap = new HashMap();
        double maxG = Constant.MIN_REWARD, maxH = Constant.MIN_REWARD, maxA = Constant.MIN_REWARD;
        ActivityRankInfo result = null;

        try {

            for (int i = 0;i<actDataCopy.size();++i) {
                //get global data Click
                RankInfo info = mMap.containsKey(actDataCopy.get(i).activityId) ? mMap.get(actDataCopy.get(i).activityId) : new RankInfo();
                double grpm = actDataCopy.get(i).hisRequest.globalVal > 0 ? actDataCopy.get(i).hisCost.globalVal / actDataCopy.get(i).hisRequest.globalVal : 0;

                info.grpm = grpm;
                info.gexp = actDataCopy.get(i).hisRequest.globalVal;
                maxG = Math.max(grpm, maxG);

                //get app data Cost
                double arpm = actDataCopy.get(i).hisRequest.appVal > 0 ? actData.get(i).hisCost.appVal / actData.get(i).hisRequest.appVal : 0;

                info.arpm = arpm;
                info.aexp = actDataCopy.get(i).hisRequest.appVal;
                if (info.hexp > 50) {
                    maxA = Math.max(arpm, maxA);

                }

                //get slot data Cost
                double hrpm = actDataCopy.get(i).hisRequest.slotVal > 0 ? actData.get(i).hisCost.slotVal / actData.get(i).hisRequest.slotVal : 0;

                info.hrpm = hrpm;
                info.hexp = actDataCopy.get(i).hisRequest.slotVal;

                mMap.put(actDataCopy.get(i).activityId, info);
            }

            for (int i = 0;i<actDataCopy.size();++i) {

                double reward = Constant.MIN_REWARD;
                double sconfidence = Math.min(actDataCopy.get(i).hisRequest.slotVal / 60, 1);
                double aconfidence = Math.min(actDataCopy.get(i).hisRequest.appVal / 60, 1);

                reward = sconfidence * normlize(mMap.get(actDataCopy.get(i).activityId).hrpm * 0.8, maxH, 0.8) +
                        (1 - sconfidence) * aconfidence * normlize(mMap.get(actDataCopy.get(i).activityId).arpm * 0.7, maxA, 0.7) +
                        (1 - sconfidence - (1 - sconfidence) * aconfidence) * normlize(mMap.get(actDataCopy.get(i).activityId).grpm * 0.5, maxG, 0.6);

//                System.out.println(actDataCopy.get(i)+" reward="+reward);
                reward = reward * reward;

                reward = Math.max(reward, Constant.MIN_REWARD);

                actModelCopy.get(i).reward = actModelCopy.get(i).reward * decay + reward;
                actModelCopy.get(i).count = actModelCopy.get(i).count * decay + 1.0;
                actModelCopy.get(i).alpha = 1.5 + actModelCopy.get(i).reward;
                actModelCopy.get(i).beta = 2.0 + (actModelCopy.get(i).count - actModelCopy.get(i).reward);


                rewards.add(actModelCopy.get(i).reward);
                counts.add(actModelCopy.get(i).count);
                alphas.add(actModelCopy.get(i).alpha);
                betas.add(actModelCopy.get(i).beta);
                activityTypes.add(actModelCopy.get(i).activityType);
                activityIds.add(actModelCopy.get(i).activityId);
                changeScores.add(actModelCopy.get(i).changeScore);
                candiList.add(actModelCopy.get(i));
            }

            //4、select

            int numMachines = candiList.size();

            SelectInfoDetail selectInfoDetail = selectMachineWithChangeScore(alphas, betas,activityTypes, activityIds,changeScores,numMachines,gama);

            int selectedActivityIndex = selectInfoDetail.index;
            result = candiList.get(selectedActivityIndex);  //筛选出来的活动及对应的模型参数


            //消耗分相近的活动信息
            ArrayList<SelectInfo> sameCostcondi = selectInfoDetail.condi;
            Double selectedActivityChangeScore=result.changeScore;
            int sameCostActivityCnt=sameCostcondi.size();

            List<SimilarCostActivitiesInfo> sameCostActivitiesInfoList = new ArrayList<>();

            for (SelectInfo  selectInfo:sameCostcondi){

                SimilarCostActivitiesInfo sameCostActivitiesInfo=new SimilarCostActivitiesInfo();

                Long  activityId=selectInfo.activityId;
                Long activityType=selectInfo.activityType;

                int ifSelected=0;
                if (selectInfo.index==selectedActivityIndex){
                    ifSelected=1;
                }

                int index=selectInfo.index;

                Double mabReward=selectInfo.reward;
                Double changeScore=selectInfo.changeScore;

                //计算与最优的差异
                Double diffChangeScore=selectInfo.changeScore-selectedActivityChangeScore;

                //封装
                sameCostActivitiesInfo.activityId=activityId;
                sameCostActivitiesInfo.sameActivityCnt=sameCostActivityCnt;
                sameCostActivitiesInfo.activityType=activityType;
                sameCostActivitiesInfo.ifSelected=ifSelected;
                sameCostActivitiesInfo.mabReward=mabReward;   //带转化筛选时重新计算了reward，与前面的reward计算不一致
                sameCostActivitiesInfo.changeScore=changeScore;
                sameCostActivitiesInfo.index=index;
                sameCostActivitiesInfo.diffChangeScore=diffChangeScore;
                sameCostActivitiesInfoList.add(sameCostActivitiesInfo);
            }

            selectActivityResult.activityModel=result;
            selectActivityResult.similarCostActivitiesInfo= sameCostActivitiesInfoList;

            mMap.clear();

            return selectActivityResult;
        }catch (Exception e)
        {
            logger.error(e.getMessage(), e);
            logger.error("error, size:{},candi:{},list:{},", size, JSON.toJSONString(candiList), JSON.toJSONString(result));
        }

        return null;
    }


    public static double normlize(double val, double max, double limit) {
        double norm = Math.min(val * limit / max, limit);
        return norm;
    }


    //融合表单和非表单类广告，用绝对值的cvr分数
    public static ActivityCvrInfo calChangeScoreMergeAbsolute(ActivityInfoAd ad) {

        double changeScoreMerge = 0.0;

        //直接用总转化除以总点击
        double changeScoreForms =ad.sumClickForms > 0 ? ad.sumEffectPVForms/ad.sumClickForms: 0 ;
        double changeScoreNotForms = ad.sumClickNotForms > 0 ? ad.sumEffectPVNotForms/ad.sumClickNotForms: 0 ;

        double effctFormsWeight = Math.min(ad.sumEffectPVForms/3.0,1.0);
        double  effctNotFormsWeight=Math.min(ad.sumEffectPVNotForms/30.0,1.0);

        double rand = Math.random();

//本广告位表单类和全局表单类数据加权  对表单类点击和转化做限制  不考虑非表单数据
        if (ad.sumEffectPVForms >=1 ) {
            changeScoreMerge = changeScoreForms;

        } else if ( 0 < ad.sumClickForms && ad.sumClickForms < 100 ) {
            double w1 = ad.sumClickForms / 100.0 / 0.2;
            double w2 = 5 - w1;
            changeScoreMerge = 0.01 * w2 * 0.06;
        } else if (ad.sumClickForms >= 100 ) {
            changeScoreMerge = 0.06 / ad.sumClickForms;

        } else if (changeScoreNotForms > 0 ) {
            changeScoreMerge = changeScoreNotForms * 0.000001;

        }  else if (rand <= 0.000001 ) {
            changeScoreMerge = Math.random();
        }

        //输出 转化得分明细
        ActivityCvrInfo  activityChangeVal= new ActivityCvrInfo() ;

        activityChangeVal.sumClickForms=ad.sumClickForms;
        activityChangeVal.sumEffectPVForms=ad.sumEffectPVForms;

        activityChangeVal.sumClickNotForms=ad.sumClickNotForms;
        activityChangeVal.sumEffectPVNotForms=ad.sumEffectPVNotForms;

        activityChangeVal.changeScoreForms= changeScoreForms;
        activityChangeVal.changeScoreNotForms= changeScoreNotForms;

        activityChangeVal.changeScoreMerge=changeScoreMerge;
        //结果输出
        return activityChangeVal ;

    }

    //卡包分版本
    private static SelectInfoDetail selectMachineWithChangeScore(List<Double> alphas, List<Double> betas,List<Long> activityTypes,List<Long> activityIds,List<Double> changeScores, int numMachines,double gama) {
        int selectMachine = 0;
        ArrayList<SelectInfo> sinfos = new  ArrayList<SelectInfo>();
        for (int i = 0; i < numMachines; i++) {
            double theta = BetaDistribution.BetaDist(alphas.get(i), betas.get(i));
            SelectInfo sinfo = new SelectInfo();
            sinfo.reward = theta;
            sinfo.activityType = activityTypes.get(i);
            sinfo.index = i;
            sinfo.activityId = activityIds.get(i);
            sinfo.changeScore = changeScores.get(i);
            sinfos.add(sinfo);
        }

        Collections.sort(sinfos, new Comparator<SelectInfo>() {
            public int compare(SelectInfo sinfo1, SelectInfo sinfo2) {
                if(sinfo1.reward > sinfo2.reward) {
                    return -1;
                }
                else {
                    return 1;

                }
            }
        });


        ArrayList<SelectInfo> condi = new ArrayList<SelectInfo>();

        for(int i = 0;i < sinfos.size();++i) {
            if(sinfos.get(0).reward - sinfos.get(i).reward <= gama) { //生成消耗分接近的候选集
//                System.out.println("condi "+i+" activityId="+sinfos.get(i).activityId+" theta="+sinfos.get(i).reward+" "+" activityType="+sinfos.get(i).activityType+" changeScore="+changeScores.get(i));
                condi.add(sinfos.get(i));
            }
        }
        Collections.sort(condi, new Comparator<SelectInfo>() {
            public int compare(SelectInfo sinfo1, SelectInfo sinfo2) {
                if(sinfo1.changeScore > sinfo2.changeScore) {
                    return -1;
                }
                else {
                    return 1;

                }
            }
        });

        selectMachine = condi.get(0).index; //选取一定范围内转化最高的

        for(int i = 0; i < condi.size();++i) {
            if(condi.get(i).activityType != 21){
                selectMachine = condi.get(i).index; //选取消耗分最大的非卡包
                break;
            }
        }

        //打印消耗分相近的活动的所有信息
        SelectInfoDetail selectInfoDetail=new SelectInfoDetail();
        selectInfoDetail.condi=condi;  //消耗分相近的每个活动信息
        selectInfoDetail.index=selectMachine;  //最优活动索引

        return selectInfoDetail;

    }

    public static class SingletonHolder {
        private static final ActivityRec30 instance = new ActivityRec30();
    }

    private static ActivityRec30 getInstance() {
        return SingletonHolder.instance;
    }
}