package cn.com.duiba.nezha.alg.common.util;


import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.List;


/**
 * Created by pc on 2017/9/7.
 */
public class DataUtil {


    public static <T> T getValueOrDefault(T value, T defaultValue) {

        if (value != null) {
            return value;
        } else {
            return defaultValue;
        }
    }

    /**
     * 判断是否比阈值大
     *
     * @param value1
     * @param value2
     * @return
     */
    public static boolean isLarger(Long value1, Long value2) {

        boolean ret = false;

        if (value1 != null && value2 != null && value1 > value2) {
            ret = true;
        }

        return ret;
    }


    /**
     * @param value
     * @return
     */
    public static Double toDouble(Long value) {
        return long2Double(value, 1L, 0);
    }


    public static double todouble(Double value) {
        double ret = 0;
        if (value != null) {
            ret = value;
        }
        return ret;
    }

    public static int toInt(Long value) {
        int ret = 0;
        if (value != null) {
            ret = value.intValue();
        }
        return ret;
    }

    /**
     * @param value
     * @param amplification
     * @return
     */
    public static Double long2Double(Long value, Long amplification, int newScala) {
        Double ret = null;
        if (value != null) {
            ret = (value + 0.0) / amplification;

            if (ret != null) {
                ret = formatDouble(ret.doubleValue(), newScala);
            }

        }
        return ret;
    }


    /**
     * @param value
     * @param amplification
     * @return
     */
    public static double long2double(long value, long amplification, int newScala) {
        double ret = formatdouble((value + 0.0) / amplification, newScala);
        return ret;
    }


    /**
     * 位数截取
     *
     * @param d
     * @return
     */
    public static Double formatDouble(Double d, int newScala) {
        Double ret = null;
        if (d != null) {
            BigDecimal bg = new BigDecimal(d).setScale(newScala, RoundingMode.UP);
            ret = bg.doubleValue();
        }
        return ret;
    }


    /**
     * 位数截取
     *
     * @param d
     * @return
     */
    public static double formatdouble(double d, int newScala) {

        BigDecimal bg = new BigDecimal(d).setScale(newScala, RoundingMode.UP);
        double ret = bg.doubleValue();
        return ret;
    }


    /**
     * @param value
     * @return
     */
    public static Long double2Long(Double value) {
        return double2Long(value, 1L);
    }

    /**
     * @param value
     * @param amplification
     * @return
     */
    public static Long double22Long(Double value, Long amplification) {
        Long ret = null;
        if (amplification == null) {
            amplification = 1L;
        }

        if (value != null) {
            ret = Math.round(value * amplification);
        }
        return ret;
    }

    /**
     * @param value
     * @param amplification
     * @return
     */
    public static long double2long(double value, long amplification) {
        return Math.round(value * amplification);
    }

    /**
     * @param value
     * @param amplification
     * @return
     */
    public static Long double2Long(double value, Long amplification) {
        return Math.round(value * amplification);
    }


    /**
     * 判断广告对用户的发券类型   首次发  重复发
     *
     * @return
     */
    public static Long addLong(Long v1, Long v2) {
        Long ret = 0L;
        try {
            if (v1 != null) {
                ret = ret + v1;
            }
            if (v2 != null) {
                ret = ret + v2;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }


    /**
     * 判断广告对用户的发券类型   首次发  重复发
     *
     * @return
     */
    public static Double addDouble(Double v1, Double v2, int newScala) {

        return formatDouble(addDouble(v1, v2), newScala);
    }

    /**
     * 判断广告对用户的发券类型   首次发  重复发
     *
     * @return
     */
    public static Double addDouble(Double v1, Double v2) {
        Double ret = 0.0;
        try {
            if (v1 != null) {
                ret = ret + v1;
            }
            if (v2 != null) {
                ret = ret + v2;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }

    /**
     * 判断广告对用户的发券类型   首次发  重复发
     *
     * @return
     */
    public static Double multiplyDouble(Double v1, Double v2) {
        Double ret = null;
        try {
            if (v1 != null && v2 != null) {
                ret = v1 * v2;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }


    /**
     * 判断广告对用户的发券类型   首次发  重复发
     *
     * @return
     */
    public static Double multiply(Double v1, Long v2) {
        Double ret = null;
        try {
            if (v1 != null && v2 != null) {
                ret = v1 * v2;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }


    /**
     * 判断广告对用户的发券类型   首次发  重复发
     *
     * @return
     */
    public static Long multiplyLong(Long v1, Long v2) {
        Long ret = null;
        try {
            if (v1 != null && v2 != null) {
                ret = v1 * v2;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }


    public static Double division(Double v1, Long v2, int newScala) {
        return formatDouble(division(v1, v2), newScala);
    }

    public static Double division(Double v1, Long v2) {
        return division(v1, toDouble(v2));
    }

    public static Double division(Long v1, Double v2, int newScala) {
        return formatDouble(division(v1, v2), newScala);
    }


    public static Double division(Long v1, Double v2) {
        return division(toDouble(v1), v2);
    }


    public static Double division(Long v1, Long v2, int newScala) {

        return formatDouble(division(v1, v2), newScala);
    }

    public static Double division(Long v1, Long v2) {

        return division(toDouble(v1), toDouble(v2));
    }


    public static Double division(Double v1, Double v2, int newScala) {
        return formatDouble(division(v1, v2), newScala);
    }


    public static boolean between(double value, double low, double high) {

        boolean ret = false;
        if (value >= low && value <= high) {
            ret = true;
        }
        return ret;
    }

    public static Double division(Double v1, Double v2) {
        Double ret = null;
        try {
            if (v1 != null && v2 != null) {
                ret = v1 / (v2 + 0.0000000001);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }


    /**
     * @param value
     * @return
     */
    public static Long str2Long(String value, Long defaultVal) {
        Long ret = defaultVal;
        if (value != null && value != "" && value != "null") {
            try {
                ret = Long.valueOf(value);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        return ret;
    }

    public static String stringStd(String src) {
        if (src == "") {
            return null;
        } else {
            return src;
        }
    }

    public static String Long2String(Long src) {
        String ret = null;
        if (src != null) {
            ret = Long.toString(src);
        }
        return ret;

    }

    public static Long string2Long(String src) {
        Long ret = null;
        if (src != null) {
            ret = Long.valueOf(src);
        }
        return ret;

    }


    public static Double string2Double(String src) {
        Double ret = null;
        if (src != null) {
            ret = Double.valueOf(src);
        }
        return ret;

    }

    public static String Integer2String(Integer src) {
        String ret = null;
        if (src != null) {
            ret = Integer.toString(src);
        }
        return ret;

    }

    public static String double2String(Double src) {
        String ret = null;
        if (src != null) {
            ret = Double.toString(src);
        }
        return ret;

    }


    public static List<String> stringToList(String src, String sep) {
        List<String> ret = null;
        if (src != null && sep != null) {
            String[] tmp = src.split(sep);
            ret = Arrays.asList(tmp);
        }
        return ret;
    }

    public static <T> T[] addAll(final T[] array1, final T... array2) {
        if (array1 == null) {
            return array2.clone();
        } else if (array2 == null) {
            return array1.clone();
        }
        final Class<?> type1 = array1.getClass().getComponentType();
        @SuppressWarnings("unchecked") // OK, because array is of type T
        final
        // a处
                T[] joinedArray = (T[]) Array.newInstance(type1, array1.length + array2.length);
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        try {
            // b处
            System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        } catch (final ArrayStoreException ase) {
            // Check if problem was due to incompatible types
            /*
             * We do this here, rather than before the copy because:
             * - it would be a wasted check most of the time
             * - safer, in case check turns out to be too strict
             */
            final Class<?> type2 = array2.getClass().getComponentType();
            if (!type1.isAssignableFrom(type2)) {
                throw new IllegalArgumentException("Cannot store " + type2.getName() + " in an array of "
                        + type1.getName(), ase);
            }
            throw ase; // No, so rethrow original
        }
        return joinedArray;
    }

    public static double[] insertElement(double original[], double element, int index) {

        int length = original.length;

        double destination[] = new double[length + 1];

        System.arraycopy(original, 0, destination, 0, index);

        destination[index] = element;

        System.arraycopy(original, index, destination, index + 1, length - index);

        return destination;
    }


}
