package cn.com.duiba.nezha.alg.common.model.advertexplore;

import java.util.HashMap;
import java.util.Map;

import cn.com.duiba.nezha.alg.common.util.DataUtil;
import lombok.Data;

@Data
public class ExploreData {

    String id;

    Long exposure = 0L;
    Long click = 0L;
    Map<Integer, Long> conv = new HashMap<>();
    Long consume = 0L;
    Long ocpcConsume = 0L;

    Double costBias = 0D;

    public static double division(Long v1, Long v2) {
        return (v1 != null && v2 != null && v2 != 0)  ? v1.doubleValue() / v2.doubleValue() : 0.0;
    }

    public double getCtr() {
        if (exposure <= 0) {
            return 0.0;
        }

        return DataUtil.formatDouble(click * 1.0 / exposure, 4);
    }

    public double getWCtr(double faithLevel) {
        return DataUtil.formatDouble(DataUtil.calWilsonScore(exposure, click, faithLevel), 4);
    }

    public double getCvr(Integer convertSubtype) {
        if (click <= 0) {
            return 0.0;
        }

        return DataUtil.formatDouble(division(conv.getOrDefault(convertSubtype, 0L), click), 4);
    }

    public double getWCvr(Integer convertSubtype, double faithLevel) {
        return DataUtil.formatDouble(DataUtil.calWilsonScore(click, conv.getOrDefault(convertSubtype, 0L), faithLevel),
                4);
    }


    public double getCtCvr(Integer convertSubtype) {
        if (exposure <= 0) {
            return 0.0;
        }

        return DataUtil.formatDouble(division(conv.getOrDefault(convertSubtype, 0L), exposure),
                4);
    }

    public double getWCtCvr(Integer convertSubtype, double faithLevel) {
        return DataUtil.formatDouble(DataUtil.calWilsonScore(exposure, conv.getOrDefault(convertSubtype, 0L), faithLevel),
                4);

    }

    public static void main(String[] args) {
        ExploreData exploreData = new ExploreData();
        exploreData.setExposure(100000L);
        exploreData.setClick(100L);
        HashMap<Integer, Long> conv = new HashMap<>();
        conv.put(0, 20L);
        conv.put(2, 10L);
        conv.put(3, 5L);
        exploreData.setConv(conv);

        System.out.println(exploreData.getCtr());
        System.out.println(exploreData.getWCtr(2));

        System.out.println(exploreData.getCvr(0));
        System.out.println(exploreData.getWCvr(0, 2));

        System.out.println(exploreData.getCtCvr(0));
        System.out.println(exploreData.getWCtCvr(0, 2));
    }


}
