package cn.com.duiba.nezha.alg.common.model.advertexplore;

import lombok.Data;

import java.util.HashMap;
import java.util.Map;

@Data
public class HourDto {
    /**
     * 曝光
     */
    private Long advertExposure = 0l;

    /**
     * 有效点击（计费点击）
     */
    private Long clickCnt = 0l;

    /**
     * 累计计费金额 消耗指标
     */
    private Long chargeFees = 0l;

    /**
     * ocpc消耗
     */
    private Long ocpcChargeFees = 0l;

    /**
     * 转化次数
     */
    private Map<Integer, Long> backendCntMap = new HashMap<>();

    /**
     * 成本
     */
    private Double cosDeviation;

    /**
     * 期望收益--目标成本
     */
    private Long aFee = 0l;

    /**
     * 参与竞价次数
     */
    private Long bidReqCount = 0l;

    /**
     * cvr
     */
    private Double cvr = 0.0;

    public static HourDto getInstance(Long bidReqCount,Long advertExposure,Long clickCnt,Long convertCnt0,
                                      Long convertCnt3,Long ocpcChargeFees,Long aFee,Double cvr) {
        Map<Integer, Long> backendCntMap=new HashMap<Integer, Long>();
        backendCntMap.put(0,convertCnt0);
        backendCntMap.put(3,convertCnt3);

        HourDto hourDto=new HourDto();
        hourDto.setBidReqCount(bidReqCount);
        hourDto.setAdvertExposure(advertExposure);
        hourDto.setClickCnt(clickCnt);
        hourDto.setBackendCntMap(backendCntMap);
        hourDto.setOcpcChargeFees(ocpcChargeFees);
        hourDto.setAFee(aFee);
        hourDto.setCvr(cvr);
        return hourDto;
    }
}
