package cn.com.duiba.nezha.alg.common.model.materialrecommend;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author lijingzhe
 * @description 素材推荐2.5
 * @date 2020/2/5
 */
public class MaterialRec25 {
    private static final Logger logger= LoggerFactory.getLogger(MaterialRec25.class);

    /**
     * @author: lijingzhe
     * @date: 2020/2/5
     * @methodParameters:
     * @methodReturnType:
     * @description: 海选新增每uv消耗召回
     */
    public static List<MaterialMatchInfo> match(List<MaterialDataInfo> materialList, List<MaterialNormInfo> exScks) {
        // 新素材试投概率
        double prob = Constant.PROB;
        // 新素材曝光阈值
        double exposureThreshold = Constant.EXPOSURE_THRESHOLD;
        // 海选召回数量
        int topn = Constant.RECALL_TOPN_25;
        // 优质素材召回数量
        int exTopN = Constant.EXCELLENT_TOPN;

        if(materialList.size() == 0){
            return null;
        }
        // 融合ctr降序队列
        Queue<AlgUtils.MatchInfo> gCandisCTR = new PriorityQueue<>(materialList.size(), AlgUtils.iComparator);
        // 广告位ctr降序队列
        Queue<AlgUtils.MatchInfo> sCandisCTR = new PriorityQueue<>(materialList.size(), AlgUtils.iComparator);
        // 融合每pv消耗队列
        Queue<AlgUtils.MatchInfo> gCandisUC = new PriorityQueue<>(materialList.size(), AlgUtils.iComparator);
        // 广告位每pv消耗队列
        Queue<AlgUtils.MatchInfo> sCandisUC = new PriorityQueue<>(materialList.size(), AlgUtils.iComparator);
        // 融合每访问pv消耗队列->2020-02-20替代为每pv券有效点击
        Queue<AlgUtils.MatchInfo> gCandisUCA = new PriorityQueue<>(materialList.size(), AlgUtils.iComparator);
        // 广告位每访问pv消耗队列->2020-02-20替代为每pv券有效点击
        Queue<AlgUtils.MatchInfo> sCandisUCA = new PriorityQueue<>(materialList.size(), AlgUtils.iComparator);
        // 按归一化score降序素材队列
        Queue<AlgUtils.MatchInfo> normCandis=new PriorityQueue<>(exTopN, AlgUtils.normComparator);
        // 海选集初始化
        List<MaterialMatchInfo> result = new ArrayList<>();
        // 可投素材封装
        List<MaterialMatchInfo> sckModel=new ArrayList<MaterialMatchInfo>();
        // 广告位总曝光次数
        double exposures = 0;
        // 广告位的总点击次数
        double clicks = 0;
        // 广告位的总活动访问次数
        double requests = 0;
        // 广告位的总消耗
        double costs = 0;
        // 广告位的总券点击次数
        double validClicks = 0;
        for(MaterialDataInfo mat : materialList){
            exposures += mat.getExposureCnt().getSlotVal();
            clicks += mat.getClickCnt().getSlotVal();
            requests += mat.getRequest().getSlotVal();
            costs += mat.getCost().getSlotVal();
            validClicks += mat.getValidClick().getSlotVal();
        }
        double ctr = exposures > 0 ? clicks/exposures : 0;
        double uca = requests > 0 ? validClicks/requests : 0;
        double uc = exposures > 0 ? costs/exposures : 0;

        // 优质素材详情数据
        Map<Long, MaterialNormInfo> exHashMap=new HashMap<>();
        if(exScks!=null) {
            for(MaterialNormInfo exSck : exScks){
                exHashMap.put(exSck.getMaterialId(), exSck);
            }
        }

        //优质素材id集合
        Set<Long> sckIds=new HashSet<>(exHashMap.keySet());
        //广告位下投放过素材id集合
        Set<Long> hisSckIds=new HashSet<>(materialList.stream().map(MaterialDataInfo::getMaterialId).collect(Collectors.toSet()));

        // 海选池素材id占位
        HashSet<Long> idset=new HashSet();
        for (MaterialDataInfo mat : materialList) {
            try {
                // 封装数据
                MaterialMatchInfo sckM=AlgUtils.fillData(mat, sckIds, exHashMap);
                sckM.setCtr(ctr);
                sckM.setUc(uc);
                sckM.setUca(uca);
                sckM.setCosts(costs);
                sckModel.add(sckM);

                // 新素材试投，上架时间小于3天
                if (sckM.exposureCnt.getGlobalVal() < exposureThreshold) {
                    if (System.currentTimeMillis() - mat.createTime < 3 * 24 * 60 * 60 * 1000) {
                        if (Math.random() < prob) {
                            result.add(sckM);
                            topn--;
                            idset.add(sckM.materialId);
                        }
                    } else if (materialList.size() > topn) {
                        if (Math.random() < 0.1 * prob) {
                            result.add(sckM);
                            topn--;
                            idset.add(sckM.materialId);
                        }
                    }
                }

                // 置信曝光ctr
                double wctr = AlgUtils.getMatchScore(sckM.exposureCnt, sckM.clickCnt, 100d, 1000d, false);
                // 置信曝光每访问pv消耗->2020-02-20替代为每pv券有效点击
                double wuca = AlgUtils.getMatchScore(sckM.request, sckM.validClick, 100d, 1000d, false);
                // 置信每pv消耗
                double wuc = AlgUtils.getMatchScore(sckM.exposureCnt, sckM.cost, 100d, 1000d, true);

                // 归一化
                if(sckM.isExcellent){
                    // 已投放过的优质素材召回
                    AlgUtils.MatchInfo emi = new AlgUtils.MatchInfo();
                    emi.mat=sckM;
                    emi.score = sckM.score;
                    normCandis.add(emi);
                }else{
                    AlgUtils.MatchInfo wctrm = new AlgUtils.MatchInfo();
                    wctrm.mat=sckM;
                    wctrm.score=wctr;
                    gCandisCTR.add(wctrm);
                    AlgUtils.MatchInfo wucam = new AlgUtils.MatchInfo();
                    wucam.mat=sckM;
                    wucam.score=wuca;
                    gCandisUCA.add(wucam);
                    AlgUtils.MatchInfo wucm = new AlgUtils.MatchInfo();
                    wucm.mat=sckM;
                    wucm.score=wuc;
                    gCandisUC.add(wucm);
                    //广告位请求数大于99 或点击大于5
                    if (sckM.exposureCnt.getSlotVal() > 99 || sckM.clickCnt.getSlotVal() > 5) {
                        AlgUtils.MatchInfo uctrm=new AlgUtils.MatchInfo();
                        uctrm.mat=sckM;
                        // 点击次数/曝光次数
                        uctrm.score=sckM.clickCnt.getSlotVal() /sckM.exposureCnt.getSlotVal();
                        // 广告位每uv消耗召回
                        sCandisCTR.add(uctrm);
                        AlgUtils.MatchInfo uckmi=new AlgUtils.MatchInfo();
                        uckmi.mat=sckM;
                        // 券点击/请求数
                        uckmi.score=sckM.cost.getSlotVal()/(100 * sckM.exposureCnt.getSlotVal());
                        // 广告位每uv券点击召回
                        sCandisUC.add(uckmi);
                    }
                    // 广告位访问请求大于5
                    if(sckM.request.getSlotVal() > 49){
                        AlgUtils.MatchInfo ucam = new AlgUtils.MatchInfo();
                        ucam.mat=sckM;
                        ucam.score=sckM.validClick.getSlotVal()/sckM.request.getSlotVal();
                        // 广告位每访问uv消耗
                        sCandisUCA.add(ucam);
                    }
                }
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
            }
        }

        // 广告位每uv消耗top10占位
        for(int i = 0; i< Constant.RECALL_SUC_TOPN && i<sCandisUC.size(); i++){
            MaterialMatchInfo mat = sCandisUC.poll().mat;
            if(idset.contains(mat.materialId))
                continue;
            result.add(mat);
            idset.add(mat.materialId);
            topn--;
        }
        // 融合每uv消耗top10占位
        for(int i = 0; i< Constant.RECALL_GUC_TOPN && i<gCandisUC.size(); i++){
            MaterialMatchInfo mat = gCandisUC.poll().mat;
            if(idset.contains(mat.materialId))
                continue;
            result.add(mat);
            idset.add(mat.materialId);
            topn--;
        }
        // 广告位ctr top10占位
        for(int i = 0; i< Constant.RECALL_SCTR_TOPN && i<sCandisCTR.size(); i++){
            MaterialMatchInfo mat = sCandisCTR.poll().mat;
            if(idset.contains(mat.materialId))
                continue;
            result.add(mat);
            idset.add(mat.materialId);
            topn--;
        }
        // 融合ctr top10占位
        for(int i = 0; i< Constant.RECALL_GCTR_TOPN && i<gCandisCTR.size(); i++){
            MaterialMatchInfo mat = gCandisCTR.poll().mat;
            if(idset.contains(mat.materialId))
                continue;
            result.add(mat);
            idset.add(mat.materialId);
            topn--;
        }
        // 广告位每访问pv券点击top5占位
        for(int i = 0; i< Constant.RECALL_SUCA_TOPN && i<sCandisUCA.size(); i++){
            MaterialMatchInfo mat = sCandisUCA.poll().mat;
            if(idset.contains(mat.materialId))
                continue;
            result.add(mat);
            idset.add(mat.materialId);
            topn--;
        }
        // 融合每访问pv券点击top5占位
        for(int i = 0; i< Constant.RECALL_GUCA_TOPN && i<gCandisUCA.size(); i++){
            MaterialMatchInfo mat = gCandisUCA.poll().mat;
            if(idset.contains(mat.materialId))
                continue;
            result.add(mat);
            idset.add(mat.materialId);
            topn--;
        }

        // 未在特定广告位有历史投放记录的素材
        if(exScks!=null){
            for(MaterialNormInfo exSck : exScks){
                if(!hisSckIds.contains(exSck.getMaterialId())){
                    AlgUtils.MatchInfo mci=new AlgUtils.MatchInfo();
                    MaterialMatchInfo aim=new MaterialMatchInfo();
                    aim.setAppId(materialList.get(0).getAppId());
                    aim.setSlotId(materialList.get(0).getSlotId());
                    aim.setMaterialId(exSck.getMaterialId());
                    aim.setnCtr(exSck.getnCtr());
                    aim.setnPvCost(exSck.getnPvCost());
                    aim.setScore(exSck.getScore());
                    aim.setExcellent(true);
                    mci.score=exSck.getScore();
                    mci.mat=aim;
                    normCandis.add(mci);
                }
            }

            for (int i=0; i < exTopN && i < normCandis.size(); i++) {
                AlgUtils.MatchInfo candisInfo= normCandis.poll();
                if(idset.contains(candisInfo.mat.getMaterialId()))
                    continue;
                result.add(candisInfo.mat);
                idset.add(candisInfo.mat.getMaterialId());
                topn--;
            }
        }

        return result;
    }
    /**
     * @author: lijingzhe
     * @date: 2020/2/5
     * @methodParameters:
     * @methodReturnType:
     * @description: 优选新增分层排序和二次约束
     */
    public static MaterialRankInfo select(List<MaterialMatchInfo> matchInfos, List<MaterialRankInfo>  materialModels) {
        HashMap<Long, MaterialRankInfo> map = new HashMap<>();
        //1、两个列表为空，或者长度不一致,或者顺序不一致，报错,返回空值
        if (matchInfos.size() == 0 || materialModels.size() == 0) {
            return null;
        }

        if (matchInfos.size() != materialModels.size()) {
            return null;
        }

        // 素材ID倒排
        List<MaterialMatchInfo> matchInfoList = matchInfos.stream().sorted(Comparator.comparing(MaterialMatchInfo::getMaterialId).reversed()).collect(Collectors.toList());
        List<MaterialRankInfo> materialModelList = materialModels.stream().sorted(Comparator.comparing(MaterialRankInfo::getMaterialId).reversed()).collect(Collectors.toList());

        for (int i = 0; i < matchInfoList.size(); i++) {
            long intoMaterialId = matchInfoList.get(i).getMaterialId();
            long modelMaterailId = materialModelList.get(i).getMaterialId();
            if (intoMaterialId != modelMaterailId) {
                return null;
            }
        }

        List<RankInfo> ris = new ArrayList<>();
        List<MaterialRankInfo> mris = new ArrayList<>();
        double costs = matchInfoList.get(0).costs;
        String oppAlg = Constant.ALG_CTR;
        // 广告位消耗>cost_thr则优先ecpm，否则优先ctr
        if(costs >= Constant.COST_THRESHOLD){
            oppAlg = Constant.ALG_UC;
        }
        // uv收益导向优先
        int algType = matchInfoList.get(0).getAlgType();
        int feeMark = matchInfoList.get(0).getFeeMark();
        if(algType == 4 && feeMark == 1){
            oppAlg = Constant.ALG_UCA;
        }
        mris = AlgUtils.getSingleOptCandis(ris, matchInfoList, materialModelList, oppAlg, 100, 100);
        AlgUtils.MaterialDetail md = AlgUtils.selectMultiOptInfo(ris, matchInfoList, materialModelList, oppAlg);
        MaterialRankInfo mri = materialModelList.get(md.index);
        mri.strategyType = md.strategyType;
        return mri;
    }
}
