/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.common.model.activityrecommend;

import cn.com.duiba.nezha.alg.common.model.activityrecommend.ActivityCvrInfo;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.ActivityInfoAd;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.ActivityInfoData;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.ActivityMatchInfo;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.ActivityRankInfo;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.ActivityVal;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.BetaDistribution;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.NormInfo;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.RankResult;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.SelectPoolInfo;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.SimilarCostActivitiesInfo;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.WilsonInterval;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityRec49 {
    private static final Logger logger = LoggerFactory.getLogger(ActivityRec49.class);
    public static Comparator<MatchInfo> iComparator = new Comparator<MatchInfo>(){

        @Override
        public int compare(MatchInfo c1, MatchInfo c2) {
            return c2.score - c1.score >= 0.0 ? 1 : -1;
        }
    };
    public static Comparator<MatchInfo> normComparator = new Comparator<MatchInfo>(){

        @Override
        public int compare(MatchInfo m1, MatchInfo m2) {
            return m2.act.score - m1.act.score >= 0.0 ? 1 : -1;
        }
    };

    public static List<ActivityMatchInfo> match(List<ActivityInfoData> actData, List<ActivityInfoAd> actAds, List<NormInfo> exActs) {
        int exTopN = Constant.EXCELLENT_TOPN;
        ArrayList<ActivityMatchInfo> result = new ArrayList<ActivityMatchInfo>();
        ArrayList<ActivityMatchInfo> actModel = new ArrayList<ActivityMatchInfo>();
        PriorityQueue<MatchInfo> candis = new PriorityQueue<MatchInfo>(actData.size(), iComparator);
        PriorityQueue<MatchInfo> slotCandis = new PriorityQueue<MatchInfo>(actData.size(), iComparator);
        PriorityQueue<MatchInfo> normCandis = new PriorityQueue<MatchInfo>(exTopN, normComparator);
        HashMap<Long, ActivityInfoAd> adHashMap = new HashMap<Long, ActivityInfoAd>();
        double form_click_cnt = 0.0;
        double notForm_click_cnt = 0.0;
        double click_cnt = 0.0;
        double form_effect_cnt = 0.0;
        double notForm_effect_cnt = 0.0;
        double effect_cnt = 0.0;
        for (ActivityInfoAd ad : actAds) {
            adHashMap.put(ad.getActivityId(), ad);
            click_cnt += (form_click_cnt += ad.getSumClickForms()) + (notForm_click_cnt += ad.getSumClickNotForms());
            effect_cnt += (form_effect_cnt += ad.getSumEffectPVForms()) + (notForm_effect_cnt += ad.getSumEffectPVNotForms());
        }
        double cvr = click_cnt > 0.0 ? effect_cnt / click_cnt : 0.0;
        double formCvrBias = form_effect_cnt < form_click_cnt ? WilsonInterval.wilsonCalc((double)form_effect_cnt, (double)form_click_cnt).lowerBound : WilsonInterval.wilsonCalc((double)form_click_cnt, (double)form_click_cnt).lowerBound;
        double notFormCvrBias = notForm_effect_cnt < notForm_click_cnt ? WilsonInterval.wilsonCalc((double)notForm_effect_cnt, (double)notForm_click_cnt).lowerBound : WilsonInterval.wilsonCalc((double)notForm_click_cnt, (double)notForm_click_cnt).lowerBound;
        double cvrBias = formCvrBias + 0.2 * notFormCvrBias;
        HashMap<Long, NormInfo> exHashMap = new HashMap<Long, NormInfo>();
        if (exActs != null) {
            for (NormInfo exAct : exActs) {
                exHashMap.put(exAct.getActivityId(), exAct);
            }
        }
        HashSet<Long> actIds = new HashSet<Long>(exHashMap.keySet());
        HashSet hisActIds = new HashSet(actData.stream().map(ActivityInfoData::getActivityId).collect(Collectors.toSet()));
        HashSet<Long> idset = new HashSet<Long>();
        for (ActivityInfoData act : actData) {
            try {
                ActivityMatchInfo actM = ActivityRec49.fillData(act, actIds, exHashMap);
                actM.setCvrBias(cvrBias);
                actModel.add(actM);
                double slotScore = WilsonInterval.wilsonCalc((double)(actM.hisCost.slotVal / 100.0), (double)actM.hisRequest.slotVal).lowerBound;
                double globalScore = WilsonInterval.wilsonCalc((double)(actM.hisCost.globalVal / 100.0), (double)actM.hisRequest.globalVal).lowerBound;
                double appScore = WilsonInterval.wilsonCalc((double)(actM.hisCost.appVal / 100.0), (double)actM.hisRequest.appVal).lowerBound;
                double matchscore = 0.0;
                double sconfidence = Math.min(actM.hisRequest.slotVal / 100.0, 1.0);
                double aconfidence = Math.min(actM.hisRequest.appVal / 100.0, 1.0);
                double gconfidence = Math.min(actM.hisRequest.globalVal / 1000.0, 1.0);
                matchscore = sconfidence * slotScore + (1.0 - sconfidence) * aconfidence * appScore * 0.9 + (1.0 - sconfidence - (1.0 - sconfidence) * aconfidence) * globalScore * Math.max(0.5, gconfidence);
                double changeScore = 0.0;
                ActivityCvrInfo activityChangeValNew = new ActivityCvrInfo();
                if (adHashMap.containsKey(act.activityId)) {
                    activityChangeValNew = ActivityRec49.calChangeScoreMergeAbsolute(adHashMap.getOrDefault(act.activityId, new ActivityInfoAd()), cvrBias);
                    changeScore = activityChangeValNew.changeScoreMerge;
                }
                actM.changeScore = changeScore;
                actM.activityChangeVal = activityChangeValNew;
                MatchInfo info = new MatchInfo();
                info.act = actM;
                info.score = matchscore;
                if (actM.isExcellent) {
                    normCandis.add(info);
                    continue;
                }
                candis.add(info);
                if (!(sconfidence > 0.99) && !(actM.hisClick.slotVal > 5.0)) continue;
                MatchInfo info2 = new MatchInfo();
                info2.act = actM;
                info2.score = actM.hisRequest.slotVal > 0.0 ? actM.hisCost.slotVal / (100.0 * actM.hisRequest.slotVal) : 0.0;
                slotCandis.add(info2);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        int slotSize = slotCandis.size();
        for (int i = 0; i < 10 && i < slotSize; ++i) {
            ActivityMatchInfo act = ((MatchInfo)slotCandis.poll()).act;
            if (idset.contains(act.activityId)) continue;
            result.add(act);
            idset.add(act.activityId);
        }
        int size = candis.size();
        for (int i = 0; i < size; ++i) {
            ActivityMatchInfo act = ((MatchInfo)candis.poll()).act;
            if (idset.contains(act.activityId)) continue;
            result.add(act);
            idset.add(act.activityId);
        }
        if (exActs != null) {
            for (NormInfo exAct : exActs) {
                if (hisActIds.contains(exAct.getActivityId())) continue;
                MatchInfo mci = new MatchInfo();
                ActivityMatchInfo aim = new ActivityMatchInfo();
                aim.setAppId(actData.get(0).getAppId());
                aim.setSlotId(actData.get(0).getSlotId());
                aim.setActivityId(exAct.getActivityId());
                aim.setnPvClick(exAct.getnPvClick());
                aim.setnPvCost(exAct.getnPvCost());
                aim.setnCvrForm(exAct.getnFormCvr());
                aim.setnCvrNotForm(exAct.getnNotFormCvr());
                aim.setnCvr(exAct.getnCvr());
                aim.setScore(exAct.getScore());
                aim.setExcellent(true);
                mci.score = exAct.getScore();
                mci.act = aim;
                normCandis.add(mci);
            }
            for (int i = 0; i < exTopN && i < normCandis.size(); ++i) {
                MatchInfo candisInfo = (MatchInfo)normCandis.poll();
                if (idset.contains(candisInfo.act.activityId)) continue;
                result.add(candisInfo.act);
                idset.add(candisInfo.act.activityId);
            }
        }
        return result;
    }

    public static RankResult select(List<ActivityRankInfo> actModel, List<ActivityMatchInfo> actData) {
        RankResult rankResult = new RankResult();
        if (actModel.size() == 0 || actData.size() == 0) {
            return null;
        }
        if (actModel.size() != actData.size()) {
            rankResult.activityModel = actModel.get(0);
            rankResult.similarCostActivitiesInfo = null;
            return rankResult;
        }
        List actModelCopy = actModel.stream().sorted(Comparator.comparing(ActivityRankInfo::getActivityId).reversed()).collect(Collectors.toList());
        List actDataCopy = actData.stream().sorted(Comparator.comparing(ActivityMatchInfo::getActivityId).reversed()).collect(Collectors.toList());
        for (int i = 0; i < actModelCopy.size(); ++i) {
            long activityIdMode = ((ActivityRankInfo)actModelCopy.get((int)i)).activityId;
            long activityIdData = ((ActivityMatchInfo)actDataCopy.get((int)i)).activityId;
            if (activityIdMode == activityIdData) continue;
            rankResult.activityModel = actModel.get(0);
            rankResult.similarCostActivitiesInfo = null;
            return rankResult;
        }
        ArrayList<Double> requests = new ArrayList<Double>();
        ArrayList<Double> rewards = new ArrayList<Double>();
        ArrayList<Double> counts = new ArrayList<Double>();
        ArrayList<Double> alphas = new ArrayList<Double>();
        ArrayList<Double> betas = new ArrayList<Double>();
        ArrayList<Double> changeScores = new ArrayList<Double>();
        ArrayList<Double> cvrBiass = new ArrayList<Double>();
        ArrayList<Long> activityIds = new ArrayList<Long>();
        ArrayList<Long> activityTypes = new ArrayList<Long>();
        ArrayList<Double> grpms = new ArrayList<Double>();
        ArrayList<Double> arpms = new ArrayList<Double>();
        ArrayList<Double> hrpms = new ArrayList<Double>();
        ArrayList<Boolean> excellents = new ArrayList<Boolean>();
        ArrayList<Integer> subTypes = new ArrayList<Integer>();
        ArrayList<Double> scores = new ArrayList<Double>();
        ArrayList candiList = new ArrayList();
        double decay = Constant.DECAY;
        int size = 0;
        HashMap<Long, RankInfo> mMap = new HashMap<Long, RankInfo>();
        double maxG = Constant.MIN_REWARD;
        double maxH = Constant.MIN_REWARD;
        double maxA = Constant.MIN_REWARD;
        double minG = 0.0;
        double minH = Constant.MIN_REWARD;
        double minA = Constant.MIN_REWARD;
        ActivityRankInfo result = new ActivityRankInfo();
        try {
            for (ActivityMatchInfo activityMatchInfo : actDataCopy) {
                double hrpm;
                double arpm;
                double grpm;
                RankInfo info = mMap.containsKey(activityMatchInfo.activityId) ? (RankInfo)mMap.get(activityMatchInfo.activityId) : new RankInfo();
                info.grpm = grpm = activityMatchInfo.hisRequest.globalVal > 0.0 ? activityMatchInfo.hisCost.globalVal / (100.0 * activityMatchInfo.hisRequest.globalVal) : 0.0;
                info.gexp = activityMatchInfo.hisRequest.globalVal;
                maxG = Math.max(grpm, maxG);
                info.arpm = arpm = activityMatchInfo.hisRequest.appVal > 0.0 ? activityMatchInfo.hisCost.appVal / (100.0 * activityMatchInfo.hisRequest.appVal) : 0.0;
                info.aexp = activityMatchInfo.hisRequest.appVal;
                if (info.aexp > 100.0) {
                    maxA = Math.max(arpm, maxA);
                }
                minA = Math.min(arpm, minA);
                info.hrpm = hrpm = activityMatchInfo.hisRequest.slotVal > 0.0 ? activityMatchInfo.hisCost.slotVal / (100.0 * activityMatchInfo.hisRequest.slotVal) : 0.0;
                info.hexp = activityMatchInfo.hisRequest.slotVal;
                if (info.hexp > 100.0) {
                    maxH = Math.max(hrpm, maxH);
                }
                minH = Math.min(hrpm, minH);
                mMap.put(activityMatchInfo.activityId, info);
            }
            for (int i = 0; i < actDataCopy.size(); ++i) {
                requests.add(((ActivityMatchInfo)actDataCopy.get((int)i)).hisRequest.slotVal);
                double hrpm = ((RankInfo)mMap.get((Object)Long.valueOf((long)((ActivityMatchInfo)actDataCopy.get((int)i)).activityId))).hrpm;
                double arpm = ((RankInfo)mMap.get((Object)Long.valueOf((long)((ActivityMatchInfo)actDataCopy.get((int)i)).activityId))).arpm;
                double grpm = ((RankInfo)mMap.get((Object)Long.valueOf((long)((ActivityMatchInfo)actDataCopy.get((int)i)).activityId))).grpm;
                hrpms.add(hrpm);
                arpms.add(arpm);
                grpms.add(grpm);
                excellents.add(((ActivityMatchInfo)actDataCopy.get((int)i)).isExcellent);
                subTypes.add(((ActivityMatchInfo)actDataCopy.get((int)i)).subType);
                scores.add(((ActivityMatchInfo)actDataCopy.get((int)i)).score);
                cvrBiass.add(((ActivityMatchInfo)actDataCopy.get((int)i)).cvrBias);
                double reward = Constant.MIN_REWARD;
                double sconfidence = Math.min(((ActivityMatchInfo)actDataCopy.get((int)i)).hisRequest.slotVal / 100.0, 1.0);
                double aconfidence = Math.min(((ActivityMatchInfo)actDataCopy.get((int)i)).hisRequest.appVal / 100.0, 1.0);
                reward = sconfidence * ActivityRec49.normlize(hrpm * 0.8, maxH, 0.8) + (1.0 - sconfidence) * aconfidence * ActivityRec49.normlize(arpm * 0.7, maxA, 0.7) + (1.0 - sconfidence - (1.0 - sconfidence) * aconfidence) * ActivityRec49.normlize(grpm * 0.5, maxG, 0.6);
                reward *= reward;
                reward = Math.max(reward, 0.0);
                ((ActivityRankInfo)actModelCopy.get((int)i)).reward = ((ActivityRankInfo)actModelCopy.get((int)i)).reward * decay + reward;
                ((ActivityRankInfo)actModelCopy.get((int)i)).count = ((ActivityRankInfo)actModelCopy.get((int)i)).count * decay + 1.0;
                ((ActivityRankInfo)actModelCopy.get((int)i)).alpha = 1.5 + ((ActivityRankInfo)actModelCopy.get((int)i)).reward;
                ((ActivityRankInfo)actModelCopy.get((int)i)).beta = 2.0 + (((ActivityRankInfo)actModelCopy.get((int)i)).count - ((ActivityRankInfo)actModelCopy.get((int)i)).reward);
                rewards.add(((ActivityRankInfo)actModelCopy.get((int)i)).reward);
                counts.add(((ActivityRankInfo)actModelCopy.get((int)i)).count);
                alphas.add(((ActivityRankInfo)actModelCopy.get((int)i)).alpha);
                betas.add(((ActivityRankInfo)actModelCopy.get((int)i)).beta);
                activityIds.add(((ActivityRankInfo)actModelCopy.get((int)i)).activityId);
                activityTypes.add(((ActivityMatchInfo)actDataCopy.get((int)i)).activityType);
                changeScores.add(((ActivityMatchInfo)actDataCopy.get((int)i)).changeScore);
                candiList.add(actModelCopy.get(i));
            }
            int numMachines = candiList.size();
            SelectInfoDetail selectInfoDetail = ActivityRec49.selectMachineWithChangeScore(alphas, betas, activityTypes, activityIds, changeScores, numMachines, hrpms, arpms, grpms, requests, excellents, subTypes, scores, cvrBiass);
            int selectedActivityIndex = selectInfoDetail.index;
            result = (ActivityRankInfo)candiList.get(selectedActivityIndex);
            result.strategyType = selectInfoDetail.strategyType;
            double maxChangeScore = selectInfoDetail.maxChangeScore;
            ArrayList<SimilarCostActivitiesInfo> sameCostActivitiesInfoList = new ArrayList<SimilarCostActivitiesInfo>();
            ArrayList<SelectPoolInfo> sameCostcondi = selectInfoDetail.condi;
            if (sameCostcondi.size() > 0) {
                double selectedActivityReward = sameCostcondi.get(0).getReward();
                int sameCostActivityCnt = sameCostcondi.size();
                for (SelectPoolInfo selectInfo : sameCostcondi) {
                    SimilarCostActivitiesInfo sameCostActivitiesInfo = new SimilarCostActivitiesInfo();
                    Long activityId = selectInfo.getActivityId();
                    Long activityType = selectInfo.getActivityType();
                    int ifSelected = 0;
                    if (selectInfo.getIndex() == selectedActivityIndex) {
                        ifSelected = 1;
                    }
                    int index = selectInfo.getIndex();
                    double mabReward = selectInfo.getReward();
                    double changeScore = selectInfo.getChangeScore();
                    double hrpm = selectInfo.getHrpm();
                    double arpm = selectInfo.getArpm();
                    double grpm = selectInfo.getGrpm();
                    int subType = selectInfo.getSubType();
                    boolean excellent = selectInfo.isExcellent();
                    double diffReward = selectInfo.getReward() - selectedActivityReward;
                    double diffChangeScore = selectInfo.getChangeScore() - maxChangeScore;
                    sameCostActivitiesInfo.activityId = activityId;
                    sameCostActivitiesInfo.sameActivityCnt = sameCostActivityCnt;
                    sameCostActivitiesInfo.activityType = activityType;
                    sameCostActivitiesInfo.ifSelected = ifSelected;
                    sameCostActivitiesInfo.mabReward = mabReward;
                    sameCostActivitiesInfo.changeScore = changeScore;
                    sameCostActivitiesInfo.index = index;
                    sameCostActivitiesInfo.hrpm = hrpm;
                    sameCostActivitiesInfo.arpm = arpm;
                    sameCostActivitiesInfo.grpm = grpm;
                    sameCostActivitiesInfo.diffReward = diffReward;
                    sameCostActivitiesInfo.diffChangeScore = diffChangeScore;
                    sameCostActivitiesInfo.subType = subType;
                    sameCostActivitiesInfo.isExcellent = excellent;
                    sameCostActivitiesInfoList.add(sameCostActivitiesInfo);
                }
            }
            rankResult.activityModel = result;
            rankResult.similarCostActivitiesInfo = sameCostActivitiesInfoList;
            mMap.clear();
            return rankResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage(), (Throwable)e);
            logger.error("error, size:{},candi:{},list:{},", new Object[]{size, JSON.toJSONString(candiList), JSON.toJSONString((Object)result)});
            return null;
        }
    }

    public static ActivityCvrInfo calChangeScoreMergeAbsolute(ActivityInfoAd ad, double cvr) {
        double changeScoreBias = 0.05;
        double changeScoreMerge = 0.0;
        double changeScoreForms = 0.0;
        double changeScoreNotForms = 0.0;
        changeScoreForms = ad.sumClickForms > ad.sumEffectPVForms ? WilsonInterval.wilsonCalc((double)ad.sumEffectPVForms, (double)ad.sumClickForms).lowerBound.doubleValue() : WilsonInterval.wilsonCalc((double)ad.sumClickForms, (double)ad.sumClickForms).lowerBound.doubleValue();
        changeScoreNotForms = ad.sumClickNotForms > ad.sumEffectPVNotForms ? WilsonInterval.wilsonCalc((double)ad.sumEffectPVNotForms, (double)ad.sumClickNotForms).lowerBound.doubleValue() : WilsonInterval.wilsonCalc((double)ad.sumClickNotForms, (double)ad.sumClickNotForms).lowerBound.doubleValue();
        double wcvr = cvr > 0.0 ? changeScoreBias / cvr : 1.0;
        changeScoreMerge = changeScoreForms + changeScoreNotForms * 0.2 * Math.min(2.5, wcvr);
        ActivityCvrInfo activityChangeVal = new ActivityCvrInfo();
        activityChangeVal.sumClickForms = ad.sumClickForms;
        activityChangeVal.sumEffectPVForms = ad.sumEffectPVForms;
        activityChangeVal.sumClickNotForms = ad.sumClickNotForms;
        activityChangeVal.sumEffectPVNotForms = ad.sumEffectPVNotForms;
        activityChangeVal.changeScoreForms = changeScoreForms;
        activityChangeVal.changeScoreNotForms = changeScoreNotForms;
        activityChangeVal.changeScoreMerge = changeScoreMerge;
        return activityChangeVal;
    }

    public static double normlize(double val, double max, double limit) {
        double norm = Math.min(val * limit / max, limit);
        return norm;
    }

    private static SelectInfoDetail selectMachineWithChangeScore(List<Double> alphas, List<Double> betas, List<Long> activityTypes, List<Long> activityIds, List<Double> changeScores, int numMachines, List<Double> hrpms, List<Double> arpms, List<Double> grpms, List<Double> requests, List<Boolean> excellents, List<Integer> subTypes, List<Double> scores, List<Double> cvrBiass) {
        SelectInfoDetail selectInfoDetail = new SelectInfoDetail();
        ArrayList<SelectPoolInfo> sinfos = new ArrayList<SelectPoolInfo>();
        for (int i = 0; i < numMachines; ++i) {
            double theta = BetaDistribution.BetaDist(alphas.get(i), betas.get(i));
            SelectPoolInfo sinfo = new SelectPoolInfo();
            sinfo.setReward(theta);
            sinfo.setActivityType(activityTypes.get(i));
            sinfo.setIndex(i);
            sinfo.setActivityId(activityIds.get(i));
            sinfo.setChangeScore(changeScores.get(i));
            sinfo.setHrpm(hrpms.get(i));
            sinfo.setArpm(arpms.get(i));
            sinfo.setGrpm(grpms.get(i));
            sinfo.setRequest(requests.get(i));
            sinfo.setExcellent(excellents.get(i));
            sinfo.setScores(scores.get(i));
            sinfo.setSubType(subTypes.get(i));
            sinfo.setCvrBias(cvrBiass.get(i));
            sinfos.add(sinfo);
        }
        if (sinfos.size() > 0) {
            List chs = sinfos.stream().sorted(Comparator.comparing(SelectPoolInfo::getChangeScore).reversed()).collect(Collectors.toList());
            double maxChangeScore = ((SelectPoolInfo)chs.get(0)).getChangeScore();
            List ranks = sinfos.stream().sorted(Comparator.comparing(SelectPoolInfo::getReward).reversed()).collect(Collectors.toList());
            for (int i = 0; i < ranks.size(); ++i) {
                if (((SelectPoolInfo)ranks.get(i)).getRequest() < 100.0) {
                    if (((SelectPoolInfo)ranks.get(i)).isExcellent() && Math.random() < 0.02) {
                        selectInfoDetail.condi = new ArrayList(ranks.subList(0, Math.min(ranks.size(), 5)));
                        selectInfoDetail.index = ((SelectPoolInfo)ranks.get(i)).getIndex();
                        selectInfoDetail.maxChangeScore = maxChangeScore;
                        selectInfoDetail.strategyType = 1;
                        break;
                    }
                    if (!(((SelectPoolInfo)ranks.get(i)).getChangeScore() < 0.8 * ((SelectPoolInfo)ranks.get(i)).getCvrBias()) || !(Math.random() < 0.001)) continue;
                    selectInfoDetail.condi = new ArrayList(ranks.subList(0, Math.min(ranks.size(), 5)));
                    selectInfoDetail.index = ((SelectPoolInfo)ranks.get(i)).getIndex();
                    selectInfoDetail.maxChangeScore = maxChangeScore;
                    selectInfoDetail.strategyType = -1;
                    break;
                }
                if (((SelectPoolInfo)ranks.get(i)).getRequest() >= 100.0 && ((SelectPoolInfo)ranks.get(i)).getRequest() <= 500.0) {
                    if (((SelectPoolInfo)ranks.get(i)).isExcellent() && i > 0 && i < 5 && Math.random() < 0.01) {
                        selectInfoDetail.condi = new ArrayList(ranks.subList(0, Math.min(ranks.size(), 5)));
                        selectInfoDetail.index = ((SelectPoolInfo)ranks.get(i)).getIndex();
                        selectInfoDetail.maxChangeScore = maxChangeScore;
                        selectInfoDetail.strategyType = 2;
                        break;
                    }
                    if (((SelectPoolInfo)ranks.get(i)).isExcellent() && i < 20 && Math.random() < 0.001) {
                        selectInfoDetail.condi = new ArrayList(ranks.subList(0, Math.min(ranks.size(), 5)));
                        selectInfoDetail.index = ((SelectPoolInfo)ranks.get(i)).getIndex();
                        selectInfoDetail.maxChangeScore = maxChangeScore;
                        selectInfoDetail.strategyType = 3;
                        break;
                    }
                    if (!(((SelectPoolInfo)ranks.get(i)).getChangeScore() < 0.8 * ((SelectPoolInfo)ranks.get(i)).getCvrBias()) || !(Math.random() < 2.0E-4)) continue;
                    selectInfoDetail.condi = new ArrayList(ranks.subList(0, Math.min(ranks.size(), 5)));
                    selectInfoDetail.index = ((SelectPoolInfo)ranks.get(i)).getIndex();
                    selectInfoDetail.maxChangeScore = maxChangeScore;
                    selectInfoDetail.strategyType = -2;
                    break;
                }
                if (!(((SelectPoolInfo)ranks.get(i)).getChangeScore() >= 0.8 * ((SelectPoolInfo)ranks.get(i)).getCvrBias())) continue;
                selectInfoDetail.condi = new ArrayList(ranks.subList(0, Math.min(ranks.size(), 5)));
                selectInfoDetail.index = ((SelectPoolInfo)ranks.get(i)).getIndex();
                selectInfoDetail.maxChangeScore = maxChangeScore;
                selectInfoDetail.strategyType = 4;
                break;
            }
            if (selectInfoDetail == null || selectInfoDetail.strategyType == 0) {
                selectInfoDetail.index = ((SelectPoolInfo)ranks.get(0)).getIndex();
                selectInfoDetail.maxChangeScore = changeScores.get(0);
                selectInfoDetail.condi = new ArrayList(ranks.subList(0, Math.min(ranks.size(), 5)));
                selectInfoDetail.strategyType = 5;
            }
        } else {
            selectInfoDetail.index = 0;
            selectInfoDetail.maxChangeScore = changeScores.get(0);
            selectInfoDetail.condi = new ArrayList();
            selectInfoDetail.strategyType = 0;
        }
        return selectInfoDetail;
    }

    private static ActivityMatchInfo fillData(ActivityInfoData act, Set<Long> actIds, Map<Long, NormInfo> exHashMap) {
        ActivityMatchInfo actM = new ActivityMatchInfo();
        actM.activityId = act.activityId;
        actM.slotId = act.slotId;
        actM.appId = act.appId;
        actM.ucRate = act.ucRate;
        actM.hisClick = new ActivityVal();
        actM.hisClick.globalVal = act.click.globalVal;
        actM.hisClick.appVal = act.click.appVal;
        actM.hisClick.slotVal = act.click.slotVal;
        actM.hisCost = new ActivityVal();
        actM.hisCost.globalVal = act.cost.globalVal;
        actM.hisCost.appVal = act.cost.appVal;
        actM.hisCost.slotVal = act.cost.slotVal;
        actM.hisRequest = new ActivityVal();
        actM.hisRequest.globalVal = act.request.globalVal;
        actM.hisRequest.appVal = act.request.appVal;
        actM.hisRequest.slotVal = act.request.slotVal;
        actM.isSupport = act.isSupport;
        actM.subType = act.subType;
        actM.isExcellent = actIds.contains(act.activityId);
        actM.nPvClick = exHashMap.getOrDefault(act.activityId, new NormInfo()).getnPvClick();
        actM.nPvCost = exHashMap.getOrDefault(act.activityId, new NormInfo()).getnPvCost();
        actM.nCvrForm = exHashMap.getOrDefault(act.activityId, new NormInfo()).getnFormCvr();
        actM.nCvrNotForm = exHashMap.getOrDefault(act.activityId, new NormInfo()).getnNotFormCvr();
        actM.nCvr = exHashMap.getOrDefault(act.activityId, new NormInfo()).getnCvr();
        actM.score = exHashMap.getOrDefault(act.activityId, new NormInfo()).getScore();
        return actM;
    }

    static class SelectInfoDetail {
        int index;
        ArrayList<SelectPoolInfo> condi;
        double maxChangeScore;
        int strategyType;

        SelectInfoDetail() {
        }
    }

    static class MatchInfo {
        double score = 0.0;
        ActivityMatchInfo act;

        MatchInfo() {
        }
    }

    static class RankInfo {
        double grpm;
        double gexp;
        double hrpm;
        double hexp;
        double arpm;
        double aexp;

        RankInfo() {
        }
    }

    static class Constant {
        static double MIN_REWARD = 0.1;
        static double DECAY = 0.99;
        static int EXCELLENT_TOPN = 5;

        Constant() {
        }
    }
}

