package cn.com.duiba.nezha.alg.common.util;

import cn.com.duiba.wolf.utils.Base58;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;

import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

/**
 * Blowfish加密解密的方法
 *
 * @link http://www.schneier.com/blowfish.html
 * @author zhoufang
 */
public class BlowfishUtils {
    private static final String CIPHER_NAME   = "Blowfish/CFB8/NoPadding";
    private static final String KEY_SPEC_NAME = "Blowfish";

    private static final ThreadLocal<HashMap<String, BlowfishUtils>> pool = new ThreadLocal<HashMap<String, BlowfishUtils>>();

    private Cipher enCipher;
    private Cipher deCipher;

    private String key;

    private BlowfishUtils(String key) {
        try {
            this.key = key;
            String iv = StringUtils.substring(DigestUtils.md5Hex(key), 0, 8);
            SecretKeySpec secretKeySpec = new SecretKeySpec(key.getBytes(), KEY_SPEC_NAME);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv.getBytes());
            enCipher = Cipher.getInstance(CIPHER_NAME);
            deCipher = Cipher.getInstance(CIPHER_NAME);
            enCipher.init(Cipher.ENCRYPT_MODE, secretKeySpec, ivParameterSpec);
            deCipher.init(Cipher.DECRYPT_MODE, secretKeySpec, ivParameterSpec);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }

    }
    /**
     * 加密
     *
     * @param s
     * @return
     */
    private String encrypt(String s) {
        String result = null;
        if (StringUtils.isNotBlank(s)) {
            try {
                byte[] encrypted = enCipher.doFinal(s.getBytes());
                result = new String(Base58.encode(encrypted));
            } catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    /**
     * 解密
     *
     * @param s
     * @return
     */
    private String decrypt(String s) {
        String result = null;
        if (StringUtils.isNotBlank(s)) {
            try {
                byte[] decrypted = Base58.decode(s);
                result = new String(deCipher.doFinal(decrypted));
            } catch (Exception e) {
                resetInstance();
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private void resetInstance() {
        pool.set(null);
    }

    public static String encryptBlowfish(String s, String key) {
        return getInstance(key).encrypt(s);
    }

    public static String decryptBlowfish(String s, String key) {
        return getInstance(key).decrypt(s);
    }

    public static String encryptBlowfish(String s) {
        return encryptBlowfish(s, "abc");
    }

    public static String decryptBlowfish(String s) {
        return decryptBlowfish(s, "abc");
    }

    private static BlowfishUtils getInstance(String key) {
        HashMap<String, BlowfishUtils> keyMap = pool.get();
        if (keyMap == null || keyMap.isEmpty()) {
            keyMap = new HashMap<String, BlowfishUtils>();
            pool.set(keyMap);
        }
        BlowfishUtils instance = keyMap.get(key);
        if (instance == null || !StringUtils.equals(instance.key, key)) {
            instance = new BlowfishUtils(key);
            keyMap.put(key, instance);
        }
        return instance;
    }


    public static void main(String[] strings){

//        String str1="k1ZZBniHR5xHSCHkRYGF21drLAF8tPbKk8PP8BtuTtgxrTketRrM631cEufVWxZ2QRE27cXFP6TkCaK";
//        String str2="FMCsKrJi2XEaURsFypnNyLPEdAQQ21RWCS4QifQiTBrNVYRdGMd1fcdheZoPN8XJmjVATXyDGQLX3a7efu";
//        String str3="k1Emc73oSqhBsMnQK2UjynAppce2WbEQaJ3XAA9pZoKst4o1KFvrAsb3avk7K1BECKmR1SVKpbqaSUd";
        String str1="2udaaLDuxNmWjrP11aLRQQuyWzsUt72EFjSYzM1nxJurELPRyvg7ByKahBbehGhr64JZnu1XLzfep9sWs9QiVxDbrspYC2rzCuw91ff";
        String str11 = "m8KNoW94S2D9SK8wHVsW8NZ11Y9KcYT2RW1K98Fh5uzJiYQqDgP2dnCMB6J3nmuvw39hqaAgbiGxTDZ";
        String str2="m8KNoW94S2D9SK8wHVsW8NZ11Y9KcYT2RW1K98Fh5uzJiYQqDgP2dnCMB6J3nmuvw39hqaAgbiGxTDZ";
        String str3="2HdqLj186jqLBR5xkSAXCjSuFeiSLJFk5tgbeH39mVDTHer6iCT4iJ2SwbNC4j3K4ooARZ6AnijRMuuEBgYuYYxZRyGujNf7sQD";
        String str4="m8KNoW94S2D9SK8wHVsW8NZ11Y9KcYT2RW1K98Fh5uzJiYQqDgP2dnCMB6J3nmuvw39hqaAgbiGxTDZ";
        String str5="2fzE3mgAo4bbSg2y3WfGaJ1KGTEqwZ8AAQcP5tAqbiwRSJ8QCQnzTc8G3QUjmMTsJ3kc8ZMNVJcRziV6drHKQWJ4";
//        System.out.println(BlowfishUtils.decryptBlowfish(str1));
//        System.out.println(BlowfishUtils.decryptBlowfish(str11));
//        String str1="HEyXLByxmT2ynBp7xDb45FUL7xfvZn2kaYdF594qQNnsQ6W3DsL5HKMvh7vCWSCqq8AZnuwnphsfpgVLMgASsFixAykWnr1qG";
//        String str2="8Pa9dXctSaqfw271hmP3YKJMvBp9vfzxcbbZSwi7eBZr7L59HGpfseGTSajnV4XwyA27qgy5geX2vCUciEVhVnarc";
//        String str3="BxNqdyk5od7zntNVS1zGk4TVMeByJCYAF89Sf6dw6UCL5Ny12dB8gw8gu87fLihb7FNECz9ojsGFGbiUKWEyJqf1YvYzH";

//        System.out.println((long)0.001);

//        String str4="HEyXLByxmT2ynBp7xDb45FUL7xfvZn2kaYdF594qQNnsQ6W3DsL5HKMvh7vCWSCqq8AZnuwnphsfpgVLMgASsFixAykWnr1qG";
//        String str5="zujAjNLjycCcEaz9XHu14rMCd46sZA4X6MAQZp7G6QUTUHNC18juDN2AwodTwpegw3NZmR8JQnGB2xy1wEeUSsy5qK7urEt4Ppe9THVVsJYi1zX4BD9q1vK2NbyR";

//        String [] material_quanyi = {"2Buopro11","2gkgguwepHvYN","2mASwV8hU2jNn","3cTk6BBuRCvDNMkuC","2CYwZioJp","2gkgguwepHvYN","2CVmdptbm","2mEbEvkAt7Wtf","3cZtM4ajY4qW3ZYZA","3cZtM4ajY5pYqkmWw","28wdWoF2S","29Vsgtuik","3XNww2CzKLf1JDsgv","2CUiRwXCh","2gkgguwepHvYN","ouqa","2CVmdptbm","28wdWoF2S","29Vsgtuik","29pYtMChr","2Buopro11","2gkgguwepHvYN","2j4Wu2AY2davW","2mASwV8hU2jNn","3XNww2CzKLf1JDsgv","CdjHAX3B5mKZz1KVq5","HLqJuhGhGiFZgFZZ4DMbD8"};
//        for (String q: material_quanyi) {
//            System.out.println(BlowfishUtils.decryptBlowfish(q));
//        }


        // 均是 【话费】 权益，标签为 2Buopro11
//        String [] huafei_quanyi = {"2Y74VS8YCJB8ojAm5qsEeiM5yfUJZWaPpLvGPnZ5434tcTizzCwoxW13DAYJ7mRgRRHHjQaF7","3H6tBReEH4MWf3urq1N3BCKhS1iihfQ7eaP1Rd8TD1ZfPncyDeMp3DmYcGwMf1w4AJ26WKcJeVtAa","6BviT2Sv8BNFGNv9Av8V65oNQkGvvEQteCdskZC5tkXNJQgv5NYKMqLAqTEFsigP8S1Vg6booZMER4aT5pwzk","FMCsKrJi2XEaURsFypnNyLPEdAQQ21RWCS4QifQiTBrNVYRdGMd1fcdheZoPN8XJmjVATXyDGQLX3a7efu"};
//        for (String hq: huafei_quanyi) {
//            System.out.println(BlowfishUtils.decryptBlowfish(hq));
//        }

        // 均是 【话费券】权益，标签为2mASwV8hU2jNn
//        String [] huafeiquan_quanyi = {"26LBP8CdA5iSvjX85zMZ5iZiHkR4tpycuBXQyRbnmcc3SCox8RJnW8myp4oSpLabkGsjwFbkxXffxUCA53bp","26LBP8CdA5iSvjX85zMZ5iZiHkR4tpycuBXQyRbnmcc3SCox8RJnW8myp4oSv2Txbkk3pdUV8Q93Z1UssQGF","3R8xMr7C1m2XH9YeQrsrVN2QGEZja3RzUPp3ukFoR8C7GmQqTTZJpNNdDAyLrVc5vtfrA6xmA2e5Ke4ha6637NYJF78j","3arjokqijhwK4iMTppotNuNkhkYDcjJR2HnQq4AG68ZRdyGMHVsfEaa2PqUt7mtcRyePzBxNaVibFvJuk21CUjV8wPK1","3asni7k1jBG1EucRYpLG6LDs6rZbKHG7pRTfYmtbrhAPv7U6CuRxG939ZGfvvSbJ49w1XNJqQLYKnWdkNvnD4DggjBWc","k1MLRmXve83vtoWtzcA39dTRfwtsidcMRnBEc3bsGkEPiBSAbouSXYzRGzfrRq6dix5QnDoUumXUq3J"};
//        for (String hfqq: huafeiquan_quanyi) {
//            System.out.println(BlowfishUtils.decryptBlowfish(hfqq));
//        }

        // 全媒体上，货到行业 5.1 ~ 5.12 理论消耗arpu Top5素材标签，解析
//        List<String> huodaoMatList = Arrays.asList("qJCUBuQAHjDZWPE3CpvkqDJ3dXHvfqM7o1zkstVRTUP9r4JDhosSNE39xgYT4DzvBa2hzJCpuakmaD7ArhE5kjHq7m5cpm","ojUgjQcZhzSUdk9eBBm4qDR1VV4fYyknCrjPNU9QoE3vPhHLWaDW32X9qfL8cFm8MGc5BgV6BUhnN2jJLCPdL3dwhRTNZT","Ftx7zztDYa4PLtud6duaE5Zb2ZTmUTp4Wdm8ndzPhtxiJgpBcmVftkJNuVPqQbE22HqXdUZvXh4HGLNCXZ","2fzE3mgAo4bbSg2y3WfGaJ1KGTEqwZ8AAQcP5tAqbiwRSJ8QCQnzTc8G3QUjmMTsJ3kc8ZMNVJcRziV6drHKQWJ4","m8KNoW94S2D9SK8wHVsW8NZ11Y9KcYT2RW1K98Fh5uzJiYQqDgP2dnCMB6J3nmuvw39hqaAgbiGxTDZ");
//        for (String subMat: huodaoMatList) {
//            String subMatDecode = BlowfishUtils.decryptBlowfish(subMat);
//            System.out.println(subMatDecode);
//        }
//        // 会籍卡行业 5.1 ~ 5.12
//        List<String> huijikaMatList = Arrays.asList("VodgF8jKMuhW1bWQCDhe3cYUmw3HS4JaBVmg7hQgbCr15jHbDn7cFp8QjEXtpwVchKXyr23xtBD","26Jx5DVGKMewtkJFwu7MbEURoDEPxKA9RYw6YknnSk4HbrEcE8trhZguRYX9da9Z7WfaGK8gZzSdWtysrmyA","6TL2yDts8sTCgxFKHCsq2T6b5Ei8xtdAZ7jjC3QZx7rvAKRcMHZatPEooYv3LhQ7n9Du7Zw2N9WxnGTo73xurpnjwniDX7pFhC68","4ZJDQh1Q8rSz96tK5VvYjLG2DgmyHjFaZnhBHsKnRz4zhhbhKWAaYjYAeCg2aSjvHHkJ33sSPPVHRweBU9DYNknCFwRPDxJ9","LRsLG64T9kAfFiAnB48qqAiUZ2Qc4yWp7dJGtKYjSs6jwKJXJBXo18BomTVg293uXsXyD2P");
//        for (String subMat: huijikaMatList) {
//            String subMatDecode = BlowfishUtils.decryptBlowfish(subMat);
//            System.out.println(subMatDecode);
//        }
//
//        List<String> videoMatList = Arrays.asList("uunCy9sjpovMq2zZGsobH8AvqiEuYzfybuPA7J4N42A7HzGeJD29AjyUJ4nkKeVZPGju3P7F7JoNXmW6ahmx9ZBmzjC1biYU36QKPX8pBVas7","R5CzT9M7gwveBQr9N8hogkFCHGVBkzbrC66pGPma8iXRr7s3fPp61kMF5Lk8bkFLXTYVr8BAMz1wqXHaKZreoYRgz947R8Yp4PxdF","4MymaESUTMiHchW8qtwTmr893wx5onF6k7keuLsVDkSeah3m7FMwTcuYvzCezen4g8R8Bey1wCTBhmeGt","4kLrNNYGTdYgk8cGpArjGyguxfSRh7NQcDBVuv28ZbGa3YbxM5UGGTr9z1tteGfaWsc8BXka5nJqHrxYMMVALEZ7b8ooXDYK","2hrkUHQ9hLWF9bwSioBLeN6LwaTw1YouAoUU9cXzjnZzeo6oxtA7YmDpNJmT2sGGBN3Kyugue7yJY1X8c98dQtc6");
//        List<String> yunyingshangMatList = Arrays.asList("4Gp3mswhNAf1fa6FsondNNTsstdSb3fkrHJyeP9XZYVu7pR6UHrVfihH1VnBgttqfBbHo411W2UVez3Ka","6Gy3Y8QPhidqsvN6t49dqFw8mJtn2mcDnLGvdvJA88txoohiRkJmigijHqYK8jo8EPBDJStREdQ85PPPU7A7GHx799C4zZyksF2W","2ctsBzJxnzZ41njyowe6YoVtfxv4cuRiN6eaWidrd2doe98i2Y4bNH1eSF3rwqVhJQEnYWZ5FruBaEYExRuVftFL","k1ZZBniHR5xHSCHkRYGF21drLAF8tPbKk8PP8BtuTtgxrTketRrM631cEufVWxZ2QRE27cXFP6TkCaK","JKE3NHHSkx63bCa3gwSdjgkv6bUVqBhVu7X6QkZnbAYnfZdZuwLZurggnqjR6Cxc7swV9tZDW79GzvFEy9YXwaZrGXhgfseB1tpJ1ygHeNnLDPyx");
//        List<String> yinyongfenfaMatList = Arrays.asList("cDVfFf1xAeDVzmFCC4KwHfQYd4PDRSY4GgXQEt5QzEzZuCNUDGF8Y3fUrCTbDihh1QFMPr9ZyBEMC1vpFT4RQopRWu","NJEeBXFRVxwrTRGYY5uUaLiAMYMJR79FSuQMyo6HrtvpUrBTxiDMYMktt1aq69cQnssrwtrhWj5iRRzhSNGAaat4NHMPJqZ7cZNHdMCnAG9B9nDurDorodas4BfcSrkmQdj5hY7b1TVJa9","6HjYkST9R1hSEQnWxusnGecEt1NKmadtjJcLTFBVCc1NXmxn25MmYVMk43upKwswdA3MBYiNDkUgD1NztgECwqm7EiPUPJ8r1GWoFkam4P2vTswGSP5vpPREYRSC4Te97bSdhDE89PyVh","DwwjyDzwhQvKNyqogpJWYQ15KXpJFafoYmjuKe529rAkQBJxkgV1Wmm84t61Y3FHeXF4kkUrd1CY7CFebU34E48gSEDQY6iYLxSG4oJpzKkZ","4yVW3D4GQg3Phqn75dCZjFwsKYSQPCrHRPF8yB1ajboEN7GBgq5CmQxossUWwdJtS6faVLbLdvBaHGuZ1LF99PLABTX2Q8u3");
//        System.out.println("视频行业: Top5素材标签");
//        for (String subMat: videoMatList) {
//            String subMatDecode = BlowfishUtils.decryptBlowfish(subMat);
//            System.out.println(subMatDecode);
//        }
//        System.out.println("运营商行业: Top5素材标签");
//        for (String subMat: yunyingshangMatList) {
//            String subMatDecode = BlowfishUtils.decryptBlowfish(subMat);
//            System.out.println(subMatDecode);
//        }
//        System.out.println("应用分发行业: Top5素材标签");
//        for (String subMat: yinyongfenfaMatList) {
//            String subMatDecode = BlowfishUtils.decryptBlowfish(subMat);
//            System.out.println(subMatDecode);
//        }



//        List<String> ft200112List = Arrays.asList("28wdWoF2S","29pYtMChr","29Vsgtuik","2Buopro11","2CUiRwXCh","2CVmdptbm","2CYwZioJp","2gkgguwepHvYN","2j4Wu2AY2davW","2mASwV8hU2jNn","2mEbEvkAt7Wtf","3cZtM4ajY4qW3ZYZA","3cZtM4ajY5pYqkmWw","3XNww2CzKLf1JDsgv","4nuPPFR5BLu5MgVYXWthm","HLqJuhGhGiFZgFZZ4DMbD8","ouqa");
//        for (String subft200112: ft200112List) {
//            String subMatDecode = BlowfishUtils.decryptBlowfish(subft200112);
//            System.out.println(subMatDecode);
//        }
//        System.out.println("ft200113List:");
//        List<String> ft200113List = Arrays.asList("2S","7AF","V8Tc","7VP","UBti","7AN","7AQ","7NY","7Cp","7NZ","7t9","7c5","7Cq","V7uF","7NW","V8Tb","7Co","7AG","V7uG","V8C4","2V","7Cm","7cA","7c4","V8Xt","7Cn","7c9","7Cz","V82y","UBrc","UBtf","2Z","2P","UC4X","UBzY","7Ck","UBtg","7c8","UBte","7Nb","2T","V8GQ","V8RC","7sy","7da","7Cy","7Cj","V8R9","7c6","7AP","V8KX","7dZ","7dn","7bu","7VJ","7Cr","V7rw","V8KY","V8Xm","7Q6","V7rz","7do","7AJ","V8RA","7dm","7dk","V8GT","UC4Y","UBrU","2W","UBzc","V8R5","7Q7","V7rt","V8Bu","7Q3","UBzQ","7Q4","7Q9","V8Xn","7Q5","7dh","V8Xs","2U","7dj","7QA","7QD","V8GS","7VH","V87X");
//        for (String subft200113: ft200113List) {
//            String subMatDecode = BlowfishUtils.decryptBlowfish(subft200113);
//            System.out.println(subMatDecode);
//        }
//
//        System.out.println("ft200114List:");
//        List<String> ft200114List = Arrays.asList("2i46dKM8yq4WH","4sYn7Y8H8VMsgNdaxs2SG","TYn6iHbejFkUrYgunnWTHo1Gw53r5tEm4LYawJ1ZC","3XNww2CzKLf1JDsgv","3cTk6BBuRCvDNMkuC","2afBazpwDHLmqxr1d","7EFDkRyXGG7paqadiEEw9FG","2XbFFmXm1jW2ze5E1","3GLgWeWq7AkhS6YDKRNCV","3cTk6BBuRCEMmfEPw","4hrdzgfBa8etnwefAZa2U","6njPgVxsBZjowGi6qAJz8Fb3C","4hrdzZWHwTaa9RyBpMUz9","3ZL2Wsrhk4MQgB2uN","D5ZBWUtjFA3yJy92Nid4J8Wgf4ZwQ3XCh","3W1pghjJ9KVcBQTwd","D5ZBWUtjBiBGRqU1QTDGyQXYCpDNXFCYM","n1iUEbdE","3LtUsNF7ESW7tv9gNN8wQ","2r4Qhj7jp1raHMQThJgiMDBjYL64","2K4iPb1C1YQwU2s17gQeh3Hy","6dZaJ3VMong2EGcoWGrKV5t48","4hrdzfr2V4vXxC5Vxe8SD","4hrdzfgJTJeg2iStoAheu","6dZaJ3VMogYYKtW6AnchdyxLi","6drpcCQ1Wso7ofFQJKiHPJSEy6DqmYtzfR9wLS5VrfCe","3gHpENHVLajTDBSbFS","2AfkLe5BnRpcqRhtMn6XQe2cLHqv","7EFDkRyXGG7qbqdQdqe4B1j","cwNVQrj82Ju1DUoZ54AxfTvRa3fwa5","4nuPPFR5BLu5MgVYXWthm","2qzXpKjaA1kDnrXh9ZdfCT5SumXX","99Y3cktjxWmouB4Ypu4AyddAAoyQh","3Vog7LzHxcvYfzivq","JFMgdtWSxSVihdTdz2x6jn","6VXwYXCkfPgytaucn6jrB51QN","Dc4FC3BLrYQu6PkWbG1rJzj6yX5s1tiEu","2jDayS74nMtBK","54JufWeNtTxUBEJcKtsPZ26EDs3AbCcHtur6","DdDH3pbRFtyaLvndaL8PWERWSMm9U7EU7","NcdT9sG7oGCxQHD","EYCKvvP4vFg","9b9cCF4npQFkVH1mNUifNMkcNT7Rh","M565XkqUsYLozJb","9b9cCF4npQFkVH1mNUifNNS6kZVj9","BLmiwuuiXa19QtpcX2ioZv","6VXwYc1oYC4tK9r1vxjy8vha8","4MiZFzoPPUw5mKRonUYNdiK5D");
//        for (String subft200114: ft200114List) {
//            String subMatDecode = BlowfishUtils.decryptBlowfish(subft200114);
//            System.out.println(subMatDecode);
//        }
//
//        System.out.println("ft200115List:");
//        List<String> ft200115List = Arrays.asList("9W7JmDiyXijFeGKbh4ywRPPu1748H","3VuDDhZpYLdVZLKA1","Dc4FC3BLrYQu6PkWbG1rJzj6yX5s1tiEu","99AW5SbDBpBgSdgoxPaFpSppXYMq7","2gjmnqjCUjdvp","9W7JmDiyXijFeGFVDLXS4xKoWsoyV","Jtnh2yfbQD2NRCmghnQjfCzZDQnudTy1yGTbF","4hpd3zJgVmBDsH2ZCabvV","2i46dKM8yq4WH","99Ew7PzSWjaQZLtRQESPeaQ3rK3oK","7EFDkRyXGG7paqadiEEw9FG","3ZRefz8PT1iZKBZgw","2m5EfkxUiJU6X","mVYf","997oa4hJDawoJHAr24bBiRMDbopd5","6dZaJ3VMong2EGcoWGrKV5t48","6jcMfXgd4FxRWpsa4ebF9sGsL","DBreVeh9EKQCXuR3HoGuo54PQv9pgQaPy","4hpd3zJgVjiAQ9DJjRhRz","6d6PqxVkih1Rg8RK9qCcZAHWK","6d6PqxVkigtoRAUweRMojgGpZ","7EFDkRyXGG7qbqdQdqe4B1j","6Ybm2nEKU7v3sQhvZE8CmnS1Y","DBreUr473PB2GfFK7qEDXCBcxzUBH4VW6","6dEQGxg2a2rpy2eeQykHCmrY2","99AW5SbDBm1bgcG68a4V6wvJN4ZZB","9WtUToQHdLeNFPL7viNxi56BZkhFr","4hpd3zJgVjieX85438CCW","54JufWeNtTtNHBUGSabc8g9KqUtW8L4GACbv","4shsdd6cd7PcK8zMb9Cfc","HjqPMjpfto4CLUrzQjmmzZ","9WHFtAhsGrv9DQbdncv3Dr66woGUT","3cP557gwE7hEB2oDG","DNhYscJDA1tp2f8S9HP2wjGre5GE5L2bc","KKb9kvM3nyUcjW5v9gWKFvuFRTYHm71qGNqEz","DBuci5U9w5yWN4N6weJG6Uy72Ps6X7qCb","4jktgf55zqS5aHPAbTDGT","6k8phBxGJxgpNdMPw1QSvqNVM","9DnZKNAeFAUPbiNAe8f1jhvxLsRBL","99AW5SbDBpEZ9fw8hynXRxYqcag5Y","MUJPTBJUTz7bGuGxyEPaeqBEcfeQYwmeS8HVKkZGLkaJvjdFXEsC","4hpd3zJgVmBDsFmze1EmB","9SKPCaQ3xvd9","6VUxB2HV6ZpqvBaQDtqBwCV4X","TXZu2hnbf1E643R7hJyqqewHYvQn91xoNS5JGebJL","6VUxB2HV6VoZXRUNAVqU1VM1G","2gjmnqjCUkJdQ","4sMKk5tVpnufdVkMqa9tb","3LtUsNF7ESW7tv9gNN8wQ","D51F1XAY4rPZGrUg9FFiXt4w93Wo587ig","4shsdd6cd8jffZ55GTYcT","DEW45o44enRQ7TNf1T479LtrDRvtMUWAd","6jcMfXgd4FxRWzSLaq6GdpoDA","2geVUrhHFNj5n","KKPUv8b7s1zWwWBixHTWLAdNHCgSB5mRtT9XR","6d5xjyHC8Ai35gRnBUXgwArtT","KKb9kvM3nyUcjW5v9gWKFvuFRTYHm7suM5eHY","4hrdzhLbh79vqYFVnPsgh","DMr1KgLEeoTywNsqtBnYeK4ZvChy19uqL");
//        for (String subft200115: ft200115List) {
//            String subMatDecode = BlowfishUtils.decryptBlowfish(subft200115);
//            System.out.println(subMatDecode);
//        }
//
//        System.out.println("ft200116List:");
//        List<String> ft200116List = Arrays.asList("mVYf","69g2FqDRSbGtvSW3zcJP2L3BvU3HW","9LSw2Ccguz3gsPu5piAES2iTyiW6V","n1iUEbdE","hJkoTkda","7EFDkRyXGG7paqadiEEw9FG","2XbFFmXm1jW2ze5E1","3LtUsNF7ESW7tv9gNN8wQ","M565XkqUsYLozJb","2hwCK9im2Mwck7Q9M","4k1F4kmGy6UXeL8tWN5wk","3cLkWLEX4YWUPZ17b","4nxNNvChz3jQtp2ANhgDx","7EFDkRyXGG7qbqdQdqe4B1j","28wdWoF2S","xCvDjA7cerAv2TrCp","A8dLmFG","2K4iPb1C1YQwU2s17gQeh3Hy","6drpcCQ1Wso7ofFQJKiHPJSEy6DqmYtzfR9wLS5VrfCe","9LYHdtCKJk8QaRFXiuur34S7aAfux","HjqPMjpfto4CLUrzQjmmzZ","F1RJ63EtdTh","3ZN3emRNgzL54Mcn5","xCvDjA7cerAxhJ6yw","3AgmSX","22kq1eBcQrAFo","2gpRwXNpug4RL","9SKPCaQ3xvd9","2hfw7RM4gmEbK","5AFYtmhnJn9xeD4sxMEgRHUx5gBVabFzZDcd4urBiZBjPptyufEPaaW","2AeKNtBWDpPqvASJkMek96aEGzVC","NcdT9sG7oGCxQHD","M5659WMEhm15HkC","6jhDvwtxiqEcppXzuRXuseYT7","DcEwbS3LuEwaQn9k6AuvCrQzEZHE8B1Gs","ihiFvr8j","4kTD7CFzfkTk1vPmtUm7GnmdK","3GLgWeWq7AmV8Xf9MaW3Y");
//        for (String subft200116: ft200116List) {
//            String subMatDecode = BlowfishUtils.decryptBlowfish(subft200116);
//            System.out.println(subMatDecode);
//        }
//
//        System.out.println("ft200117List:");
//        List<String> ft200117List = Arrays.asList("mVYf","BJPxdbGM3XjFmYjLGDrj56","FtRdDAUCs14UU2SA9APn7rkiJH","9LSw2Ccguz3gsPu5piAES2iTyiW6V","2hwCK9im2Mwck7Q9M","3GLgWeWq7AkhS6YDKRNCV","B3PpXwBXNsEUAzW8KyjwEX","2afBazpwDHLmqxr1d","7EFDkRyXGG7paqadiEEw9FG","7wxGXoJiixSiEtHBuz","7mqM1KsMEWfgNXi4Ko","3cLkWLEX4YWUPZ17b","4nxNNvChz3jQtp2ANhgDx","7EFDkRyXGG7qbqdQdqe4B1j","28wdWoF2S","B3PpXwBaeQVpcX8jzDXeHy","P54pawK1vht2vaQjYbD2icFVB4BwTa","A8dLmFG","ZikpDxPfdMfkcbUcCkiQhVyc7askNUEEUm","ZikpDxPYkKA6man4cpZVddjLyMtMTJkdMM","HjqPMjpfto4CLUrzQjmmzZ","2AfkLe5BnRpcqRhtMn6XQe2cLHqv","3ZN3emRNgzL54Mcn5","xCvDjA7cerAxhJ6yw","4hzrppHdByGC5ZioKtXAa","99Y3cktjxWmouB4Ypu4AyddAAoyQh","9SKPCaQ3xvd9","2hfw7RM4gmEbK","GX5aqTUWUT3XfzsTAsnSzzL8JK","9FXDrhQJaeFba2FtgrP4mxrFdf8uD","FtRdDAUCs14UU2R8KtCnP9eL4n","3LtUsNF7ESW7tv9gNN8wQ","BLmiwuuiXa19QtpcX2ioZv","4khXHHZktKSCn8gprEPTd");
//        for (String subft200117: ft200117List) {
//            String subMatDecode = BlowfishUtils.decryptBlowfish(subft200117);
//            System.out.println(subMatDecode);
//        }



//        String materialAllCatg = "KuiWHMWPLwSAMyhFyKCmg5TiPqMHdbg2mvCgkTLWeZtRJ5rEKkk7z4H4yHvRvhpb3fNHveFWGBFsBaDx15Y2bELs166bzqGHwcetnAFBkxU3s54kTGc4mKp5hWdiExfdZN8Y4paekdPrC87Em2huSeaRJNTZ9kW2v9Ei4Bt8TMjWKrm8X9aPexz";
//        String materialCatg = "5752fnAf9FKGWCx4yS9UC3u17jzqzwXnsX2qW9ctxawe61TeUxXEo4m4wzv5byUDMoQtYjpZce1Dyib8iJ6a9FwAadDw";
//
//        System.out.println(BlowfishUtils.decryptBlowfish(materialAllCatg));
//        System.out.println(BlowfishUtils.decryptBlowfish(materialCatg));
//        String materialCatg2 = "3K3iKSquqCa7FM9WSKpeupMMwc4ktJWT4LZgcBxrhVkgcHjifkG84bJhc8";
//        String materialAllCatg2 = "zvyXrVWxydCzDQRRYHqyrPifVXXtbfu4w5RYc6sNXvMHYnzXEiRmGVNJyqBSfXfj8Re4c64ASzpUamt4HBsi4oDxq4TWgsCavdgPBk47t1kpuu297VN8BRmrZoXZ";
//
//        System.out.println(BlowfishUtils.decryptBlowfish(materialAllCatg2));
//        System.out.println(BlowfishUtils.decryptBlowfish(materialCatg2));



        List<String> ft200118List = Arrays.asList("3ZZJqnXYr7yvezYkx","3cZtvqSKTc7Uncppo","2Bvesp1WZ","4oBL1sdS1WrvPFbgRVibE","2i4gHjMbJq8mk","2mD1jmLiZ2Jfx","2BxbmT6vz","29pDLXh5V");
        for (String subft200118: ft200118List) {
            String subMatDecode = BlowfishUtils.decryptBlowfish(subft200118);
            System.out.println(subMatDecode);
        }

        List<String> ft200119List = Arrays.asList("29WzifjAv","2AV8SFfVY","2hbY9xP5baAHR","2j4WvtaTLg42v");
        for (String subft200119: ft200119List) {
            String subMatDecode = BlowfishUtils.decryptBlowfish(subft200119);
            System.out.println(subMatDecode);
        }

    }

}

