package cn.com.duiba.nezha.alg.common.util;

import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;

import java.time.*;
import java.time.format.DateTimeFormatter;
import java.util.*;

@Slf4j
public class LocalDateUtil {

    public static Map<String, DateTimeFormatter> map = new HashMap<>();

    public static void main(String[] args) {

        LocalDateTime localDateTime1 = getLocalDateTime("2019-02-19 11:01:10", DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
        LocalDateTime localDateTime2 = getLocalDateTime("2019-02-22 10:54:41", DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());

        System.out.println("localDateTime=" + localDateTime1.getDayOfWeek().getValue());
        System.out.println("wn=" + DateUtil.getWeekNumber("2019-02-19 11:01:10", DateStyle.YYYY_MM_DD_HH_MM_SS));
        System.out.println("localDateTime.between=" + getBetweenDuration(localDateTime1, localDateTime2).toHours());


        LocalDate localDate1 = getLocalDate("2018-09-05", DateStyle.YYYY_MM_DD.getValue());
        LocalDate localDate2 = getLocalDate("2018-09-03", DateStyle.YYYY_MM_DD.getValue());

        System.out.println("localDate=" + localDate1);
        System.out.println("localDate.between=" + getBetweenDays(localDate1, localDate2));


        LocalTime localTime1 = getLocalTime("13:02:10", DateStyle.HH_MM_SS.getValue());
        LocalTime localTime2 = getLocalTime("12:02:10", DateStyle.HH_MM_SS.getValue());
        System.out.println("localTime=" + localTime1);
        System.out.println("localTime.between=" + getBetweenSeconds(localTime1, localTime2));


        Long millis = getTimeMillis("2019-02-22 10:54:41", DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
        System.out.println("millis=" + millis);

        Date date = DateUtil.getDate("2019-02-22 10:54:41", DateStyle.YYYY_MM_DD_HH_MM_SS);
        Date otherDate = DateUtil.getDate("2019-02-23 10:54:40", DateStyle.YYYY_MM_DD_HH_MM_SS);
        Long dayBetween = getIntervalDays(date, null);
        System.out.println("dayBetween=" + dayBetween);


    }

    public static int getCurrentDate(DateStyle dateStyle) {
        LocalDateTime localDate = LocalDateTime.now();
        return localDate.getHour();
    }


    /**
     * @param date      日期
     * @param otherDate 另一个日期
     * @return 相差天数
     */
    public static Long getIntervalDays(Date date, Date otherDate) {

        Long ret = null;
        if (date == null || otherDate == null) {
            return null;
        }

        LocalDateTime dateLocal = dateToLocal(date);
        LocalDateTime otherDateLocal = dateToLocal(otherDate);
        Duration duration = getBetweenDuration(dateLocal, otherDateLocal);
        if (duration != null) {
            ret = duration.toDays();
        }
        return ret;
    }


    public static LocalDateTime dateToLocal(Date date) {
        LocalDateTime localDate = null;
        if (date != null) {
            Instant instant = date.toInstant();
            ZoneId zoneId = ZoneId.systemDefault();
            localDate = instant.atZone(zoneId).toLocalDateTime();
        }

        return localDate;
    }


    /**
     * 获取时间
     *
     * @param time
     * @param parttern
     * @return
     */
    public static Long getTimeMillis(String time, String parttern) {

        Long ret = null;
        if (parttern != null) {
            LocalDateTime localDateTime = getLocalDateTime(time, parttern);
            ret = getTimeMillis(localDateTime);
        }
        return ret;
    }


    public static Long getTimeMillis(LocalDateTime localDateTime) {

        Long ret = null;

        if (localDateTime != null) {
            ret = localDateTime.toInstant(ZoneOffset.of("+8")).toEpochMilli();
        }

        return ret;
    }


    /**
     * 获取时间
     *
     * @param time
     * @param parttern
     * @return
     */
    public static Integer getHour(String time, String parttern) {

        Integer ret = null;
        if (parttern != null) {
            LocalDateTime localDateTime = getLocalDateTime(time, parttern);
            ret = getHour(localDateTime);
        }
        return ret;
    }

    /**
     * 获取时间
     *
     * @param time
     * @param parttern
     * @return
     */
    public static Integer getMinute(String time, String parttern) {

        Integer ret = null;
        if (parttern != null) {
            LocalDateTime localDateTime = getLocalDateTime(time, parttern);
            ret = getMinute(localDateTime);
        }
        return ret;
    }

    /**
     * 获取时间
     *
     * @param time
     * @param parttern
     * @return
     */
    public static Integer getDayOfWeek(String time, String parttern) {

        Integer ret = null;
        if (parttern != null) {
            LocalDateTime localDateTime = getLocalDateTime(time, parttern);
            ret = getDayOfWeek(localDateTime);
        }
        return ret;
    }

    private static Integer getDayOfMonth(String time, String pattern) {
        Integer ret = null;
        if (pattern != null) {
            LocalDateTime localDateTime = getLocalDateTime(time, pattern);
            ret = localDateTime.getDayOfMonth();
        }
        return ret;
    }

    public static Integer getDayOfMonthSafely(String time, String pattern) {
        try {
            return getDayOfMonth(time, pattern);
        } catch (Exception e) {
            log.info("exception when get day of month ", e);
            return null;
        }
    }

    public static Integer getMinute(LocalDateTime localDateTime) {

        Integer ret = null;

        if (localDateTime != null) {
            ret = localDateTime.getMinute();
        }

        return ret;
    }

    public static Integer getHour(LocalDateTime localDateTime) {

        Integer ret = null;

        if (localDateTime != null) {
            ret = localDateTime.getHour();
        }

        return ret;
    }

    public static Integer getDayOfWeek(LocalDateTime localDateTime) {

        Integer ret = null;

        if (localDateTime != null) {
            ret = localDateTime.getDayOfWeek().getValue();
        }
        return ret;
    }

    /**
     * 获取两个日期相差的天数
     *
     * @param date      日期字符串
     * @param otherDate 另一个日期字符串
     * @return 相差小时数 date -otherDate
     */
    public static Long getIntervalMinutes(String date, String otherDate, DateStyle dateStyle, DateStyle otherDateStyle) {

        Long ret = null;
        try {
            LocalDateTime localDateTime1 = getLocalDateTime(date, dateStyle.getValue());
            LocalDateTime localDateTime2 = getLocalDateTime(otherDate, otherDateStyle.getValue());


            if (localDateTime1 != null && localDateTime2 != null) {
                ret = getBetweenDuration(localDateTime2, localDateTime1).toMinutes();
            }

        } catch (Exception e) {

        }

        return ret;
    }

    /**
     * 获取日期与当前时间差，单位：分钟
     * <p>
     * now -date1
     *
     * @param date1 日期字符串
     * @return 相差小时数 date -otherDate
     */
    public static Long getIntervalMinutes(String date1, DateStyle dateStyle) {

        Long ret = null;
        try {
            LocalDateTime localDateTime1 = LocalDateTime.now();
            LocalDateTime localDateTime2 = getLocalDateTime(date1, dateStyle.getValue());


            if (localDateTime1 != null && localDateTime2 != null) {
                ret = getBetweenDuration(localDateTime2, localDateTime1).toMinutes();
            }

        } catch (Exception e) {

        }

        return ret;
    }


    /**
     * 获取日期与当前时间差，单位：分钟
     * <p>
     * now -date1
     *
     * @param date1 日期字符串
     * @return 相差小时数 date -otherDate
     */
    public static Long getIntervalDays(String date1, DateStyle dateStyle) {

        Long ret = null;
        try {
            LocalDate localDate1 = LocalDate.now();
            LocalDate localDate2 = getLocalDate(date1, dateStyle.getValue());


            if (localDate1 != null && localDate2 != null) {
                ret = getBetweenDays(localDate2, localDate1);
            }

        } catch (Exception e) {

        }

        return ret;
    }


    public static String getCurrentLocalDateTime(DateStyle dateStyle) {

        String ret = null;
        if (dateStyle != null) {
            ret = getCurrentLocalDateTime(dateStyle.getValue());
        }
        return ret;
    }

    public static String getCurrentLocalDateTime(String parttern) {
        String ret = null;
        if (parttern != null) {
            ret = LocalDateTime.now().format(DateTimeFormatter.ofPattern(parttern));
        }
        return ret;
    }


//    public static DateTimeFormatter getDateTimeFormatter(String parttern) {
//        DateTimeFormatter ret = null;
//        if (parttern != null) {
//            map.putIfAbsent(parttern, DateTimeFormatter.ofPattern(parttern));
//        }
//        ret = map.get(parttern);
//        return ret;
//    }


    public static java.time.Duration getBetweenDuration(LocalDateTime start, LocalDateTime end) {
        java.time.Duration ret = null;
        if (start != null && end != null) {
            ret = java.time.Duration.between(start, end);
        }
        return ret;
    }

    public static Long getBetweenDays(LocalDate start, LocalDate end) {
        Long ret = null;
        if (start != null && end != null) {
            ret = end.toEpochDay() - start.toEpochDay();
        }
        return ret;
    }

    public static Long getBetweenSeconds(LocalTime start, LocalTime end) {
        Long ret = null;
        if (start != null && end != null) {
            ret = end.toSecondOfDay() - start.toSecondOfDay() + 0L;
        }
        return ret;
    }


    public static LocalDate getLocalDate(String timeString, String parttern) {
        LocalDate ret = null;
        if (timeString != null && parttern != null) {
            ret = LocalDate.parse(timeString, DateTimeFormatter.ofPattern(parttern));

        }

        return ret;
    }

    public static LocalTime getLocalTime(String timeString, String parttern) {
        LocalTime ret = null;
        if (timeString != null && parttern != null) {
            ret = LocalTime.parse(timeString, DateTimeFormatter.ofPattern(parttern));

        }

        return ret;
    }

    public static LocalDateTime getLocalDateTime(String timeString, String parttern) {
        LocalDateTime ret = null;
        if (timeString != null && parttern != null) {
            ret = LocalDateTime.parse(timeString, DateTimeFormatter.ofPattern(parttern));

        }


        return ret;
    }


    /**
     * 增加日期的天数。失败返回null。
     *
     * @param date      日期字符串
     * @param dayAmount 增加数量。可为负数
     * @return 增加天数后的日期字符串
     */
    public static String addDay(String date, int dayAmount, DateStyle dateStyle) {


        LocalDate localDate1 = getLocalDate(date, dateStyle.getValue());

        LocalDate localDate2 = localDate1.plusDays(dayAmount);

        return localDate2.format(DateTimeFormatter.ofPattern(dateStyle.getValue()));
    }


    /**
     * 增加日期的天数。失败返回null。
     *
     * @param dayAmount 增加数量。可为负数
     * @return 增加天数后的日期字符串
     */
    public static String addDay(int dayAmount, DateStyle dateStyle) {


        LocalDate localDate1 = LocalDate.now();

        LocalDate localDate2 = localDate1.plusDays(dayAmount);

        return localDate2.format(DateTimeFormatter.ofPattern(dateStyle.getValue()));
    }

}
