package cn.com.duiba.nezha.alg.common.model.slotmaterialselect;

import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;

/**
 * Created by Administrator on 2019/2/18.
 */
public class SlotMaterialSelect {

    private static final Logger logger = LoggerFactory.getLogger(SlotMaterialSelect.class);

    ArrayList<Double> rewards = new ArrayList<>();
    ArrayList<Double> counts = new ArrayList<>();
    ArrayList<Double> alphas = new ArrayList<>();
    ArrayList<Double> betas = new ArrayList<>();



    static class Constant {
        static double MIN_REWARD = 0.1;
        static long DISCOUNT = 2;
        static int MAX_HIS_VAL = 10000;
        static double DECAY = 0.99;  //100次以前的观察，无效
        static int SEARANK_TOPN = 30;
    }



    private double getCtr(double exposure,double click)
    {
        return exposure > 0 ? click / exposure : 0;
    }

    public static double normlize(double val, double max, double limit) {
        double norm = Math.min(val * limit / max, limit);
        return norm;
    }

    public static Comparator<MatchInfo> iComparator = new Comparator<MatchInfo>() {

        @Override
        public int compare(MatchInfo c1, MatchInfo c2) {
            return (int) (c2.matchScore - c1.matchScore >= 0 ? 1 : -1); //按score大小排序
        }
    };

    //match  海选 1500--30

    /**
     *
     * @param materialList
     * @param prob  新活动试投概率 初版设为万分之一 0.0001
     * @param exposureThreshold  新活动试投曝光阈值 ，初版设为100
     * @return
     */
    public  List<MatchInfo> matchMaterial(List<SlotMaterialInfo> materialList,double prob,long exposureThreshold) {

        if (materialList.size()==0){
            System.out.println("materialList is null !" );
            return null;
        }

        Queue<MatchInfo> candis = new PriorityQueue<>(materialList.size(), iComparator);
        Queue<MatchInfo> slotCandis = new PriorityQueue<>(materialList.size(), iComparator);
        Queue<MatchInfo> appCandis = new PriorityQueue<>(materialList.size(), iComparator);
        Queue<MatchInfo> globalCandis = new PriorityQueue<>(materialList.size(), iComparator);

        List<MatchInfo> result = new ArrayList<MatchInfo>();

        //1、init
        int topn = Constant.SEARANK_TOPN;
        HashSet<Long> idset = new HashSet();  //topn——id
        int limitTopn = topn;  //提前

        HashMap<Long,MatchInfo> mMap = new HashMap();
        double maxG = 0.01, maxH = 0.01;

        //2、info
        for (SlotMaterialInfo m : materialList) {
            try {

                double slotClick = m.getClickCnt().getSlotVal();
                double appClick = m.getClickCnt().getAppVal();
                double globalClick = m.getClickCnt().getGlobalVal();

                double slotExposure = m.getExposureCnt().getSlotVal();
                double appExposure = m.getExposureCnt().getAppVal();
                double globalExposure = m.getExposureCnt().getGlobalVal();

                double slotCtr = getCtr(slotExposure, slotClick);
                double appCtr = getCtr(appExposure, appClick);
                double globalCtr = getCtr(globalExposure, globalClick);

                MatchInfo info = mMap.containsKey(m.materialId) ? mMap.get(m.materialId) : new MatchInfo();
                info.setMaterailId(m.materialId);
                info.setSlotCtr(slotCtr);
                info.setAppCtr(appCtr);
                info.setGlobalCtr(globalCtr);
                info.setSlotExposure(slotExposure);
                info.setAppExposure(appExposure);
                info.setGlobalExposure(globalExposure);


                //新素材试投

                if (globalExposure < exposureThreshold) {    //全局素材曝光数小于100
                    //continue;
                    if(System.currentTimeMillis() -m.getCreateTime() < 60 * 1000 * 60 * 24 * 3) //上架时间小于三天
                    {
                        if (Math.random() < prob) { //小于0.0001进行试投
                            result.add(info);
                            topn--; //占用一个名额
                            idset.add(info.materailId) ;
                            //System.out.println("try put new material= "+ info.materailId);
                        }
                    }
                    else if (materialList.size() > limitTopn) { //为什么
                        if (Math.random() < 0.1 * prob) {  //小于0.00001进行试投
                            result.add(info);
                            topn--;//占用一个名额
                            idset.add(info.materailId) ;
                            //System.out.println("try put new material way2= "+ info.materailId);
                        }
                    }

                }



                //计算matchscore
                double slotScore = WilsonInterval.wilsonCalc((long) slotClick, (long) slotExposure * 3).lowerBound;
                double globalScore = WilsonInterval.wilsonCalc((long) globalClick, (long) globalExposure * 3).lowerBound;
                double appScore = WilsonInterval.wilsonCalc((long) appClick, (long) appExposure * 3).lowerBound;
                //为什么乘以3
                double coef = 0, matchscore = 0;

                double sconfidence = Math.min(slotExposure / 100, 1);
                double aconfidence = Math.min(appExposure / 100, 1);
                double gconfidence = Math.min(globalExposure / 1000, 1);

                matchscore = sconfidence * slotScore
                        + (1 - sconfidence) * aconfidence * appScore * 0.9
                        + (1 - sconfidence - (1 - sconfidence) * aconfidence) * globalScore * Math.max(0.5, gconfidence);


                info.setMatchScore(matchscore);

                candis.add(info);
                mMap.put(m.materialId, info);

                //System.out.println("materialId= " + m.materialId);
                //System.out.println("slotScore= "+ slotScore + "  globalScore= "+globalScore + "  appScore= " +appScore);
                //System.out.println("sconfidence= " + sconfidence + "  aconfidence= " + aconfidence + "  gconfidence= " + gconfidence);
                //System.out.println("matchscore0= "+ matchscore);


                if (aconfidence > 0.99 || appClick > 10) { //app请求数大于99 或点击大于5  //bug 应该是appVal>5
                    double matchScore2 = appExposure > 0 ? appClick / appExposure : 0.0;

                    MatchInfo info2= new MatchInfo();

                    info2.setMaterailId(m.materialId);
                    info2.setSlotCtr(slotCtr);
                    info2.setAppCtr(appCtr);
                    info2.setGlobalCtr(globalCtr);
                    info2.setSlotExposure(slotExposure);
                    info2.setAppExposure(appExposure);
                    info2.setGlobalExposure(globalExposure);

                    info2.setMatchScore(matchScore2);
                    appCandis.add(info2);
                    //System.out.println("matchscore2= " + info2.matchScore);
                }


                if (sconfidence > 0.99 || slotClick > 10) { //广告位请求数大于99 或点击大于5
                    double matchScore3 = slotExposure > 0 ? slotClick / slotExposure : 0.0;

                    MatchInfo info3=new MatchInfo();

                    info3.setMaterailId(m.materialId);
                    info3.setSlotCtr(slotCtr);
                    info3.setAppCtr(appCtr);
                    info3.setGlobalCtr(globalCtr);
                    info3.setSlotExposure(slotExposure);
                    info3.setAppExposure(appExposure);
                    info3.setGlobalExposure(globalExposure);

                    info3.setMatchScore(matchScore3);
                    slotCandis.add(info3);
                   // System.out.println("matchscore3= " + info3.matchScore);
                }

               // System.out.println("matchscore4= " + info.matchScore);



            } catch (Exception e)
            {
               logger.error("error,materialId: m.materialId= " +m.materialId);
                logger.error(e.getMessage(), e);
//                System.out.println(e.getMessage());
            }
        }

        //取前topn
        int slotCandiSize = slotCandis.size();
        for (int i = 0; i < 10 && i < slotCandiSize; i++) {
            MatchInfo infoSlot =  slotCandis.poll();
            //System.out.println("try  materialId= "+ infoSlot.materailId + " matchScore= " +infoSlot.matchScore
            //  + " slotExposure= " + infoSlot.slotExposure +" slotCtr= "+ infoSlot.slotCtr);

            if(idset.contains(infoSlot.materailId))
                continue;
            result.add(infoSlot);   //未判断去重 可能重复
            idset.add(infoSlot.materailId);
            topn-- ;
            if(result.size()>=limitTopn)
                break;

        }

        int candiSize = candis.size();
        int resultSize=result.size() ;

        for (int i = 0; resultSize < limitTopn && i < candiSize; i++) {
            MatchInfo candisInfo =  candis.poll();
            if(idset.contains(candisInfo.materailId))
                continue;
            result.add(candisInfo);

            //System.out.println("materailId= " + candisInfo.materailId + " score= " + candisInfo.matchScore);

            idset.add(candisInfo.materailId);   //凑齐topn个活动
            resultSize = result.size() ;
            topn-- ;
        }

        return result;
    }


   //优选 30--1
    public  SlotMaterialModel selectMaterial(List<MatchInfo> matchInfoList,
                                                  List<SlotMaterialModel>  materialModelList) {


        //1、两个列表为空，或者长度不一致,或者顺序不一致，报错,返回空值
        if (matchInfoList.size() == 0 || materialModelList.size() == 0) {
            System.out.println("matchInfoList or materialModelList is null !");
            return null;
        }

        if (matchInfoList.size() != materialModelList.size()) {
            System.out.println("matchInfoList and materialModelList are not same size !");
            return null;
        }

        for (int i = 0; i < matchInfoList.size(); i++) {
            long intoMaterialId = matchInfoList.get(i).getMaterailId();
            long modelMaterailId = materialModelList.get(i).getMaterialId();
            if (intoMaterialId != modelMaterailId) {
                System.out.println("matchInfoList and materialModelList not put materialId in same order !");
                return null;
            }
        }

        //1、init
        clear();
        double decay = Constant.DECAY;
        //HashMap<Long,Info> mMap = new HashMap();
        double maxG = 0.01, maxH = 0.01;

        ArrayList<Double> rewards = new ArrayList<>();
        ArrayList<Double> counts = new ArrayList<>();
        ArrayList<Double> alphas = new ArrayList<>();
        ArrayList<Double> betas = new ArrayList<>();

        List<SlotMaterialModel> modeCopyList = materialModelList;

        SlotMaterialModel result = null;

        //2、info
        //计算回报
        List<MatchInfo> candiList = new ArrayList<>();
        double maxSlot = Constant.MIN_REWARD, maxApp = Constant.MIN_REWARD, maxGlobal = Constant.MIN_REWARD;

        try {
            for (int i = 0; i < matchInfoList.size(); i++) {
                MatchInfo info = matchInfoList.get(i);
                SlotMaterialModel model = materialModelList.get(i);
                SlotMaterialModel modelCopy = modeCopyList.get(i);

                if (info.getGlobalExposure() > 0) {
                    double reward = Constant.MIN_REWARD;
                    double slotConfidence = Math.min(info.getSlotExposure() / 100, 1);
                    double appConfidence = Math.min(info.getAppExposure() / 100, 1);
                    double globalConfidence = Math.min(info.getGlobalExposure() / 1000, 1);

                    reward = slotConfidence * normlize(info.getSlotCtr(), maxSlot, 0.8)
                            + (1 - slotConfidence) * appConfidence * normlize(info.getAppCtr(), maxApp, 0.7)
                            + (1 - slotConfidence - (1 - slotConfidence) * appConfidence) * globalConfidence * normlize(info.getGlobalCtr(), maxGlobal, 0.5);

                    System.out.println(info.getMaterailId() + ": reward= " + reward);
                    // if(Math.random() < 0.0001) {
                    //   logger.info("SlotMaterialSelect materiallist:{} materialId:{} appid:{} clk:{} hctr:{} maxh:{} reward:{} gctr:{} maxg:{}");
                    //}
                    reward = reward * reward;
                    reward = Math.max(reward, Constant.MIN_REWARD);

                    modeCopyList.get(i).reward = modeCopyList.get(i).reward * decay + reward;
                    modeCopyList.get(i).count = modeCopyList.get(i).count * decay + 1.0;
                    modeCopyList.get(i).alpha = 1.5 + modeCopyList.get(i).reward;
                    modeCopyList.get(i).beta = 2.0 + (modeCopyList.get(i).count - modeCopyList.get(i).reward);

                    rewards.add(modeCopyList.get(i).reward);
                    counts.add(modeCopyList.get(i).count);
                    alphas.add(modeCopyList.get(i).alpha);
                    betas.add(modeCopyList.get(i).beta);
                } else {
                }
            }

            // 3 select one

            int numMachines = matchInfoList.size();
            int selectMachineId = selectMachine(alphas, betas, numMachines);

            result = modeCopyList.get(selectMachineId);

            return result;
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            logger.error("error, size:{},candi:{},list:{},", matchInfoList.size(), JSON.toJSONString(candiList), JSON.toJSONString(result));
        }
        return null;
    }



    private void clear()
    {
        rewards = new ArrayList<Double>();
        counts = new ArrayList<Double>();
        alphas = new ArrayList<Double>();
        betas = new ArrayList<Double>();
    }

    private int selectMachine(List<Double> alphas, List<Double> betas,int numMachines) {
        int selectMachine = 0;
        double maxTheta = 0;
        for (int i = 0; i < numMachines; i++) {
            double theta = BetaDistribution.BetaDist(alphas.get(i), betas.get(i));
            System.out.println("theta= "+ theta);
            if (theta > maxTheta) {
                maxTheta = theta;
                selectMachine = i;
            }
        }
        return selectMachine;
    }

}
