package cn.com.duiba.nezha.alg.common.model.materialrecommend;

/**
 * @author lijingzhe
 * @description 海选实体类
 * @date 2019/12/12
 */
public class MaterialMatchInfo {
    /**
     * 素材ID
     */
    long materialId;
    /**
     * 素材标签
     */
    int materialTag;
    /**
     * 媒体ID
     */
    long appId;
    /**
     * 广告位ID
     */
    long slotId;
    /**
     * 是否优质素材
     */
    boolean isExcellent = false;
    /**
     * 素材曝光次数
     */
    MaterialVal exposureCnt;
    /**
     * 素材点击次数
     */
    MaterialVal clickCnt;
    /**
     * 消耗
     */
    MaterialVal cost;
    /**
     * 广告位、媒体和全局维度融合后置信ctr
     */
    double matchScore;
    /**
     * 去除广告位偏差归一化ctr
     */
    double nCtr;
    /**
     * 去除广告位偏差归一化每pv消耗
     */
    double nPvCost;
    /**
     * 归一化分
     */
    double score;
    /**
     * 广告位ctr
     */
    double ctr;
    /**
     * 广告位每pv消耗
     */
    double uc;


    public long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(long materialId) {
        this.materialId = materialId;
    }

    public int getMaterialTag() {
        return materialTag;
    }

    public void setMaterialTag(int materialTag) {
        this.materialTag = materialTag;
    }

    public long getAppId() {
        return appId;
    }

    public void setAppId(long appId) {
        this.appId = appId;
    }

    public long getSlotId() {
        return slotId;
    }

    public void setSlotId(long slotId) {
        this.slotId = slotId;
    }

    public boolean isExcellent() {
        return isExcellent;
    }

    public void setExcellent(boolean excellent) {
        isExcellent = excellent;
    }

    public MaterialVal getExposureCnt() {
        return exposureCnt;
    }

    public void setExposureCnt(MaterialVal exposureCnt) {
        this.exposureCnt = exposureCnt;
    }

    public MaterialVal getClickCnt() {
        return clickCnt;
    }

    public void setClickCnt(MaterialVal clickCnt) {
        this.clickCnt = clickCnt;
    }

    public MaterialVal getCost() {
        return cost;
    }

    public void setCost(MaterialVal cost) {
        this.cost = cost;
    }

    public double getMatchScore() {
        return matchScore;
    }

    public void setMatchScore(double matchScore) {
        this.matchScore = matchScore;
    }

    public double getnCtr() {
        return nCtr;
    }

    public void setnCtr(double nCtr) {
        this.nCtr = nCtr;
    }

    public double getnPvCost() {
        return nPvCost;
    }

    public void setnPvCost(double nPvCost) {
        this.nPvCost = nPvCost;
    }

    public double getScore() {
        return score;
    }

    public void setScore(double score) {
        this.score = score;
    }

    public double getCtr() {
        return ctr;
    }

    public void setCtr(double ctr) {
        this.ctr = ctr;
    }

    public double getUc() {
        return uc;
    }

    public void setUc(double uc) {
        this.uc = uc;
    }

    @Override
    public String toString() {
        return "MaterialMatchInfo{" +
                "materialId=" + materialId +
                ", materialTag=" + materialTag +
                ", appId=" + appId +
                ", slotId=" + slotId +
                ", isExcellent=" + isExcellent +
                ", exposureCnt=" + exposureCnt +
                ", clickCnt=" + clickCnt +
                ", cost=" + cost +
                ", matchScore=" + matchScore +
                ", nCtr=" + nCtr +
                ", nPvCost=" + nPvCost +
                ", score=" + score +
                ", ctr=" + ctr +
                ", uc=" + uc +
                '}';
    }
}
