package cn.com.duiba.nezha.alg.common.model.materialrecommend;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import junit.framework.TestCase;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author lijingzhe
 * @description 优选自测
 * @date 2019/12/17
 */
public class MaterialRecTest extends TestCase {

    public void testSelect() throws Exception {
        //读取本地模拟文件
        String Path="/Users/lijingzhe/codes/duiba_sql/materials";
        BufferedReader reader = null;
        String laststr = "";
        try {
            FileInputStream fileInputStream = new FileInputStream(Path);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream, "UTF-8");
            reader = new BufferedReader(inputStreamReader);
            String tempString = null;
            while ((tempString = reader.readLine()) != null) {
                laststr += tempString;
            }
            reader.close();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (reader != null) {
                try {
                    reader.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        JSONArray jsonArray = JSON.parseArray(laststr);
        List<MaterialMatchInfo> matchInfoList = new ArrayList<>();
        List<MaterialRankInfo> materialRankInfos = new ArrayList<>();
        for (int i = 0; i < jsonArray.size(); i++) {
            MaterialMatchInfo mmi = jsonArray.getJSONObject(i).toJavaObject(MaterialMatchInfo.class);
            matchInfoList.add(mmi);
            MaterialRankInfo smm = new MaterialRankInfo();
            smm.slotId = mmi.slotId;
            smm.appId = mmi.appId;
            smm.materialId = mmi.materialId;
            materialRankInfos.add(smm);
        }

        //单元测试
        Map<Long,Integer> map = new HashMap<>();

        for (int i=0;i<10000;i++) {
            MaterialRankInfo ret = MaterialRec20.select(matchInfoList, materialRankInfos);
            map.put(ret.materialId,map.getOrDefault(ret.materialId,0) + 1);
        }
        System.out.println(map);
    }
}
