package cn.com.duiba.nezha.alg.common.model.roipid;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;

public class PIDFactorExploration {
    private static final Logger logger = LoggerFactory.getLogger(cn.com.duiba.nezha.alg.common.model.roipid.PIDFactorExploration.class);

    public enum FactorLevel {

        LOW("0", "level-0"),//降低

        STABLE("1", "level-1"),

        HIGH("2", "level-2");//提高


        private String code;
        private String dec;

        FactorLevel(String code, String dec) {
            this.code = code;
            this.dec = dec;
        }

        public String getCode() {
            return code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getDec() {
            return dec;
        }

        public void setDec(String dec) {
            this.dec = dec;
        }
    }

    static double[] costWeightBucket = {0, 2000, 5000, 10000, 20000, 50000};
    static double[] costWeight = {1.0, 1.0, 0.9, 0.8, 0.7, 0.5};
    static double[] biasWeightBucket = {0.0,1.0, 1.2, 1.5, 2.0, 5.0};
    static double[] biasWeight = {1.0, 1.0, 0.9, 0.8, 0.7, 0.5};


    /**
     * 因子试探（根据缓存数据，调用频率：10min调用1次）
     *
     * @param pidControlInfo 统计数据，上一次缓存数据
     * @return 因子试探表, 调节主要依据
     */

    public static PIDFactorExplorationDo exploreFactor(PIDControlInfo pidControlInfo) {

        if (AssertUtil.isEmpty(pidControlInfo)) {
            return null;
        }

        PIDFactorExplorationDo ret = new PIDFactorExplorationDo();

        circuitBreaker(pidControlInfo, ret);

        try {


            // 1、设置默认值
            Double lastFactor = pidControlInfo.factor != null ? pidControlInfo.factor : 1.0 ;   // 当前的调节因子

            Double lowerLimit = 0.4;                                  // 调节因子下限
            Double upperLimit = 1.2;                                  // 调节因子上限

            Double[] stepList = {-0.05, 0.00, 0.05};                  // 基准值调节步长

            Double baseValue = lastFactor;                            // 基准值
            Double defaultValue  = lastFactor;
            Double[] baseFlowRate = {0.2, 0.5, 0.3};                  // 基准流量比例

            //因子试探表
            Map<String, Double> factorMap = new HashMap<>(FactorLevel.values().length);
            Map<String, Double> flowRateMap = new HashMap<>(FactorLevel.values().length);

            //调节主要依据

            //2、当前对象是否合法
            if (AssertUtil.isNotEmpty(pidControlInfo)) {

                //3、计算统计数据

                double costDay = pidControlInfo.costDay;
                double costHour = pidControlInfo.costHour;//当前时段的消耗
                double costLastHour = pidControlInfo.costLastHour;//上个时段的消耗
                double convertDay = pidControlInfo.costLastHour;//累计转化
                double convertHour = pidControlInfo.convertHour;//当前时段的转化
                double convertLastHour = pidControlInfo.convertLastHour;//上个时段的转化
                double targetCpa = pidControlInfo.targetCpa;//目标出价

                double actualCpaHour = convertHour > 0 ? costHour / convertHour : costHour;
                double actualCpaDay = convertDay > 0 ? costDay / convertDay : costDay ;
                double actualCpaLastHour = convertLastHour > 0 ? costLastHour / convertLastHour : costLastHour;
                double biasDay = targetCpa > 0 ? actualCpaDay / targetCpa :  1.0;
                double biasHour = targetCpa > 0 ? actualCpaHour / targetCpa : 1.0;
                double biasLastHour = targetCpa > 0 ?  actualCpaLastHour / targetCpa :1.0;


                //5、计算basevalue
                double actual = convertHour > 0 ? costHour / convertHour : targetCpa;

                double initFactor = targetCpa / actual;

                if (convertHour >= 3 && convertHour < 5) {
                    initFactor = initFactor > 1.2 ? 1.2 : initFactor;
                    initFactor = initFactor < 0.8 ? 0.8 : initFactor;
                } else if (convertHour >= 5 && convertHour < 10) {
                    if (initFactor < 1) {
                        initFactor = Math.pow(initFactor, 1.5);
                    }
                    initFactor = initFactor > 1.5 ? 1.5 : initFactor;
                    initFactor = initFactor < 0.7 ? 0.7 : initFactor;
                } else if (convertHour >= 10) {
                    if (initFactor < 1) {
                        initFactor = Math.pow(initFactor, 2);
                    }
                    initFactor = initFactor > 2 ? 2 : initFactor;
                    initFactor = initFactor < 0.5 ? 0.5 : initFactor;
                } else {
                    if (costHour < 5 * targetCpa)
                        initFactor = 1;
                    else {
                        initFactor = targetCpa / costHour;
                        initFactor = initFactor > 1.5 ? 1.5 : initFactor;
                        initFactor = initFactor < 0.5 ? 0.5 : initFactor;
                    }
                }
                baseValue = initFactor;
//                defaultValue =  Math.max(baseValue,lastFactor);
                if (baseValue-lastFactor > 0.2 || baseValue-lastFactor < -0.2){
                    defaultValue = baseValue;
                } else {
                    defaultValue = lastFactor;
                }


                Double costBias = costLastHour != 0 ? costHour/costLastHour : 1.0;

//                PIDFactorExplorationDo lastExplorationDo = pidControlInfo.getLastFactorExplorationDo();
//                if (AssertUtil.isNotEmpty(lastExplorationDo)) {
//
//                    Map<String, Double> lastFactorMap = lastExplorationDo.getFactorExploreMap();
//
//                }

                Double costConfWeight = getConfidenceWeight(costHour, costWeightBucket, costWeight, 0.5);
                Double biasConfWeight = getConfidenceWeight(biasHour, biasWeightBucket, biasWeight, 0.5);


                // 6、试价幅度调节
                if (costDay <= 0 || biasHour >= 5) {

                    //降价幅度
                    stepList[0] = Math.min(Math.max(-0.2 * DataUtil.division(biasHour,costConfWeight),-0.3),-0.01);
                    stepList[2] = Math.min(0.2 * DataUtil.division(costConfWeight * biasConfWeight,costBias), 0.1);

                    //降价占比
                    baseFlowRate[0] = 0.9;
                    //提价占比
                    baseFlowRate[2] = 0.0;

                } else if ((costHour <= 5000 || costBias <= 0.7) && biasHour <= 2) {

                    //降价
                    stepList[0] = Math.min(Math.max(-0.2 * DataUtil.division(biasHour,costConfWeight),-0.1),-0.01);

                    //涨价幅度
                    stepList[2] = Math.min(Math.max(0.2 * DataUtil.division(costConfWeight * biasConfWeight,costBias), 0.1),0.3);

                    //提价占比
                    baseFlowRate[2] = Math.min(Math.max(costConfWeight * biasConfWeight,0.6),0.9);
                    //降价占比
                    baseFlowRate[0] = baseFlowRate[2] > 0.8 ? 0.0 : 0.15;


                } else {

                    //降价幅度
                    stepList[0] = Math.min(Math.max(-0.2 * DataUtil.division(biasHour,costConfWeight),-0.1),-0.01);
                    //降价幅度
                    stepList[2] = Math.min(Math.max(0.2 * DataUtil.division(costConfWeight * biasConfWeight,costBias), 0.1),0.2);
                    //涨价占比
                    baseFlowRate[0] = 0.2;
                    //降价占比
                    baseFlowRate[2] = 0.2;
                }

                baseFlowRate[1] = DataUtil.formatDouble((1.0 - baseFlowRate[2] - baseFlowRate[0]), 3);
            }


            for (FactorLevel factorLevel : FactorLevel.values()) {
                String key = factorLevel.getCode();
                int i = DataUtil.toInt(DataUtil.string2Long(key));
                Double factor = DataUtil.formatDouble(getNormalValue((defaultValue + stepList[i]), baseValue, lowerLimit, upperLimit), 6);
                Double flowRate = DataUtil.formatDouble(baseFlowRate[i], 3);

                factorMap.put(key, factor);
                flowRateMap.put(key, flowRate);
            }

            ret.setFactorExploreMap(factorMap);
            ret.setFactorFlowRateMap(flowRateMap);

            if (Math.random()<0.01) {
                logger.info("FactorExploration:{} ", JSON.toJSONString(ret));
            }

        } catch (Exception e) {
            logger.error("FactorExploration.getExploreFactor error:" + e);
        }
        return ret;

    }


    public static Double getNormalValue(Double value, Double defaultValue, Double lower, Double upper) {

        Double ret = defaultValue;
        if (value != null) {
            ret = value < lower ? lower : (value > upper ? upper : value);
        }
        return ret;
    }

    public static Double getConfidenceWeight(double value, double[] bucketList, double[] weightList, double defaultValue) {
        double ret = defaultValue;

        if (bucketList != null && bucketList.length > 0 && weightList != null && weightList.length == bucketList.length) {
            double lastWeight = weightList[0];
            double lastBound = bucketList[0];
            for (int i = 0; i < bucketList.length; i++) {
                double bound = bucketList[i];
                if (value <= bound) {
                    double curWeight = weightList[i];
                    double curBound = bucketList[i];
                    if (i > 0) {
                        ret = lastWeight + (curWeight - lastWeight) * (value - lastBound) / (curBound - lastBound);
                    } else {
                        ret = curWeight;
                    }

                    break;
                }
                lastWeight = weightList[i];
                lastBound = bucketList[i];
            }
        }

        return DataUtil.formatDouble(ret, 3);
    }

    public static void circuitBreaker(PIDControlInfo pidControlInfo, PIDFactorExplorationDo ret) {

        Boolean label = false;
        Double target = pidControlInfo.targetCpa != 0 ? pidControlInfo.targetCpa : 1;
        Double orientCostG1d = pidControlInfo.costDay != null ? pidControlInfo.costDay : 0.0;             //配置消耗
        Long orientConvert = pidControlInfo.convertDay;
        Double orientConfidence = orientCostG1d / (target * 5);  //配置置信度
        Double orientCostConvert = (orientConvert != 0 && orientCostG1d != 0) ? orientCostG1d / orientConvert : target;       //配置当天实际成本
        Double orientCostConvertbias = (orientConvert != 0) ? orientCostConvert / target : orientCostG1d / target;

        Long currentTime = DataUtil.string2Long(LocalDateUtil.getCurrentLocalDateTime("HH"));

        if (currentTime <= 7L && orientCostG1d >= 100000 && orientCostConvertbias >= 2.0) {
            ret.setCirBreaker(true);
            ret.setCostConvertbias(orientCostConvertbias);

        } else if (currentTime > 7L && orientCostG1d >= 60000 && orientCostConvertbias >= 1.2) {
            ret.setCirBreaker(true);
            ret.setCostConvertbias(orientCostConvertbias);
        }
    }


    //    //单元测试
    public static void main(String[] args) {
//        for (FactorLevel level : FactorLevel.values()) {
//            String key = level.getCode();
//            System.out.println(key);
//        }

//        try {
            String str ="{\"convertDay\":100,\"convertHour\":10,\"convertLastHour\":2000,\"costDay\":60000," +
                    "\"costHour\":60000,\"costLastHour\":0,\"factor\":0.6,\"lastFactorExplorationDo\":{\"fa\n" +
                    "ctorExploreMap\":{\"0\":0.999999,\"1\":1.0,\"2\":1.0}," +
                    "\"factorFlowRateMap\":{\"0\":0.0,\"1\":0.101,\"2\":0.901}},\"targetCpa\":100.0}";
            JSONObject object = JSON.parseObject(str);
//            PIDControlInfo pidControlDoInfo = JSONObject.parseObject(str, PIDControlInfo.class);

            PIDControlInfo pidControlDoInfo = new PIDControlInfo();
            pidControlDoInfo.costDay = 50000L;//累计消耗
            pidControlDoInfo.costHour = 1000L;//当前时段的消耗
            pidControlDoInfo.costLastHour = 2000L;//上个时段的消耗
            pidControlDoInfo.convertDay = 12L;//累计转化
            pidControlDoInfo.convertHour = 10L;//当前时段的转化
            pidControlDoInfo.convertLastHour = 10L;//上个时段的转化
            pidControlDoInfo.targetCpa = 4000.0;//目标出价
            pidControlDoInfo.factor = 0.6;//当前配置维度的调价因子
            pidControlDoInfo.lastFactorExplorationDo = null;



            PIDFactorExplorationDo ret3 = new PIDFactorExplorationDo();
//                    exploreFactor(pidControlDoInfo);
//            System.out.println("ret3:" + JSON.toJSONString(ret3));
            circuitBreaker(pidControlDoInfo,ret3);
            System.out.println("ret3:" + JSON.toJSONString(ret3));

//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//          double costConfWeight = getConfidenceWeight(100000000, costWeightBucket, costWeight, 0.5);
//          double biasConfWeight = getConfidenceWeight(0.5, biasWeightBucket, biasWeight, 0.5);
//          System.out.println("ret4:" + costConfWeight);
//          System.out.println("ret5:" + biasConfWeight);
//        Long currentTime = DataUtil.string2Long(LocalDateUtil.getCurrentLocalDateTime("HH"));
//        System.out.println(currentTime);
//        if (currentTime > 10L){
//            System.out.println(currentTime);
//        }
    }


}

