/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.common.model.activityrecommend;

import cn.com.duiba.nezha.alg.common.model.activityrecommend.ActivityInfoAd;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.ActivityInfoData;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.ActivityMatchInfo;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.ActivityRankInfo;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.ActivityRec42;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.BetaDistribution;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.NormInfo;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.RankResult;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.SelectPoolInfo;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.SimilarCostActivitiesInfo;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityRec46 {
    private static final Logger logger = LoggerFactory.getLogger(ActivityRec46.class);

    public static List<ActivityMatchInfo> match(List<ActivityInfoData> actData, List<ActivityInfoAd> actAds, List<NormInfo> exActs) {
        return ActivityRec42.match(actData, actAds, exActs);
    }

    public static RankResult select(List<ActivityRankInfo> actModel, List<ActivityMatchInfo> actData, List<Double> parameters) {
        int exeN = Constant.EXCN;
        int thr = Constant.THR;
        double probL = Constant.PROBL;
        double level = Constant.LEVEL;
        double probH = Constant.PROBH;
        if (parameters.size() == 5) {
            exeN = parameters.get(0).intValue();
            thr = parameters.get(1).intValue();
            probL = parameters.get(2);
            level = parameters.get(3);
            probH = parameters.get(4);
        }
        RankResult rankResult = new RankResult();
        if (actModel.size() == 0 || actData.size() == 0) {
            return null;
        }
        if (actModel.size() != actData.size()) {
            rankResult.activityModel = actModel.get(0);
            rankResult.similarCostActivitiesInfo = null;
            return rankResult;
        }
        List actModelCopy = actModel.stream().sorted(Comparator.comparing(ActivityRankInfo::getActivityId).reversed()).collect(Collectors.toList());
        List actDataCopy = actData.stream().sorted(Comparator.comparing(ActivityMatchInfo::getActivityId).reversed()).collect(Collectors.toList());
        for (int i = 0; i < actModelCopy.size(); ++i) {
            long activityIdMode = ((ActivityRankInfo)actModelCopy.get((int)i)).activityId;
            long activityIdData = ((ActivityMatchInfo)actDataCopy.get((int)i)).activityId;
            if (activityIdMode == activityIdData) continue;
            rankResult.activityModel = actModel.get(0);
            rankResult.similarCostActivitiesInfo = null;
            return rankResult;
        }
        ArrayList<Double> requests = new ArrayList<Double>();
        ArrayList<Double> rewards = new ArrayList<Double>();
        ArrayList<Double> counts = new ArrayList<Double>();
        ArrayList<Double> alphas = new ArrayList<Double>();
        ArrayList<Double> betas = new ArrayList<Double>();
        ArrayList<Double> changeScores = new ArrayList<Double>();
        ArrayList<Double> cvrBiass = new ArrayList<Double>();
        ArrayList<Long> activityIds = new ArrayList<Long>();
        ArrayList<Long> activityTypes = new ArrayList<Long>();
        ArrayList<Double> grpms = new ArrayList<Double>();
        ArrayList<Double> arpms = new ArrayList<Double>();
        ArrayList<Double> hrpms = new ArrayList<Double>();
        ArrayList<Boolean> excellents = new ArrayList<Boolean>();
        ArrayList<Integer> subTypes = new ArrayList<Integer>();
        ArrayList<Double> scores = new ArrayList<Double>();
        ArrayList candiList = new ArrayList();
        double decay = Constant.DECAY;
        int size = 0;
        HashMap<Long, RankInfo> mMap = new HashMap<Long, RankInfo>();
        double maxG = Constant.MIN_REWARD;
        double maxH = Constant.MIN_REWARD;
        double maxA = Constant.MIN_REWARD;
        double minG = 0.0;
        double minH = Constant.MIN_REWARD;
        double minA = Constant.MIN_REWARD;
        ActivityRankInfo result = new ActivityRankInfo();
        try {
            int i;
            for (i = 0; i < actDataCopy.size(); ++i) {
                double hrpm;
                double arpm;
                double grpm;
                RankInfo info = mMap.containsKey(((ActivityMatchInfo)actDataCopy.get((int)i)).activityId) ? (RankInfo)mMap.get(((ActivityMatchInfo)actDataCopy.get((int)i)).activityId) : new RankInfo();
                info.grpm = grpm = ((ActivityMatchInfo)actDataCopy.get((int)i)).hisRequest.globalVal > 0.0 ? ((ActivityMatchInfo)actDataCopy.get((int)i)).hisCost.globalVal / ((ActivityMatchInfo)actDataCopy.get((int)i)).hisRequest.globalVal : 0.0;
                info.gexp = ((ActivityMatchInfo)actDataCopy.get((int)i)).hisRequest.globalVal;
                maxG = Math.max(grpm, maxG);
                info.arpm = arpm = ((ActivityMatchInfo)actDataCopy.get((int)i)).hisRequest.appVal > 0.0 ? ((ActivityMatchInfo)actDataCopy.get((int)i)).hisCost.appVal / ((ActivityMatchInfo)actDataCopy.get((int)i)).hisRequest.appVal : 0.0;
                info.aexp = ((ActivityMatchInfo)actDataCopy.get((int)i)).hisRequest.appVal;
                if (info.aexp > 100.0) {
                    maxA = Math.max(arpm, maxA);
                }
                minA = Math.min(arpm, minA);
                info.hrpm = hrpm = ((ActivityMatchInfo)actDataCopy.get((int)i)).hisRequest.slotVal > 0.0 ? ((ActivityMatchInfo)actDataCopy.get((int)i)).hisCost.slotVal / ((ActivityMatchInfo)actDataCopy.get((int)i)).hisRequest.slotVal : 0.0;
                info.hexp = ((ActivityMatchInfo)actDataCopy.get((int)i)).hisRequest.slotVal;
                if (info.hexp > 100.0) {
                    maxH = Math.max(hrpm, maxH);
                }
                minH = Math.min(hrpm, minH);
                mMap.put(((ActivityMatchInfo)actDataCopy.get((int)i)).activityId, info);
            }
            for (i = 0; i < actDataCopy.size(); ++i) {
                requests.add(((ActivityMatchInfo)actDataCopy.get((int)i)).hisRequest.slotVal);
                double hrpm = ((RankInfo)mMap.get((Object)Long.valueOf((long)((ActivityMatchInfo)actDataCopy.get((int)i)).activityId))).hrpm;
                double arpm = ((RankInfo)mMap.get((Object)Long.valueOf((long)((ActivityMatchInfo)actDataCopy.get((int)i)).activityId))).arpm;
                double grpm = ((RankInfo)mMap.get((Object)Long.valueOf((long)((ActivityMatchInfo)actDataCopy.get((int)i)).activityId))).grpm;
                hrpms.add(hrpm);
                arpms.add(arpm);
                grpms.add(grpm);
                excellents.add(((ActivityMatchInfo)actDataCopy.get((int)i)).isExcellent);
                subTypes.add(((ActivityMatchInfo)actDataCopy.get((int)i)).subType);
                scores.add(((ActivityMatchInfo)actDataCopy.get((int)i)).score);
                cvrBiass.add(((ActivityMatchInfo)actDataCopy.get((int)i)).cvrBias);
                double reward = Constant.MIN_REWARD;
                double sconfidence = Math.min(((ActivityMatchInfo)actDataCopy.get((int)i)).hisRequest.slotVal / 100.0, 1.0);
                double aconfidence = Math.min(((ActivityMatchInfo)actDataCopy.get((int)i)).hisRequest.appVal / 100.0, 1.0);
                reward = sconfidence * ActivityRec46.normlize(hrpm * 0.8, maxH, 0.8) + (1.0 - sconfidence) * aconfidence * ActivityRec46.normlize(arpm * 0.7, maxA, 0.7) + (1.0 - sconfidence - (1.0 - sconfidence) * aconfidence) * ActivityRec46.normlize(grpm * 0.5, maxG, 0.6);
                reward *= reward;
                reward = Math.max(reward, 0.0);
                ((ActivityRankInfo)actModelCopy.get((int)i)).reward = ((ActivityRankInfo)actModelCopy.get((int)i)).reward * decay + reward;
                ((ActivityRankInfo)actModelCopy.get((int)i)).count = ((ActivityRankInfo)actModelCopy.get((int)i)).count * decay + 1.0;
                ((ActivityRankInfo)actModelCopy.get((int)i)).alpha = 1.5 + ((ActivityRankInfo)actModelCopy.get((int)i)).reward;
                ((ActivityRankInfo)actModelCopy.get((int)i)).beta = 2.0 + (((ActivityRankInfo)actModelCopy.get((int)i)).count - ((ActivityRankInfo)actModelCopy.get((int)i)).reward);
                rewards.add(((ActivityRankInfo)actModelCopy.get((int)i)).reward);
                counts.add(((ActivityRankInfo)actModelCopy.get((int)i)).count);
                alphas.add(((ActivityRankInfo)actModelCopy.get((int)i)).alpha);
                betas.add(((ActivityRankInfo)actModelCopy.get((int)i)).beta);
                activityIds.add(((ActivityRankInfo)actModelCopy.get((int)i)).activityId);
                activityTypes.add(((ActivityMatchInfo)actDataCopy.get((int)i)).activityType);
                changeScores.add(((ActivityMatchInfo)actDataCopy.get((int)i)).changeScore);
                candiList.add(actModelCopy.get(i));
            }
            int numMachines = candiList.size();
            SelectInfoDetail selectInfoDetail = ActivityRec46.selectMachineWithChangeScore(alphas, betas, activityTypes, activityIds, changeScores, numMachines, hrpms, arpms, grpms, requests, excellents, subTypes, scores, cvrBiass, thr, probL, level, probH);
            int selectedActivityIndex = selectInfoDetail.index;
            result = (ActivityRankInfo)candiList.get(selectedActivityIndex);
            result.strategyType = selectInfoDetail.strategyType;
            double maxChangeScore = selectInfoDetail.maxChangeScore;
            ArrayList<SimilarCostActivitiesInfo> sameCostActivitiesInfoList = new ArrayList<SimilarCostActivitiesInfo>();
            ArrayList<SelectPoolInfo> sameCostcondi = selectInfoDetail.condi;
            if (sameCostcondi.size() > 0) {
                double selectedActivityReward = sameCostcondi.get(0).getReward();
                int sameCostActivityCnt = sameCostcondi.size();
                for (SelectPoolInfo selectInfo : sameCostcondi) {
                    SimilarCostActivitiesInfo sameCostActivitiesInfo = new SimilarCostActivitiesInfo();
                    Long activityId = selectInfo.getActivityId();
                    Long activityType = selectInfo.getActivityType();
                    int ifSelected = 0;
                    if (selectInfo.getIndex() == selectedActivityIndex) {
                        ifSelected = 1;
                    }
                    int index = selectInfo.getIndex();
                    double mabReward = selectInfo.getReward();
                    double changeScore = selectInfo.getChangeScore();
                    double hrpm = selectInfo.getHrpm();
                    double arpm = selectInfo.getArpm();
                    double grpm = selectInfo.getGrpm();
                    int subType = selectInfo.getSubType();
                    boolean excellent = selectInfo.isExcellent();
                    double diffReward = selectInfo.getReward() - selectedActivityReward;
                    double diffChangeScore = selectInfo.getChangeScore() - maxChangeScore;
                    sameCostActivitiesInfo.activityId = activityId;
                    sameCostActivitiesInfo.sameActivityCnt = sameCostActivityCnt;
                    sameCostActivitiesInfo.activityType = activityType;
                    sameCostActivitiesInfo.ifSelected = ifSelected;
                    sameCostActivitiesInfo.mabReward = mabReward;
                    sameCostActivitiesInfo.changeScore = changeScore;
                    sameCostActivitiesInfo.index = index;
                    sameCostActivitiesInfo.hrpm = hrpm;
                    sameCostActivitiesInfo.arpm = arpm;
                    sameCostActivitiesInfo.grpm = grpm;
                    sameCostActivitiesInfo.diffReward = diffReward;
                    sameCostActivitiesInfo.diffChangeScore = diffChangeScore;
                    sameCostActivitiesInfo.subType = subType;
                    sameCostActivitiesInfo.isExcellent = excellent;
                    sameCostActivitiesInfoList.add(sameCostActivitiesInfo);
                }
            }
            rankResult.activityModel = result;
            rankResult.similarCostActivitiesInfo = sameCostActivitiesInfoList;
            mMap.clear();
            return rankResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage(), (Throwable)e);
            logger.error("error, size:{},candi:{},list:{},", new Object[]{size, JSON.toJSONString(candiList), JSON.toJSONString((Object)result)});
            return null;
        }
    }

    public static double normlize(double val, double max, double limit) {
        double norm = Math.min(val * limit / max, limit);
        return norm;
    }

    private static SelectInfoDetail selectMachineWithChangeScore(List<Double> alphas, List<Double> betas, List<Long> activityTypes, List<Long> activityIds, List<Double> changeScores, int numMachines, List<Double> hrpms, List<Double> arpms, List<Double> grpms, List<Double> requests, List<Boolean> excellents, List<Integer> subTypes, List<Double> scores, List<Double> cvrBiass, int thr, double probL, double level, double probH) {
        SelectInfoDetail selectInfoDetail = new SelectInfoDetail();
        ArrayList<SelectPoolInfo> sinfos = new ArrayList<SelectPoolInfo>();
        for (int i = 0; i < numMachines; ++i) {
            if (activityTypes.get(i) == 21L) continue;
            double theta = BetaDistribution.BetaDist(alphas.get(i), betas.get(i));
            SelectPoolInfo sinfo = new SelectPoolInfo();
            sinfo.setReward(theta);
            sinfo.setActivityType(activityTypes.get(i));
            sinfo.setIndex(i);
            sinfo.setActivityId(activityIds.get(i));
            sinfo.setChangeScore(changeScores.get(i));
            sinfo.setHrpm(hrpms.get(i));
            sinfo.setArpm(arpms.get(i));
            sinfo.setGrpm(grpms.get(i));
            sinfo.setRequest(requests.get(i));
            sinfo.setExcellent(excellents.get(i));
            sinfo.setScores(scores.get(i));
            sinfo.setExcellent(excellents.get(i));
            sinfo.setSubType(subTypes.get(i));
            sinfo.setCvrBias(cvrBiass.get(i));
            sinfos.add(sinfo);
        }
        if (sinfos.size() > 0) {
            List chs = sinfos.stream().sorted(Comparator.comparing(SelectPoolInfo::getChangeScore).reversed()).collect(Collectors.toList());
            double maxChangeScore = ((SelectPoolInfo)chs.get(0)).getChangeScore();
            List ranks = sinfos.stream().sorted(Comparator.comparing(SelectPoolInfo::getReward).reversed()).collect(Collectors.toList());
            double maxRewards = ((SelectPoolInfo)ranks.get(0)).getReward();
            List viceRanks = ranks.stream().filter(e -> e.getReward() >= 0.8 * maxRewards).collect(Collectors.toList());
            List lowExRanks = ranks.stream().filter(e -> e.isExcellent()).sorted(Comparator.comparing(SelectPoolInfo::getScores).reversed()).collect(Collectors.toList());
            List conRanks = ranks.stream().filter(e -> e.getChangeScore() >= 0.8 * e.getCvrBias()).collect(Collectors.toList());
            selectInfoDetail.condi = new ArrayList(ranks.subList(0, Math.min(ranks.size(), 5)));
            selectInfoDetail.maxChangeScore = maxChangeScore;
            if (Math.random() < 0.2) {
                if (lowExRanks.size() > 0 && ((SelectPoolInfo)lowExRanks.get(0)).getRequest() < 5000.0) {
                    selectInfoDetail.index = ((SelectPoolInfo)lowExRanks.get(0)).getIndex();
                    selectInfoDetail.strategyType = 1;
                }
            } else if (Math.random() < 0.3 && viceRanks.size() > 0) {
                double sws = viceRanks.stream().map(f -> f.getReward() / maxRewards).reduce((a, b) -> a + b).get();
                for (int i = 0; i < viceRanks.size(); ++i) {
                    double sw = ((SelectPoolInfo)viceRanks.get(i)).getReward() / (maxRewards * sws);
                    if (!(Math.random() < sw)) continue;
                    selectInfoDetail.index = ((SelectPoolInfo)viceRanks.get(i)).getIndex();
                    selectInfoDetail.strategyType = 2;
                }
            } else if (conRanks.size() > 0) {
                selectInfoDetail.index = ((SelectPoolInfo)conRanks.get(0)).getIndex();
                selectInfoDetail.strategyType = 3;
            }
            if (selectInfoDetail == null || selectInfoDetail.strategyType == 0) {
                selectInfoDetail.index = ((SelectPoolInfo)ranks.get(0)).getIndex();
                selectInfoDetail.strategyType = 5;
            }
        } else {
            selectInfoDetail.index = 0;
            selectInfoDetail.maxChangeScore = changeScores.get(0);
            selectInfoDetail.condi = new ArrayList();
            selectInfoDetail.strategyType = 0;
        }
        return selectInfoDetail;
    }

    static class SelectInfoDetail {
        int index;
        ArrayList<SelectPoolInfo> condi;
        double maxChangeScore;
        int strategyType;

        SelectInfoDetail() {
        }
    }

    static class RankInfo {
        double grpm;
        double gexp;
        double hrpm;
        double hexp;
        double arpm;
        double aexp;

        RankInfo() {
        }
    }

    static class Constant {
        static double MIN_REWARD = 0.1;
        static double DECAY = 0.99;
        static int SEARANK_TOPN = 30;
        static int EXCELLENT_TOPN = 20;
        static int EXCN = 1;
        static int THR = 5000;
        static double PROBL = 0.2;
        static double LEVEL = 0.8;
        static double PROBH = 0.3;

        Constant() {
        }
    }
}

