package cn.com.duiba.nezha.alg.common.model.materialrecommend;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import junit.framework.TestCase;

import java.io.*;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author lijingzhe
 * @description 优选自测
 * @date 2019/12/17
 */
public class MaterialRecTest extends TestCase {

    public void testSelect() throws Exception {
        //模拟请求次数
        int request = 10000;
        //读取本地模拟文件
        String path20="/Users/lijingzhe/codes/duiba_sql/materials20";
        String path25="/Users/lijingzhe/codes/duiba_sql/materials25";
        BufferedReader reader20 = null;
        BufferedReader reader25 = null;
        String laststr20 = "";
        String laststr25 = "";
        try {
            FileInputStream fileInputStream20 = new FileInputStream(path20);
            FileInputStream fileInputStream25 = new FileInputStream(path25);
            InputStreamReader inputStreamReader20 = new InputStreamReader(fileInputStream20, "UTF-8");
            InputStreamReader inputStreamReader25 = new InputStreamReader(fileInputStream25, "UTF-8");
            reader20 = new BufferedReader(inputStreamReader20);
            reader25 = new BufferedReader(inputStreamReader25);
            String tempString20 = null;
            String tempString25 = null;
            while((tempString20 = reader20.readLine()) != null) {
                laststr20 += tempString20;
            }
            while ((tempString25 = reader25.readLine()) != null) {
                laststr25 += tempString25;
            }
            reader20.close();
            reader25.close();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if(reader20 != null) {
                try {
                    reader20.close();
                }catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (reader25 != null) {
                try {
                    reader25.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        JSONArray jsonArray20 = JSON.parseArray(laststr20);
        JSONArray jsonArray25 = JSON.parseArray(laststr25);
        List<MaterialMatchInfo> matchInfoList20 = new ArrayList<>();
        List<MaterialMatchInfo> matchInfoList25 = new ArrayList<>();
        List<MaterialRankInfo> materialRankInfos20 = new ArrayList<>();
        List<MaterialRankInfo> materialRankInfos25 = new ArrayList<>();
        Map<Long,MaterialMatchInfo> maps20 = new HashMap<>();
        Map<Long,MaterialMatchInfo> maps25 = new HashMap<>();
        for(int i = 0; i < jsonArray20.size(); i++) {
            MaterialMatchInfo mmi = jsonArray20.getJSONObject(i).toJavaObject(MaterialMatchInfo.class);
            matchInfoList20.add(mmi);
            maps20.put(mmi.getMaterialId(),mmi);
            MaterialRankInfo smm = new MaterialRankInfo();
            smm.slotId = mmi.slotId;
            smm.appId = mmi.appId;
            smm.materialId = mmi.materialId;
            materialRankInfos20.add(smm);
        }

        for (int i = 0; i < jsonArray25.size(); i++) {
            MaterialMatchInfo mmi = jsonArray25.getJSONObject(i).toJavaObject(MaterialMatchInfo.class);
            matchInfoList25.add(mmi);
            maps25.put(mmi.getMaterialId(),mmi);
            MaterialRankInfo smm = new MaterialRankInfo();
            smm.slotId = mmi.slotId;
            smm.appId = mmi.appId;
            smm.materialId = mmi.materialId;
            materialRankInfos25.add(smm);
        }

        //单元测试
        Map<Long,Integer> map20 = new HashMap<>();
        Map<Long,Integer> map25 = new HashMap<>();

        Map<Integer,Integer> m20 = new HashMap<>();
        Map<Integer,Integer> m25 = new HashMap<>();

        Map<String,Integer> mr20 = new HashMap<>();
        Map<String,Integer> mr25 = new HashMap<>();

        Map<Long,Double> ctrs20 = new HashMap<>();
        Map<Long,Double> ucas20 = new HashMap<>();
        Map<Long,Double> ucs20 = new HashMap<>();
        Map<Long,Double> ctrs25 = new HashMap<>();
        Map<Long,Double> ucas25 = new HashMap<>();
        Map<Long,Double> ucs25 = new HashMap<>();

        Map<String,Double> algs = new HashMap<>();

        for(int i=0;i<request;i++){
            MaterialRankInfo ret = MaterialRec20.select(matchInfoList20, materialRankInfos20);
            map20.put(ret.materialId,map20.getOrDefault(ret.materialId, 0) + 1);
            m20.put(ret.strategyType,m20.getOrDefault(ret.strategyType, 0) + 1);
            mr20.put(ret.materialId+","+ret.strategyType,mr20.getOrDefault(ret.materialId+","+ret.strategyType, 0) + 1);
           double ctr = maps20.get(ret.materialId).getExposureCnt().getSlotVal() > 0 ? maps20.get(ret.materialId).getClickCnt().getSlotVal()/maps20.get(ret.materialId).getExposureCnt().getSlotVal() : 0;
           double uca = maps20.get(ret.materialId).getRequest().getSlotVal() > 0 ? maps20.get(ret.materialId).getCost().getSlotVal()/maps20.get(ret.materialId).getRequest().getSlotVal() : 0;
           double uc = maps20.get(ret.materialId).getExposureCnt().getSlotVal() > 0 ? maps20.get(ret.materialId).getCost().getSlotVal()/maps20.get(ret.materialId).getExposureCnt().getSlotVal() : 0;
           ctrs20.put(ret.materialId,ctrs20.getOrDefault(ret.materialId,0d) + ctr);
           ucas20.put(ret.materialId,ucas20.getOrDefault(ret.materialId,0d) + uca);
           ucs20.put(ret.materialId,ucs20.getOrDefault(ret.materialId,0d) + uc);
        }
        for (int i=0;i<request;i++) {
            MaterialRankInfo ret = MaterialRec25.select(matchInfoList25, materialRankInfos25);
            map25.put(ret.materialId,map25.getOrDefault(ret.materialId,0) + 1);
            m25.put(ret.strategyType,m25.getOrDefault(ret.strategyType, 0) + 1);
            mr25.put(ret.materialId+","+ret.strategyType,mr25.getOrDefault(ret.materialId+","+ret.strategyType, 0) + 1);
            double ctr = maps25.get(ret.materialId).getExposureCnt().getSlotVal() > 0 ? maps25.get(ret.materialId).getClickCnt().getSlotVal()/maps25.get(ret.materialId).getExposureCnt().getSlotVal() : 0;
            double uca = maps25.get(ret.materialId).getRequest().getSlotVal() > 0 ? maps25.get(ret.materialId).getCost().getSlotVal()/maps25.get(ret.materialId).getRequest().getSlotVal() : 0;
            double uc = maps25.get(ret.materialId).getExposureCnt().getSlotVal() > 0 ? maps25.get(ret.materialId).getCost().getSlotVal()/maps25.get(ret.materialId).getExposureCnt().getSlotVal() : 0;
            ctrs25.put(ret.materialId,ctrs25.getOrDefault(ret.materialId,0d) + ctr);
            ucas25.put(ret.materialId,ucas25.getOrDefault(ret.materialId, 0d) + uca);
            ucs25.put(ret.materialId,ucs25.getOrDefault(ret.materialId, 0d) + uc);
        }

        System.out.println("map20:"+map20);
        System.out.println("map25:"+map25);
        System.out.println("m20:"+m20);
        System.out.println("mr20:"+mr20);
        System.out.println("m25:"+m25);
        System.out.println("mr25:"+mr25);
        algs.put("alg20+ctr", ctrs20.values().stream().reduce((x,y)->x+y).get());
        algs.put("alg20+uca", ucas20.values().stream().reduce((x,y)->x+y).get());
        algs.put("alg20+uc", ucs20.values().stream().reduce((x,y)->x+y).get());
        algs.put("alg25+ctr", ctrs25.values().stream().reduce((x,y)->x+y).get());
        algs.put("alg25+uca",ucas25.values().stream().reduce((x,y)->x+y).get());
        algs.put("alg25+uc", ucs25.values().stream().reduce((x,y)->x+y).get());
        System.out.println(algs);
    }
}
