package cn.com.duiba.nezha.alg.example.util;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.StringZIP;
import cn.com.duiba.nezha.alg.example.constant.ProjectConstant;
import cn.com.duiba.nezha.alg.example.constant.PsConstant;
import cn.com.duiba.nezha.alg.example.util.conf.JedisPoolConf;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.FFM;
import cn.com.duiba.nezha.alg.model.FM;
import com.alibaba.fastjson.JSON;

import java.util.HashMap;
import java.util.Map;

public class StdModelSave {


    public static JedisUtil jedisUtil = new JedisUtil(JedisPoolConf.jedisConfig);

    /**
     * @param modelKey
     * @return
     */
    private static String getLastModelKey(String modelKey) {

        return "nz_last_model_new_" + modelKey + "_";
    }


    /**
     * @param modelKey
     * @return
     */
    private static String getADXModelKey(String modelKey) {

        return "TAE:ALGBID:MODEL:" + modelKey ;
    }
    /**
     * @param modelKey
     * @param model
     * @return
     */
    public static void saveModelByKeyToMD(String modelKey, FM model) {

        if (AssertUtil.isAnyEmpty(modelKey, model)) {
            System.out.println("saveCTRLastModelByKeyToES empty,modelKey=" + modelKey);
            return;
        }
        try {
            // 获取缓存Key
            String key = getLastModelKey(modelKey);
            // 保存
            Map<String, FM> map = new HashMap<>();
            map.put(key, model);
            System.out.println("save model with key " + key);
            MongoUtil.bulkWriteUpdateT(PsConstant.MODEL_TYPE, map, "model update");

        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    /**
     * @param modelKey
     * @return
     */
    public static FM getModelByKeyFromMD(String modelKey) {
        FM ret = null;

        if (AssertUtil.isAnyEmpty(modelKey)) {
            System.out.println("getCTRModelByKeyFromMD empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            // 获取缓存Key
            String key = getLastModelKey(modelKey);
            System.out.println("read model with key=" + key);
            // 保存
            ret = MongoUtil.findByIdT(PsConstant.MODEL_TYPE, key, FM.class);


        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }


    /**
     * @param modelKey
     * @param model
     * @return
     */
    public static void saveModelByKeyToMDFFM(String modelKey, FFM model) {

        if (AssertUtil.isAnyEmpty(modelKey, model)) {
            System.out.println("saveCTRLastModelByKeyToES empty,modelKey=" + modelKey);
            return;
        }
        try {
            // 获取缓存Key
            String key = getLastModelKey(modelKey);
            // 保存
            Map<String, FFM> map = new HashMap<>();
            map.put(key, model);
            System.out.println("save model with key " + key);
            MongoUtil.bulkWriteUpdateT(PsConstant.MODEL_TYPE, map, "model update");

        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    /**
     * @param modelKey
     * @return
     */
    public static FFM getModelByKeyFromMDFFM(String modelKey) {
        FFM ret = null;

        if (AssertUtil.isAnyEmpty(modelKey)) {
            System.out.println("getCTRModelByKeyFromMD empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            // 获取缓存Key
            String key = getLastModelKey(modelKey);
            System.out.println("read model with key=" + key);
            // 保存
            ret = MongoUtil.findByIdT(PsConstant.MODEL_TYPE, key, FFM.class);


        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }

    /**
     * @param modelKey
     * @param model
     * @return
     */
    public static void saveModelByKeyToJedis(String modelKey, FM model) {

        if (cn.com.duiba.nezha.alg.common.util.AssertUtil.isAnyEmpty(modelKey, model)) {
            System.out.println("saveCTRLastModelByKeyToES empty,modelKey=" + modelKey);
            return;
        }
        try {
            // 获取缓存Key
            String key = getLastModelKey(modelKey);

            // 保存
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString(model);
            String value2 = StringZIP.zipString(value); //压缩

            jedisUtil.setex(key, value2, ProjectConstant.WEEK_1_EXPIRE);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * @param modelKey
     * @return
     */
    public static FM getModelByKeyFromJedis(String modelKey) {
        FM ret = null;

        if (AssertUtil.isAnyEmpty(modelKey)) {
            System.out.println("getCTRModelByKeyFromMD empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            // 获取缓存Key
            String key = getLastModelKey(modelKey);
            System.out.println("read model with key=" + key);
            // 保存
            String ret1 = jedisUtil.get(key);
            String ret2 = StringZIP.unzipString(ret1);// 解压
            // 解压
            ret = JSON.parseObject(ret2, FM.class);

        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }

    /**
     * @param modelKey
     * @return
     */
    public static FM getModelByKeyFromJedis(String modelKey, JedisUtil ju) {
        FM ret = null;

        if (AssertUtil.isAnyEmpty(modelKey)) {
            System.out.println("getCTRModelByKeyFromMD empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            // 获取缓存Key
            String key = getLastModelKey(modelKey);
            System.out.println("read model with key=" + key);
            // 保存
            String ret1 = ju.get(key);
            String ret2 = StringZIP.unzipString(ret1);// 解压
            // 解压
            ret = JSON.parseObject(ret2, FM.class);

        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }
    public static CODER getCODERModelByKeyFromJedis(String modelKey, JedisUtil ju) {
        CODER ret = null;

        if (AssertUtil.isAnyEmpty(modelKey)) {
            System.out.println("getCTRModelByKeyFromMD empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            // 获取缓存Key
            String key = getLastModelKey(modelKey);
            System.out.println("read model with key=" + key);
            // 保存
            String ret1 = ju.get(key);
            String ret2 = StringZIP.unzipString(ret1);// 解压
            // 解压
            ret = JSON.parseObject(ret2, CODER.class);

        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }
    /**
     * @param modelKey
     * @return
     */
    public static FM getADXModelByKeyFromJedis(String modelKey, JedisUtil ju) {
        FM ret = null;

        if (AssertUtil.isAnyEmpty(modelKey)) {
            System.out.println("getCTRModelByKeyFromMD empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            // 获取缓存Key
            String key = getADXModelKey(modelKey);
            System.out.println("read model with key=" + key);
            // 保存
            String ret1 = ju.get(key);
            String ret2 = StringZIP.unzipString(ret1);// 解压
            // 解压
            ret = JSON.parseObject(ret2, FM.class);

        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }

    /**
     * @param modelKey
     * @param model
     * @return
     */
    public static void saveModelByKeyToJedis(String modelKey, FM model, JedisUtil ju) {

        if (cn.com.duiba.nezha.alg.common.util.AssertUtil.isAnyEmpty(modelKey, model)) {
            System.out.println("saveCTRLastModelByKeyToES empty,modelKey=" + modelKey);
            return;
        }
        try {
            // 获取缓存Key
            String key = getLastModelKey(modelKey);

            // 保存
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString(model);
            String value2 = StringZIP.zipString(value); //压缩

            ju.setex(key, value2, ProjectConstant.YEAR_1_EXPIRE);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    /**
     * @param modelKey
     * @param model
     * @return
     */
    public static void saveADXModelByKeyToJedis(String modelKey, FM model, JedisUtil ju) {

        if (cn.com.duiba.nezha.alg.common.util.AssertUtil.isAnyEmpty(modelKey, model)) {
            System.out.println("saveCTRLastModelByKeyToES empty,modelKey=" + modelKey);
            return;
        }
        try {
            // 获取缓存Key
            String key = getADXModelKey(modelKey);

            // 保存
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString(model);
            String value2 = StringZIP.zipString(value); //压缩

            ju.setex(key, value2, ProjectConstant.YEAR_1_EXPIRE);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    public static void saveCODERModelByKeyToJedis(String modelKey, CODER model, JedisUtil ju) {

        if (cn.com.duiba.nezha.alg.common.util.AssertUtil.isAnyEmpty(modelKey, model)) {
            System.out.println("saveCTRLastModelByKeyToES empty,modelKey=" + modelKey);
            return;
        }
        try {
            // 获取缓存Key
            String key = getLastModelKey(modelKey);

            // 保存
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString(model);
            String value2 = StringZIP.zipString(value); //压缩

            ju.setex(key, value2, ProjectConstant.YEAR_1_EXPIRE);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }



    /**
     * @param modelKey
     * @param model
     * @return
     */
    public static void saveModelByKeyToJedisFFM(String modelKey, FFM model) {

        if (cn.com.duiba.nezha.alg.common.util.AssertUtil.isAnyEmpty(modelKey, model)) {
            System.out.println("saveCTRLastModelByKeyToES empty,modelKey=" + modelKey);
            return;
        }
        try {
            // 获取缓存Key
            String key = getLastModelKey(modelKey);

            // 保存
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString(model);
            String value2 = StringZIP.zipString(value); //压缩

            jedisUtil.setex(key, value2, ProjectConstant.YEAR_1_EXPIRE);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * @param modelKey
     * @param model
     * @return
     */
    public static void saveModelByKeyToJedisFFM(String modelKey, FFM model, JedisUtil ju) {

        if (cn.com.duiba.nezha.alg.common.util.AssertUtil.isAnyEmpty(modelKey, model)) {
            System.out.println("saveCTRLastModelByKeyToES empty,modelKey=" + modelKey);
            return;
        }
        try {
            // 获取缓存Key
            String key = getLastModelKey(modelKey);

            // 保存
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString(model);
            String value2 = StringZIP.zipString(value); //压缩

            ju.setex(key, value2, ProjectConstant.WEEK_1_EXPIRE);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * @param modelKey
     * @return
     */
    public static FFM getModelByKeyFromJedisFFM(String modelKey) {
        FFM ret = null;

        if (AssertUtil.isAnyEmpty(modelKey)) {
            System.out.println("getCTRModelByKeyFromMD empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            // 获取缓存Key
            String key = getLastModelKey(modelKey);
            System.out.println("read model with key=" + key);
            // 保存
            String ret1 = jedisUtil.get(key);
            String ret2 = StringZIP.unzipString(ret1);// 解压
            // 解压
            ret = JSON.parseObject(ret2, FFM.class);

        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }

    /**
     * @param modelKey
     * @return
     */
    public static FFM getModelByKeyFromJedisFFM(String modelKey, JedisUtil ju) {
        FFM ret = null;

        if (AssertUtil.isAnyEmpty(modelKey)) {
            System.out.println("getCTRModelByKeyFromMD empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            // 获取缓存Key
            String key = getLastModelKey(modelKey);
            System.out.println("read model with key=" + key);
            // 保存
            String ret1 = ju.get(key);
            String ret2 = StringZIP.unzipString(ret1);// 解压
            // 解压
            ret = JSON.parseObject(ret2, FFM.class);

        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }
}
