package cn.com.duiba.nezha.alg.example.example;

import cn.com.duiba.nezha.alg.alg.plugins.ActPlugInDQNRcmder;
import cn.com.duiba.nezha.alg.alg.title.ActTitleRcmdAlg;
import cn.com.duiba.nezha.alg.alg.title.ActTitleRecaller;
import cn.com.duiba.nezha.alg.alg.vo.plug.ResPlugInRcmdDo;
import cn.com.duiba.nezha.alg.alg.vo.title.*;
import cn.com.duiba.nezha.alg.example.util.StdCoderModelSaveBo;
import cn.com.duiba.nezha.alg.feature.vo.ActFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.ActTitleFeatureDo;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import com.alibaba.fastjson.JSON;
import org.junit.Test;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ActTitleDQNRcmderTest {

    @Test
    public void rcmd() {


        //1 编码器获取 缓存
        CODER coderModel = StdCoderModelSaveBo.getModelCoderByKeyFromJedis("act_title_coder_dqn_v001", "act");

        System.out.println(coderModel);
        //2 TF本地模型获取  缓存
        LocalTFModel ltfModel = new LocalTFModel();
        try {
            ltfModel.loadModel("/Users/lwj/Desktop/model3/");



            List<FilterActTitleDo> filterActTitleDoList = new ArrayList<>();
            String f1="{\"activityId\":1,\"activityPage\":2,\"activitySkin\":3,\"activitySubTitleId\":102,\"activitySubTitleName\":\"副标题1\",\"activitySubTitleTagId\":202,\"activityTitleId\":101,\"activityTitleName\":\"主标题1\",\"activityTitleTagId\":201,\"isNew\":1,\"subIsNew\":1}";
            FilterActTitleDo fDo1=JSON.parseObject(f1,FilterActTitleDo.class);
            filterActTitleDoList.add(fDo1);


            String f2="{\"activityId\":1,\"activityPage\":2,\"activitySkin\":3,\"activitySubTitleId\":103,\"activitySubTitleName\":\"副标题1\",\"activitySubTitleTagId\":202,\"activityTitleId\":101,\"activityTitleName\":\"主标题1\",\"activityTitleTagId\":201,\"isNew\":1,\"subIsNew\":1}";
            FilterActTitleDo fDo2=JSON.parseObject(f2,FilterActTitleDo.class);
            filterActTitleDoList.add(fDo2);


            List<PreSelectActTitleDo> preSelectActTitleDoList = new ArrayList<>();

            RecallActTitleDo recallActTitleDo=ActTitleRecaller.recall(filterActTitleDoList,preSelectActTitleDoList , true);




            //4 获取非创意特征（同点击率预估模型）

            //5 获取资源位创意推荐统计对象（算法1，入参）

            List<ActTitleStatDo> actTitleStatDoList = new ArrayList<>();
            List<ActTitleStatDo> actSubTitleStatDoList = new ArrayList<>();
            List<ActTitleStatDo> actSlotTitleStatDoList = new ArrayList<>();
            List<ActTitleStatDo> actSlotSubTitleStatDoList = new ArrayList<>();

            //6 预估

            String featureStr = "{\"activityId\":17918,\"activityPage\":17918,\"appId\":52250,\"areaCode\":3301,\"dsm2A\":1,\"slotId\":279179}";

            ActTitleFeatureDo actTitleFeatureDo = JSON.parseObject(featureStr, ActTitleFeatureDo.class);
            actTitleFeatureDo.setAppId(300L);
            actTitleFeatureDo.setActivityId(30L);
//            coderModel = null;
//            System.out.println("coder="+JSON.toJSONString(coderModel));

            Map<String, Long> retMap = new HashMap<>();

            System.out.println(LocalDateTime.now());

            for (int i = 0; i < 100; i++) {
                ActTitleRcmdDo ret1 = ActTitleRcmdAlg.rcmd2(coderModel,
                        ltfModel,
                        recallActTitleDo,
                        actTitleStatDoList,
                        actSubTitleStatDoList,
                        actSlotTitleStatDoList,
                        actSlotSubTitleStatDoList,
                        actTitleFeatureDo,
                        true);

//                System.out.println("ret="+JSON.toJSONString(ret1));
                if (ret1 != null) {
                    retMap.put(ret1.getKey(), retMap.getOrDefault(ret1.getKey(), 0L) + 1);
                } else {
                    retMap.put(null, retMap.getOrDefault(null, 0L) + 1);
                }
            }

            System.out.println("retMap=" + JSON.toJSONString(retMap));

            System.out.println(LocalDateTime.now());

        } catch (Exception e) {
            e.printStackTrace();
            System.out.println(e);

        }
    }
}
