package cn.com.duiba.nezha.alg.example.util;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.example.constant.PsConstant;
import cn.com.duiba.nezha.alg.model.FM;

import java.util.HashMap;
import java.util.Map;

public class StdModelSave {







    /**
     * @param modelKey
     * @return
     */
    private static String getLastModelKey(String modelKey) {

        return "nz_last_model_new_" + modelKey + "_";
    }


    /**
     * @param modelKey
     * @param model
     * @return
     */
    public static void saveModelByKeyToMD(String modelKey, FM model) {

        if (AssertUtil.isAnyEmpty(modelKey, model)) {
            System.out.println("saveCTRLastModelByKeyToES empty,modelKey=" + modelKey);
            return;
        }
        try {
            // 获取缓存Key
            String key = getLastModelKey(modelKey);
            // 保存
            Map<String, FM> map = new HashMap<>();
            map.put(key, model);
            System.out.println("save model with key " + key);
            MongoUtil.bulkWriteUpdateT(PsConstant.MODEL_TYPE, map,"model update");

        } catch (Exception e) {
            e.printStackTrace();
        }
    }



    /**
     * @param modelKey
     * @return
     */
    public static FM getModelByKeyFromMD(String modelKey) {
        FM ret = null;

        if (AssertUtil.isAnyEmpty(modelKey)) {
            System.out.println("getCTRModelByKeyFromMD empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            // 获取缓存Key
            String key = getLastModelKey(modelKey);
            System.out.println("read model with key="+key);
            // 保存
            ret = MongoUtil.findByIdT(PsConstant.MODEL_TYPE, key, FM.class);

        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }
}
