/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.example.example.matchtest;

import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DateUtil;
import cn.com.duiba.nezha.alg.example.example.matchtest.StatisAdInfo;
import cn.com.duiba.nezha.alg.example.util.StdModelSave;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Match {
    public static void merge(List<StatisAdInfo> statisAdInfoList) throws Exception {
        if (AssertUtil.isNotEmpty(statisAdInfoList)) {
            Map<String, StatisAdInfo> collect = statisAdInfoList.stream().collect(Collectors.groupingBy(StatisAdInfo::getKey, Collectors.collectingAndThen(Collectors.toList(), list1 -> Match.sumStatisAdInfo(list1))));
            Map<String, List<StatisAdInfo>> redisKey = new ArrayList<StatisAdInfo>(collect.values()).stream().collect(Collectors.groupingBy(StatisAdInfo::getRedisKey));
            for (Map.Entry<String, List<StatisAdInfo>> entry : redisKey.entrySet()) {
                HashMap<String, StatisAdInfo> statisAdInfoMap30min = new HashMap<String, StatisAdInfo>();
                entry.getValue().forEach(item -> statisAdInfoMap30min.put(item.getAdKey(), (StatisAdInfo)item));
                Match.updateHourVars(entry.getKey(), statisAdInfoMap30min);
                Match.updateDayVars(entry.getKey(), statisAdInfoMap30min);
            }
        }
    }

    public static StatisAdInfo sumStatisAdInfo(List<StatisAdInfo> statisAdInfoList) {
        StatisAdInfo statisAdInfo = new StatisAdInfo();
        statisAdInfo.setKey(statisAdInfoList.get(0).getKey());
        statisAdInfo.setRedisKey(statisAdInfoList.get(0).getRedisKey());
        statisAdInfo.setAdKey(statisAdInfoList.get(0).getAdKey());
        statisAdInfo.setExpCnt(0L);
        statisAdInfo.setChargeCnt(0L);
        statisAdInfo.setChargeFees(0L);
        statisAdInfo.setConvert0Cnt(0L);
        statisAdInfo.setConvert2Cnt(0L);
        statisAdInfo.setConvert3Cnt(0L);
        for (StatisAdInfo sd : statisAdInfoList) {
            System.out.println(sd.getExpCnt());
            System.out.println(66666);
            statisAdInfo.addExpCnt(sd.getExpCnt());
            System.out.println(statisAdInfo.getExpCnt());
            statisAdInfo.addChargeCnt(sd.getChargeCnt());
            statisAdInfo.addChargeFees(sd.getChargeFees());
            statisAdInfo.addConvert0Cnt(sd.getConvert0Cnt());
            statisAdInfo.addConvert2Cnt(sd.getConvert2Cnt());
            statisAdInfo.addConvert3Cnt(sd.getConvert3Cnt());
        }
        return statisAdInfo;
    }

    private static void updateHourVars(String key, Map<String, StatisAdInfo> statisAdInfoMap30m_new) {
        Map statisAdInfoMap30m_last = (Map)StdModelSave.jedisUtil.get(key, Map.class);
        Map<String, StatisAdInfo> statisAdInfoMap1hour = Stream.concat(statisAdInfoMap30m_last.entrySet().stream(), statisAdInfoMap30m_new.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (value1, value2) -> {
            StatisAdInfo statisAdInfo = new StatisAdInfo();
            statisAdInfo.setKey(value2.getKey().replace("30min", "1hour"));
            statisAdInfo.setRedisKey(value2.getRedisKey().replace("30min", "1hour"));
            statisAdInfo.setAdKey(value2.getAdKey());
            statisAdInfo.addExpCnt(value1.getExpCnt() + value2.getExpCnt());
            statisAdInfo.addChargeCnt(value1.getChargeCnt() + value2.getChargeCnt());
            statisAdInfo.addChargeFees(value1.getChargeFees() + value2.getChargeFees());
            statisAdInfo.addConvert0Cnt(value1.getConvert0Cnt() + value2.getConvert0Cnt());
            statisAdInfo.addConvert2Cnt(value1.getConvert2Cnt() + value2.getConvert2Cnt());
            statisAdInfo.addConvert3Cnt(value1.getConvert3Cnt() + value2.getConvert3Cnt());
            return statisAdInfo;
        }));
        String hourKey = key.replace("30min", "1hour");
    }

    private static void updateDayVars(String key, Map<String, StatisAdInfo> statisAdInfoMap30min_new) {
        String dayRedisKey = key.replace("30min", "1day");
        Map statisAdInfoMap1d_last = (Map)StdModelSave.jedisUtil.get(dayRedisKey, Map.class);
        String currentTime = DateUtil.getCurrentTime((DateStyle)DateStyle.HH);
        Map<String, StatisAdInfo> statisAdInfoMap1hour = Stream.concat(statisAdInfoMap1d_last.entrySet().stream(), statisAdInfoMap30min_new.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (value1, value2) -> {
            StatisAdInfo statisAdInfo = new StatisAdInfo();
            if ("0".equals(currentTime)) {
                statisAdInfo.setKey(value2.getKey().replace("30min", "1day"));
                statisAdInfo.setRedisKey(value2.getRedisKey().replace("30min", "1day"));
                statisAdInfo.setAdKey(value2.getAdKey());
                statisAdInfo.addExpCnt(value2.getExpCnt());
                statisAdInfo.addChargeCnt(value2.getChargeCnt());
                statisAdInfo.addChargeFees(value2.getChargeFees());
                statisAdInfo.addConvert0Cnt(value2.getConvert0Cnt());
                statisAdInfo.addConvert2Cnt(value2.getConvert2Cnt());
                statisAdInfo.addConvert3Cnt(value2.getConvert3Cnt());
            } else {
                statisAdInfo.setKey(value2.getKey().replace("30min", "1day"));
                statisAdInfo.setRedisKey(value2.getRedisKey().replace("30min", "1day"));
                statisAdInfo.setAdKey(value2.getAdKey());
                statisAdInfo.addExpCnt(value1.getExpCnt() + value2.getExpCnt());
                statisAdInfo.addChargeCnt(value1.getChargeCnt() + value2.getChargeCnt());
                statisAdInfo.addChargeFees(value1.getChargeFees() + value2.getChargeFees());
                statisAdInfo.addConvert0Cnt(value1.getConvert0Cnt() + value2.getConvert0Cnt());
                statisAdInfo.addConvert2Cnt(value1.getConvert2Cnt() + value2.getConvert2Cnt());
                statisAdInfo.addConvert3Cnt(value1.getConvert3Cnt() + value2.getConvert3Cnt());
            }
            return statisAdInfo;
        }));
    }

    public static Double cvr(StatisAdInfo statisAdInfo) {
        double cvr0 = Match.calWilsonScore(statisAdInfo.getConvert0Cnt(), statisAdInfo.getChargeCnt());
        double cvr2 = Match.calWilsonScore(statisAdInfo.getConvert2Cnt(), statisAdInfo.getChargeCnt());
        double cvr3 = Match.calWilsonScore(statisAdInfo.getConvert3Cnt(), statisAdInfo.getChargeCnt());
        if (cvr2 == 0.0) {
            cvr2 = cvr0;
        }
        if (cvr3 == 0.0) {
            cvr3 = cvr0;
        }
        double cvr = 0.3333333333333333 * (cvr0 + cvr2 + cvr3);
        return cvr;
    }

    private static double calWilsonScore(long convert, long click) {
        if (click == 0L) {
            return 0.0;
        }
        double ratio = (double)convert * 1.0 / (double)click;
        double faithLevel = 0.99;
        double faithSquare = faithLevel * faithLevel;
        return (ratio + faithSquare / (double)(2L * click) - faithLevel * Math.sqrt((double)(4L * click) * ratio * (1.0 - ratio) + faithSquare) / (double)(2L * click)) / (1.0 + faithSquare / (double)click);
    }

    public static List<StatisAdInfo> rank(Map<String, StatisAdInfo> statisAdInfoMap, String type, String dim, Integer size) {
        List<StatisAdInfo> res = new ArrayList<StatisAdInfo>();
        if (type == "charge") {
            res = statisAdInfoMap.values().stream().filter(statisAdInfo -> statisAdInfo.getChargeFees() > 100L).sorted(Comparator.comparing(StatisAdInfo::getChargeFees).reversed()).limit(size.intValue()).collect(Collectors.toList());
        }
        if (type == "cvr") {
            res = statisAdInfoMap.values().stream().filter(statisAdInfo -> statisAdInfo.getCvr() > 4.0E-4).sorted(Comparator.comparing(StatisAdInfo::getCvr).reversed()).limit(size.intValue()).collect(Collectors.toList());
        }
        return res;
    }

    private static double calWilsonScore(Long convert, Long click) {
        if (convert == null || click == null) {
            return 0.0;
        }
        if (click == 0L) {
            return 0.0;
        }
        if (convert > click) {
            return 0.0;
        }
        double ratio = (double)convert.longValue() * 1.0 / (double)click.longValue();
        double faithLevel = 0.99;
        double faithSquare = faithLevel * faithLevel;
        return (ratio + faithSquare / (double)(2L * click) - faithLevel * Math.sqrt((double)(4L * click) * ratio * (1.0 - ratio) + faithSquare) / (double)(2L * click)) / (1.0 + faithSquare / (double)click.longValue());
    }

    public static void main(String[] args) {
        ArrayList<StatisAdInfo> statisAdInfoList = new ArrayList<StatisAdInfo>();
        HashMap<String, StatisAdInfo> statisAdInfoMap = new HashMap<String, StatisAdInfo>();
        StatisAdInfo statisAdInfo0 = new StatisAdInfo(0L, 0L, 0L, 0L, 0L, 0L, 0.0);
        StatisAdInfo statisAdInfo1 = new StatisAdInfo(0L, 0L, 0L, 0L, 0L, 0L, 0.0);
        StatisAdInfo statisAdInfo2 = new StatisAdInfo(0L, 0L, 0L, 0L, 0L, 0L, 0.0);
        statisAdInfo0.setKey("trade_30min_27516_54228");
        statisAdInfo0.setRedisKey("trade_30min_27516");
        statisAdInfo0.setAdKey("54228");
        statisAdInfo0.setExpCnt(10000L);
        statisAdInfo0.setChargeCnt(10000L);
        statisAdInfo0.setChargeFees(10000L);
        statisAdInfo0.setConvert0Cnt(10000L);
        statisAdInfo0.setConvert2Cnt(10000L);
        statisAdInfo0.setConvert3Cnt(10000L);
        statisAdInfo1.setKey("advert_30min_27516_54428");
        statisAdInfo1.setRedisKey("advert_30min_27516");
        statisAdInfo1.setAdKey("54428");
        statisAdInfo1.setExpCnt(1000L);
        statisAdInfo1.setChargeCnt(1000L);
        statisAdInfo1.setChargeFees(1000L);
        statisAdInfo1.setConvert0Cnt(800L);
        statisAdInfo1.setConvert2Cnt(1000L);
        statisAdInfo1.setConvert3Cnt(1000L);
        statisAdInfo1.setCvr(0.43333333333333335 * Match.calWilsonScore(4L, 3L));
        System.err.println(statisAdInfo1.getCvr());
        if (statisAdInfo1.getCvr() == null) {
            System.out.println("aaaaaaaaaaaaaaaaaaaaaa");
        }
        statisAdInfoList.add(statisAdInfo0);
        statisAdInfoList.add(statisAdInfo1);
        statisAdInfo2.setKey("advert_30min_27516_54328");
        statisAdInfo2.setRedisKey("advert_30min_27516");
        statisAdInfo2.setAdKey("54328");
        statisAdInfo2.setExpCnt(100000L);
        statisAdInfo2.setChargeCnt(10000L);
        statisAdInfo2.setChargeFees(500000000L);
        statisAdInfo2.setConvert0Cnt(900L);
        statisAdInfo2.setConvert2Cnt(100L);
        statisAdInfo2.setConvert3Cnt(100L);
        statisAdInfo2.setCvr(Match.cvr(statisAdInfo2));
        statisAdInfoList.add(statisAdInfo1);
        statisAdInfoList.add(statisAdInfo2);
        statisAdInfoList.add(statisAdInfo0);
        Map<String, List<StatisAdInfo>> redisKey = statisAdInfoList.stream().collect(Collectors.groupingBy(StatisAdInfo::getRedisKey));
        System.out.println(redisKey.toString());
        for (Map.Entry<String, List<StatisAdInfo>> entry : redisKey.entrySet()) {
            HashMap<String, StatisAdInfo> statisAdInfoMap1 = new HashMap<String, StatisAdInfo>();
            entry.getValue().forEach(item -> statisAdInfoMap1.put(item.getAdKey(), (StatisAdInfo)item));
            String offKey = entry.getKey();
            System.out.println("1111" + statisAdInfoMap1);
            System.out.println(entry);
            List<StatisAdInfo> res1 = Match.rank(statisAdInfoMap1, "cvr", "", 1);
            String dayKeyRes1 = offKey + "_charge";
            System.out.println(res1);
        }
        statisAdInfoMap.put(statisAdInfo0.getAdKey(), statisAdInfo0);
        statisAdInfoMap.put(statisAdInfo1.getAdKey(), statisAdInfo1);
        statisAdInfoMap.put(statisAdInfo2.getAdKey(), statisAdInfo2);
        double costlimit = 500.0;
        List<Object> res = new ArrayList();
        res = statisAdInfoList.stream().filter(statisAdInfo -> statisAdInfo.getRedisKey() != null && statisAdInfo.getRedisKey().contains("trade") && (double)statisAdInfo.getChargeFees().longValue() > 8.0 * costlimit || statisAdInfo.getRedisKey() != null && statisAdInfo.getRedisKey().contains("account") && (double)statisAdInfo.getChargeFees().longValue() > 2.0 * costlimit || statisAdInfo.getRedisKey() != null && statisAdInfo.getRedisKey().contains("advert") && (double)statisAdInfo.getChargeFees().longValue() > 1.0 * costlimit).sorted(Comparator.comparing(StatisAdInfo::getChargeFees).reversed()).limit(10L).collect(Collectors.toList());
        System.out.println("aaaaaaaaaaaaaaaa");
        System.out.println(res.size() + "   " + statisAdInfoList.size());
        System.out.println(res.toString());
    }
}

