package cn.com.duiba.nezha.alg.example.example;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.StringZIP;
import cn.com.duiba.nezha.alg.example.util.JedisUtil;
import cn.com.duiba.nezha.alg.example.util.conf.JedisPoolConf;
import cn.com.duiba.nezha.alg.feature.coder.FeatureCoder3;
import cn.com.duiba.nezha.alg.feature.vo.FeatureCode;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.CODER2;
import cn.com.duiba.nezha.alg.model.DenseCoder;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import com.alibaba.fastjson.JSON;

import java.util.HashMap;
import java.util.Map;

public class Tututu {

    public static JedisUtil jedisUtil = new JedisUtil(JedisPoolConf.jedisConfig);
    private static Map<String, Map<String, FeatureCode>> tmpCoderCache = new HashMap<>();

    public static void main(String[] args) throws Exception {
        cococoder();
    }
    private static void cococoder() throws Exception {
//        String modelId = "mid_ftrl_coder_bcvr_v412";
//        String key = "nz_last_model_new_" + modelId + "_";
//        System.out.println(key);
//        String ret1 = jedisUtil.get(key);
//        String ret2 = StringZIP.unzipString(ret1);// 解压
//        // 解压
//        CODER2 coder = JSON.parseObject(ret2, CODER2.class);

        String modelId = "mid_feature_eva_online_code_v001";
        DenseCoder coder = getDenseCoder2ByKeyFromJedis(modelId, jedisUtil);

        String rawStr="{\"backTimeConsume\":\"{\\\"0\\\":56.85,\\\"2\\\":123.51}\",\"f213001\":\"157,61,28,290,133," +
                "277,269,241,38\",\"f213002\":\"1213,1945,193,25,2797,565,1,158,397,2857,2833,973,277,301,181,1201,109,169,433,37,2341,121,313\",\"f213003\":\"157,61,26,290,133,270,241,37\",\"f213004\":\"1213,973,277,1945,194,301,182,1201,25,109,169,433,37,565,2341,1,158,121,397,2857,313\",\"f603002\":\"1\",\"f603001\":\"1\",\"f110001\":\"0\",\"f144009\":\"0\",\"f144007\":\"0\",\"f144008\":\"0\",\"f144005\":\"0\",\"f144006\":\"0\",\"f144003\":\"0\",\"f144004\":\"0\",\"f144001\":\"0\",\"f144002\":\"0\",\"f201001\":\"82045\",\"f660001\":\"21\",\"f660003\":\"0\",\"f660004\":\"0\",\"f144010\":\"0\",\"f810001\":\"null\",\"f810002\":\"null\",\"f306001\":\"2\",\"chargeType\":\"2\",\"f601001\":\"1\",\"f601002\":\"1\",\"linkageSubtype\":\"0-3,0-8,4-3,4-8\",\"f410001\":\"2\",\"f212004\":\"1922,3082,307,1942,41,4454,4430,896,3,250,630,4525,1542,440,478,288,1903,1560,173,269,687,62,3650,2458,3709,193,497\",\"f212003\":\"250,100,41,459,212,292,440,421,382,60\",\"f212002\":\"1922,3085,308,1943,48,4457,4430,896,7,254,633,4526,4491,1542,442,478,289,1905,1560,175,272,688,65,3650,2458,3709,193,498\",\"f212001\":\"252,100,45,461,213,292,442,422,84,384,63\",\"f602001\":\"1\",\"f211003\":\"157,62,25,291,133,181,277,268,241,38\",\"f211002\":\"1213,1945,193,1225,25,2809,2797,565,1,158,397,2857,2833,973,277,301,181,1201,985,109,169,433,37,2305,1549,2341,121,313\",\"f211001\":\"157,61,25,291,133,181,277,268,49,241,39\",\"f670001\":\"3f0cf9de03a038fcc103a55ee982a3ec\",\"f670002\":\"0\",\"f660201\":\"0\",\"f211004\":\"1213,1945,194,1225,25,2809,2797,565,1,157,397,2857,973,277,301,181,1201,985,109,169,433,37,2305,1549,2341,121,313\",\"f112001\":\"05.03.0001,05.02.0018,05.02.0006\",\"f101001\":\"74797\",\"f602002\":\"1\",\"orderId\":\"taw-3463202568220437\",\"f113001\":\"04.01.0006,04.03.0005,04.03.0017\",\"f812001\":\"0\",\"f812002\":\"0\",\"f360001\":\"-1\",\"f360002\":\"-1\",\"f360005\":\"1\",\"f812010\":\"0\",\"f502001\":\"0\",\"f502002\":\"2\",\"f502004\":\"5\",\"f812007\":\"0\",\"f812008\":\"0\",\"f812009\":\"0\",\"f812003\":\"0\",\"f812004\":\"0\",\"f812005\":\"0\",\"f812006\":\"0\",\"f770501\":\"0\",\"f606002\":\"0\",\"f606001\":\"-1\",\"f102001\":\"02.01.0003\",\"f301001\":\"20684\",\"advertId\":\"62713\",\"f210001\":\"157,61,25,291,133,181,277,268,49,241,39\",\"f210002\":\"1213,1945,194,1225,25,2809,2797,565,1,157,397,2857,2833,973,277,301,181,1201,985,109,169,433,37,2305,1549,2341,121,313\",\"f770401\":\"0\",\"f999999\":\"21_nu\",\"f210003\":\"157,193,61,25,292,133,181,277,268,241,39\",\"f770402\":\"0\",\"f210004\":\"1213,1945,194,1225,25,2809,2797,565,1,157,397,2857,973,277,301,182,1201,985,109,169,433,37,2305,1549,2341,121,313\",\"f604002\":\"1\",\"f604001\":\"1\",\"f501001\":\"Android\",\"f312001\":\"1\",\"f303001\":\"2\",\"consumerId\":\"26567895477\",\"f406001\":\"0\",\"f115003\":\"2\",\"f115004\":\"null\",\"f115001\":\"2\",\"f605001\":\"-1\",\"f605002\":\"0\",\"f151301\":\"\",\"f302001\":\"20684\",\"f608001\":\"1\",\"f104001\":\"96677\",\"f414004\":\"0\",\"f414007\":\"null\",\"f414005\":\"null\",\"f311001\":\"20684\",\"f151007\":\"话费\",\"f151001\":\"优选保\",\"f151002\":\"\",\"f505001\":\"600-1099\",\"f151006\":\"赠险\",\"f151004\":\"0\",\"f770102\":\"1\",\"f413006\":\"0\",\"f413007\":\"null\",\"f413004\":\"0\",\"f413005\":\"null\",\"f413009\":\"-1\",\"f609001\":\"0\",\"f804004\":\"7\",\"f804003\":\"9\",\"f804002\":\"12\",\"f804001\":\"13\",\"f770001\":\"07.19.0010\",\"f151104\":\"100w\",\"f151105\":\"赠险\",\"f151103\":\"意外险\",\"f415004\":\"0\",\"f415005\":\"null\",\"f415007\":\"null\",\"f504001\":\"Letv X501\",\"f607001\":\"1\",\"f680001\":\"0\",\"f680002\":\"0\",\"f680003\":\"0\",\"f403004\":\"0\",\"f805001\":\"2\",\"f805002\":\"10\",\"f805003\":\"3\",\"f805004\":\"5\",\"f9702\":\"0\",\"f205002\":\"382\",\"f205001\":\"39\",\"f701001\":\"3062713\",\"f404003\":\"workother\",\"f106001\":\"17878\",\"f1150011\":\"21_2\",\"f701002\":\"1082045\",\"f9607\":\"null\",\"f9608\":\"null\",\"f9609\":\"null\",\"f503001\":\"3701\",\"time\":\"20210309000506\",\"f9601\":\"null\",\"f9602\":\"null\",\"f9603\":\"null\",\"f411001\":\"2\",\"f411003\":\"0\",\"f411002\":\"2\",\"f411005\":\"6\",\"f411004\":\"2\",\"f331001\":\"2\",\"f508002\":\"X501\",\"f806001\":\"2\",\"f508001\":\"Letv\",\"f806002\":\"10\",\"f806003\":\"3\",\"f830101\":\"null\",\"f806004\":\"5\",\"f830102\":\"null\",\"f508006\":\"Letv\",\"f830103\":\"null\",\"f508005\":\"乐视\",\"f830104\":\"null\",\"f508004\":\"X501\",\"f508003\":\"Letv\",\"f611001\":\"1\",\"f9903\":\"0\",\"advertBackSubTypes\":\"[0,2]\",\"f141016\":\"0\",\"f141018\":\"0\",\"f9930\":\"-1\",\"f108001\":\"379795\",\"f807002\":\"11\",\"f807001\":\"1\",\"f507001\":\"3\",\"f807004\":\"6\",\"f830111\":\"null\",\"f807003\":\"2\",\"f830112\":\"null\",\"f9927\":\"-1\",\"f830113\":\"null\",\"f9928\":\"-1\",\"f830114\":\"null\",\"f9929\":\"-1\",\"f507003\":\"Android6.0\",\"f9802\":\"0\",\"f226007\":\"0\",\"f226006\":\"0\",\"f226005\":\"0\",\"f226004\":\"0\",\"f226003\":\"0\",\"f226002\":\"0\",\"f226001\":\"0\",\"f610001\":\"0\",\"f143010\":\"0\",\"f226008\":\"0\",\"f108003\":\"379795\",\"f830011\":\"{}\",\"f830012\":\"{}\",\"f830013\":\"{}\",\"f830014\":\"{}\",\"f109001\":\"8\",\"f506001\":\"1\",\"f121003\":\"null\",\"f8807\":\"1\",\"f8803\":\"1\",\"f143007\":\"0\",\"f225006\":\"0\",\"f143006\":\"0\",\"f250302\":\"2325,3729,375,51,1088,3,307,765,5493,532,582,352,2317,329,835,74,237,603\",\"f225005\":\"0\",\"f143009\":\"0\",\"f412002\":\"1\",\"f250301\":\"317,117,57,557,255,513,73\",\"f225004\":\"0\",\"f143008\":\"0\",\"f412001\":\"1\",\"f225003\":\"0\",\"f143003\":\"0\",\"f412004\":\"0\",\"f143002\":\"0\",\"f412003\":\"0\",\"f143005\":\"0\",\"f412006\":\"0\",\"f143004\":\"0\",\"f412005\":\"0\",\"f143001\":\"0\",\"f214001\":\"317,117,58,557,255,531,514,478,73\",\"f214002\":\"2325,3729,375,51,5361,1088,4,307,766,5493,5436,1866,532,582,352,2318,225,329,835,76,4487,237,602\",\"f214003\":\"317,117,57,557,255,513,481,73\",\"f214004\":\"2325,1866,532,3729,375,582,352,2317,51,228,329,835,74,1088,4487,3,307,237,765,5493,603\"}";

        Map<String, String> featureIdxMap = (Map) JSON.parseObject(rawStr);
//        Map sample=new HashMap();
//        for(int i=0;i<50;i++){
//            FeatureMapDo featureMapDo = new FeatureMapDo();
//            featureMapDo.setStaticFeatureMap(featureIdxMap);
//            sample.put(i,featureMapDo);
//        }

        long start=System.currentTimeMillis();
        for(int k=0;k<100000;k++){
            String codeNew = coder.getCode(featureIdxMap);
            if (k%1000==0){
                long end=System.currentTimeMillis();
                System.out.println(end-start);
                start=System.currentTimeMillis();
                System.out.println(codeNew);
            }
        }
    }

    private static void pppredict() throws Exception {
        LocalTFModel model=new LocalTFModel();
        model.loadModel("/Users/yudian/duiba/feature/Model/test_fm_pb");
        Map sample=new HashMap();
        String featureStr="f101001:257;f102001:5;f104001:300;f106001:87;f108001:1256;f110001:1;f201001:86;f301001:128;f306001:1;f501001:2;f502001:4;f502002:5;f503001:330;f505001:3;f601002:10;f602002:12;f603002:2;f604002:2;f605002:3;f606002:2;f607001:2;f608001:2;f609001:2;f610001:1;f611001:11;f804003:3;f805003:8;f806003:8;f807003:10;f804004:1;f805004:4;f806004:4;f807004:5;f808001:589;f809001:43;f810001:1;f808002:584;f809002:49;f810002:1;f9916:518;f9917:487;f9918:362;f115001:2;f9501:16;f9502:18;f9503:21";
        for(int i=0;i<50;i++){
            sample.put(i,featureStr);
        }

        long start=System.currentTimeMillis();
        for(int k=0;k<100000;k++){
            Map result = model.predictStr(sample);
            if (k%1000==0){
                long end=System.currentTimeMillis();
                System.out.println(end-start);
                start=System.currentTimeMillis();
            }
        }
    }

    private static DenseCoder getDenseCoder2ByKeyFromJedis(String modelKey, JedisUtil redis) {
        DenseCoder ret = null;

        if (AssertUtil.isAnyEmpty(modelKey)) {
            System.out.println("getModelByKeyFromJedis empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            // 获取缓存Key
            String key = "nz_last_model_new_" + modelKey + "_";
            System.out.println("read model with key=" + key);
            // 保存


            String ret1 = null;

            ret1 = redis.get(key);

            String ret2 = StringZIP.unzipString(ret1);// 解压
            // 解压
            ret = JSON.parseObject(ret2, DenseCoder.class);

        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }

}
