package cn.com.duiba.nezha.alg.example.example;

import cn.com.duiba.nezha.alg.alg.vo.strongtargetexplore.STEParams;
import cn.com.duiba.nezha.alg.example.constant.ProjectConstant;
import cn.com.duiba.nezha.alg.example.util.JedisUtil;
import cn.com.duiba.nezha.alg.example.util.conf.JedisPoolConf;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

public class STEParamsSaver {
    public static JedisUtil jedisUtil = new JedisUtil(JedisPoolConf.jedisConfig);

    public static void saveNdAdvertParamByKeyToJedis(String modelKey, STEParams param, JedisUtil ju) {
        if (cn.com.duiba.nezha.alg.common.util.AssertUtil.isAnyEmpty(modelKey, param)) {
            System.out.println("save empty, modelKey=" + modelKey);
            return;
        }
        try {
            // 获取缓存Key
            String key = modelKey;

            // 保存
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString(param);

            ju.setex(key, value, ProjectConstant.YEAR_1_EXPIRE);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        STEParams steParams = new STEParams();

        // 数据置信最小维度上统计CVR大于设定的阈值
        steParams.setClickConfidenceThreshold(5000);
        steParams.setSepStageThreshold(300);
        steParams.setColdStartThreshold1(50);
        steParams.setColdStartThreshold2(100);
        steParams.setColdStartThreshold3(150);
        steParams.setExposeConfidenceThreshold2(600);

        // 数据置信最小维度上统计CVR的阈值 => 用于辅助判断是走哪套扶持参数
        steParams.setMinDimStatsCvrThreshold(0.01);

        // 数据置信最小维度上统计CVR小于设定的阈值 => 参数与上个块中相同
        steParams.setClickConfidenceThresholdSet2(20000);
        steParams.setSepStageThresholdSet2(1200);
        steParams.setColdStartThresholdSet4(200);
        steParams.setColdStartThresholdSet5(400);
        steParams.setColdStartThresholdSet6(600);
        steParams.setExposeConfidenceThresholdSet5(2000);

        // 因子上限设置
        steParams.setExposureUpperBound1(1.21);
        steParams.setExposureK1(-3.5 * Math.pow(10, -4));
        steParams.setExposureUpperBound2(1.20);
        steParams.setExposureK2(-1 * Math.pow(10, -4));

        // 衰减函数相关参数（candis中扶持因子随序衰减）
        steParams.setAlpha(0.6);
        steParams.setBeta(1.0);
        steParams.setBias(0.0);

        saveNdAdvertParamByKeyToJedis("NZ_K86_STE", steParams, jedisUtil);
        System.out.println(JSONObject.toJSONString(steParams));

    }

}