/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.example.util;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.StringZIP;
import cn.com.duiba.nezha.alg.example.constant.ProjectConstant;
import cn.com.duiba.nezha.alg.example.constant.PsConstant;
import cn.com.duiba.nezha.alg.example.util.JedisUtil;
import cn.com.duiba.nezha.alg.example.util.MongoUtil;
import cn.com.duiba.nezha.alg.example.util.conf.JedisPoolConf;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.FFM;
import cn.com.duiba.nezha.alg.model.FM;
import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StdModelSave {
    public static JedisUtil jedisUtil = new JedisUtil(JedisPoolConf.jedisConfig);

    private static String getLastModelKey(String modelKey) {
        return "nz_last_model_new_" + modelKey + "_";
    }

    private static String getADXModelKey(String modelKey) {
        return "TAE:ALGBID:MODEL:" + modelKey;
    }

    public static void saveModelByKeyToMD(String modelKey, FM model) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey, model})) {
            System.out.println("saveCTRLastModelByKeyToES empty,modelKey=" + modelKey);
            return;
        }
        try {
            String key = StdModelSave.getLastModelKey(modelKey);
            HashMap<String, FM> map = new HashMap<String, FM>();
            map.put(key, model);
            System.out.println("save model with key " + key);
            MongoUtil.bulkWriteUpdateT(PsConstant.MODEL_TYPE, map, "model update");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static FM getModelByKeyFromMD(String modelKey) {
        FM ret = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey})) {
            System.out.println("getCTRModelByKeyFromMD empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            String key = StdModelSave.getLastModelKey(modelKey);
            System.out.println("read model with key=" + key);
            ret = MongoUtil.findByIdT(PsConstant.MODEL_TYPE, key, FM.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static void saveModelByKeyToMDFFM(String modelKey, FFM model) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey, model})) {
            System.out.println("saveCTRLastModelByKeyToES empty,modelKey=" + modelKey);
            return;
        }
        try {
            String key = StdModelSave.getLastModelKey(modelKey);
            HashMap<String, FFM> map = new HashMap<String, FFM>();
            map.put(key, model);
            System.out.println("save model with key " + key);
            MongoUtil.bulkWriteUpdateT(PsConstant.MODEL_TYPE, map, "model update");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static FFM getModelByKeyFromMDFFM(String modelKey) {
        FFM ret = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey})) {
            System.out.println("getCTRModelByKeyFromMD empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            String key = StdModelSave.getLastModelKey(modelKey);
            System.out.println("read model with key=" + key);
            ret = MongoUtil.findByIdT(PsConstant.MODEL_TYPE, key, FFM.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static void saveModelByKeyToJedis(String modelKey, FM model) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey, model})) {
            System.out.println("saveCTRLastModelByKeyToES empty,modelKey=" + modelKey);
            return;
        }
        try {
            String key = StdModelSave.getLastModelKey(modelKey);
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString((Object)model);
            String value2 = StringZIP.zipString((String)value);
            jedisUtil.setex(key, value2, ProjectConstant.WEEK_1_EXPIRE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static FM getModelByRedisKeyFromJedis(String redisKey) {
        FM ret = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{redisKey})) {
            System.out.println("getModelByRedisKeyFromJedis empty,redisKey=" + redisKey);
            return ret;
        }
        try {
            String key = redisKey;
            String ret1 = jedisUtil.get(key);
            String ret2 = StringZIP.unzipString((String)ret1);
            ret = (FM)JSON.parseObject((String)ret2, FM.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static FM getModelByKeyFromJedis(String modelKey) {
        FM ret = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey})) {
            System.out.println("getCTRModelByKeyFromMD empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            String key = StdModelSave.getLastModelKey(modelKey);
            String ret1 = jedisUtil.get(key);
            String ret2 = StringZIP.unzipString((String)ret1);
            ret = (FM)JSON.parseObject((String)ret2, FM.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static Map<String, Double> getMapByKeyFromJedis(String key) {
        Map ret = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{key})) {
            System.out.println("getCTRModelByKeyFromMD empty,modelKey=" + key);
            return ret;
        }
        try {
            String ret1 = jedisUtil.get(key);
            String ret2 = StringZIP.unzipString((String)ret1);
            ret = (Map)JSON.parseObject((String)ret2, Map.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static List<String> getListByKeyFromJedis(String key) {
        List ret = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{key})) {
            System.out.println("getCTRModelByKeyFromMD empty,modelKey=" + key);
            return ret;
        }
        try {
            String ret1 = jedisUtil.get(key);
            ret = (List)JSON.parseObject((String)ret1, List.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static void saveADXModelByKeyToJedis(String modelKey, FM model) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey, model})) {
            System.out.println("saveCTRLastModelByKeyToES empty,modelKey=" + modelKey);
            return;
        }
        try {
            String key = StdModelSave.getADXModelKey(modelKey);
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString((Object)model);
            String value2 = StringZIP.zipString((String)value);
            jedisUtil.setex(key, value2, ProjectConstant.WEEK_1_EXPIRE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static FM getModelByKeyFromJedis(String modelKey, JedisUtil ju) {
        FM ret = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey})) {
            System.out.println("getCTRModelByKeyFromMD empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            String key = StdModelSave.getLastModelKey(modelKey);
            System.out.println("read model with key=" + key);
            String ret1 = ju.get(key);
            String ret2 = StringZIP.unzipString((String)ret1);
            ret = (FM)JSON.parseObject((String)ret2, FM.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static CODER getCODERModelByKeyFromJedis(String modelKey, JedisUtil ju) {
        CODER ret = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey})) {
            System.out.println("getCTRModelByKeyFromMD empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            String key = StdModelSave.getLastModelKey(modelKey);
            System.out.println("read model with key=" + key);
            String ret1 = ju.get(key);
            String ret2 = StringZIP.unzipString((String)ret1);
            ret = (CODER)JSON.parseObject((String)ret2, CODER.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static CODER getADXCODERModelByKeyFromJedis(String modelKey, JedisUtil ju) {
        CODER ret = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey})) {
            System.out.println("getCTRModelByKeyFromMD empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            String key = StdModelSave.getADXModelKey(modelKey);
            System.out.println("read model with key=" + key);
            String ret1 = ju.get(key);
            String ret2 = StringZIP.unzipString((String)ret1);
            ret = (CODER)JSON.parseObject((String)ret2, CODER.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static FM getADXModelByKeyFromJedis(String modelKey, JedisUtil ju) {
        FM ret = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey})) {
            System.out.println("getCTRModelByKeyFromMD empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            String key = StdModelSave.getADXModelKey(modelKey);
            System.out.println("read model with key=" + key);
            String ret1 = ju.get(key);
            String ret2 = StringZIP.unzipString((String)ret1);
            ret = (FM)JSON.parseObject((String)ret2, FM.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static FM getADXModelByKeyFromJedis(String modelKey) {
        FM ret = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey})) {
            System.out.println("getCTRModelByKeyFromMD empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            String key = StdModelSave.getADXModelKey(modelKey);
            System.out.println("read model with key=" + key);
            String ret1 = jedisUtil.get(key);
            String ret2 = StringZIP.unzipString((String)ret1);
            ret = (FM)JSON.parseObject((String)ret2, FM.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static void saveModelByKeyToJedis(String modelKey, FM model, JedisUtil ju) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey, model})) {
            System.out.println("saveCTRLastModelByKeyToES empty,modelKey=" + modelKey);
            return;
        }
        try {
            String key = StdModelSave.getLastModelKey(modelKey);
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString((Object)model);
            String value2 = StringZIP.zipString((String)value);
            ju.setex(key, value2, ProjectConstant.YEAR_1_EXPIRE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveListByKeyToJedis(String key, List<String> map, JedisUtil ju) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{key, map})) {
            System.out.println("saveCTRLastModelByKeyToES empty,modelKey=" + key);
            return;
        }
        try {
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString(map);
            ju.setex(key, value, ProjectConstant.YEAR_1_EXPIRE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveMapByKeyToJedis(String key, Map<String, Double> map, JedisUtil ju) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{key, map})) {
            System.out.println("saveCTRLastModelByKeyToES empty,modelKey=" + key);
            return;
        }
        try {
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString(map);
            String value2 = StringZIP.zipString((String)value);
            ju.setex(key, value2, ProjectConstant.YEAR_1_EXPIRE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveADXModelByKeyToJedis(String modelKey, FM model, JedisUtil ju) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey, model})) {
            System.out.println("saveCTRLastModelByKeyToES empty,modelKey=" + modelKey);
            return;
        }
        try {
            String key = StdModelSave.getADXModelKey(modelKey);
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString((Object)model);
            String value2 = StringZIP.zipString((String)value);
            ju.setex(key, value2, ProjectConstant.YEAR_1_EXPIRE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveCODERModelByKeyToJedis(String modelKey, CODER model, JedisUtil ju) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey, model})) {
            System.out.println("saveCTRLastModelByKeyToES empty,modelKey=" + modelKey);
            return;
        }
        try {
            String key = StdModelSave.getLastModelKey(modelKey);
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString((Object)model);
            String value2 = StringZIP.zipString((String)value);
            ju.setex(key, value2, ProjectConstant.YEAR_1_EXPIRE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveADXCODERModelByKeyToJedis(String modelKey, CODER model, JedisUtil ju) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey, model})) {
            System.out.println("saveCTRLastModelByKeyToES empty,modelKey=" + modelKey);
            return;
        }
        try {
            String key = StdModelSave.getADXModelKey(modelKey);
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString((Object)model);
            String value2 = StringZIP.zipString((String)value);
            ju.setex(key, value2, ProjectConstant.YEAR_1_EXPIRE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveModelByKeyToJedisFFM(String modelKey, FFM model) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey, model})) {
            System.out.println("saveCTRLastModelByKeyToES empty,modelKey=" + modelKey);
            return;
        }
        try {
            String key = StdModelSave.getLastModelKey(modelKey);
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString((Object)model);
            String value2 = StringZIP.zipString((String)value);
            jedisUtil.setex(key, value2, ProjectConstant.YEAR_1_EXPIRE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveModelByKeyToJedisFFM(String modelKey, FFM model, JedisUtil ju) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey, model})) {
            System.out.println("saveCTRLastModelByKeyToES empty,modelKey=" + modelKey);
            return;
        }
        try {
            String key = StdModelSave.getLastModelKey(modelKey);
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString((Object)model);
            String value2 = StringZIP.zipString((String)value);
            ju.setex(key, value2, ProjectConstant.WEEK_1_EXPIRE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static FFM getModelByKeyFromJedisFFM(String modelKey) {
        FFM ret = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey})) {
            System.out.println("getCTRModelByKeyFromMD empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            String key = StdModelSave.getLastModelKey(modelKey);
            System.out.println("read model with key=" + key);
            String ret1 = jedisUtil.get(key);
            String ret2 = StringZIP.unzipString((String)ret1);
            ret = (FFM)JSON.parseObject((String)ret2, FFM.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static FFM getModelByKeyFromJedisFFM(String modelKey, JedisUtil ju) {
        FFM ret = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey})) {
            System.out.println("getCTRModelByKeyFromMD empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            String key = StdModelSave.getLastModelKey(modelKey);
            System.out.println("read model with key=" + key);
            String ret1 = ju.get(key);
            String ret2 = StringZIP.unzipString((String)ret1);
            ret = (FFM)JSON.parseObject((String)ret2, FFM.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static void saveDataByKeyToJedis(String modelKey, Map<String, String> model) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey, model})) {
            System.out.println("saveCTRLastModelByKeyToES empty,modelKey=" + modelKey);
            return;
        }
        try {
            System.out.println("save model with key " + modelKey);
            String value = JSON.toJSONString(model);
            String value2 = StringZIP.zipString((String)value);
            jedisUtil.setex(modelKey, value2, ProjectConstant.WEEK_1_EXPIRE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Map<String, String> getDataByKeyToJedis(String modelKey) {
        Map ret = null;
        try {
            String ret1 = jedisUtil.get(modelKey);
            String ret2 = StringZIP.unzipString((String)ret1);
            ret = (Map)JSON.parseObject((String)ret2, Map.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }
}

