package cn.com.duiba.nezha.alg.example.util;

import cn.com.duiba.nezha.alg.common.util.StringZIP;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.example.util.conf.JedisPoolConf;
//import cn.com.duiba.nezha.compute.biz.conf.MongoDbConf;
import cn.com.duiba.nezha.alg.example.constant.ProjectConstant;
//import cn.com.duiba.nezha.compute.biz.dto.DenseCoderDo;
//import cn.com.duiba.nezha.compute.biz.utils.mongodb.MongoClientUtil;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;




import com.alibaba.fastjson.JSON;

public class StdCoderModelSaveBo {


//    public static MongoClientUtil mongoClientUtil = new MongoClientUtil(MongoDbConf.config);

    public static JedisUtil jedisUtil = new JedisUtil(JedisPoolConf.jedisConfig);


    /**
     * @param modelKey
     * @return
     */
    private static String getLastModelKey(String modelKey) {

        return "nz_last_model_new_" + modelKey + "_";
    }


//    /**
//     * @param modelKey
//     * @param denseCoderDo
//     * @return
//     */
//    public static void saveFieldCoderByKeyToJedis(String modelKey, DenseCoderDo denseCoderDo) {
//
//        if (cn.com.duiba.nezha.alg.common.util.AssertUtil.isAnyEmpty(modelKey, denseCoderDo)) {
//            System.out.println("saveModelByKeyToJedis,modelKey=" + modelKey);
//            return;
//        }
//        try {
//            // 获取缓存Key
//            String key = getLastModelKey(modelKey);
//            // 保存
//            System.out.println("save model with key " + key);
//            String value = JSON.toJSONString(denseCoderDo);
//            String value2 = StringZIP.zipString(value); //压缩
//
//            jedisUtil.setex(key, value2, ProjectConstant.WEEK_1_EXPIRE);
//
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//    }
//
//
//    /**
//     * @param modelKey
//     * @return
//     */
//    public static DenseCoderDo getFieldCoderByKeyFromJedis(String modelKey) {
//        DenseCoderDo ret = null;
//
//        if (AssertUtil.isAnyEmpty(modelKey)) {
//            System.out.println("getModelByKeyFromJedis empty,modelKey=" + modelKey);
//            return ret;
//        }
//        try {
//            // 获取缓存Key
//            String key = getLastModelKey(modelKey);
//            System.out.println("read model with key=" + key);
//            // 保存
//            String ret1 = jedisUtil.get(key);
//            String ret2 = StringZIP.unzipString(ret1);// 解压
//            // 解压
//            ret = JSON.parseObject(ret2, DenseCoderDo.class);
//
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//
//        return ret;
//    }


    /**
     * @param modelKey
     * @param CODER
     * @return
     */
    public static void saveModelCoderByKeyToJedis(String modelKey, CODER CODER) {

        if (cn.com.duiba.nezha.alg.common.util.AssertUtil.isAnyEmpty(modelKey, CODER)) {
            System.out.println("saveModelByKeyToJedis,modelKey=" + modelKey);
            return;
        }
        try {
            // 获取缓存Key
            String key = getLastModelKey(modelKey);
            // 保存
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString(CODER);
            String value2 = StringZIP.zipString(value); //压缩

            jedisUtil.setex(key, value2, ProjectConstant.WEEK_1_EXPIRE);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    /**
     * @param modelKey
     * @return
     */
    public static CODER getModelCoderByKeyFromJedis(String modelKey) {
        CODER ret = null;

        if (AssertUtil.isAnyEmpty(modelKey)) {
            System.out.println("getModelByKeyFromJedis empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            // 获取缓存Key
            String key = getLastModelKey(modelKey);
            System.out.println("read model with key=" + key);
            // 保存
            String ret1 = jedisUtil.get(key);
            String ret2 = StringZIP.unzipString(ret1);// 解压
            // 解压
            ret = JSON.parseObject(ret2, CODER.class);

        } catch (Exception e) {
            e.printStackTrace();
        }

        return ret;
    }

}
