/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.example.util;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.StringZIP;
import cn.com.duiba.nezha.alg.example.constant.ProjectConstant;
import cn.com.duiba.nezha.alg.example.constant.PsConstant;
import cn.com.duiba.nezha.alg.example.util.JedisUtil;
import cn.com.duiba.nezha.alg.example.util.MongoUtil;
import cn.com.duiba.nezha.alg.example.util.conf.JedisPoolConf;
import cn.com.duiba.nezha.alg.model.FFM;
import cn.com.duiba.nezha.alg.model.FM;
import com.alibaba.fastjson.JSON;
import java.util.HashMap;

public class StdModelSave {
    public static JedisUtil jedisUtil = new JedisUtil(JedisPoolConf.jedisConfig);

    private static String getLastModelKey(String modelKey) {
        return "nz_last_model_new_" + modelKey + "_";
    }

    public static void saveModelByKeyToMD(String modelKey, FM model) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey, model})) {
            System.out.println("saveCTRLastModelByKeyToES empty,modelKey=" + modelKey);
            return;
        }
        try {
            String key = StdModelSave.getLastModelKey(modelKey);
            HashMap<String, FM> map = new HashMap<String, FM>();
            map.put(key, model);
            System.out.println("save model with key " + key);
            MongoUtil.bulkWriteUpdateT(PsConstant.MODEL_TYPE, map, "model update");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static FM getModelByKeyFromMD(String modelKey) {
        FM ret = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey})) {
            System.out.println("getCTRModelByKeyFromMD empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            String key = StdModelSave.getLastModelKey(modelKey);
            System.out.println("read model with key=" + key);
            ret = MongoUtil.findByIdT(PsConstant.MODEL_TYPE, key, FM.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static void saveModelByKeyToMDFFM(String modelKey, FFM model) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey, model})) {
            System.out.println("saveCTRLastModelByKeyToES empty,modelKey=" + modelKey);
            return;
        }
        try {
            String key = StdModelSave.getLastModelKey(modelKey);
            HashMap<String, FFM> map = new HashMap<String, FFM>();
            map.put(key, model);
            System.out.println("save model with key " + key);
            MongoUtil.bulkWriteUpdateT(PsConstant.MODEL_TYPE, map, "model update");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static FFM getModelByKeyFromMDFFM(String modelKey) {
        FFM ret = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey})) {
            System.out.println("getCTRModelByKeyFromMD empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            String key = StdModelSave.getLastModelKey(modelKey);
            System.out.println("read model with key=" + key);
            ret = MongoUtil.findByIdT(PsConstant.MODEL_TYPE, key, FFM.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static void saveModelByKeyToJedis(String modelKey, FM model) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey, model})) {
            System.out.println("saveCTRLastModelByKeyToES empty,modelKey=" + modelKey);
            return;
        }
        try {
            String key = StdModelSave.getLastModelKey(modelKey);
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString((Object)model);
            String value2 = StringZIP.zipString((String)value);
            jedisUtil.setex(key, value2, ProjectConstant.WEEK_1_EXPIRE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static FM getModelByKeyFromJedis(String modelKey) {
        FM ret = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey})) {
            System.out.println("getCTRModelByKeyFromMD empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            String key = StdModelSave.getLastModelKey(modelKey);
            System.out.println("read model with key=" + key);
            String ret1 = jedisUtil.get(key);
            String ret2 = StringZIP.unzipString((String)ret1);
            ret = (FM)JSON.parseObject((String)ret2, FM.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static void saveModelByKeyToJedisFFM(String modelKey, FFM model) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey, model})) {
            System.out.println("saveCTRLastModelByKeyToES empty,modelKey=" + modelKey);
            return;
        }
        try {
            String key = StdModelSave.getLastModelKey(modelKey);
            System.out.println("save model with key " + key);
            String value = JSON.toJSONString((Object)model);
            String value2 = StringZIP.zipString((String)value);
            jedisUtil.setex(key, value2, ProjectConstant.WEEK_1_EXPIRE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static FFM getModelByKeyFromJedisFFM(String modelKey) {
        FFM ret = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{modelKey})) {
            System.out.println("getCTRModelByKeyFromMD empty,modelKey=" + modelKey);
            return ret;
        }
        try {
            String key = StdModelSave.getLastModelKey(modelKey);
            System.out.println("read model with key=" + key);
            String ret1 = jedisUtil.get(key);
            String ret2 = StringZIP.unzipString((String)ret1);
            ret = (FFM)JSON.parseObject((String)ret2, FFM.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }
}

