package cn.com.duiba.nezha.alg.example.example.dpa;

import cn.com.duiba.nezha.alg.alg.dpa.PackageRecall;
import cn.com.duiba.nezha.alg.alg.vo.dpa.PackageInfoDo;
import cn.com.duiba.nezha.alg.alg.vo.dpa.PackageRecallDo;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.ActivityMatchInfo;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import junit.framework.TestCase;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author lijingzhe
 * @description 召回本地测试
 * @date 2020/6/21
 */
public class DPATest extends TestCase {

     public void testActivityRecall() throws Exception{
        String algPath="/Users/lijingzhe/codes/duiba_sql/activityIds40";
        BufferedReader algR = null;
        String algjs = "";
        try {
            FileInputStream algFs = new FileInputStream(algPath);
            InputStreamReader algIr = new InputStreamReader(algFs, "UTF-8");
            algR = new BufferedReader(algIr);
            String alg = null, alg48 = null;
            while ((alg = algR.readLine()) != null) {
                algjs += alg;
            }
            algR.close();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (algR != null) {
                try {
                    algR.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        JSONArray algJa = JSON.parseArray(algjs);
        List<PackageInfoDo> pks = new ArrayList<>();
        List<String> ps = new ArrayList<>();
        Map<Long,PackageInfoDo> pkm = new HashMap<>();
        for (int i = 0; i < algJa.size(); i++) {
            ActivityMatchInfo actD = algJa.getJSONObject(i).toJavaObject(ActivityMatchInfo.class);
            PackageInfoDo pk = new PackageInfoDo();
            pk.setSlotId(actD.getSlotId());
            pk.getPackageIdDo().setActivityId(actD.getActivityId());
            pk.setReuqest(actD.getHisRequest().slotVal);
            pk.setGlobalReuqest(actD.getHisRequest().globalVal);
            pk.setClick(actD.getHisClick().slotVal);
            pk.setGlobalClick(actD.getHisClick().globalVal);
            pk.setCost(actD.getHisCost().slotVal);
            pk.setGlobalCost(actD.getHisCost().globalVal);
            pk.setEffect(actD.getHisEffect().slotVal);
            pk.setGlobalEffect(actD.getHisEffect().globalVal);
            pks.add(pk);
            ps.add(JSONObject.toJSONString(pk));
            pkm.put(pk.getPackageIdDo().getActivityId(),pk);
        }
        System.out.println("input:" + ps);

        PackageRecall recall = new PackageRecall();
        int request = 10000;
        Map<Long,String> wils = new HashMap<>();
        Map<Long,String> ucbs = new HashMap<>();
        for(int i = 0; i < request; i++){
            List<PackageRecallDo> wil = recall.matchPackage(pks, 10, 2, 0);
            for (PackageRecallDo w : wil) {
                long activityId = w.getPackageInfoDo().getPackageIdDo().getActivityId();
                String smStr = wils.getOrDefault(activityId, "");
                StateMatch sm = smStr.isEmpty() ? new StateMatch() : JSONObject.parseObject(smStr, StateMatch.class);
                sm.acitivtyId = activityId;
                sm.count += 1;
                sm.cost += w.getPackageInfoDo().getReuqest() > 0 ? w.getPackageInfoDo().getCost()/w.getPackageInfoDo().getReuqest(): 0;
                wils.put(activityId, JSON.toJSONString(sm));
            }
            List<PackageRecallDo> ucb = recall.ucbPackage(pks, 10, 1, 2);
            for (PackageRecallDo u : ucb) {
                long activityId = u.getPackageInfoDo().getPackageIdDo().getActivityId();
                String smStr = ucbs.getOrDefault(activityId, "");
                StateMatch sm = smStr.isEmpty() ? new StateMatch() : JSONObject.parseObject(smStr, StateMatch.class);
                sm.acitivtyId = activityId;
                sm.count += 1;
                sm.cost += u.getPackageInfoDo().getReuqest() > 0 ? u.getPackageInfoDo().getCost()/u.getPackageInfoDo().getReuqest(): 0;
                ucbs.put(activityId, JSON.toJSONString(sm));
            }
        }
        System.out.println("wilson:" + wils.values());
        System.out.println("=======================================================");
        System.out.println("ucb:" + ucbs.values());
    }

    public void PackageRecallTest() throws Exception{

    }

    static class StateMatch{
        long acitivtyId;
        int count;
        double cost;

        public long getAcitivtyId() {
            return acitivtyId;
        }

        public int getCount() {
            return count;
        }

        public double getCost() {
            return cost;
        }

        public void setAcitivtyId(long acitivtyId) {
            this.acitivtyId = acitivtyId;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public void setCost(double cost) {
            this.cost = cost;
        }
    }
}
