package cn.com.duiba.nezha.alg.example.util.conf;


import cn.com.duiba.nezha.alg.example.constant.ProjectConstant;
import redis.clients.jedis.JedisPoolConfig;

import java.io.FileNotFoundException;

/**
 * Created by pc on 2016/11/18.
 */
public class JedisPoolConf {


    public static JedisPoolConfig poolConfig;

    public static JedisConfig jedisConfig;
    public static JedisConfig testJedisConfig;

    public static JedisConfig actJedisConfig;

    public static JedisConfig dpaActJedisConfig;

    public static JedisConfig materialJedisConfig;

    public static JedisConfig adxJedisConfig;

    public static JedisConfig rtaJedisConfig;

    public static JedisConfig rtaTestJedisConfig;

    static {
        try {
            initJedisPoolConfig();
            initJedisConfig();
            initTestJedisConfig();

            initActJedisConfig();
            initDpaActJedisConfig();
            initAdxJedisConfig();
            initRtaJedisConfig();
            initRtaTestJedisConfig();

        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private static void initDpaActJedisConfig() throws Exception {
        String ip = ConfigFactory.getInstance().getConfigProperties(ProjectConstant.CONFIG_PATH).getProperty(ProjectConstant.REDIS_DPA_ACT_IP);
        String passWord = ConfigFactory.getInstance().getConfigProperties(ProjectConstant.CONFIG_PATH).getProperty(ProjectConstant.REDIS_DPA_ACT_PW);
        int port = ConfigFactory.getInstance().getConfigProperties(ProjectConstant.CONFIG_PATH).getInt(ProjectConstant.REDIS_DPA_ACT_PORT, ProjectConstant.REDIS_PORT_DEAFULT);

        dpaActJedisConfig = new JedisConfig();
        dpaActJedisConfig.setIp(ip);
        dpaActJedisConfig.setPassWord(passWord);
        dpaActJedisConfig.setPort(port);
    }

    private static void initJedisPoolConfig() {
        poolConfig = new JedisPoolConfig();
        poolConfig.setMaxIdle(ProjectConstant.MAX_IDLE);
        poolConfig.setMinIdle(ProjectConstant.MIN_IDLE);
        poolConfig.setMaxTotal(ProjectConstant.MAX_TOTAL);
        poolConfig.setMaxWaitMillis(ProjectConstant.MAX_WAIT_MILLIS);
        poolConfig.setTestOnBorrow(ProjectConstant.TEST_ON_BORROW);
        poolConfig.setTestOnReturn(ProjectConstant.TEST_ON_RETURN);
    }


    private static void initJedisConfig() throws Exception {

        String ip = ConfigFactory.getInstance().getConfigProperties(ProjectConstant.CONFIG_PATH).getProperty(ProjectConstant.REDIS_IP);
        String passWord = ConfigFactory.getInstance().getConfigProperties(ProjectConstant.CONFIG_PATH).getProperty(ProjectConstant.REDIS_PW);
        int port = ConfigFactory.getInstance().getConfigProperties(ProjectConstant.CONFIG_PATH).getInt(ProjectConstant.REDIS_PORT, ProjectConstant.REDIS_PORT_DEAFULT);

        jedisConfig = new JedisConfig();
        jedisConfig.setIp(ip);
        jedisConfig.setPassWord(passWord);
        jedisConfig.setPort(port);

    }


    private static void initTestJedisConfig() throws Exception {

        String ip = ConfigFactory.getInstance().getConfigProperties(ProjectConstant.CONFIG_PATH).getProperty(ProjectConstant.REDIS_TEST_IP);
        String passWord = ConfigFactory.getInstance().getConfigProperties(ProjectConstant.CONFIG_PATH).getProperty(ProjectConstant.REDIS_TEST_PW);
        int port = ConfigFactory.getInstance().getConfigProperties(ProjectConstant.CONFIG_PATH).getInt(ProjectConstant.REDIS_TEST_PORT, ProjectConstant.REDIS_PORT_DEAFULT);

        testJedisConfig = new JedisConfig();
        testJedisConfig.setIp(ip);
        testJedisConfig.setPassWord(passWord);
        testJedisConfig.setPort(port);

    }

    private static void initActJedisConfig() throws Exception {

        String ip = ConfigFactory.getInstance().getConfigProperties(ProjectConstant.CONFIG_PATH).getProperty(ProjectConstant.REDIS_ACT_IP);
        String passWord = ConfigFactory.getInstance().getConfigProperties(ProjectConstant.CONFIG_PATH).getProperty(ProjectConstant.REDIS_ACT_PW);
        int port = ConfigFactory.getInstance().getConfigProperties(ProjectConstant.CONFIG_PATH).getInt(ProjectConstant.REDIS_ACT_PORT, ProjectConstant.REDIS_PORT_DEAFULT);

        actJedisConfig = new JedisConfig();
        actJedisConfig.setIp(ip);
        actJedisConfig.setPassWord(passWord);
        actJedisConfig.setPort(port);

    }

    private static void initAdxJedisConfig() throws Exception {

        String ip = ConfigFactory.getInstance().getConfigProperties(ProjectConstant.CONFIG_PATH).getProperty(ProjectConstant.REDIS_ADX_IP);
        String passWord = ConfigFactory.getInstance().getConfigProperties(ProjectConstant.CONFIG_PATH).getProperty(ProjectConstant.REDIS_ADX_PW);
        int port = ConfigFactory.getInstance().getConfigProperties(ProjectConstant.CONFIG_PATH).getInt(ProjectConstant.REDIS_ADX_PORT, ProjectConstant.REDIS_PORT_DEAFULT);

        adxJedisConfig = new JedisConfig();
        adxJedisConfig.setIp(ip);
        adxJedisConfig.setPassWord(passWord);
        adxJedisConfig.setPort(port);

    }

    private static void initRtaJedisConfig() throws Exception {

        String ip = ConfigFactory.getInstance().getConfigProperties(ProjectConstant.CONFIG_PATH).getProperty(ProjectConstant.REDIS_RTA_IP);
        String passWord = ConfigFactory.getInstance().getConfigProperties(ProjectConstant.CONFIG_PATH).getProperty(ProjectConstant.REDIS_RTA_PW);
        int port = ConfigFactory.getInstance().getConfigProperties(ProjectConstant.CONFIG_PATH).getInt(ProjectConstant.REDIS_RTA_PORT, ProjectConstant.REDIS_PORT_DEAFULT);

        rtaJedisConfig = new JedisConfig();
        rtaJedisConfig.setIp(ip);
        rtaJedisConfig.setPassWord(passWord);
        rtaJedisConfig.setPort(port);

    }


    private static void initRtaTestJedisConfig() throws Exception {

        String ip = ConfigFactory.getInstance().getConfigProperties(ProjectConstant.CONFIG_PATH).getProperty(ProjectConstant.REDIS_RTA_TEST_IP);
        String passWord = ConfigFactory.getInstance().getConfigProperties(ProjectConstant.CONFIG_PATH).getProperty(ProjectConstant.REDIS_RTA_TEST_PW);
        int port = ConfigFactory.getInstance().getConfigProperties(ProjectConstant.CONFIG_PATH).getInt(ProjectConstant.REDIS_RTA_TEST_PORT, ProjectConstant.REDIS_PORT_DEAFULT);

        rtaTestJedisConfig = new JedisConfig();
        rtaTestJedisConfig.setIp(ip);
        rtaTestJedisConfig.setPassWord(passWord);
        rtaTestJedisConfig.setPort(port);

    }


}
