/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.example.util.conf;

import cn.com.duiba.nezha.alg.example.constant.ProjectConstant;
import cn.com.duiba.nezha.alg.example.util.conf.ConfigFactory;
import cn.com.duiba.nezha.alg.example.util.conf.JedisConfig;
import redis.clients.jedis.JedisPoolConfig;

public class JedisPoolConf {
    public static JedisPoolConfig poolConfig;
    public static JedisConfig jedisConfig;

    private static void initJedisPoolConfig() {
        poolConfig = new JedisPoolConfig();
        poolConfig.setMaxIdle(ProjectConstant.MAX_IDLE);
        poolConfig.setMinIdle(ProjectConstant.MIN_IDLE);
        poolConfig.setMaxTotal(ProjectConstant.MAX_TOTAL);
        poolConfig.setMaxWaitMillis((long)ProjectConstant.MAX_WAIT_MILLIS);
        poolConfig.setTestOnBorrow(ProjectConstant.TEST_ON_BORROW.booleanValue());
        poolConfig.setTestOnReturn(ProjectConstant.TEST_ON_RETURN.booleanValue());
    }

    private static void initJedisConfig() throws Exception {
        String ip = ConfigFactory.getInstance().getConfigProperties("/application.properties").getProperty(ProjectConstant.REDIS_IP);
        String passWord = ConfigFactory.getInstance().getConfigProperties("/application.properties").getProperty(ProjectConstant.REDIS_PW);
        int port = ConfigFactory.getInstance().getConfigProperties("/application.properties").getInt(ProjectConstant.REDIS_PORT, ProjectConstant.REDIS_PORT_DEAFULT);
        jedisConfig = new JedisConfig();
        jedisConfig.setIp(ip);
        jedisConfig.setPassWord(passWord);
        jedisConfig.setPort(port);
    }

    static {
        try {
            JedisPoolConf.initJedisPoolConfig();
            JedisPoolConf.initJedisConfig();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

