package cn.com.duiba.nezha.alg.example.example;

import cn.com.duiba.nezha.alg.alg.adx.rcmd.AdxIdeaDQNRcmder2;
import cn.com.duiba.nezha.alg.alg.plugins.ActPlugInDQNRcmder;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxIdeaFeatureDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxResourceRcmdDo;
import cn.com.duiba.nezha.alg.alg.vo.plug.ResPlugInRcmdDo;
import cn.com.duiba.nezha.alg.alg.vo.plug.ResPlugInStatDo;
import cn.com.duiba.nezha.alg.example.util.StdCoderModelSaveBo;
import cn.com.duiba.nezha.alg.feature.vo.ActFeatureDo;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import com.alibaba.fastjson.JSON;
import net.sf.json.JSONObject;
import org.junit.Test;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ActPlugInDQNRcmder2Test {

    @Test
    public void feaureParse() {

        ActFeatureDo actFeatureDo = new ActFeatureDo();

        actFeatureDo.setResPlugInId(1L);
        actFeatureDo.setResPlugInIndex(2L);
        actFeatureDo.setAppId(100L);
        actFeatureDo.setAreaCode(3301L);

        System.out.println(JSON.toJSONString(ActPlugInDQNRcmder.feaureParse(actFeatureDo)));

    }

    @Test
    public void rcmd() {


        //1 编码器获取 缓存
        CODER coderModel = StdCoderModelSaveBo.getModelCoderByKeyFromJedis("act_resplug_coder_dqn_v001", "act");

        //2 TF本地模型获取  缓存
        LocalTFModel ltfModel = new LocalTFModel();
        try {
            ltfModel.loadModel("/Users/lwj/Desktop/model2/");


            String plugListStr = "[{\"activityPage\":17918,\"dsm2A\":1,\"key\":\"279179_17918_1_2176_2\",\"resPlugInId\":2176,\"resPlugInIndex\":2,\"resPlugInStatDo\":{\"clickPv\":5021,\"convertPv\":336,\"costFee\":24955,\"joinPv\":131,\"launchCnt\":7230,\"resPlugInId\":2176,\"resPlugInIndex\":2,\"slotId\":279179,\"updateTime\":\"2019-12-12 16:04:52\",\"visitPv\":3563},\"slotId\":279179},{\"activityPage\":17918,\"dsm2A\":1,\"key\":\"279179_17918_1_2169_2\",\"resPlugInId\":2169,\"resPlugInIndex\":2,\"resPlugIn\n" +
                    "StatDo\":{\"clickPv\":4762,\"convertPv\":452,\"costFee\":26343,\"joinPv\":69,\"launchCnt\":7380,\"resPlugInId\":2169,\"resPlugInIndex\":2,\"slotId\":279179,\"updateTime\":\"2019-12-12 16:04:52\",\"visitPv\":3784},\"slotId\":279179},{\"activityPage\":17918,\"dsm2A\":1,\"key\":\"279179_17918_1_2156_0\",\"resPlugInId\":2156,\"resPlugInIndex\":0,\"resPlugInStatDo\":{\"clickPv\":1174,\"convertPv\":111,\"costFee\":7028,\"joinPv\":0,\"launchCnt\":1695,\"resPlugInId\":2156,\"resPlugInIndex\":0,\"slotId\":279179,\"updateTime\":\"2019-12-12 16:03:59\",\"visitPv\":1035},\"slotId\":279179},{\"activityPage\":17918,\"dsm2A\":1,\"key\":\"279179_17918_1_2041_2\",\"resPlugInId\":2041,\"resPlugInIndex\":2,\"resPlugInStatDo\":{\"clickPv\":4557,\"convertPv\":305,\"costFee\":25336,\"joinPv\":162,\"launchCnt\":7188,\"resPlugInId\":2041,\"resPlugInIndex\":2,\"slotId\":279179,\"updateTime\":\"2019-12-12 16:04:52\",\"visitPv\":3664},\"slotId\":279179},{\"activityPage\":17918,\"dsm2A\":1,\"key\":\"279179_17918_1_2041_4\",\"resPlugInId\":2041,\"resPlugInIndex\":4,\"resPlugInStatDo\":{\"clickPv\":4251,\"convertPv\":210,\"costFee\":26860,\"joinPv\":150,\"launchCnt\":5553,\"resPlugInId\":2041,\"resPlugInIndex\":4,\"slotId\":279179,\"updateTime\":\"2019-12-12 16:04:52\",\"visitPv\":3664},\"slotId\":279179},{\"activityPage\":17918,\"dsm2A\":1,\"key\":\"279179_17918_1_null_null\",\"resPlugInStatDo\":{},\"slotId\":279179},{\"activityPage\":16394,\"dsm\n" +
                    "2A\":1,\"key\":\"300643_16394_1_2140_4\",\"resPlugInId\":2140,\"resPlugInIndex\":4,\"resPlugInStatDo\":{},\"slotId\":300643}]";

            //3 创意特征对象List
            List<ResPlugInRcmdDo> plugList = JSON.parseArray(plugListStr, ResPlugInRcmdDo.class);
//            String p1S="";
//            ResPlugInRcmdDo p1 = JSON.parseObject(p1S,ResPlugInRcmdDo.class);


            //4 获取非创意特征（同点击率预估模型）

            //5 获取资源位创意推荐统计对象（算法1，入参）

            //6 预估

            String featureStr = "{\"activityId\":17918,\"activityPage\":17918,\"appId\":52250,\"areaCode\":3301,\"dsm2A\":1,\"slotId\":279179}";

            ActFeatureDo actFeatureDo = JSON.parseObject(featureStr, ActFeatureDo.class);
            actFeatureDo.setAppId(300L);
            actFeatureDo.setActivityId(30L);

//            coderModel = null;

            System.out.println("coder="+JSON.toJSONString(coderModel));

            Map<String, Long> retMap = new HashMap<>();
            System.out.println(LocalDateTime.now());

            for (int i = 0; i < 1; i++) {
                ResPlugInRcmdDo ret1 = ActPlugInDQNRcmder.rcmd(plugList, actFeatureDo, coderModel, ltfModel);

                System.out.println("ret="+JSON.toJSONString(ret1));
                if (ret1 != null) {
                    retMap.put(ret1.getKey(), retMap.getOrDefault(ret1.getKey(), 0L) + 1);
                } else {
                    retMap.put(null, retMap.getOrDefault(null, 0L) + 1);
                }

            }
            System.out.println("retMap=" + JSON.toJSONString(retMap));

            System.out.println(LocalDateTime.now());

        } catch (Exception e) {

            System.out.println(e);

        }
    }

    @Test
    public void rcmdWithMap() {
    }

    @Test
    public void rcmd2() {
    }
}