/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.example.util;

import cn.com.duiba.nezha.alg.alg.vo.adx.rta.RtaRoiControlModel;
import cn.com.duiba.nezha.alg.alg.vo.ee.AdExploreModel;
import cn.com.duiba.nezha.alg.alg.vo.ee.AppGroupDo;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.OcpxControlModel;
import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.common.util.StringZIP;
import cn.com.duiba.nezha.alg.example.util.JedisUtil;
import cn.com.duiba.nezha.alg.example.util.conf.JedisPoolConf;
import com.alibaba.fastjson.JSON;

public class StatSyncBo {
    public static JedisUtil jedisUtil = new JedisUtil(JedisPoolConf.jedisConfig);
    public static JedisUtil testJedisUtil = new JedisUtil(JedisPoolConf.jedisConfig);
    public static JedisUtil rtaJedisUtil = new JedisUtil(JedisPoolConf.rtaJedisConfig);
    public static JedisUtil rtaTestJedisUtil = new JedisUtil(JedisPoolConf.rtaTestJedisConfig);

    public static String getAdExploreModelKey(Long advertId) {
        return "NZ_K119_1_" + advertId;
    }

    public static String getAppGroupKey() {
        return "NZ_K119_2_app";
    }

    public static String getModelKey(String modelId, String groupId) {
        String ret = null;
        if (groupId != null) {
            ret = "NZ_K86_nz_alg_s_m_" + modelId + "_" + groupId;
        }
        if (groupId == null) {
            ret = "NZ_K86_nz_alg_s_m_" + modelId;
        }
        return ret;
    }

    public static void saveModelToRedis(OcpxControlModel ocpxControlModel, String modelId, int ttl) {
        String key = StatSyncBo.getModelKey(modelId, null);
        System.out.println("saveModelToRedis key=" + key);
        try {
            String value = JSON.toJSONString((Object)ocpxControlModel);
            String value2 = StringZIP.zipString((String)value);
            jedisUtil.setex(key, value2, ttl);
            String updateTimeKey = key + "_update_time";
            String updateTime = LocalDateUtil.getCurrentLocalDateTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS);
            jedisUtil.setex(updateTimeKey, updateTime, ttl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static OcpxControlModel readModelFromRedis(String modelId) {
        String key = StatSyncBo.getModelKey(modelId, null);
        OcpxControlModel ret = null;
        System.out.println("readModelFromRedis key=" + key);
        try {
            String ret1 = jedisUtil.get(key);
            String ret2 = StringZIP.unzipString((String)ret1);
            ret = (OcpxControlModel)JSON.parseObject((String)ret2, OcpxControlModel.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static RtaRoiControlModel readRtaRoiModelFromRedis(String modelId) {
        String key = StatSyncBo.getModelKey(modelId, null);
        RtaRoiControlModel ret = null;
        System.out.println("readRtaRoiModelFromRedis key=" + key);
        try {
            String ret1 = rtaJedisUtil.get(key);
            String ret2 = StringZIP.unzipString((String)ret1);
            ret = (RtaRoiControlModel)JSON.parseObject((String)ret2, RtaRoiControlModel.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static void saveRtaTestRoiModelToRedis(RtaRoiControlModel roiControlModel, String modelId, int ttl) {
        String key = StatSyncBo.getModelKey(modelId, null);
        System.out.println("saveModelToRedis key=" + key);
        try {
            String value = JSON.toJSONString((Object)roiControlModel);
            String value2 = StringZIP.zipString((String)value);
            rtaTestJedisUtil.setex(key, value2, ttl);
            String updateTimeKey = key + "_update_time";
            String updateTime = LocalDateUtil.getCurrentLocalDateTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS);
            rtaTestJedisUtil.setex(updateTimeKey, updateTime, ttl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static RtaRoiControlModel readRtaTestRoiModelFromRedis(String modelId) {
        String key = StatSyncBo.getModelKey(modelId, null);
        RtaRoiControlModel ret = null;
        System.out.println("readRtaRoiModelFromRedis key=" + key);
        try {
            String ret1 = rtaTestJedisUtil.get(key);
            String ret2 = StringZIP.unzipString((String)ret1);
            ret = (RtaRoiControlModel)JSON.parseObject((String)ret2, RtaRoiControlModel.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static void saveAdExploreModelToRedis(AdExploreModel model, String key, int ttl) {
        System.out.println("saveAdExploreModelToRedis key=" + key);
        try {
            String value = JSON.toJSONString((Object)model);
            String value2 = StringZIP.zipString((String)value);
            testJedisUtil.setex(key, value2, ttl);
            String updateTimeKey = key + "_update_time";
            String updateTime = LocalDateUtil.getCurrentLocalDateTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS);
            testJedisUtil.setex(updateTimeKey, updateTime, ttl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static AdExploreModel readAdExploreModelFromRedis(String key) {
        AdExploreModel ret = null;
        System.out.println("readRtaRoiModelFromRedis key=" + key);
        try {
            String ret1 = testJedisUtil.get(key);
            String ret2 = StringZIP.unzipString((String)ret1);
            ret = (AdExploreModel)JSON.parseObject((String)ret2, AdExploreModel.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static void saveAppGroupDoToRedis(AppGroupDo model, String key, int ttl) {
        System.out.println("saveAppGroupDoToRedis key=" + key);
        try {
            String value = JSON.toJSONString((Object)model);
            String value2 = StringZIP.zipString((String)value);
            testJedisUtil.setex(key, value2, ttl);
            String updateTimeKey = key + "_update_time";
            String updateTime = LocalDateUtil.getCurrentLocalDateTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS);
            testJedisUtil.setex(updateTimeKey, updateTime, ttl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static AppGroupDo readAppGroupDoFromRedis(String key) {
        AppGroupDo ret = null;
        System.out.println("readRtaRoiModelFromRedis key=" + key);
        try {
            String ret1 = testJedisUtil.get(key);
            String ret2 = StringZIP.unzipString((String)ret1);
            ret = (AppGroupDo)JSON.parseObject((String)ret2, AppGroupDo.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StatSyncBo)) {
            return false;
        }
        StatSyncBo other = (StatSyncBo)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof StatSyncBo;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    public String toString() {
        return "StatSyncBo()";
    }
}

