package cn.com.duiba.nezha.alg.example.example;

import cn.com.duiba.nezha.alg.alg.adx.rcmd.AdxIdeaDQNRcmder2;
import cn.com.duiba.nezha.alg.alg.params.AdxIdeaRcmdParam;
import cn.com.duiba.nezha.alg.alg.plugins.ResPlugInStatModel;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxIdeaFeatureDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxResourceRcmdDo;
import cn.com.duiba.nezha.alg.alg.vo.plug.ResPlugInStatDo;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.example.util.StdCoderModelSaveBo;
import cn.com.duiba.nezha.alg.feature.vo.AdxFeatureDo;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import com.alibaba.fastjson.JSON;
import net.sf.json.JSONObject;
import org.junit.Test;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResPlugInStatModelTest {

    public static ResPlugInStatDo historyStatDo = null;

    @Test
    public void merge() {

        ResPlugInStatDo hourStatDo = new ResPlugInStatDo();

        hourStatDo.setSlotId(1L);
        hourStatDo.setDsm2A(4L);
        hourStatDo.setResPlugInId(10L);
        hourStatDo.setResPlugInIndex(2L);


        hourStatDo.setMainVisitPv(10000L);
        hourStatDo.setMainJoinPv(5000L);
        hourStatDo.setMainLaunchCnt(4000L);
        hourStatDo.setMainClickPv(1000L);
        hourStatDo.setMainCostFee(50000L);
        hourStatDo.setMainConvertPv(30L);

        hourStatDo.setResPlugVisitPv(1000L);
        hourStatDo.setResPlugJoinPv(500L);
        hourStatDo.setResPlugLaunchCnt(400L);
        hourStatDo.setResPlugClickPv(100L);
        hourStatDo.setResPlugCostFee(5000L);
        hourStatDo.setResPlugConvertPv(3L);


        for (int i = 0; i < 10; i++) {
            historyStatDo = ResPlugInStatModel.merge(historyStatDo, hourStatDo);

            Double rpm = DataUtil.division(historyStatDo.getCostFee(), historyStatDo.getVisitPv(), 4);
            System.out.println("rpm=" + rpm + "," + JSON.toJSONString(historyStatDo));
        }


    }

    @Test
    public void rcmd() {



        String str = "{\"ideaParamsMap\":{5125:{\"advertConsume\":14766,\"adxConsume\":159202029279,\"bidPv\":17851,\"currentTimes\":0,\"fused\":true,\"giveUpRatio\":0.0,\"historyTimes\":173,\"ideaId\":5125,\"lastUpdateTime\":\"20191201181000\",\"rpm\":-0.17254,\"weight\":0.018},5128:{\"advertConsume\":7463,\"adxConsume\":92989518780,\"bidPv\":34306,\"currentRoi\":0.488,\"currentTimes\":87,\"fused\":false,\"giveUpRatio\":0.0,\"historyTimes\":172,\"ideaId\":5128,\"lastUpdateTime\":\"20191201181000\",\"rpm\":-0.08187,\"weight\":4.13},4382:{\"advertConsume\":6133,\"adxConsume\":57862876686,\"bidPv\":13475,\"currentRoi\":0.902,\"currentTimes\":254,\"fused\":false,\"giveUpRatio\":0.06499999999999999,\"historyTimes\":1470,\"ideaId\":4382,\"lastUpdateTime\":\"20191201181000\",\"rpm\":-0.03362,\"weight\":69.22},2239:{\"advertConsume\":3203,\"adxConsume\":31440293093,\"bidPv\":2553,\"currentRoi\":1.258,\"currentTimes\":1,\"fused\":false,\"giveUpRatio\":0.0,\"historyTimes\":340,\"ideaId\":2239,\"lastUpdateTime\":\"20191201181000\",\"rpm\":-0.14054,\"weight\":26.32},4593:{\"advertConsume\":12093,\"adxConsume\":128535014538,\"bidPv\":9858,\"currentTimes\":0,\"fused\":true,\"giveUpRatio\":0.10984999999999996,\"historyTimes\":748,\"ideaId\":4593,\"lastUpdateTime\":\"20191201181000\",\"rpm\":-0.23711,\"weight\":0.018}}}\n";

        AdxResourceRcmdDo lastAdxResourceRcmdDo = JSON.parseObject(str, AdxResourceRcmdDo.class);


        String feature = "{\"f4010010\":\"Mozilla/5.0 (Linux; Android 9; JSN-TL00 Build/HONORJSN-TL00; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/74.0.3729.136 Mobile Safari/537.36 mojia/1007093802\",\"f4010091\":\"0\",\"f3010120\":\"1\",\"f2010030\":\"4\",\"f4010090\":\"0\",\"f1010010\":\"11\",\"f5010060\":\"0\",\"f4010041\":\"0\",\"f4010121\":\"18\",\"f2010020\":\"0\",\"f4010080\":\"1\",\"f3010010\":\"4382\",\"f3010130\":\"0\",\"f6010020\":\"com.moji.mjweather\",\"f5010070\":\"0\",\"f4010122\":\"7\",\"f4010031\":\"84\",\"f4010030\":\"4501\",\"f4010110\":\"108.50602\",\"f4010032\":\"2\",\"f4010070\":\"0\",\"f2010050\":\"4\",\"f6010010\":\"mojiWeather\",\"f2010010\":\"80\",\"f3010060\":\"60\",\"f6010090\":\"80\",\"f5010080\":\"0\",\"f4010020\":\"223.104.22.160\",\"f3010070\":\"60\",\"f4010060\":\"JSN-TL00\",\"f1010020\":\"3\",\"f5010090\":\"0\",\"f5010050\":\"869093031361160\",\"f5010010\":\"O\",\"f4010100\":\"22.79545\"}";

        Map<String, String> statFeaureMap = JSONObject.fromObject(feature);

        statFeaureMap.remove("f3010010");


        //1 编码器获取 缓存
        CODER coderModel = StdCoderModelSaveBo.getADXModelCoderByKeyFromJedis("adx_coder_dqn_v001");

        //2 TF本地模型获取  缓存
        LocalTFModel ltfModel = new LocalTFModel();
        try {
            ltfModel.loadModel("/Users/lwj/Desktop/model/", "100");


            //3 创意特征对象List
            List<AdxIdeaFeatureDo> ideaFeatureList = new ArrayList<>();

            AdxIdeaFeatureDo i1 = new AdxIdeaFeatureDo();
            i1.setIdeaId(2239L);

            AdxIdeaFeatureDo i2 = new AdxIdeaFeatureDo();
            i2.setIdeaId(4382L);

            AdxIdeaFeatureDo i3 = new AdxIdeaFeatureDo();
            i3.setIdeaId(4593L);

            AdxIdeaFeatureDo i4 = new AdxIdeaFeatureDo();
            i4.setIdeaId(5125L);


            AdxIdeaFeatureDo i5 = new AdxIdeaFeatureDo();
            i5.setIdeaId(5128L);

            ideaFeatureList.add(i1);
            ideaFeatureList.add(i2);
            ideaFeatureList.add(i3);
            ideaFeatureList.add(i4);
            ideaFeatureList.add(i5);
            //4 获取非创意特征（同点击率预估模型）
            AdxFeatureDo adxFeatureDo = new AdxFeatureDo();

//            adxFeatureDo.setAreaCode(101L);
//            adxFeatureDo.setImeiDayBidTimes(null);


            //5 获取资源位创意推荐统计对象（算法1，入参）


            //6 预估
            AdxIdeaRcmdParam adxIdeaRcmdParam = new AdxIdeaRcmdParam();
            adxIdeaRcmdParam.setIdeaFeatureList(ideaFeatureList); //创意特征对象List
            adxIdeaRcmdParam.setAdxFeatureDo(adxFeatureDo);//非创意特征对象
            adxIdeaRcmdParam.setAdxResourceRcmdDo(lastAdxResourceRcmdDo);//资源位创意推荐统计对象
            adxIdeaRcmdParam.setCoderModel(coderModel);//编码器模型
            adxIdeaRcmdParam.setCoderModel(null);//编码器模型
            adxIdeaRcmdParam.setLtfModel(ltfModel);//本地TF深度模型

//            AdxIdeaFeatureDo ret = AdxIdeaRcmdAlg.ideaRcmd(adxIdeaRcmdParam);
            System.out.println("test2");
//            System.out.println("ret=" + JSON.toJSONString(ret));

//            System.out.println(JSON.toJSONString(ideaFeatureList));
            Map<Long, Long> retMap = new HashMap<>();
            System.out.println(LocalDateTime.now());
            for (int i = 0; i < 1000; i++) {
                AdxIdeaFeatureDo ret1 = AdxIdeaDQNRcmder2.ideaRcmd(adxIdeaRcmdParam, statFeaureMap);


//                ResPlugInStatModel.
//                System.out.println(JSON.toJSONString(ret1));
                if (ret1 != null) {
                    retMap.put(ret1.getIdeaId(), retMap.getOrDefault(ret1.getIdeaId(), 0L) + 1);
                } else {
                    retMap.put(null, retMap.getOrDefault(null, 0L) + 1);
                }

            }
            System.out.println("test3");
            System.out.println("retMap=" + JSON.toJSONString(retMap));

            System.out.println(LocalDateTime.now());

        } catch (Exception e) {

        }
    }
}