/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.example.example;

import cn.com.duiba.nezha.alg.example.util.StdModelSave;
import cn.com.duiba.nezha.alg.model.FM;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class FMModelPredictTest {
    public static void main(String[] args) {
        FMModelPredictTest.testAdx();
    }

    public static void testAdx() {
        try {
            String key1 = "adx_mid_ftrl_fm_ctr_v002";
            FM modelCtr = StdModelSave.getADXModelByKeyFromJedis(key1);
            System.out.println("time=" + modelCtr.getUpdateTime());
            String str1 = "{\"f4010010\":\"Cupid/qc_100001_100086/5.53.011;NetType/4G LTE;QTP/1.1.38.4\",\"f7030011\":\"5\",\"f3010120\":\"1\",\"f2010030\":\"0\",\"f7030010\":\"11355,12263,20319,25001,4781\",\"f1010010\":\"96\",\"f7010010\":\"01040208,010601,010602,020101,020105,020113,020408,020601,02070602,020710,020714,020811,02090202,021103,021111,021119,021126,021308,0214,021404,021405,02140701,021408,021411,021808,022406,030219\",\"f7010011\":\"6\",\"f5010060\":\"0\",\"f7020010\":\"4827,6047,8319,8070,6675,7856,8241,7795,5301,1283,5779,7866,5080,7606,7860,3680,1182,5777,1576,468,5891,648,7868,3701,7413,10319,7751,2187,4336\",\"f7020011\":\"6\",\"f4010121\":\"22\",\"f2010020\":\"0\",\"f3010010\":\"8606\",\"f3010130\":\"43\",\"f5010070\":\"0\",\"f4010122\":\"1\",\"f4010031\":\"82\",\"f4010030\":\"3702\",\"f4010032\":\"1\",\"f4010070\":\"android\",\"f2010050\":\"\",\"f2010010\":\"640\",\"f3010060\":\"120\",\"f5010080\":\"0\",\"f4010020\":\"117.136.78.22\",\"f3010070\":\"640\",\"f4010060\":\"vivo Y71\",\"f3010030\":\"0\",\"f1010020\":\"12\",\"f5010090\":\"0\",\"f6010040\":\"1\",\"f5010050\":\"025ef91faee5dd37000c15de14eb5df6\"}";
            JSONObject featureIdxMap = JSON.parseObject((String)str1);
            Double retCtr1 = modelCtr.predict((Map)featureIdxMap);
            System.out.println("ctr1=" + retCtr1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void test1() {
        try {
            String key1 = "mid_ftrl_fm_ctr_v010";
            String key2 = "mid_ftrl_fm_bcvr_v010";
            FM modelCtr = StdModelSave.getModelByKeyFromJedis(key1);
            FM modelCvr = StdModelSave.getModelByKeyFromJedis(key2);
            String str1 = "{\"orderId\":\"taw-507586214260798\",\"f608001\":\"1\",\"f113001\":\"04.01.0003\",\"f9913\":\"11\",\"f508002\":\"A73t\",\"f806001\":\"11\",\"f508001\":\"OPPO\",\"f806002\":\"6\",\"f806003\":\"8\",\"f830101\":\"null,56695_43895\",\"f9916\":\"02.24.0001&2\",\"f806004\":\"4\",\"f830102\":\"null,22597_12311\",\"f9917\":\"02.24.0001&1\",\"f830103\":\"null,07.14.0051_07.23.0013\",\"f9918\":\"02.24.0001&1\",\"f830104\":\"null\",\"f9919\":\"02.24.0001&8\",\"f104001\":\"77741\",\"f603002\":\"2\",\"f603001\":\"2\",\"f110001\":\"0\",\"f502001\":\"1\",\"f502002\":\"1\",\"f611001\":\"2\",\"f505001\":\"2700-4499\",\"f770102\":\"1\",\"f809001\":\"1\",\"f809002\":\"0\",\"f770501\":\"0\",\"f606002\":\"1\",\"f606001\":\"1\",\"f201001\":\"63596\",\"f102001\":\"02.06.0003\",\"f830001\":\"56695\",\"f830002\":\"22597\",\"f830003\":\"07.14.0051\",\"f830004\":\"17\",\"f609001\":\"1\",\"f804004\":\"5\",\"f804003\":\"7\",\"f804002\":\"9\",\"f9930\":\"0\",\"f804001\":\"8\",\"f9931\":\"-1\",\"f301001\":\"17826\",\"f9932\":\"-1\",\"f9933\":\"-1\",\"f9934\":\"-1\",\"f550102\":\"null,11&6,23&7,13&1,24&16,14&1,25&17,15&6,16&2,17&1,18&3,19&7,1&2,2&2,3&2,4&1,5&1,6&2,7&3,8&6,9&3,20&2,10&1,21&3\",\"f550101\":\"null,11&9,23&6,13&2,24&4,14&2,25&5,15&3,16&4,17&11,18&11,19&4,1&10,2&2,3&2,4&2,5&2,6&5,7&7,8&4,9&9,20&11,10&4,21&4\",\"f108001\":\"320375\",\"advertId\":\"43895\",\"f807002\":\"11\",\"f9924\":\"\",\"f807001\":\"10\",\"f507001\":\"3\",\"f807004\":\"7\",\"f830111\":\"null\",\"f807003\":\"8\",\"f830112\":\"null\",\"f9927\":\"0\",\"f810001\":\"null\",\"f770001\":\"07.23.0013\",\"f830113\":\"null\",\"f9928\":\"0\",\"f810002\":\"null\",\"f830114\":\"null\",\"f9929\":\"0\",\"f770401\":\"0\",\"f9921\":\"\",\"f306001\":\"2\",\"f9922\":\"\",\"f770402\":\"0\",\"f9923\":\"\",\"f604002\":\"2\",\"f604001\":\"2\",\"f501001\":\"Android\",\"f610001\":\"0\",\"chargeType\":\"2\",\"f206001\":\"540\",\"f504001\":\"OPPO A73t\",\"f601001\":\"2\",\"f601002\":\"2\",\"f303001\":\"28\",\"f114001\":\"119\",\"f607001\":\"1\",\"f114002\":\"128\",\"f406001\":\"12\",\"f206002\":\"538\",\"f811001\":\"102\",\"f403004\":\"0\",\"f830011\":\"{0=, 2=, 3=}\",\"f805001\":\"9\",\"f830012\":\"{0=, 2=, 3=}\",\"f805002\":\"11\",\"f830013\":\"{0=, 2=, 3=}\",\"f805003\":\"7\",\"f830014\":\"{0=, 2=, 3=}\",\"f805004\":\"6\",\"f602001\":\"2\",\"f115001\":\"0\",\"f205002\":\"85\",\"f205001\":\"10\",\"f701001\":\"1043895\",\"f808002\":\"0_0,02.24.0001_0\",\"f811002\":\"102\",\"f404003\":\"workother\",\"f106001\":\"12311\",\"f506001\":\"1\",\"f121001\":\"001003\",\"f121002\":\"005002\",\"f121003\":\"false\",\"f121004\":\"003003\",\"f8807\":\"1\",\"f121005\":\"004006\",\"f121006\":\"002002\",\"f808001\":\"0_1,02.24.0001_1\",\"f8803\":\"1\",\"f605001\":\"1\",\"f605002\":\"1\",\"f112001\":\"05.02.0018,05.02.0008\",\"f550302\":\"null,11&17,23&6,13&0,24&18,25&17,14&0,15&4,16&2,17&1,18&16,19&6,1&2,2&1,3&2,4&1,5&0,6&1,7&3,8&5,9&7,20&7,21&3,10&1\",\"f550301\":\"null,11&9,23&6,13&1,24&5,25&7,14&1,15&7,16&6,17&10,18&9,19&6,1&6,2&2,3&3,4&3,5&1,6&5,7&8,8&6,9&7,20&6,21&6,10&2\",\"f101001\":\"43895\",\"f503001\":\"5134\",\"time\":\"20191209013125\",\"f302001\":\"17826\",\"f602002\":\"2\"}";
            String str2 = "{\"orderId\":\"taw-507586166230895\",\"f608001\":\"1\",\"f113001\":\"04.01.0003\",\"f9913\":\"11\",\"f806001\":\"8\",\"f806002\":\"6\",\"f806003\":\"6\",\"f830101\":\"null\",\"f806004\":\"4\",\"f830102\":\"null\",\"f830103\":\"null\",\"f830104\":\"null\",\"f104001\":\"77741\",\"f603002\":\"1\",\"f603001\":\"1\",\"f110001\":\"0\",\"f502001\":\"1\",\"f502002\":\"1\",\"f611001\":\"1\",\"f505001\":\"4500+\",\"f770102\":\"1\",\"f770501\":\"0\",\"f606002\":\"0\",\"f606001\":\"-1\",\"f201001\":\"61642\",\"f102001\":\"02.06.0003\",\"f609001\":\"0\",\"f804004\":\"5\",\"f804003\":\"7\",\"f804002\":\"9\",\"f9930\":\"-1\",\"f804001\":\"8\",\"f9931\":\"-1\",\"f301001\":\"14130\",\"f9932\":\"-1\",\"f9933\":\"-1\",\"f9934\":\"-1\",\"f550102\":\"null,11&16,23&3,24&15,13&1,25&17,14&1,15&3,16&2,17&1,18&11,19&7,1&4,2&4,3&1,4&1,5&1,6&2,7&1,8&6,9&7,20&8,10&1,21&2\",\"f550101\":\"null,11&4,23&9,24&5,13&2,25&5,14&2,15&6,16&5,17&8,18&7,19&8,1&8,2&4,3&5,4&2,5&2,6&4,7&5,8&6,9&8,20&7,10&2,21&6\",\"f108001\":\"311115\",\"advertId\":\"43895\",\"f807002\":\"5\",\"f807001\":\"7\",\"f507001\":\"3\",\"f807004\":\"4\",\"f830111\":\"null\",\"f807003\":\"6\",\"f830112\":\"null\",\"f9927\":\"-1\",\"f810001\":\"null\",\"f770001\":\"07.23.0013\",\"f830113\":\"null\",\"f9928\":\"-1\",\"f810002\":\"null\",\"f830114\":\"null\",\"f9929\":\"-1\",\"f770401\":\"0\",\"f306001\":\"2\",\"f770402\":\"0\",\"f604002\":\"1\",\"f604001\":\"1\",\"f501001\":\"IOS\",\"f610001\":\"0\",\"chargeType\":\"1\",\"f206001\":\"262\",\"f504001\":\"IPHONE\",\"f601001\":\"1\",\"f601002\":\"1\",\"f303001\":\"28\",\"f114001\":\"118\",\"f607001\":\"1\",\"f114002\":\"121\",\"f406001\":\"0\",\"f206002\":\"260\",\"f403004\":\"0\",\"f830011\":\"{}\",\"f805001\":\"10\",\"f830012\":\"{}\",\"f805002\":\"9\",\"f830013\":\"{}\",\"f805003\":\"7\",\"f830014\":\"{}\",\"f805004\":\"5\",\"f602001\":\"1\",\"f115001\":\"0\",\"f205002\":\"197\",\"f205001\":\"196\",\"f701001\":\"1043895\",\"f404003\":\"workother\",\"f106001\":\"12311\",\"f121001\":\"001003\",\"f121002\":\"005002\",\"f121003\":\"false\",\"f121004\":\"003003\",\"f8807\":\"1\",\"f121005\":\"004006\",\"f121006\":\"002002\",\"f8803\":\"1\",\"f605001\":\"-1\",\"f605002\":\"0\",\"f112001\":\"05.02.0018,05.02.0008\",\"f550302\":\"null,11&15,13&0,25&15,14&0,15&7,16&2,17&1,18&9,19&12,1&2,2&2,3&3,4&1,5&0,6&1,7&1,8&1,9&5,20&7,21&2\",\"f550301\":\"null,11&3,13&1,25&7,14&1,15&7,16&5,17&6,18&10,19&4,1&6,2&6,3&5,4&3,5&1,6&6,7&5,8&6,9&8,20&6,21&6\",\"f101001\":\"43895\",\"f503001\":\"3599\",\"time\":\"20191209013132\",\"f302001\":\"14130\",\"f602002\":\"1\"}";
            String str3 = "{\"orderId\":\"taw-507585749660529\",\"f608001\":\"1\",\"f113001\":\"04.01.0003\",\"f9913\":\"11\",\"f508002\":\"PBBM00\",\"f806001\":\"11\",\"f508001\":\"\",\"f806002\":\"11\",\"f806003\":\"8\",\"f830101\":\"null,52416_43895\",\"f9916\":\"02.22.0006&2\",\"f806004\":\"6\",\"f830102\":\"null,18943_12311\",\"f9917\":\"02.22.0006&1\",\"f830103\":\"null,07.23.0008_07.23.0013\",\"f9918\":\"02.22.0006&1\",\"f830104\":\"null\",\"f9919\":\"02.22.0006&8\",\"f104001\":\"77741\",\"f603002\":\"2\",\"f603001\":\"2\",\"f110001\":\"0\",\"f502001\":\"1\",\"f502002\":\"1\",\"f611001\":\"2\",\"f505001\":\"1100-1699\",\"f770102\":\"1\",\"f809001\":\"1\",\"f809002\":\"0\",\"f770501\":\"0\",\"f606002\":\"1\",\"f606001\":\"1\",\"f201001\":\"57045\",\"f102001\":\"02.06.0003\",\"f830001\":\"52416\",\"f830002\":\"18943\",\"f830003\":\"07.23.0008\",\"f830004\":\"9\",\"f609001\":\"1\",\"f804004\":\"5\",\"f804003\":\"7\",\"f804002\":\"9\",\"f9930\":\"1\",\"f804001\":\"8\",\"f9931\":\"-1\",\"f301001\":\"17440\",\"f9932\":\"-1\",\"f9933\":\"-1\",\"f9934\":\"-1\",\"f550102\":\"null,11&17,23&5,13&1,24&16,14&1,25&17,15&7,16&3,17&3,18&14,19&10,1&7,2&2,3&2,4&1,5&1,6&2,7&1,8&6,9&7,20&8,10&1,21&5\",\"f550101\":\"null,11&4,23&6,13&3,24&7,14&3,25&6,15&5,16&4,17&6,18&8,19&7,1&6,2&3,3&4,4&2,5&2,6&6,7&12,8&5,9&8,20&4,10&3,21&8\",\"f108001\":\"314832\",\"advertId\":\"43895\",\"f807002\":\"8\",\"f9924\":\"02.22.0006\",\"f807001\":\"19\",\"f507001\":\"2\",\"f807004\":\"5\",\"f830111\":\"null\",\"f807003\":\"12\",\"f830112\":\"null\",\"f9927\":\"0\",\"f810001\":\"null\",\"f770001\":\"07.23.0013\",\"f830113\":\"null\",\"f9928\":\"0\",\"f810002\":\"null\",\"f830114\":\"null\",\"f9929\":\"0\",\"f770401\":\"0\",\"f9921\":\"\",\"f306001\":\"2\",\"f9922\":\"\",\"f770402\":\"0\",\"f9923\":\"\",\"f604002\":\"2\",\"f604001\":\"2\",\"f501001\":\"Android\",\"f610001\":\"0\",\"chargeType\":\"2\",\"f206001\":\"540\",\"f504001\":\"PBBM00\",\"f601001\":\"2\",\"f601002\":\"2\",\"f303001\":\"28\",\"f607001\":\"1\",\"f406001\":\"12\",\"f206002\":\"538\",\"f811001\":\"102\",\"f403004\":\"0\",\"f830011\":\"{0=, 2=, 3=}\",\"f805001\":\"17\",\"f830012\":\"{0=, 2=, 3=}\",\"f805002\":\"11\",\"f830013\":\"{0=, 2=, 3=}\",\"f805003\":\"12\",\"f830014\":\"{0=, 2=, 3=}\",\"f805004\":\"7\",\"f602001\":\"2\",\"f115001\":\"0\",\"f205002\":\"39\",\"f205001\":\"22\",\"f701001\":\"1043895\",\"f808002\":\"0_0,02.22.0006_0\",\"f811002\":\"102\",\"f404003\":\"workother\",\"f106001\":\"12311\",\"f506001\":\"1\",\"f121001\":\"001003\",\"f121002\":\"005002\",\"f121003\":\"false\",\"f121004\":\"003003\",\"f8807\":\"1\",\"f121005\":\"004006\",\"f121006\":\"002002\",\"f808001\":\"0_1,02.22.0006_1\",\"f8803\":\"1\",\"f605001\":\"1\",\"f605002\":\"1\",\"f112001\":\"05.02.0018,05.02.0008\",\"f550302\":\"null,11&16,23&0,24&16,13&0,14&0,25&17,15&7,16&2,17&7,18&8,19&4,1&7,2&1,3&3,4&1,5&0,6&1,7&3,8&4,9&7,20&9,21&2,10&1\",\"f550301\":\"null,11&5,23&1,24&2,13&1,14&1,25&11,15&7,16&7,17&12,18&6,19&5,1&4,2&7,3&4,4&3,5&1,6&4,7&6,8&5,9&9,20&7,21&7,10&2\",\"f101001\":\"43895\",\"f503001\":\"3799\",\"time\":\"20191209013205\",\"f302001\":\"17440\",\"f602002\":\"2\"}";
            String str4 = "{\"orderId\":\"taw-507585893000163\",\"f608001\":\"0\",\"f113001\":\"04.01.0003\",\"f9913\":\"11\",\"f508002\":\"PBET00\",\"f806001\":\"7\",\"f508001\":\"\",\"f806002\":\"7\",\"f806003\":\"6\",\"f830101\":\"null,58908_43895\",\"f9916\":\"02.20.0001&10,02.24.0001&2,02.01.0002&11,02.01.0003&12,02.01.0008&12,02.23.0001&10,02.22.0006&11,02.06&10,02.10&10,02.19&10\",\"f806004\":\"4\",\"f830102\":\"null,24305_12311\",\"f9917\":\"02.20.0001&1,02.24.0001&1,02.01.0002&1,02.01.0003&1,02.01.0008&9,02.23.0001&1,02.22.0006&1,02.06&1,02.10&1,02.19&1\",\"f830103\":\"null,07.24.0001_07.23.0013\",\"f9918\":\"02.20.0001&1,02.24.0001&1,02.01.0002&1,02.01.0003&1,02.01.0008&1,02.23.0001&1,02.22.0006&1,02.06&1,02.10&1,02.19&1\",\"f830104\":\"null\",\"f9919\":\"02.20.0001&4,02.24.0001&8,02.01.0002&3,02.01.0003&1,02.01.0008&3,02.23.0001&4,02.22.0006&3,02.06&4,02.10&4,02.19&4\",\"f104001\":\"77741\",\"f603002\":\"2\",\"f603001\":\"2\",\"f110001\":\"0\",\"f502001\":\"1\",\"f502002\":\"1\",\"f611001\":\"3\",\"f505001\":\"\u5176\u4ed6\",\"f770102\":\"1\",\"f809001\":\"2\",\"f809002\":\"1\",\"f770501\":\"0\",\"f606002\":\"1\",\"f606001\":\"1\",\"f201001\":\"63596\",\"f102001\":\"02.06.0003\",\"f830001\":\"58908\",\"f830002\":\"24305\",\"f830003\":\"07.24.0001\",\"f830004\":\"8\",\"f609001\":\"1\",\"f804004\":\"5\",\"f804003\":\"7\",\"f804002\":\"9\",\"f9930\":\"8\",\"f804001\":\"8\",\"f9931\":\"-1\",\"f301001\":\"12897\",\"f9932\":\"-1\",\"f9933\":\"-1\",\"f9934\":\"-1\",\"f550102\":\"null,11&6,23&7,24&16,13&1,14&1,25&17,15&6,16&2,17&1,18&3,19&7,1&2,2&2,3&2,4&1,5&1,6&2,7&3,8&6,9&3,20&2,21&3,10&1\",\"f550101\":\"null,11&9,23&6,24&4,13&2,14&2,25&5,15&3,16&4,17&11,18&11,19&4,1&10,2&2,3&2,4&2,5&2,6&5,7&7,8&4,9&9,20&11,21&4,10&4\",\"f108001\":\"307038\",\"advertId\":\"43895\",\"f807002\":\"12\",\"f9924\":\"02.10,02.20.0001,02.01.0003,02.23.0001,02.01.0008,02.22.0006,02.06,02.19\",\"f807001\":\"11\",\"f507001\":\"3\",\"f807004\":\"7\",\"f830111\":\"null\",\"f807003\":\"8\",\"f830112\":\"null\",\"f9927\":\"0\",\"f810001\":\"null\",\"f770001\":\"07.23.0013\",\"f830113\":\"null\",\"f9928\":\"0\",\"f810002\":\"null\",\"f830114\":\"null\",\"f9929\":\"1\",\"f770401\":\"0\",\"f9921\":\"\",\"f306001\":\"2\",\"f9922\":\"\",\"f770402\":\"0\",\"f9923\":\"02.01.0002\",\"f604002\":\"2\",\"f604001\":\"2\",\"f501001\":\"Android\",\"f610001\":\"0\",\"chargeType\":\"2\",\"f206001\":\"540\",\"f504001\":\"PBET00\",\"f601001\":\"2\",\"f601002\":\"2\",\"f303001\":\"28\",\"f607001\":\"0\",\"f406001\":\"5\",\"f206002\":\"538\",\"f811001\":\"105,302\",\"f403004\":\"0\",\"f830011\":\"{0=, 2=, 3=}\",\"f805001\":\"9\",\"f830012\":\"{0=, 2=, 3=}\",\"f805002\":\"11\",\"f830013\":\"{0=, 2=, 3=}\",\"f805003\":\"7\",\"f830014\":\"{0=, 2=, 3=}\",\"f805004\":\"6\",\"f602001\":\"2\",\"f115001\":\"0\",\"f205002\":\"85\",\"f205001\":\"10\",\"f701001\":\"1043895\",\"f808002\":\"02.10_0,0_1,02.20.0001_0,02.01.0002_0,02.01.0003_0,02.23.0001_0,02.01.0008_1,02.22.0006_0,02.06_0,02.24.0001_0,02.19_0\",\"f811002\":\"105\",\"f404003\":\"workother\",\"f106001\":\"12311\",\"f506001\":\"1\",\"f121001\":\"001003\",\"f121002\":\"005002\",\"f121003\":\"false\",\"f121004\":\"003003\",\"f8807\":\"1\",\"f121005\":\"004006\",\"f121006\":\"002002\",\"f808001\":\"02.10_1,0_2,02.20.0001_1,02.01.0002_1,02.01.0003_1,02.23.0001_1,02.01.0008_6,02.22.0006_1,02.06_1,02.24.0001_1,02.19_1\",\"f8803\":\"1\",\"f605001\":\"1\",\"f605002\":\"1\",\"f112001\":\"05.02.0018,05.02.0008\",\"f550302\":\"null,11&17,23&6,13&0,24&18,14&0,25&17,15&4,16&2,17&1,18&16,19&6,1&2,2&1,3&2,4&1,5&0,6&1,7&3,8&5,9&7,20&7,21&3,10&1\",\"f550301\":\"null,11&9,23&6,13&1,24&5,14&1,25&7,15&7,16&6,17&10,18&9,19&6,1&6,2&2,3&3,4&3,5&1,6&5,7&8,8&6,9&7,20&6,21&6,10&2\",\"f101001\":\"43895\",\"f503001\":\"4502\",\"time\":\"20191209013230\",\"f302001\":\"12897\",\"f602002\":\"2\"}";
            String str5 = "{\"orderId\":\"taw-507586040580548\",\"f608001\":\"1\",\"f113001\":\"04.01.0003\",\"f9913\":\"11\",\"f508002\":\"S6\",\"f806001\":\"8\",\"f508001\":\"Meizu\",\"f806002\":\"6\",\"f806003\":\"6\",\"f830101\":\"null\",\"f806004\":\"4\",\"f830102\":\"null\",\"f830103\":\"null\",\"f830104\":\"null\",\"f603002\":\"1\",\"f603001\":\"1\",\"f550201\":\"null,22&8,24&10,25&5,26&9,27&5,28&7,29&6,1340&8,162&5,163&11,493&9,196&8,471&9,384&11,188&7,266&13,178&7,159&10,405&5,30&8,53&7,31&8,10&9\",\"f110001\":\"0\",\"f550202\":\"null,22&7,24&7,25&4,26&7,27&6,28&7,29&7,1340&7,162&6,163&8,493&6,196&7,471&8,384&7,188&7,266&9,178&5,159&7,405&6,30&6,53&6,31&5,10&3\",\"f502001\":\"1\",\"f502002\":\"1\",\"f611001\":\"1\",\"f505001\":\"600-1099\",\"f770102\":\"1\",\"f770501\":\"0\",\"f606002\":\"0\",\"f606001\":\"-1\",\"f201001\":\"61642\",\"f102001\":\"02.06.0003\",\"f660001\":\"9\",\"f609001\":\"0\",\"f804004\":\"5\",\"f804003\":\"7\",\"f804002\":\"9\",\"f9930\":\"-1\",\"f804001\":\"8\",\"f9931\":\"-1\",\"f301001\":\"17631\",\"f9932\":\"-1\",\"f9933\":\"-1\",\"f9934\":\"-1\",\"f550102\":\"null,11&16,23&3,13&1,24&15,14&1,25&17,15&3,16&2,17&1,18&11,19&7,1&4,2&4,3&1,4&1,5&1,6&2,7&1,8&6,9&7,20&8,21&2,10&1\",\"f550101\":\"null,11&4,23&9,13&2,24&5,14&2,25&5,15&6,16&5,17&8,18&7,19&8,1&8,2&4,3&5,4&2,5&2,6&4,7&5,8&6,9&8,20&7,21&6,10&2\",\"f108001\":\"311115\",\"advertId\":\"43895\",\"f807002\":\"11\",\"f807001\":\"19\",\"f507001\":\"1\",\"f807004\":\"6\",\"f830111\":\"null\",\"f807003\":\"12\",\"f830112\":\"null\",\"f9927\":\"-1\",\"f810001\":\"null\",\"f770001\":\"07.23.0013\",\"f830113\":\"null\",\"f9928\":\"-1\",\"f810002\":\"null\",\"f830114\":\"null\",\"f9929\":\"-1\",\"f770401\":\"0\",\"f306001\":\"2\",\"f770402\":\"0\",\"f604002\":\"1\",\"f604001\":\"1\",\"f501001\":\"Android\",\"f610001\":\"0\",\"chargeType\":\"2\",\"f206001\":\"262\",\"f504001\":\"Meizu S6\",\"f660102\":\"1\",\"f601001\":\"1\",\"f601002\":\"1\",\"f303001\":\"28\",\"f114001\":\"118\",\"f550402\":\"null,22&5,24&3,25&4,26&5,27&5,28&5,29&5,1340&6,162&4,163&7,196&5,493&4,471&7,384&5,188&5,266&6,178&5,159&5,405&1,30&3,31&4,53&6,10&6\",\"f607001\":\"1\",\"f550401\":\"null,22&8,24&12,25&4,26&7,27&6,28&8,29&6,1340&7,162&7,163&9,196&7,493&11,471&10,384&12,188&7,266&12,178&9,159&12,405&5,30&7,31&11,53&8,10&6\",\"f114002\":\"121\",\"f406001\":\"0\",\"f206002\":\"260\",\"f403004\":\"0\",\"f830011\":\"{}\",\"f805001\":\"10\",\"f830012\":\"{}\",\"f805002\":\"9\",\"f830013\":\"{}\",\"f805003\":\"7\",\"f830014\":\"{}\",\"f805004\":\"5\",\"f602001\":\"1\",\"f115001\":\"0\",\"f205002\":\"197\",\"f205001\":\"196\",\"f701001\":\"1043895\",\"f404003\":\"workother\",\"f106001\":\"12311\",\"f506001\":\"1\",\"f660201\":\"0\",\"f8807\":\"1\",\"f8803\":\"1\",\"f605001\":\"-1\",\"f605002\":\"0\",\"f550302\":\"null,11&15,13&0,14&0,25&15,15&7,16&2,17&1,18&9,19&12,1&2,2&2,3&3,4&1,5&0,6&1,7&1,8&1,9&5,20&7,21&2\",\"f550301\":\"null,11&3,13&1,14&1,25&7,15&7,16&5,17&6,18&10,19&4,1&6,2&6,3&5,4&3,5&1,6&6,7&5,8&6,9&8,20&6,21&6\",\"f101001\":\"43895\",\"f503001\":\"3601\",\"time\":\"20191209013237\",\"f302001\":\"17631\",\"f602002\":\"1\"}";
            String str6 = "{\"orderId\":\"taw-507586292800772\",\"f608001\":\"0\",\"f113001\":\"04.01.0003\",\"f9913\":\"11\",\"f508002\":\"A33m\",\"f806001\":\"3\",\"f508001\":\"OPPO\",\"f806002\":\"3\",\"f806003\":\"3\",\"f830101\":\"null\",\"f9916\":\"02.24.0001&4,02.01.0008&2,02.22.0006&2,02.06&2\",\"f806004\":\"3\",\"f830102\":\"null\",\"f9917\":\"02.24.0001&1,02.01.0008&1,02.22.0006&1,02.06&1\",\"f830103\":\"null\",\"f9918\":\"02.24.0001&1,02.01.0008&1,02.22.0006&1,02.06&1\",\"f830104\":\"null\",\"f9919\":\"02.24.0001&6,02.01.0008&8,02.22.0006&8,02.06&8\",\"f104001\":\"77741\",\"f603002\":\"1\",\"f603001\":\"1\",\"f110001\":\"0\",\"f502001\":\"1\",\"f502002\":\"1\",\"f611001\":\"7\",\"f505001\":\"600-1099\",\"f770102\":\"1\",\"f809001\":\"1\",\"f809002\":\"0\",\"f770501\":\"0\",\"f606002\":\"0\",\"f606001\":\"-1\",\"f201001\":\"67739\",\"f102001\":\"02.06.0003\",\"f609001\":\"0\",\"f804004\":\"5\",\"f804003\":\"7\",\"f804002\":\"9\",\"f9930\":\"3\",\"f804001\":\"8\",\"f9931\":\"-1\",\"f301001\":\"1874\",\"f9932\":\"-1\",\"f9933\":\"-1\",\"f9934\":\"-1\",\"f550102\":\"null,11&17,23&8,13&1,24&0,25&18,14&1,15&7,16&3,17&1,18&8,19&3,1&4,2&1,3&1,4&1,5&1,6&2,7&1,8&4,9&7,20&8,10&1,21&5\",\"f550101\":\"null,11&4,23&5,13&2,24&1,25&5,14&3,15&4,16&4,17&6,18&5,19&6,1&4,2&2,3&3,4&2,5&3,6&6,7&5,8&5,9&6,20&4,10&5,21&5\",\"f108001\":\"316184\",\"advertId\":\"43895\",\"f807002\":\"9\",\"f9924\":\"02.22.0006,02.06,02.24.0001\",\"f807001\":\"2\",\"f507001\":\"3\",\"f807004\":\"5\",\"f830111\":\"null\",\"f807003\":\"3\",\"f830112\":\"null\",\"f9927\":\"0\",\"f810001\":\"null\",\"f770001\":\"07.23.0013\",\"f830113\":\"null\",\"f9928\":\"0\",\"f810002\":\"null\",\"f830114\":\"null\",\"f9929\":\"1\",\"f770401\":\"0\",\"f9921\":\"\",\"f306001\":\"2\",\"f9922\":\"\",\"f770402\":\"0\",\"f9923\":\"02.01.0008\",\"f604002\":\"1\",\"f604001\":\"1\",\"f501001\":\"Android\",\"f610001\":\"0\",\"chargeType\":\"2\",\"f206001\":\"262\",\"f504001\":\"OPPO A33m\",\"f601001\":\"6\",\"f601002\":\"6\",\"f303001\":\"2000\",\"f607001\":\"1\",\"f406001\":\"1\",\"f206002\":\"260\",\"f811001\":\"104\",\"f403004\":\"0\",\"f830011\":\"{}\",\"f805001\":\"3\",\"f830012\":\"{}\",\"f805002\":\"4\",\"f830013\":\"{}\",\"f805003\":\"3\",\"f830014\":\"{}\",\"f805004\":\"3\",\"f602001\":\"6\",\"f115001\":\"0\",\"f205002\":\"67\",\"f205001\":\"29\",\"f701001\":\"1043895\",\"f808002\":\"0_0,02.01.0008_0,02.22.0006_0,02.06_0,02.24.0001_0\",\"f811002\":\"104\",\"f404003\":\"workother\",\"f106001\":\"12311\",\"f121001\":\"001003\",\"f121002\":\"005002\",\"f121003\":\"false\",\"f121004\":\"003003\",\"f8807\":\"1\",\"f121005\":\"004006\",\"f121006\":\"002002\",\"f808001\":\"0_1,02.01.0008_1,02.22.0006_1,02.06_1,02.24.0001_1\",\"f8803\":\"1\",\"f605001\":\"1\",\"f605002\":\"1\",\"f112001\":\"05.02.0018,05.02.0008\",\"f550302\":\"null,11&15,23&1,13&1,25&15,14&1,15&4,16&2,17&1,18&12,19&1,1&2,2&1,3&1,4&1,5&0,6&1,7&0,8&3,9&4,20&6,10&1,21&3\",\"f550301\":\"null,11&3,23&3,13&2,25&3,14&3,15&3,16&3,17&4,18&4,19&2,1&3,2&2,3&2,4&2,5&1,6&3,7&0,8&3,9&3,20&2,10&2,21&3\",\"f101001\":\"43895\",\"f503001\":\"3418\",\"time\":\"20191209013433\",\"f302001\":\"1874\",\"f602002\":\"6\"}";
            String str7 = "{\"orderId\":\"taw-507585551590875\",\"f608001\":\"0\",\"f113001\":\"04.01.0003\",\"f9913\":\"11\",\"f508002\":\"AL00\",\"f806001\":\"1\",\"f508001\":\"BND\",\"f9914\":\"sogou.mobile.explorer,com.jifen.qukan,com.mt.mtxx.mtxx,com.qihoo.browser,com.tencent.mm,com.tencent.android.qqdownloader,com.tencent.qqpim,com.tencent.wifimanager,com.tencent.qqpimsecure,com.tencent.mtt,com.ss.android.article.lite,com.ss.android.article.news,com.ss.android.ugc.aweme,com.tencent.mobileqq,com.baidu.searchbox.lite,com.autonavi.minimap\",\"f806002\":\"0\",\"f9915\":\"47,36,0,\\\\N,26,31,1,45,53,52\",\"f806003\":\"2\",\"f830101\":\"null\",\"f9916\":\"02.21.0004&10,02.20.0001&13,02.24.0001&12,02.01.0002&11,02.01.0003&12,02.01.0007&11,02.01.0008&13,02.23.0001&13,02.22.0001&12,02.22.0002&10,02.22.0006&10,02.16&10,02.17&12,02.06&13,02.19&12,02.15&12,02.03&11,02.14&13,02.09&11,02.13&10\",\"f806004\":\"1\",\"f830102\":\"null\",\"f9917\":\"02.21.0004&1,02.20.0001&9,02.24.0001&9,02.01.0002&1,02.01.0003&1,02.01.0007&1,02.01.0008&9,02.23.0001&1,02.22.0001&1,02.22.0002&1,02.22.0006&9,02.16&1,02.17&1,02.06&9,02.19&1,02.15&1,02.03&1,02.14&9,02.09&9,02.13&1\",\"f830103\":\"null\",\"f9918\":\"02.21.0004&1,02.20.0001&1,02.24.0001&1,02.01.0002&1,02.01.0003&1,02.01.0007&1,02.01.0008&1,02.23.0001&1,02.22.0001&1,02.22.0002&1,02.22.0006&1,02.16&1,02.17&1,02.06&1,02.19&1,02.15&1,02.03&1,02.14&1,02.09&1,02.13&1\",\"f830104\":\"null\",\"f9919\":\"02.21.0004&4,02.20.0001&1,02.24.0001&2,02.01.0002&2,02.01.0003&1,02.01.0007&4,02.01.0008&1,02.23.0001&1,02.22.0001&1,02.22.0002&4,02.22.0006&12,02.16&4,02.17&1,02.06&1,02.19&1,02.15&1,02.03&2,02.14&1,02.09&3,02.13&4\",\"f660302\":\"6\",\"f603002\":\"4\",\"f603001\":\"4\",\"f550201\":\"null,22&8,24&10,25&5,26&9,27&5,28&7,29&6,1340&8,162&5,196&8,493&9,163&11,471&9,384&11,188&7,178&7,266&13,159&10,405&5,30&8,53&7,31&8,10&9\",\"f110001\":\"1\",\"f550202\":\"null,22&7,24&7,25&4,26&7,27&6,28&7,29&7,1340&7,162&6,196&7,493&6,163&8,471&8,384&7,188&7,178&5,266&9,159&7,405&6,30&6,53&6,31&5,10&3\",\"f502001\":\"1\",\"f502002\":\"1\",\"f611001\":\"19\",\"f9902\":\"sogou.mobile.explorer,com.sogou.activity.src,com.tencent.news.lite,com.qiyi.video,com.sohu.inputmethod.sogou,com.yiche.autoeasy,com.jifen.qukan,com.sankuai.meituan,com.tencent.filemanager,cn.lt.appstore,com.tencent.androidqqmail,com.cleanmaster.mguard_cn,com.mt.mtxx.mtxx,com.qihoo.browser,com.tencent.mm,com.sdu.didi.psnger,com.tencent.android.qqdownloader,com.huawei.bone,com.tencent.qqpim,com.android.launcher8,com.ttyouqu.app,com.market.chenxiang,com.tencent.wifimanager,com.qihoo.cleandroid_cn,com.szcx.explorer,com.tencent.qqpimsecure,cn.lt.game,com.tencent.qqlive,com.qihoo360.mobilesafe,com.tencent.map,com.tencent.mtt,cn.opda.a.phonoalbumshoushou,com.ss.android.article.lite,com.ss.android.article.news,com.ss.android.ugc.aweme,com.tencent.mobileqq,cn.com.scnxbank.mbank,com.unionpay,com.qsmy.walkmonkey,com.baidu.searchbox.lite,com.planet.light2345,com.mobiletool.appstore,com.qihoo.appstore,com.nxy.sc,com.jingdong.app.mall,cn.xuexi.android,com.ijinshan.browser_fast,com.autonavi.minimap,cn.kuwo.player,com.browser2345,com.cleanmaster.security_cn,com.ijinshan.kbatterydoctor,com.eg.android.alipaygphone,com.browser_llqhz\",\"f505001\":\"600-1099\",\"f9906\":\"22,15,19,21,24,13,18,31,20,\\\\N,32\",\"f9907\":\"2206,1504,2208,1904,2103,2401,2404,2203,2205,1305,1806,2204,3106,2005,\\\\N,3103,2202,2207,2003,2004,1902,1906,1801,1802,1803,1804,1805,3101,3205,3208,2403,2002,1506,3204,3207\",\"f9908\":\"0\",\"f770102\":\"2\",\"f809001\":\"1\",\"f809002\":\"1\",\"f770501\":\"0\",\"f606002\":\"3\",\"f606001\":\"1\",\"f201001\":\"42211\",\"f102001\":\"02.06.0003\",\"f660001\":\"9\",\"f609001\":\"0\",\"f804004\":\"5\",\"f804003\":\"7\",\"f804002\":\"9\",\"f9930\":\"11\",\"f804001\":\"8\",\"f9931\":\"-1\",\"f301001\":\"17530\",\"f9932\":\"-1\",\"f9933\":\"-1\",\"f9934\":\"-1\",\"f550102\":\"null,11&14,23&4,13&1,24&0,25&15,14&1,15&2,16&1,17&2,18&8,19&7,1&5,2&1,3&1,4&1,5&1,6&1,7&3,8&4,9&4,20&7,10&1,21&1\",\"f550101\":\"null,11&4,23&5,13&2,24&0,25&3,14&3,15&4,16&4,17&3,18&2,19&4,1&5,2&2,3&3,4&3,5&2,6&3,7&5,8&5,9&5,20&4,10&3,21&4\",\"f108001\":\"315380\",\"advertId\":\"43895\",\"f807002\":\"0\",\"f9924\":\"02.01.0003,02.01.0007,02.01.0008,02.06,02.24.0001,02.15,02.19,02.20.0001,02.23.0001,02.03,02.14\",\"f807001\":\"2\",\"f507001\":\"3\",\"f9925\":\"null,22&g3,\\\\N&g1,13&g1,24&g1,15&g2,18&g1,19&g1,20&g1,31&g1,32&g1,21&g1\",\"f807004\":\"1\",\"f830111\":\"null\",\"f9926\":\"null,3101&g1,2207&g2,2404&g1,2206&g3,2403&g1,2205&g1,2204&g3,2005&g2,2203&g4,2401&g1,2004&g2,2202&g1,2103&g1,2003&g2,2002&g1,2208&g1,3208&g1,1305&g1,3207&g1,\\\\N&g2,3205&g2,3106&g2,3204&g1,3103&g1,1906&g1,1806&g2,1805&g1,1904&g2,1804&g1,1506&g1,1803&g1,1902&g1,1802&g1,1801&g1,1504&g2\",\"f807003\":\"3\",\"f830112\":\"null\",\"f9927\":\"0\",\"f810001\":\"null\",\"f770001\":\"07.23.0013\",\"f830113\":\"null\",\"f9928\":\"1\",\"f810002\":\"null\",\"f830114\":\"null\",\"f9929\":\"8\",\"f770401\":\"0\",\"f9921\":\"\",\"f306001\":\"2\",\"f9922\":\"02.22.0006\",\"f770402\":\"0\",\"f9923\":\"02.22.0001,02.01.0002,02.22.0002,02.17,02.16,02.21.0004,02.09,02.13\",\"f604002\":\"5\",\"f604001\":\"5\",\"f501001\":\"Android\",\"f610001\":\"0\",\"chargeType\":\"1\",\"f206001\":\"262\",\"f504001\":\"BND-AL00\",\"f660102\":\"2\",\"f601001\":\"-1\",\"f601002\":\"12\",\"f303001\":\"28\",\"f114001\":\"118\",\"f550402\":\"null,22&5,24&3,25&4,26&5,27&5,28&5,29&5,1340&6,162&4,493&4,163&7,471&7,196&5,384&5,188&5,178&5,266&6,159&5,405&1,30&3,53&6,31&4,10&6\",\"f607001\":\"0\",\"f550401\":\"null,22&8,24&12,25&4,26&7,27&6,28&8,29&6,1340&7,162&7,493&11,163&9,471&10,196&7,384&12,188&7,178&9,266&12,159&12,405&5,30&7,53&8,31&11,10&6\",\"f114002\":\"134\",\"f406001\":\"0\",\"f206002\":\"260\",\"f811001\":\"106,204,402\",\"f403004\":\"0\",\"f830011\":\"{}\",\"f805001\":\"1\",\"f830012\":\"{}\",\"f805002\":\"2\",\"f830013\":\"{}\",\"f805003\":\"2\",\"f830014\":\"{}\",\"f805004\":\"2\",\"f770302\":\"0\",\"f770301\":\"0\",\"f602001\":\"-1\",\"f115001\":\"0\",\"f205002\":\"253\",\"f205001\":\"25\",\"f701001\":\"1043895\",\"f404007\":\"news,ecommerce,video,earnonline,autocar,shopping\",\"f808002\":\"02.22.0001_0,02.01.0002_0,02.01.0003_0,02.22.0002_0,02.01.0007_0,02.01.0008_1,02.22.0006_1,02.17_0,02.06_1,02.24.0001_1,02.16_0,02.21.0004_0,02.15_0,02.09_1,02.19_0,0_1,02.20.0001_1,02.23.0001_0,02.03_0,02.14_1,02.13_0\",\"f811002\":\"107\",\"f404003\":\"work\",\"f106001\":\"12311\",\"f506001\":\"2\",\"f660201\":\"0\",\"f8807\":\"1\",\"f808001\":\"02.22.0001_1,02.01.0002_1,02.01.0003_1,02.22.0002_1,02.01.0007_1,02.01.0008_1,02.22.0006_12,02.17_1,02.06_2,02.24.0001_3,02.16_1,02.21.0004_1,02.15_1,02.09_4,02.19_1,0_1,02.20.0001_1,02.23.0001_1,02.03_1,02.14_2,02.13_1\",\"f8803\":\"1\",\"f605001\":\"1\",\"f605002\":\"2\",\"f550302\":\"null,11&1,23&4,24&9,13&1,25&16,14&1,15&2,16&2,17&1,18&9,19&6,1&14,2&1,3&1,4&1,5&1,6&1,7&1,8&3,9&4,20&5,10&1,21&1\",\"f550301\":\"null,11&2,23&2,24&3,13&2,25&3,14&2,15&2,16&2,17&2,18&2,19&3,1&2,2&2,3&2,4&2,5&2,6&2,7&3,8&3,9&2,20&2,10&2,21&2\",\"f101001\":\"43895\",\"f503001\":\"5101\",\"f770202\":\"6\",\"time\":\"20191209013102\",\"f302001\":\"17530\",\"f602002\":\"14\"}";
            String str8 = "{\"orderId\":\"taw-507587694230887\",\"f608001\":\"0\",\"f113001\":\"04.01.0003\",\"f9913\":\"11\",\"f508002\":\"V1818CA\",\"f806001\":\"14\",\"f508001\":\"\",\"f9914\":\"com.jifen.qukan,com.tencent.mm,com.baidu.searchbox,com.bbk.iqoo.feedback,com.xunmeng.pinduoduo,com.android.bbk.lockscreen3,com.autonavi.minimap,com.smile.gifmaker,com.fenbi.android.solar\",\"f806002\":\"11\",\"f9915\":\"26,1,36,47,24\",\"f806003\":\"10\",\"f830101\":\"null\",\"f9916\":\"02.24.0001&5,02.01.0008&2,02.22.0006&7,02.14&2\",\"f806004\":\"7\",\"f830102\":\"null\",\"f9917\":\"02.24.0001&1,02.01.0008&1,02.22.0006&1,02.14&2\",\"f830103\":\"null\",\"f9918\":\"02.24.0001&1,02.01.0008&1,02.22.0006&1,02.14&1\",\"f830104\":\"null\",\"f9919\":\"02.24.0001&6,02.01.0008&8,02.22.0006&6,02.14&9\",\"f603002\":\"6\",\"f603001\":\"6\",\"f550201\":\"null,22&8,24&10,25&5,26&9,27&5,28&7,29&6,1340&8,162&5,493&9,471&9,196&8,163&11,384&11,188&7,266&13,178&7,159&10,405&5,30&8,53&7,31&8,10&9\",\"f110001\":\"0\",\"f550202\":\"null,22&7,24&7,25&4,26&7,27&6,28&7,29&7,1340&7,162&6,493&6,471&8,196&7,163&8,384&7,188&7,266&9,178&5,159&7,405&6,30&6,53&6,31&5,10&3\",\"f502001\":\"1\",\"f502002\":\"1\",\"f611001\":\"7\",\"f9902\":\"com.okfunc.towelvideo,com.jifen.qukan,com.tencent.mm,com.baidu.searchbox,com.yuncheapp.android.pearl,com.icbc,com.bbk.iqoo.feedback,com.tencent.qqlive,com.xunmeng.pinduoduo,com.qire.pigcompose,com.jm.video,cn.txtqbmfyd.reader,com.vivo.childrenmode,com.android.bbk.lockscreen3,com.autonavi.minimap,com.jifen.seafood,com.smile.gifmaker,com.qile76y.dragonsky,com.fenbi.android.solar,com.eg.android.alipaygphone\",\"f505001\":\"1100-1699\",\"f9906\":\"21,31,22,32,\\\\N,15,24,20,18,26\",\"f9907\":\"2103,3106,2206,3208,\\\\N,1504,2403,2002,2003,2004,1805,2601,3204,3205,3207\",\"f9908\":\"0\",\"f770102\":\"1\",\"f809001\":\"2\",\"f809002\":\"1\",\"f770501\":\"0\",\"f606002\":\"1\",\"f606001\":\"1\",\"f201001\":\"23032\",\"f102001\":\"02.06.0003\",\"f660001\":\"9\",\"f609001\":\"1\",\"f804004\":\"5\",\"f804003\":\"6\",\"f804002\":\"9\",\"f9930\":\"2\",\"f804001\":\"8\",\"f9931\":\"-1\",\"f301001\":\"15800\",\"f9932\":\"-1\",\"f9933\":\"-1\",\"f9934\":\"-1\",\"f550102\":\"null,11&6,23&7,13&1,24&16,25&17,14&1,15&6,16&2,17&1,18&3,19&7,1&2,2&2,3&2,4&1,5&1,6&2,7&3,8&6,9&3,20&2,21&3,10&1\",\"f550101\":\"null,11&9,23&6,13&2,24&4,25&5,14&2,15&3,16&4,17&11,18&11,19&4,1&10,2&2,3&2,4&2,5&2,6&5,7&7,8&4,9&9,20&11,21&4,10&4\",\"f108001\":\"739\",\"advertId\":\"43895\",\"f807002\":\"11\",\"f9924\":\"02.22.0006,02.24.0001\",\"f807001\":\"19\",\"f507001\":\"3\",\"f9925\":\"null,22&g1,24&g1,\\\\N&g1,26&g1,15&g1,18&g1,20&g1,31&g1,32&g1,21&g1\",\"f807004\":\"6\",\"f830111\":\"null\",\"f9926\":\"null,3208&g1,3207&g1,2206&g1,2601&g1,2403&g1,\\\\N&g2,3205&g1,3106&g1,3204&g1,2004&g1,2103&g1,2003&g1,2002&g1,1805&g1,1504&g1\",\"f807003\":\"12\",\"f830112\":\"null\",\"f9927\":\"1\",\"f810001\":\"null\",\"f770001\":\"07.23.0013\",\"f830113\":\"null\",\"f9928\":\"0\",\"f810002\":\"null\",\"f830114\":\"null\",\"f9929\":\"1\",\"f770401\":\"0\",\"f9921\":\"02.14\",\"f306001\":\"2\",\"f9922\":\"\",\"f770402\":\"0\",\"f9923\":\"02.01.0008\",\"f604002\":\"6\",\"f604001\":\"6\",\"f501001\":\"Android\",\"f610001\":\"0\",\"chargeType\":\"2\",\"f206001\":\"262\",\"f504001\":\"V1818CA\",\"f660102\":\"1\",\"f601001\":\"6\",\"f601002\":\"6\",\"f303001\":\"28\",\"f114001\":\"119\",\"f550402\":\"null,22&5,24&3,25&4,26&5,27&5,28&5,29&5,1340&6,162&4,493&4,471&7,196&5,163&6,384&6,188&5,266&6,178&5,159&5,405&1,30&3,31&4,53&6,10&6\",\"f607001\":\"0\",\"f550401\":\"null,22&8,24&12,25&4,26&7,27&6,28&8,29&6,1340&7,162&7,493&11,471&10,196&7,163&9,384&12,188&7,266&12,178&9,159&12,405&5,30&7,31&11,53&8,10&6\",\"f114002\":\"130\",\"f406001\":\"12\",\"f206002\":\"260\",\"f811001\":\"103,402\",\"f403004\":\"0\",\"f830011\":\"{}\",\"f805001\":\"14\",\"f830012\":\"{}\",\"f805002\":\"12\",\"f830013\":\"{}\",\"f805003\":\"10\",\"f830014\":\"{}\",\"f805004\":\"7\",\"f602001\":\"6\",\"f115001\":\"0\",\"f205002\":\"17\",\"f205001\":\"10\",\"f701001\":\"1043895\",\"f404007\":\"news,ecommerce,teeneducation,reading,video,shopping\",\"f808002\":\"0_1,02.14_1,02.01.0008_0,02.22.0006_0,02.24.0001_0\",\"f404002\":\"young\",\"f811002\":\"104\",\"f404003\":\"work\",\"f106001\":\"12311\",\"f506001\":\"2\",\"f660201\":\"0\",\"f8807\":\"1\",\"f808001\":\"0_2,02.14_12,02.01.0008_1,02.22.0006_1,02.24.0001_1\",\"f8803\":\"1\",\"f605001\":\"1\",\"f605002\":\"1\",\"f550302\":\"null,11&19,23&9,13&0,14&0,25&17,15&7,16&3,17&1,18&1,19&6,1&3,2&1,3&1,4&1,5&0,6&2,7&1,8&6,9&5,20&7,10&1,21&3\",\"f550301\":\"null,11&3,23&12,13&1,14&1,25&10,15&6,16&8,17&12,18&11,19&7,1&6,2&2,3&2,4&3,5&0,6&12,7&10,8&5,9&11,20&9,10&12,21&7\",\"f101001\":\"43895\",\"f503001\":\"1401\",\"time\":\"20191209014216\",\"f302001\":\"15800\",\"f602002\":\"6\"}";
            String str9 = "{\"orderId\":\"taw-507587556450789\",\"f608001\":\"0\",\"f113001\":\"04.01.0003\",\"f9913\":\"11\",\"f508002\":\"MLA-AL10\",\"f806001\":\"5\",\"f508001\":\"HUAWEI\",\"f806002\":\"12\",\"f806003\":\"5\",\"f830101\":\"null\",\"f9916\":\"02.23.0001&2,02.06&4\",\"f806004\":\"7\",\"f830102\":\"null\",\"f9917\":\"02.23.0001&1,02.06&1\",\"f830103\":\"null\",\"f9918\":\"02.23.0001&1,02.06&1\",\"f830104\":\"null\",\"f9919\":\"02.23.0001&8,02.06&6\",\"f104001\":\"77741\",\"f603002\":\"1\",\"f603001\":\"1\",\"f110001\":\"0\",\"f502001\":\"1\",\"f502002\":\"1\",\"f611001\":\"1\",\"f505001\":\"1700-2699\",\"f770102\":\"1\",\"f809001\":\"1\",\"f809002\":\"0\",\"f770501\":\"0\",\"f606002\":\"8\",\"f606001\":\"99\",\"f201001\":\"67892\",\"f102001\":\"02.06.0003\",\"f609001\":\"0\",\"f804004\":\"5\",\"f804003\":\"6\",\"f804002\":\"9\",\"f9930\":\"2\",\"f804001\":\"8\",\"f9931\":\"-1\",\"f301001\":\"2156\",\"f9932\":\"-1\",\"f9933\":\"-1\",\"f9934\":\"-1\",\"f550102\":\"null,11&6,23&7,24&16,13&1,25&17,14&1,15&6,16&2,17&1,18&3,19&7,1&2,2&2,3&2,4&1,5&1,6&2,7&3,8&6,9&3,20&2,10&1,21&3\",\"f550101\":\"null,11&9,23&6,24&4,13&2,25&5,14&2,15&3,16&4,17&11,18&11,19&4,1&10,2&2,3&2,4&2,5&2,6&5,7&7,8&4,9&9,20&11,10&4,21&4\",\"f108001\":\"315922\",\"advertId\":\"43895\",\"f807002\":\"5\",\"f9924\":\"02.23.0001,02.06\",\"f807001\":\"2\",\"f507001\":\"1\",\"f807004\":\"4\",\"f830111\":\"null\",\"f807003\":\"3\",\"f830112\":\"null\",\"f9927\":\"0\",\"f810001\":\"null\",\"f770001\":\"07.23.0013\",\"f830113\":\"null\",\"f9928\":\"0\",\"f810002\":\"null\",\"f830114\":\"null\",\"f9929\":\"0\",\"f770401\":\"0\",\"f9921\":\"\",\"f306001\":\"2\",\"f9922\":\"\",\"f770402\":\"0\",\"f9923\":\"\",\"f604002\":\"3\",\"f604001\":\"3\",\"f501001\":\"Android\",\"f610001\":\"0\",\"chargeType\":\"2\",\"f206001\":\"262\",\"f504001\":\"HUAWEI MLA-AL10\",\"f601001\":\"1\",\"f601002\":\"1\",\"f303001\":\"2000\",\"f114001\":\"118\",\"f607001\":\"0\",\"f114002\":\"121\",\"f406001\":\"0\",\"f206002\":\"260\",\"f811001\":\"103\",\"f403004\":\"0\",\"f830011\":\"{}\",\"f805001\":\"6\",\"f830012\":\"{}\",\"f805002\":\"12\",\"f830013\":\"{}\",\"f805003\":\"5\",\"f830014\":\"{}\",\"f805004\":\"7\",\"f602001\":\"6\",\"f115001\":\"0\",\"f205002\":\"85\",\"f205001\":\"10\",\"f701001\":\"1043895\",\"f808002\":\"0_0,02.23.0001_0,02.06_0\",\"f811002\":\"103\",\"f404003\":\"workother\",\"f106001\":\"12311\",\"f121001\":\"001003\",\"f121002\":\"005002\",\"f121003\":\"false\",\"f121004\":\"003003\",\"f8807\":\"1\",\"f121005\":\"004006\",\"f121006\":\"002002\",\"f808001\":\"0_1,02.23.0001_1,02.06_1\",\"f8803\":\"1\",\"f605001\":\"99\",\"f605002\":\"8\",\"f112001\":\"05.02.0018,05.02.0008\",\"f550302\":\"null,11&16,23&6,13&1,25&14,14&1,15&4,16&2,17&2,18&16,19&8,1&2,2&1,3&2,4&1,5&1,6&1,8&7,9&7,20&7,21&2,10&1\",\"f550301\":\"null,11&3,23&4,13&2,25&3,14&2,15&3,16&3,17&2,18&4,19&6,1&3,2&2,3&2,4&2,5&2,6&4,8&4,9&4,20&3,21&3,10&2\",\"f101001\":\"43895\",\"f503001\":\"11\",\"time\":\"20191209014227\",\"f302001\":\"2156\",\"f602002\":\"6\"}";
            String str10 = "{\"orderId\":\"taw-507587649090388\",\"f608001\":\"0\",\"f113001\":\"04.01.0003\",\"f9913\":\"11\",\"f508002\":\"A5010\",\"f806001\":\"2\",\"f508001\":\"ONEPLUS\",\"f9914\":\"com.jifen.qukan,com.tencent.reading,com.ifeng.news2,com.tencent.mm,com.tencent.android.qqdownloader,com.baidu.searchbox,com.tencent.wifimanager,com.shoujiduoduo.ringtone,com.tencent.mtt,com.xunmeng.pinduoduo,com.ss.android.article.lite,com.tencent.gallerymanager,com.autonavi.minimap,com.smile.gifmaker\",\"f806002\":\"11\",\"f9915\":\"\\\\N,0,26,47,1,36,63,52,49,10\",\"f806003\":\"3\",\"f830101\":\"null,58350_43895,57820_43895\",\"f9916\":\"02.01.0007&2,02.14&2\",\"f806004\":\"6\",\"f830102\":\"null,23096_12311,23411_12311\",\"f9917\":\"02.01.0007&1,02.14&1\",\"f830103\":\"null,07.10.0027_07.23.0013,07.11.0013_07.23.0013\",\"f9918\":\"02.01.0007&1,02.14&1\",\"f830104\":\"null,1_9,1_9\",\"f9919\":\"02.01.0007&8,02.14&8\",\"f603002\":\"3\",\"f603001\":\"3\",\"f550201\":\"null,22&8,24&10,25&5,26&9,27&5,28&7,29&6,1340&8,162&5,196&8,163&11,471&9,493&9,384&11,188&7,266&13,178&7,159&10,405&5,30&8,31&8,53&7,10&9\",\"f110001\":\"0\",\"f550202\":\"null,22&7,24&7,25&4,26&7,27&6,28&7,29&7,1340&7,162&6,196&7,163&8,471&8,493&6,384&7,188&7,266&9,178&5,159&7,405&6,30&6,31&5,53&6,10&3\",\"f502001\":\"1\",\"f502002\":\"1\",\"f611001\":\"4\",\"f9902\":\"com.oneplus.calculator,com.instamag.activity,com.doc360.client,com.oneplus.card,com.sohu.inputmethod.sogou,fucai3d.main,com.jifen.qukan,com.cootek.crazyreader,com.hexin.plat.android,com.xiachufang,com.cleanmaster.mguard_cn,cn.oneplus.wallet,com.oneplus.backuprestore,com.lechuan.midunovel,com.autonavi.manu.widget,com.tencent.reading,com.nineton.weatherforecast,happy.merge.pigpig,org.zwanoo.android.speedtest,com.oneplus.iconpack.circle,com.ifeng.news2,com.tencent.mm,com.tencent.android.qqdownloader,com.starbaba.stepaward,com.baidu.searchbox,com.oneapp.max.security.pro.cn,cn.easymobi.application.phonecall,com.android.egg,com.yuncheapp.android.pearl,vip.qufenqian.crab,com.ttyouqu.app,com.duoduo.opera,com.oneplus.iconpack.square,com.tencent.wifimanager,com.shoujiduoduo.ringtone,com.tencent.qqlive,com.tencent.mtt,com.xunmeng.pinduoduo,com.sina.mail.free,com.clov4r.android.nil,com.redteamobile.oneplus.roaming,com.oneplus.iconpack.oneplus,tv.pps.mobile,com.ss.android.article.lite,com.google.android.syncadapters.contacts,net.oneplus.widget,com.google.android.partnersetup,com.beststudio.good.habit,com.subway.bjsubway,com.kugou.android,zz.dela.cmcc.traffic,com.baidu.baidumap,com.oneplus.iconpack.h2folio,com.oneplus.iconpack.h2light,cn.cisc,cn.cntv,com.oneplus.bbs,com.liulishuo.engzo,com.tencent.gallerymanager,com.qihoo.appstore,net.oneplus.h2launcher,com.cmcc.cmvideo,com.weili.wangcaiba,com.hireader.novel,com.autonavi.minimap,com.oneplus.cloud,com.pkuhit.phmm,com.kmxs.reader,com.mango.doubleball,com.kk.xx.analyzer,cn.cntv.zongyichunwan,com.smile.gifmaker,com.bmcc.ms.ui,com.oneplus.iconpack.h2default,com.taobao.taobao,com.oneapp.max.cn,com.eg.android.alipaygphone\",\"f505001\":\"2700-4499\",\"f9906\":\"18,19,22,32,21,31,\\\\N,15,24,13,20,26,12\",\"f9907\":\"1801,1806,1901,2208,3203,2103,3206,2108,2203,1904,2202,3106,\\\\N,2206,1505,1504,2403,1305,2002,1506,3104,2602,2604,2605,1803,2003,2004,1201,1203,1805,3204,3205,3207\",\"f9908\":\"0\",\"f770102\":\"1\",\"f809001\":\"1\",\"f809002\":\"0\",\"f770501\":\"0\",\"f606002\":\"1\",\"f606001\":\"1\",\"f201001\":\"42211\",\"f102001\":\"02.06.0003\",\"f830001\":\"58350,57820\",\"f830002\":\"23096,23411\",\"f830003\":\"07.10.0027,07.11.0013\",\"f830004\":\"1,1\",\"f660001\":\"9\",\"f609001\":\"1\",\"f804004\":\"5\",\"f804003\":\"6\",\"f804002\":\"9\",\"f9930\":\"2\",\"f804001\":\"8\",\"f9931\":\"-1\",\"f301001\":\"16779\",\"f9932\":\"-1\",\"f9933\":\"-1\",\"f9934\":\"-1\",\"f550102\":\"null,11&14,23&4,13&1,24&0,14&1,25&15,15&2,16&1,17&2,18&8,19&7,1&5,2&1,3&1,4&1,5&1,6&1,7&3,8&4,9&4,20&7,21&1,10&1\",\"f550101\":\"null,11&4,23&5,13&2,24&0,14&3,25&3,15&4,16&4,17&3,18&2,19&4,1&5,2&2,3&3,4&3,5&2,6&3,7&5,8&5,9&5,20&4,21&4,10&3\",\"f108001\":\"315385\",\"advertId\":\"43895\",\"f807002\":\"12\",\"f9924\":\"02.01.0007,02.14\",\"f807001\":\"1\",\"f507001\":\"2\",\"f9925\":\"null,22&g2,12&g1,13&g1,24&g1,26&g1,15&g2,18&g1,19&g2,\\\\N&g2,20&g1,31&g1,21&g2,32&g2\",\"f807004\":\"7\",\"f830111\":\"null,57820_43895\",\"f9926\":\"null,2108&g1,2602&g1,2206&g2,2403&g2,2203&g1,2004&g1,2202&g2,2103&g2,2003&g1,2002&g2,2605&g1,2604&g1,2208&g1,1305&g1,3207&g1,\\\\N&g3,3206&g2,3205&g1,1203&g1,3106&g1,3204&g1,1201&g1,3104&g1,3203&g2,1806&g1,1805&g1,1904&g2,1803&g1,1506&g1,1505&g1,1901&g1,1504&g3,1801&g1\",\"f807003\":\"2\",\"f830112\":\"null,23411_12311\",\"f9927\":\"0\",\"f810001\":\"null\",\"f770001\":\"07.23.0013\",\"f830113\":\"null,07.11.0013_07.23.0013\",\"f9928\":\"0\",\"f810002\":\"null\",\"f830114\":\"null,1_9\",\"f9929\":\"0\",\"f770401\":\"0\",\"f9921\":\"\",\"f306001\":\"2\",\"f9922\":\"\",\"f770402\":\"0\",\"f9923\":\"\",\"f604002\":\"3\",\"f604001\":\"3\",\"f501001\":\"Android\",\"f610001\":\"0\",\"chargeType\":\"1\",\"f206001\":\"262\",\"f504001\":\"ONEPLUS A5010\",\"f660102\":\"1\",\"f601001\":\"3\",\"f601002\":\"3\",\"f303001\":\"28\",\"f550402\":\"null,22&5,24&3,25&4,26&5,27&5,28&5,29&5,1340&6,162&4,196&5,471&7,163&6,493&4,384&6,188&5,178&5,266&6,159&5,405&1,30&3,53&6,31&4,10&6\",\"f607001\":\"0\",\"f550401\":\"null,22&8,24&12,25&4,26&7,27&6,28&8,29&6,1340&7,162&7,196&7,471&10,163&9,493&11,384&12,188&7,178&9,266&12,159&12,405&5,30&7,53&8,31&11,10&6\",\"f406001\":\"0\",\"f206002\":\"260\",\"f811001\":\"103\",\"f403004\":\"0\",\"f830011\":\"{0=57820, 2=, 3=}\",\"f805001\":\"1\",\"f830012\":\"{0=23411, 2=, 3=}\",\"f805002\":\"2\",\"f830013\":\"{0=07.11.0013, 2=, 3=}\",\"f805003\":\"2\",\"f830014\":\"{0=1, 2=, 3=}\",\"f805004\":\"2\",\"f602001\":\"3\",\"f115001\":\"0\",\"f205002\":\"253\",\"f205001\":\"25\",\"f701001\":\"1043895\",\"f404007\":\"news,share_fund,ecommerce,adulteducation,reading,lottery,video,earnonline,finance,shopping\",\"f808002\":\"0_0,02.14_0,02.01.0007_0\",\"f404002\":\"old\",\"f811002\":\"103\",\"f404003\":\"work\",\"f106001\":\"12311\",\"f506001\":\"1\",\"f404004\":\"college\",\"f660201\":\"0\",\"f8807\":\"1\",\"f808001\":\"0_1,02.14_1,02.01.0007_1\",\"f8803\":\"1\",\"f605001\":\"1\",\"f605002\":\"1\",\"f550302\":\"null,11&1,23&4,13&1,24&9,25&16,14&1,15&2,16&2,17&1,18&9,19&6,1&14,2&1,3&1,4&1,5&1,6&1,7&1,8&3,9&4,20&5,21&1,10&1\",\"f550301\":\"null,11&2,23&2,13&2,24&3,25&3,14&2,15&2,16&2,17&2,18&2,19&3,1&2,2&2,3&2,4&2,5&2,6&2,7&3,8&3,9&2,20&2,21&2,10&2\",\"f101001\":\"43895\",\"f503001\":\"11\",\"time\":\"20191209014228\",\"f302001\":\"16779\",\"f602002\":\"3\"}";
            String str11 = "{\"orderId\":\"taw-507587971920000\",\"f608001\":\"1\",\"f113001\":\"04.01.0003\",\"f9913\":\"11\",\"f508002\":\"AL00\",\"f806001\":\"20\",\"f508001\":\"INE\",\"f806002\":\"7\",\"f806003\":\"12\",\"f830101\":\"null,56923_43895\",\"f806004\":\"4\",\"f830102\":\"null,18489_12311\",\"f830103\":\"null,07.23.0008_07.23.0013\",\"f830104\":\"null\",\"f104001\":\"77741\",\"f603002\":\"1\",\"f603001\":\"1\",\"f110001\":\"0\",\"f502001\":\"1\",\"f502002\":\"1\",\"f611001\":\"1\",\"f505001\":\"\u5176\u4ed6\",\"f770102\":\"1\",\"f770501\":\"0\",\"f606002\":\"0\",\"f606001\":\"-1\",\"f201001\":\"28867\",\"f102001\":\"02.06.0003\",\"f830001\":\"56923\",\"f830002\":\"18489\",\"f830003\":\"07.23.0008\",\"f830004\":\"9\",\"f609001\":\"0\",\"f804004\":\"5\",\"f804003\":\"6\",\"f804002\":\"9\",\"f9930\":\"-1\",\"f804001\":\"8\",\"f9931\":\"-1\",\"f301001\":\"14541\",\"f9932\":\"-1\",\"f9933\":\"-1\",\"f9934\":\"-1\",\"f550102\":\"null,11&17,23&5,13&1,24&16,14&1,25&17,15&7,16&3,17&3,18&14,19&10,1&7,2&2,3&2,4&1,5&1,6&2,7&1,8&6,9&7,20&8,10&1,21&5\",\"f550101\":\"null,11&4,23&6,13&3,24&7,14&3,25&6,15&5,16&4,17&6,18&8,19&7,1&6,2&3,3&4,4&2,5&2,6&6,7&12,8&5,9&8,20&4,10&3,21&8\",\"f108001\":\"203809\",\"advertId\":\"43895\",\"f807002\":\"7\",\"f807001\":\"13\",\"f507001\":\"3\",\"f807004\":\"4\",\"f830111\":\"null\",\"f807003\":\"10\",\"f830112\":\"null\",\"f9927\":\"-1\",\"f810001\":\"null\",\"f770001\":\"07.23.0013\",\"f830113\":\"null\",\"f9928\":\"-1\",\"f810002\":\"null\",\"f830114\":\"null\",\"f9929\":\"-1\",\"f770401\":\"0\",\"f306001\":\"2\",\"f770402\":\"0\",\"f604002\":\"1\",\"f604001\":\"1\",\"f501001\":\"Android\",\"f610001\":\"0\",\"chargeType\":\"2\",\"f206001\":\"262\",\"f504001\":\"INE-AL00\",\"f601001\":\"1\",\"f601002\":\"1\",\"f303001\":\"28\",\"f114001\":\"118\",\"f607001\":\"1\",\"f114002\":\"120\",\"f406001\":\"0\",\"f206002\":\"260\",\"f403004\":\"0\",\"f830011\":\"{0=, 2=, 3=}\",\"f805001\":\"15\",\"f830012\":\"{0=, 2=, 3=}\",\"f805002\":\"11\",\"f830013\":\"{0=, 2=, 3=}\",\"f805003\":\"10\",\"f830014\":\"{0=, 2=, 3=}\",\"f805004\":\"6\",\"f602001\":\"1\",\"f115001\":\"0\",\"f205002\":\"39\",\"f205001\":\"22\",\"f701001\":\"1043895\",\"f404003\":\"workother\",\"f106001\":\"12311\",\"f506001\":\"2\",\"f121001\":\"001003\",\"f121002\":\"005002\",\"f121003\":\"false\",\"f121004\":\"003003\",\"f8807\":\"1\",\"f121005\":\"004006\",\"f121006\":\"002002\",\"f8803\":\"1\",\"f605001\":\"-1\",\"f605002\":\"0\",\"f112001\":\"05.02.0018,05.02.0008\",\"f550302\":\"null,11&17,23&1,13&0,24&17,25&17,14&1,15&4,16&2,17&1,18&11,19&4,1&4,2&1,3&1,4&1,5&1,6&1,7&1,8&6,9&5,20&4,10&1,21&1\",\"f550301\":\"null,11&4,23&5,13&1,24&4,25&11,14&11,15&6,16&7,17&7,18&7,19&6,1&6,2&5,3&3,4&3,5&2,6&5,7&5,8&4,9&9,20&8,10&3,21&6\",\"f101001\":\"43895\",\"f503001\":\"3301\",\"time\":\"20191209014229\",\"f302001\":\"14541\",\"f602002\":\"1\"}";
            String str12 = "{\"orderId\":\"taw-507587508230779\",\"f608001\":\"1\",\"f113001\":\"04.01.0003\",\"f9913\":\"11\",\"f508002\":\"AL00\",\"f806001\":\"7\",\"f508001\":\"LLD\",\"f806002\":\"6\",\"f806003\":\"5\",\"f830101\":\"null\",\"f806004\":\"4\",\"f830102\":\"null\",\"f830103\":\"null\",\"f830104\":\"null\",\"f104001\":\"77741\",\"f603002\":\"1\",\"f603001\":\"1\",\"f110001\":\"0\",\"f502001\":\"1\",\"f502002\":\"1\",\"f611001\":\"1\",\"f505001\":\"600-1099\",\"f770102\":\"1\",\"f770501\":\"0\",\"f606002\":\"0\",\"f606001\":\"-1\",\"f201001\":\"68585\",\"f102001\":\"02.06.0003\",\"f609001\":\"0\",\"f804004\":\"5\",\"f804003\":\"6\",\"f804002\":\"9\",\"f9930\":\"-1\",\"f804001\":\"8\",\"f9931\":\"-1\",\"f301001\":\"16474\",\"f9932\":\"-1\",\"f9933\":\"-1\",\"f9934\":\"-1\",\"f550102\":\"null,11&17,23&5,24&16,13&1,14&1,25&17,15&7,16&3,17&3,18&14,19&10,1&7,2&2,3&2,4&1,5&1,6&2,7&1,8&6,9&7,20&8,10&1,21&5\",\"f550101\":\"null,11&4,23&6,24&7,13&3,14&3,25&6,15&5,16&4,17&6,18&8,19&7,1&6,2&3,3&4,4&2,5&2,6&6,7&12,8&5,9&8,20&4,10&3,21&8\",\"f108001\":\"318885\",\"advertId\":\"43895\",\"f807002\":\"7\",\"f807001\":\"7\",\"f507001\":\"1\",\"f807004\":\"4\",\"f830111\":\"null\",\"f807003\":\"5\",\"f830112\":\"null\",\"f9927\":\"-1\",\"f810001\":\"null\",\"f770001\":\"07.23.0013\",\"f830113\":\"null\",\"f9928\":\"-1\",\"f810002\":\"null\",\"f830114\":\"null\",\"f9929\":\"-1\",\"f770401\":\"0\",\"f306001\":\"2\",\"f770402\":\"0\",\"f604002\":\"1\",\"f604001\":\"1\",\"f501001\":\"Android\",\"f610001\":\"0\",\"chargeType\":\"2\",\"f206001\":\"262\",\"f504001\":\"LLD-AL00\",\"f601001\":\"1\",\"f601002\":\"1\",\"f303001\":\"28\",\"f607001\":\"1\",\"f406001\":\"5\",\"f206002\":\"260\",\"f403004\":\"0\",\"f830011\":\"{}\",\"f805001\":\"7\",\"f830012\":\"{}\",\"f805002\":\"6\",\"f830013\":\"{}\",\"f805003\":\"5\",\"f830014\":\"{}\",\"f805004\":\"4\",\"f602001\":\"1\",\"f115001\":\"0\",\"f205002\":\"44\",\"f205001\":\"22\",\"f701001\":\"1043895\",\"f404003\":\"workother\",\"f106001\":\"12311\",\"f506001\":\"1\",\"f121001\":\"001003\",\"f121002\":\"005002\",\"f121003\":\"false\",\"f121004\":\"003003\",\"f8807\":\"1\",\"f121005\":\"004006\",\"f121006\":\"002002\",\"f8803\":\"1\",\"f605001\":\"-1\",\"f605002\":\"0\",\"f112001\":\"05.02.0018,05.02.0008\",\"f550302\":\"null,11&18,23&1,13&0,25&17,14&0,15&5,16&3,17&0,1&11,2&0,3&2,4&0,6&1,8&2,9&5,20&5,21&3,10&0\",\"f550301\":\"null,11&8,23&5,13&1,25&5,14&1,15&3,16&4,17&1,1&6,2&1,3&4,4&1,6&6,8&8,9&4,20&3,21&3,10&1\",\"f101001\":\"43895\",\"f503001\":\"4101\",\"time\":\"20191209014228\",\"f302001\":\"16474\",\"f602002\":\"1\"}";
            String str13 = "{\"orderId\":\"taw-503825544300528\",\"f608001\":\"1\",\"f113001\":\"04.01.0003\",\"f9913\":\"11\",\"f508002\":\"PCAM00\",\"f806001\":\"13\",\"f508001\":\"\",\"f806002\":\"12\",\"f806003\":\"9\",\"f830101\":\"null\",\"f806004\":\"7\",\"f830102\":\"null\",\"f830103\":\"null\",\"f830104\":\"null\",\"f104001\":\"81987\",\"f603002\":\"1\",\"f603001\":\"1\",\"f110001\":\"0\",\"f502001\":\"11\",\"f502002\":\"3\",\"f611001\":\"1\",\"f505001\":\"\u5176\u4ed6\",\"f770102\":\"1\",\"f770501\":\"0\",\"f606002\":\"0\",\"f606001\":\"-1\",\"f201001\":\"54420\",\"f102001\":\"02.06.0003\",\"f609001\":\"0\",\"f804004\":\"6\",\"f804003\":\"7\",\"f804002\":\"11\",\"f9930\":\"-1\",\"f804001\":\"9\",\"f9931\":\"-1\",\"f301001\":\"13744\",\"f9932\":\"-1\",\"f9933\":\"-1\",\"f9934\":\"-1\",\"f550102\":\"null,11&17,23&6,13&1,14&1,25&15,15&7,16&4,17&1,18&4,19&8,1&5,2&3,3&1,4&1,5&1,6&2,7&1,8&4,9&8,20&9,21&6,10&1\",\"f550101\":\"null,11&4,23&5,13&4,14&6,25&2,15&4,16&6,17&10,18&6,19&7,1&4,2&3,3&8,4&8,5&2,6&4,7&10,8&4,9&9,20&7,21&11,10&5\",\"f108001\":\"293434\",\"advertId\":\"43895\",\"f807002\":\"12\",\"f807001\":\"17\",\"f507001\":\"2\",\"f807004\":\"7\",\"f830111\":\"null\",\"f807003\":\"12\",\"f830112\":\"null\",\"f9927\":\"-1\",\"f810001\":\"null\",\"f770001\":\"07.23.0013\",\"f830113\":\"null\",\"f9928\":\"-1\",\"f810002\":\"null\",\"f830114\":\"null\",\"f9929\":\"-1\",\"f770401\":\"0\",\"f306001\":\"2\",\"f770402\":\"0\",\"f604002\":\"1\",\"f604001\":\"1\",\"f501001\":\"Android\",\"f610001\":\"0\",\"chargeType\":\"2\",\"f206001\":\"262\",\"f504001\":\"PCAM00\",\"f601001\":\"1\",\"f601002\":\"1\",\"f303001\":\"28\",\"f114001\":\"118\",\"f607001\":\"1\",\"f114002\":\"123\",\"f406001\":\"2\",\"f206002\":\"260\",\"f403004\":\"0\",\"f830011\":\"{}\",\"f805001\":\"13\",\"f830012\":\"{}\",\"f805002\":\"12\",\"f830013\":\"{}\",\"f805003\":\"9\",\"f830014\":\"{}\",\"f805004\":\"7\",\"f602001\":\"1\",\"f115001\":\"0\",\"f205002\":\"472\",\"f205001\":\"471\",\"f701001\":\"1043895\",\"f404003\":\"workother\",\"f106001\":\"12311\",\"f506001\":\"1\",\"f121003\":\"null\",\"f8807\":\"1\",\"f8803\":\"1\",\"f605001\":\"-1\",\"f605002\":\"0\",\"f112001\":\"05.02.0018,05.02.0008\",\"f550302\":\"null,11&19,23&5,13&0,14&0,25&17,15&4,16&4,17&9,18&19,19&7,1&1,2&1,3&1,4&0,5&0,6&2,7&1,9&7,20&10,10&0,21&7\",\"f550301\":\"null,11&8,23&8,13&1,14&1,25&6,15&3,16&5,17&7,18&10,19&7,1&3,2&2,3&8,4&1,5&1,6&3,7&4,9&10,20&7,10&1,21&9\",\"f101001\":\"43895\",\"f503001\":\"4101\",\"time\":\"20191204115926\",\"f302001\":\"13744\",\"f602002\":\"1\"}";
            String str14 = "{\"orderId\":\"taw-503820069980471\",\"f608001\":\"0\",\"f113001\":\"04.01.0003\",\"f9913\":\"11\",\"f508002\":\"AL00\",\"f806001\":\"1\",\"f508001\":\"STK\",\"f806002\":\"1\",\"f806003\":\"2\",\"f830101\":\"null,58908_43895,58617_43895,42180_43895,58420_43895,35186_43895\",\"f806004\":\"2\",\"f830102\":\"null,24305_12311,23841_12311,6419_12311,23745_12311,323_12311\",\"f830103\":\"null,07.24.0001_07.23.0013,07.24.0001_07.23.0013,07.11.0019_07.23.0013,07.24.0013_07.23.0013\",\"f830104\":\"null\",\"f104001\":\"81987\",\"f603002\":\"10\",\"f603001\":\"-1\",\"f110001\":\"1\",\"f502001\":\"11\",\"f502002\":\"3\",\"f611001\":\"17\",\"f770102\":\"1\",\"f770501\":\"0\",\"f606002\":\"1\",\"f606001\":\"1\",\"f201001\":\"60119\",\"f102001\":\"02.06.0003\",\"f830001\":\"58908,58617,42180,58420,35186\",\"f830002\":\"24305,23841,6419,23745,323\",\"f830003\":\"07.24.0001,07.24.0001,07.11.0019,07.24.0013\",\"f830004\":\"8,8,11,8,10\",\"f609001\":\"1\",\"f804004\":\"6\",\"f804003\":\"7\",\"f804002\":\"11\",\"f9930\":\"-1\",\"f804001\":\"9\",\"f9931\":\"-1\",\"f301001\":\"17083\",\"f9932\":\"-1\",\"f9933\":\"-1\",\"f9934\":\"-1\",\"f550102\":\"null,11&14,23&4,24&0,13&1,25&17,14&1,15&2,16&1,17&4,18&8,19&7,1&5,2&1,3&1,4&1,5&1,6&1,7&3,8&6,9&4,20&7,21&2,10&1\",\"f550101\":\"null,11&4,23&5,24&0,13&2,25&5,14&2,15&4,16&4,17&3,18&3,19&4,1&5,2&2,3&3,4&3,5&2,6&3,7&5,8&5,9&5,20&3,21&5,10&3\",\"f108001\":\"299802\",\"advertId\":\"43895\",\"f807002\":\"1\",\"f807001\":\"1\",\"f507001\":\"1\",\"f807004\":\"2\",\"f830111\":\"null\",\"f807003\":\"2\",\"f830112\":\"null\",\"f9927\":\"-1\",\"f810001\":\"null\",\"f770001\":\"07.23.0013\",\"f830113\":\"null\",\"f9928\":\"-1\",\"f810002\":\"null\",\"f830114\":\"null\",\"f9929\":\"-1\",\"f770401\":\"0\",\"f306001\":\"2\",\"f770402\":\"0\",\"f604002\":\"15\",\"f604001\":\"-1\",\"f501001\":\"Android\",\"f610001\":\"0\",\"chargeType\":\"2\",\"f206001\":\"262\",\"f504001\":\"STK-AL00\",\"f601001\":\"-1\",\"f601002\":\"12\",\"f303001\":\"28\",\"f114001\":\"118\",\"f607001\":\"0\",\"f114002\":\"127\",\"f406001\":\"12\",\"f206002\":\"260\",\"f403004\":\"0\",\"f830011\":\"{0=, 2=, 3=}\",\"f805001\":\"2\",\"f830012\":\"{0=, 2=, 3=}\",\"f805002\":\"1\",\"f830013\":\"{0=, 2=, 3=}\",\"f805003\":\"2\",\"f830014\":\"{0=, 2=, 3=}\",\"f805004\":\"2\",\"f602001\":\"-1\",\"f115001\":\"0\",\"f205002\":\"253\",\"f205001\":\"25\",\"f701001\":\"1043895\",\"f404003\":\"workother\",\"f106001\":\"12311\",\"f506001\":\"1\",\"f121003\":\"null\",\"f8807\":\"1\",\"f8803\":\"1\",\"f605001\":\"1\",\"f605002\":\"1\",\"f112001\":\"05.02.0018,05.02.0008\",\"f550302\":\"null,11&11,23&1,13&1,14&0,25&10,15&2,16&1,17&1,18&4,19&1,1&1,2&1,3&1,4&1,5&1,6&1,7&1,8&4,9&2,20&2,10&1,21&1\",\"f550301\":\"null,11&3,23&4,13&2,14&1,25&2,15&2,16&2,17&3,18&3,19&2,1&3,2&2,3&2,4&2,5&2,6&2,7&4,8&5,9&3,20&2,10&2,21&2\",\"f101001\":\"43895\",\"f503001\":\"4304\",\"time\":\"20191204115028\",\"f302001\":\"17083\",\"f602002\":\"17\"}";
            List<String> strList = Arrays.asList(str1, str2, str3, str4, str5, str6, str7, str8, str9, str10, str11, str12, str13, str14);
            for (int i = 0; i < 14; ++i) {
                JSONObject featureIdxMap = JSON.parseObject((String)strList.get(i));
                Double retCtr1 = modelCtr.predict((Map)featureIdxMap);
                Double retCvr1 = modelCvr.predict((Map)featureIdxMap);
                featureIdxMap.put("f104001", "81987");
                if (i >= 12) {
                    featureIdxMap.put("f104001", "77741");
                }
                Double retCtr2 = modelCtr.predict((Map)featureIdxMap);
                Double retCvr2 = modelCvr.predict((Map)featureIdxMap);
                System.out.println(i + ",ctr1=" + retCtr1 + ",cvr1=" + retCvr1 + ",ctr2=" + retCtr2 + ",cvr2=" + retCvr2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void test2() {
        try {
            String key2 = "mid_ftrl_fm_bcvr_v335";
            String f0 = "{\"orderId\":\"taw-587910242000078\",\"f608001\":\"0\",\"f113001\":\"04.01.0008,04.03.0017,04.03.0020\",\"f508002\":\"V1941A\",\"f806001\":\"5\",\"f508001\":\"\",\"f9914\":\"\",\"f806002\":\"33\",\"f9915\":\"\",\"f806003\":\"5\",\"f830101\":\"null,61979_62030,43532_62030,61663_62030,43532_62030\",\"f9916\":\"02.20.0001&10,02.24.0001&7,02.24.0002&10,02.01.0003&10,02.01.0007&10,02.23.0001&11,02.23.0003&9,02.22.0001&10,02.22.0004&10,02.22.0006&11,02.16&10,02.17&7,02.06&9,02.19&2,02.07&7,02.15&9,02.03&9,02.14&11,02.09&9\",\"f806004\":\"18\",\"f830102\":\"null,25786_26569,12918_26569,26239_26569,12918_26569\",\"f9917\":\"02.20.0001&1,02.24.0001&1,02.24.0002&1,02.01.0003&1,02.01.0007&1,02.23.0001&1,02.23.0003&1,02.22.0001&1,02.22.0004&1,02.22.0006&1,02.16&1,02.17&1,02.06&1,02.19&2,02.07&1,02.15&1,02.03&1,02.14&9,02.09&1\",\"f830103\":\"null,07.10.0004_07.10.0103,07.10.0073_07.10.0103,07.10.0004_07.10.0103\",\"f9918\":\"02.20.0001&1,02.24.0001&1,02.24.0002&1,02.01.0003&1,02.01.0007&1,02.23.0001&1,02.23.0003&1,02.22.0001&1,02.22.0004&1,02.22.0006&1,02.16&1,02.17&1,02.06&1,02.19&1,02.07&1,02.15&1,02.03&1,02.14&1,02.09&1\",\"f830104\":\"null\",\"f9919\":\"02.20.0001&4,02.24.0001&6,02.24.0002&4,02.01.0003&4,02.01.0007&4,02.23.0001&2,02.23.0003&4,02.22.0001&4,02.22.0004&4,02.22.0006&4,02.16&4,02.17&6,02.06&4,02.19&9,02.07&6,02.15&5,02.03&5,02.14&3,02.09&5\",\"f104001\":\"87540\",\"f603002\":\"5\",\"f603001\":\"5\",\"f110001\":\"1\",\"f502001\":\"15\",\"f502002\":\"7\",\"f611001\":\"14\",\"f9902\":\"7481,6047,8070,6675,9037,7607,7086,5202,9699,7856,7795,9832,8633,1283,7893,8925,7866,8852,5677,7589,7590,3726,7860,3902,3680,7422,1182,3771,648,3701,1165,5003,7129,8397,7413,7751,3684,2187,481\",\"f9906\":\"\",\"f9907\":\"\",\"f9908\":\"0\",\"f770102\":\"1\",\"f809001\":\"1\",\"f809002\":\"1\",\"f770501\":\"0\",\"f606002\":\"8\",\"f606001\":\"99\",\"f201001\":\"64631\",\"f102001\":\"02.14.0001\",\"f830001\":\"61979,43532,61663,43532\",\"f830002\":\"25786,12918,26239,12918\",\"f830003\":\"07.10.0004,07.10.0073,07.10.0004\",\"f830004\":\"16,1\",\"f609001\":\"0\",\"f804004\":\"18\",\"f804003\":\"5\",\"f804002\":\"33\",\"f9930\":\"12\",\"f804001\":\"5\",\"f9931\":\"-1\",\"f301001\":\"17572\",\"f9932\":\"-1\",\"f9933\":\"-1\",\"f9934\":\"-1\",\"f108001\":\"319307\",\"advertId\":\"62030\",\"f807002\":\"33\",\"f9924\":\"02.01.0003,02.01.0007,02.07,02.22.0006,02.06,02.24.0001,02.15,02.20.0001,02.23.0003,02.23.0001,02.03,02.14\",\"f807001\":\"8\",\"f507001\":\"1\",\"f807004\":\"18\",\"f830111\":\"null\",\"f807003\":\"6\",\"f830112\":\"null\",\"f9927\":\"0\",\"f810001\":\"null\",\"f770001\":\"07.10.0103\",\"f830113\":\"null\",\"f9928\":\"0\",\"f810002\":\"null\",\"f830114\":\"null\",\"f9929\":\"6\",\"f770401\":\"0\",\"f9921\":\"\",\"f306001\":\"2\",\"f9922\":\"\",\"f770402\":\"0\",\"f9923\":\"02.22.0001,02.22.0004,02.24.0002,02.17,02.16,02.09\",\"f604002\":\"10\",\"f604001\":\"12\",\"f501001\":\"Android\",\"f610001\":\"0\",\"chargeType\":\"1\",\"f206001\":\"262\",\"f504001\":\"V1941A\",\"f601001\":\"-1\",\"f601002\":\"11\",\"f303001\":\"28\",\"f607001\":\"0\",\"f406001\":\"0\",\"f206002\":\"260\",\"f811001\":\"107,302,402\",\"f403004\":\"0\",\"f830011\":\"{0=, 2=, 3=}\",\"f805001\":\"5\",\"f830012\":\"{0=, 2=, 3=}\",\"f805002\":\"33\",\"f830013\":\"{0=, 2=, 3=}\",\"f805003\":\"5\",\"f830014\":\"{0=, 2=, 3=}\",\"f805004\":\"18\",\"f9701\":\"010601,0201,020101,020105,020114,020207,020209,020408,020601,0207,020702,020706,02070602,02070603,020710,020714,0208,020801,0211,021103,021118,021119,02112001,021126,021308,0214,021404,022406,050117\",\"f602001\":\"-1\",\"f115001\":\"0\",\"f205002\":\"55\",\"f205001\":\"27\",\"f701001\":\"1062030\",\"f404007\":\"news,ecommerce,teeneducation,video,shopping\",\"f808002\":\"02.22.0001_0,02.01.0003_0,02.22.0004_0,02.01.0007_0,02.07_0,02.24.0002_0,02.22.0006_0,02.17_0,02.06_0,02.24.0001_0,02.16_0,02.15_0,02.09_0,02.19_1,0_1,02.20.0001_0,02.23.0003_0,02.23.0001_0,02.03_0,02.14_1\",\"f404002\":\"young\",\"f811002\":\"107\",\"f404003\":\"workother\",\"f106001\":\"26569\",\"f506001\":\"1\",\"f404004\":\"milldleschool\",\"f121003\":\"null\",\"f8807\":\"1\",\"f808001\":\"02.22.0001_1,02.01.0003_1,02.22.0004_1,02.01.0007_1,02.07_1,02.24.0002_1,02.22.0006_1,02.17_1,02.06_1,02.24.0001_1,02.16_1,02.15_1,02.09_1,02.19_12,0_1,02.20.0001_1,02.23.0003_1,02.23.0001_1,02.03_1,02.14_5\",\"f8803\":\"1\",\"f605001\":\"99\",\"f605002\":\"8\",\"f112001\":\"05.02.0018\",\"f101001\":\"62030\",\"f503001\":\"3208\",\"time\":\"20200223151720\",\"f302001\":\"17572\",\"f602002\":\"15\"}";
            String f1 = "{\"orderId\":\"taw-587911778930550\",\"f608001\":\"0\",\"f113001\":\"04.01.0008,04.03.0017,04.03.0020\",\"f508002\":\"Y66iA\",\"f806001\":\"5\",\"f508001\":\"vivo\",\"f9914\":\"\",\"f806002\":\"33\",\"f9915\":\"\",\"f806003\":\"5\",\"f830101\":\"null,60574_62030\",\"f9916\":\"02.20.0001&9,02.01.0004&9,02.01.0008&10,02.23.0001&10,02.23.0003&9,02.14&10\",\"f806004\":\"18\",\"f830102\":\"null,9876_26569\",\"f9917\":\"02.20.0001&1,02.01.0004&1,02.01.0008&1,02.23.0001&1,02.23.0003&1,02.14&1\",\"f830103\":\"null,07.10.0004_07.10.0103\",\"f9918\":\"02.20.0001&1,02.01.0004&1,02.01.0008&1,02.23.0001&1,02.23.0003&1,02.14&1\",\"f830104\":\"null\",\"f9919\":\"02.20.0001&5,02.01.0004&5,02.01.0008&4,02.23.0001&4,02.23.0003&5,02.14&4\",\"f104001\":\"87540\",\"f603002\":\"1\",\"f603001\":\"1\",\"f110001\":\"0\",\"f502001\":\"15\",\"f502002\":\"7\",\"f611001\":\"3\",\"f9902\":\"6228,9789,7481,7962,7454,5402,5202,7856,10922,7788,8870,8826,1283,11204,5928,8925,8233,5904,7606,7860,3902,3680,2789,2923,7422,2773,10587,10285,1215,7751,5211,9921\",\"f505001\":\"1100-1699\",\"f9906\":\"\",\"f9907\":\"\",\"f9908\":\"0\",\"f770102\":\"1\",\"f809001\":\"1\",\"f809002\":\"0\",\"f770501\":\"0\",\"f606002\":\"10\",\"f606001\":\"99\",\"f201001\":\"64631\",\"f102001\":\"02.14.0001\",\"f830001\":\"60574\",\"f830002\":\"9876\",\"f830003\":\"07.10.0004\",\"f830004\":\"\",\"f609001\":\"0\",\"f804004\":\"18\",\"f804003\":\"5\",\"f804002\":\"33\",\"f9930\":\"5\",\"f804001\":\"5\",\"f9931\":\"-1\",\"f301001\":\"17572\",\"f9932\":\"-1\",\"f9933\":\"-1\",\"f9934\":\"-1\",\"f108001\":\"319307\",\"advertId\":\"62030\",\"f807002\":\"33\",\"f9924\":\"02.01.0008,02.20.0001,02.23.0003,02.23.0001,02.14\",\"f807001\":\"8\",\"f507001\":\"3\",\"f807004\":\"18\",\"f830111\":\"null\",\"f807003\":\"6\",\"f830112\":\"null\",\"f9927\":\"0\",\"f810001\":\"null\",\"f770001\":\"07.10.0103\",\"f830113\":\"null\",\"f9928\":\"0\",\"f810002\":\"null\",\"f830114\":\"null\",\"f9929\":\"1\",\"f770401\":\"0\",\"f9921\":\"\",\"f306001\":\"2\",\"f9922\":\"\",\"f770402\":\"0\",\"f9923\":\"02.01.0004\",\"f604002\":\"5\",\"f604001\":\"5\",\"f501001\":\"Android\",\"f610001\":\"0\",\"chargeType\":\"1\",\"f206001\":\"262\",\"f504001\":\"vivo Y66i A\",\"f601001\":\"3\",\"f601002\":\"3\",\"f303001\":\"28\",\"f607001\":\"0\",\"f406001\":\"0\",\"f206002\":\"260\",\"f811001\":\"105\",\"f403004\":\"0\",\"f830011\":\"{0=, 2=, 3=}\",\"f805001\":\"5\",\"f830012\":\"{0=, 2=, 3=}\",\"f805002\":\"33\",\"f830013\":\"{0=, 2=, 3=}\",\"f805003\":\"5\",\"f830014\":\"{0=, 2=, 3=}\",\"f805004\":\"18\",\"f9701\":\"0201,020105,020308,020601,0207,020702,020706,02070602,02070603,020711,02071103,020714,0210,021002,021308,021312,022601,0301,030104,03010401,03011002,03011003,050117\",\"f602001\":\"15\",\"f115001\":\"0\",\"f205002\":\"55\",\"f205001\":\"27\",\"f701001\":\"1062030\",\"f404007\":\"MOBA,ecommerce,reading,video,adventuregame,shopping\",\"f808002\":\"0_0,02.20.0001_0,02.23.0003_0,02.23.0001_0,02.14_0,02.01.0004_0,02.01.0008_0\",\"f404002\":\"young\",\"f811002\":\"105\",\"f404003\":\"work\",\"f106001\":\"26569\",\"f506001\":\"1\",\"f121003\":\"null\",\"f8807\":\"1\",\"f808001\":\"0_1,02.20.0001_1,02.23.0003_1,02.23.0001_1,02.14_1,02.01.0004_1,02.01.0008_1\",\"f8803\":\"1\",\"f605001\":\"1\",\"f605002\":\"1\",\"f112001\":\"05.02.0018\",\"f101001\":\"62030\",\"f503001\":\"4503\",\"time\":\"20200223151839\",\"f302001\":\"17572\",\"f602002\":\"11\"}";
            String f2 = "{\"orderId\":\"taw-587465176240472\",\"f608001\":\"0\",\"f113001\":\"04.03.0013,04.01.0008,04.03.0017,04.03.0009\",\"f508002\":\"AL00\",\"f806001\":\"2\",\"f508001\":\"JKM\",\"f9914\":\"\",\"f806002\":\"17\",\"f9915\":\"\",\"f806003\":\"3\",\"f830101\":\"null,60957_61802,31233_61802,44967_61802,60122_61802,60840_61802\",\"f9916\":\"02.21.0004&9,02.20.0001&10,02.24.0001&10,02.01.0003&11,02.01.0007&9,02.01.0008&10,02.23.0001&12,02.23.0003&12,02.22.0001&11,02.22.0006&11,02.16&11,02.17&10,02.07&10,02.15&9,02.03&11,02.14&11,02.09&10\",\"f806004\":\"10\",\"f830102\":\"null,13566_26310,8220_26310,13922_26310,8331_26310,17599_26310\",\"f9917\":\"02.21.0004&1,02.20.0001&1,02.24.0001&1,02.01.0003&1,02.01.0007&1,02.01.0008&7,02.23.0001&8,02.23.0003&9,02.22.0001&1,02.22.0006&1,02.16&1,02.17&1,02.07&1,02.15&1,02.03&1,02.14&7,02.09&1\",\"f830103\":\"null,07.09.0014_07.10.0093,07.24.0013_07.10.0093,07.09.0018_07.10.0093,07.24.0014_07.10.0093,07.09.0020_07.10.0093\",\"f9918\":\"02.21.0004&1,02.20.0001&1,02.24.0001&1,02.01.0003&1,02.01.0007&1,02.01.0008&1,02.23.0001&1,02.23.0003&1,02.22.0001&1,02.22.0006&1,02.16&1,02.17&1,02.07&1,02.15&1,02.03&1,02.14&1,02.09&1\",\"f830104\":\"null\",\"f9919\":\"02.21.0004&5,02.20.0001&4,02.24.0001&4,02.01.0003&3,02.01.0007&5,02.01.0008&4,02.23.0001&1,02.23.0003&1,02.22.0001&3,02.22.0006&3,02.16&2,02.17&4,02.07&4,02.15&5,02.03&2,02.14&3,02.09&4\",\"f104001\":\"87300\",\"f603002\":\"5\",\"f603001\":\"5\",\"f110001\":\"0\",\"f502001\":\"7\",\"f502002\":\"7\",\"f611001\":\"11\",\"f9902\":\"10300,7481,3692,2127,1857,8070,10038,7609,7607,3977,7911,7856,7875,7795,7068,9076,7421,7901,3454,3456,7893,7866,7996,7610,8682,176,7589,10006,7860,7477,8215,6081,5794,8036,10296,2090,3523,1165,8276,3106,7592,7751,8972,8970,2187,4336\",\"f505001\":\"\u5176\u4ed6\",\"f9906\":\"\",\"f9907\":\"\",\"f9908\":\"0\",\"f770102\":\"1\",\"f809001\":\"1\",\"f809002\":\"1\",\"f770501\":\"0\",\"f606002\":\"1\",\"f606001\":\"1\",\"f201001\":\"67949\",\"f102001\":\"02.14.0001\",\"f830001\":\"60957,31233,44967,60122,60840\",\"f830002\":\"13566,8220,13922,8331,17599\",\"f830003\":\"07.09.0014,07.24.0013,07.09.0018,07.24.0014,07.09.0020\",\"f830004\":\"15,6,15,8,8\",\"f609001\":\"0\",\"f804004\":\"19\",\"f804003\":\"6\",\"f804002\":\"39\",\"f9930\":\"12\",\"f804001\":\"7\",\"f9931\":\"-1\",\"f301001\":\"1493\",\"f9932\":\"-1\",\"f9933\":\"-1\",\"f9934\":\"-1\",\"f108001\":\"322376\",\"advertId\":\"61802\",\"f807002\":\"36\",\"f9924\":\"02.01.0003,02.01.0007,02.07,02.01.0008,02.22.0006,02.24.0001,02.15,02.20.0001,02.23.0003,02.23.0001,02.03,02.14\",\"f807001\":\"3\",\"f507001\":\"3\",\"f807004\":\"18\",\"f830111\":\"null\",\"f807003\":\"3\",\"f830112\":\"null\",\"f9927\":\"0\",\"f810001\":\"null\",\"f770001\":\"07.10.0093\",\"f830113\":\"null\",\"f9928\":\"0\",\"f810002\":\"null\",\"f830114\":\"null\",\"f9929\":\"5\",\"f770401\":\"0\",\"f9921\":\"\",\"f306001\":\"2\",\"f9922\":\"\",\"f770402\":\"0\",\"f9923\":\"02.22.0001,02.17,02.16,02.21.0004,02.09\",\"f604002\":\"11\",\"f604001\":\"15\",\"f501001\":\"Android\",\"f610001\":\"0\",\"chargeType\":\"2\",\"f206001\":\"262\",\"f504001\":\"JKM-AL00\",\"f601001\":\"-1\",\"f601002\":\"10\",\"f303001\":\"2000\",\"f607001\":\"0\",\"f406001\":\"0\",\"f206002\":\"260\",\"f811001\":\"106,203,302\",\"f403004\":\"0\",\"f830011\":\"{0=, 2=, 3=}\",\"f805001\":\"3\",\"f830012\":\"{0=, 2=, 3=}\",\"f805002\":\"19\",\"f830013\":\"{0=, 2=, 3=}\",\"f805003\":\"3\",\"f830014\":\"{0=, 2=, 3=}\",\"f805004\":\"11\",\"f9701\":\"010601,0201,020105,020308,0204,020408,020503,020601,0207,020710,020714,0208,020801,021120,021126,021212,021308,0214,021404,021805,022406,0225\",\"f602001\":\"-1\",\"f115001\":\"2\",\"f205002\":\"395\",\"f205001\":\"31\",\"f701001\":\"3061802\",\"f404007\":\"news,ecommerce,reading,video,live,shopping\",\"f808002\":\"02.22.0001_0,02.01.0003_0,02.01.0007_0,02.07_0,02.01.0008_1,02.22.0006_0,02.17_0,02.24.0001_0,02.16_0,02.21.0004_0,02.15_0,02.09_0,0_1,02.20.0001_0,02.23.0003_1,02.23.0001_1,02.03_0,02.14_1\",\"f811002\":\"107\",\"f404003\":\"work\",\"f106001\":\"26310\",\"f121003\":\"null\",\"f8807\":\"1\",\"f808001\":\"02.22.0001_1,02.01.0003_1,02.01.0007_1,02.07_1,02.01.0008_5,02.22.0006_1,02.17_1,02.24.0001_1,02.16_1,02.21.0004_1,02.15_1,02.09_1,0_1,02.20.0001_1,02.23.0003_2,02.23.0001_1,02.03_1,02.14_2\",\"f8803\":\"1\",\"f605001\":\"1\",\"f605002\":\"1\",\"f112001\":\"05.02.0018\",\"f101001\":\"61802\",\"f503001\":\"6501\",\"time\":\"20200223073810\",\"f302001\":\"1493\",\"f602002\":\"17\"}";
            String f3 = "{\"orderId\":\"taw-587478298810469\",\"f608001\":\"0\",\"f113001\":\"04.03.0013,04.01.0008,04.03.0017\",\"f508002\":\"R9tm\",\"f806001\":\"2\",\"f508001\":\"OPPO\",\"f9914\":\"\",\"f806002\":\"15\",\"f9915\":\"\",\"f806003\":\"2\",\"f830101\":\"null,54204_57480,61035_57480,60505_57480,60505_57480,54432_57480,53107_57480,60840_57480,54204_57480,50778_57480,60505_57480,32095_57480,57855_57480,60505_57480\",\"f9916\":\"02.21.0004&12,02.24.0001&13,02.24.0002&13,02.01.0003&13,02.01.0008&13,02.23.0001&13,02.23.0003&13,02.22.0001&13,02.22.0002&12,02.22.0004&13,02.16&13,02.17&13,02.06&13,02.02&13,02.04&12,02.10&11,02.19&13,02.07&11,02.15&13,02.03&13,02.14&13,02.09&13\",\"f806004\":\"9\",\"f830102\":\"null,13566_23124,25929_23124,22412_23124,22412_23124,20619_23124,8220_23124,17599_23124,13566_23124,323_23124,22412_23124,323_23124,8220_23124,22412_23124\",\"f9917\":\"02.21.0004&10,02.24.0001&10,02.24.0002&1,02.01.0003&1,02.01.0008&1,02.23.0001&1,02.23.0003&10,02.22.0001&1,02.22.0002&1,02.22.0004&1,02.16&1,02.17&1,02.06&1,02.02&10,02.04&1,02.10&1,02.19&10,02.07&1,02.15&1,02.03&1,02.14&1,02.09&10\",\"f830103\":\"null,07.07.0003_07.10.0057,07.24.0001_07.10.0057,07.10.0004_07.10.0057,07.10.0004_07.10.0057,07.24.0001_07.10.0057,07.24.0013_07.10.0057,07.09.0020_07.10.0057,07.07.0003_07.10.0057,07.24.0013_07.10.0057,07.10.0004_07.10.0057,07.24.0013_07.10.0057,07.24.0013_07.10.0057,07.10.0004_07.10.0057\",\"f9918\":\"02.21.0004&1,02.24.0001&1,02.24.0002&1,02.01.0003&1,02.01.0008&1,02.23.0001&1,02.23.0003&1,02.22.0001&1,02.22.0002&1,02.22.0004&1,02.16&1,02.17&1,02.06&1,02.02&1,02.04&1,02.10&1,02.19&1,02.07&1,02.15&1,02.03&1,02.14&1,02.09&1\",\"f830104\":\"null\",\"f9919\":\"02.21.0004&4,02.24.0001&1,02.24.0002&1,02.01.0003&1,02.01.0008&1,02.23.0001&1,02.23.0003&1,02.22.0001&1,02.22.0002&1,02.22.0004&1,02.16&1,02.17&1,02.06&1,02.02&1,02.04&1,02.10&3,02.19&1,02.07&3,02.15&1,02.03&1,02.14&1,02.09&1\",\"f104001\":\"79160\",\"f603002\":\"1\",\"f603001\":\"1\",\"f110001\":\"10\",\"f502001\":\"7\",\"f502002\":\"7\",\"f611001\":\"19\",\"f9902\":\"7454,3692,7609,5189,5191,7856,4745,1575,7795,1821,1220,7991,8130,7893,1184,4582,7866,8852,1742,7610,229,1823,1830,7860,3895,3921,3976,7841,667,1165,9536,731,7129,2003,7413,7751,8778,410\",\"f505001\":\"1700-2699\",\"f9906\":\"\",\"f9907\":\"\",\"f9908\":\"0\",\"f770102\":\"5\",\"f809001\":\"1\",\"f809002\":\"1\",\"f770501\":\"0\",\"f606002\":\"9\",\"f606001\":\"99\",\"f201001\":\"42211\",\"f102001\":\"02.14.0001\",\"f830001\":\"54204,61035,60505,60505,54432,53107,60840,54204,50778,60505,32095,57855,60505\",\"f830002\":\"13566,25929,22412,22412,20619,8220,17599,13566,323,22412,323,8220,22412\",\"f830003\":\"07.07.0003,07.24.0001,07.10.0004,07.10.0004,07.24.0001,07.24.0013,07.09.0020,07.07.0003,07.24.0013,07.10.0004,07.24.0013,07.24.0013,07.10.0004\",\"f830004\":\"16,8,8,5,8,16,4,17,4\",\"f609001\":\"0\",\"f804004\":\"10\",\"f804003\":\"5\",\"f804002\":\"18\",\"f9930\":\"14\",\"f804001\":\"5\",\"f9931\":\"-1\",\"f301001\":\"1874\",\"f9932\":\"-1\",\"f9933\":\"-1\",\"f9934\":\"-1\",\"f108001\":\"327457\",\"advertId\":\"57480\",\"f807002\":\"22\",\"f9924\":\"02.01.0003,02.07,02.01.0008,02.06,02.24.0001,02.04,02.15,02.19,02.10,02.23.0003,02.23.0001,02.03,02.14,02.02\",\"f807001\":\"1\",\"f507001\":\"2\",\"f807004\":\"13\",\"f830111\":\"null\",\"f807003\":\"2\",\"f830112\":\"null\",\"f9927\":\"0\",\"f810001\":\"null\",\"f770001\":\"07.10.0057\",\"f830113\":\"null\",\"f9928\":\"0\",\"f810002\":\"null\",\"f830114\":\"null\",\"f9929\":\"8\",\"f770401\":\"0\",\"f9921\":\"\",\"f306001\":\"2\",\"f9922\":\"\",\"f770402\":\"0\",\"f9923\":\"02.22.0001,02.22.0002,02.22.0004,02.24.0002,02.17,02.16,02.21.0004,02.09\",\"f604002\":\"8\",\"f604001\":\"8\",\"f501001\":\"Android\",\"f610001\":\"0\",\"chargeType\":\"1\",\"f206001\":\"262\",\"f504001\":\"OPPO R9tm\",\"f601001\":\"-1\",\"f601002\":\"12\",\"f303001\":\"2000\",\"f607001\":\"0\",\"f406001\":\"3\",\"f206002\":\"260\",\"f811001\":\"107,203,303\",\"f403004\":\"0\",\"f830011\":\"{0=, 2=, 3=}\",\"f805001\":\"2\",\"f830012\":\"{0=, 2=, 3=}\",\"f805002\":\"25\",\"f830013\":\"{0=, 2=, 3=}\",\"f805003\":\"3\",\"f830014\":\"{0=, 2=, 3=}\",\"f805004\":\"15\",\"f770302\":\"0\",\"f770301\":\"0\",\"f9701\":\"0201,020101,020102,020105,020310,0204,020408,020601,0207,020706,02070602,020710,020714,0208,020801,021101,02110101,02110102,021213,021308,0214,021405,021701,0225,03010601\",\"f602001\":\"-1\",\"f115001\":\"0\",\"f205002\":\"253\",\"f205001\":\"25\",\"f701001\":\"1057480\",\"f404007\":\"news,earnonline\",\"f808002\":\"02.22.0001_0,02.01.0003_0,02.22.0002_0,02.22.0004_0,02.07_0,02.24.0002_0,02.01.0008_0,02.17_0,02.06_0,02.24.0001_1,02.16_0,02.21.0004_1,02.04_0,02.15_0,02.09_1,02.19_1,02.10_0,0_1,02.23.0003_1,02.23.0001_0,02.03_0,02.14_0,02.02_1\",\"f811002\":\"108\",\"f404003\":\"workother\",\"f106001\":\"23124\",\"f121003\":\"null\",\"f8807\":\"1\",\"f808001\":\"02.22.0001_1,02.01.0003_1,02.22.0002_1,02.22.0004_1,02.07_1,02.24.0002_1,02.01.0008_1,02.17_1,02.06_1,02.24.0001_4,02.16_1,02.21.0004_7,02.04_1,02.15_1,02.09_5,02.19_3,02.10_1,0_1,02.23.0003_3,02.23.0001_1,02.03_1,02.14_1,02.02_5\",\"f8803\":\"1\",\"f605001\":\"1\",\"f605002\":\"1\",\"f112001\":\"05.02.0018\",\"f101001\":\"57480\",\"f503001\":\"2102\",\"f770202\":\"5\",\"time\":\"20200223075431\",\"f302001\":\"1874\",\"f602002\":\"20\"}";
            String f4 = "{\"orderId\":\"taw-587478632000727\",\"f608001\":\"1\",\"f113001\":\"04.03.0013,04.01.0008,04.03.0017\",\"f508002\":\"V1818CT\",\"f806001\":\"10\",\"f508001\":\"\",\"f9914\":\"\",\"f806002\":\"35\",\"f9915\":\"\",\"f806003\":\"7\",\"f830101\":\"null\",\"f806004\":\"18\",\"f830102\":\"null\",\"f830103\":\"null\",\"f830104\":\"null\",\"f104001\":\"86726\",\"f603002\":\"1\",\"f603001\":\"1\",\"f110001\":\"0\",\"f502001\":\"7\",\"f502002\":\"7\",\"f611001\":\"1\",\"f9902\":\"3798,2447,3692,1857,1581,9558,7607,11195,7856,1295,1666,7795,1220,1860,10568,5833,7848,9978,7610,64,7589,10841,471,10577,7860,3895,7422,11118,11507,10558,10186,429,1576,9977,2129,7129,9686,10426,612,10206,2566,2187\",\"f505001\":\"\u5176\u4ed6\",\"f9906\":\"\",\"f9907\":\"\",\"f9908\":\"0\",\"f770102\":\"1\",\"f770501\":\"0\",\"f606002\":\"0\",\"f606001\":\"-1\",\"f201001\":\"65009\",\"f102001\":\"02.14.0001\",\"f609001\":\"0\",\"f804004\":\"19\",\"f804003\":\"6\",\"f804002\":\"38\",\"f9930\":\"-1\",\"f804001\":\"8\",\"f9931\":\"-1\",\"f301001\":\"15857\",\"f9932\":\"-1\",\"f9933\":\"-1\",\"f9934\":\"-1\",\"f108001\":\"306460\",\"advertId\":\"61649\",\"f807002\":\"34\",\"f807001\":\"9\",\"f507001\":\"1\",\"f807004\":\"18\",\"f830111\":\"null\",\"f807003\":\"7\",\"f830112\":\"null\",\"f9927\":\"-1\",\"f810001\":\"null\",\"f770001\":\"07.10.0057\",\"f830113\":\"null\",\"f9928\":\"-1\",\"f810002\":\"null\",\"f830114\":\"null\",\"f9929\":\"-1\",\"f770401\":\"0\",\"f306001\":\"2\",\"f770402\":\"0\",\"f604002\":\"1\",\"f604001\":\"1\",\"f501001\":\"Android\",\"f610001\":\"0\",\"chargeType\":\"2\",\"f206001\":\"264\",\"f504001\":\"V1818CT\",\"f601001\":\"1\",\"f601002\":\"1\",\"f303001\":\"30\",\"f114001\":\"118\",\"f607001\":\"1\",\"f114002\":\"121\",\"f406001\":\"0\",\"f206002\":\"263\",\"f403004\":\"0\",\"f830011\":\"{}\",\"f805001\":\"10\",\"f830012\":\"{}\",\"f805002\":\"35\",\"f830013\":\"{}\",\"f805003\":\"7\",\"f830014\":\"{}\",\"f805004\":\"18\",\"f9701\":\"0201,020101,020102,020105,020114,020310,0204,020408,020601,020712,020714,0208,020801,021007,021008,021009,021308,0214,021404,021405,02140701,022406,0225\",\"f602001\":\"1\",\"f115001\":\"2\",\"f205002\":\"267\",\"f205001\":\"266\",\"f701001\":\"3061649\",\"f404003\":\"workother\",\"f106001\":\"9092\",\"f506001\":\"1\",\"f121003\":\"null\",\"f8807\":\"1\",\"f8803\":\"1\",\"f605001\":\"-1\",\"f605002\":\"0\",\"f112001\":\"05.02.0018\",\"f101001\":\"61649\",\"f503001\":\"4206\",\"time\":\"20200223075435\",\"f302001\":\"15857\",\"f602002\":\"1\"}";
            String f5 = "{\"orderId\":\"taw-587966964240285\",\"f608001\":\"0\",\"f113001\":\"04.03.0013,04.01.0008,04.03.0017\",\"f508002\":\"X9Plus\",\"f806001\":\"9\",\"f508001\":\"vivo\",\"f9914\":\"\",\"f806002\":\"24\",\"f9915\":\"\",\"f806003\":\"7\",\"f830101\":\"null,60574_57480\",\"f9916\":\"02.01.0003&2,02.05&2,02.14&5\",\"f806004\":\"14\",\"f830102\":\"null,9876_23124\",\"f9917\":\"02.01.0003&1,02.05&1,02.14&1\",\"f830103\":\"null,07.10.0004_07.10.0057\",\"f9918\":\"02.01.0003&1,02.05&1,02.14&1\",\"f830104\":\"null\",\"f9919\":\"02.01.0003&8,02.05&8,02.14&6\",\"f104001\":\"79160\",\"f603002\":\"2\",\"f603001\":\"2\",\"f110001\":\"0\",\"f502001\":\"16\",\"f502002\":\"7\",\"f611001\":\"6\",\"f9902\":\"418,8435,7962,6047,7454,6675,9037,7899,5775,8674,8240,489,7607,3458,214,3584,1473,376,8788,7856,1295,7795,5780,9189,3867,8916,8523,8633,1283,4628,8562,7902,7893,8925,8142,8852,4222,3608,3395,4271,3891,3726,471,7606,7860,4771,7422,2773,3714,8404,1182,8334,6025,3835,2090,2788,3837,7811,3812,648,1959,2544,3701,540,7127,7129,7413,7751,9013,5211,9921,2187,410,9033\",\"f505001\":\"2700-4499\",\"f9906\":\"\",\"f9907\":\"\",\"f9908\":\"0\",\"f770102\":\"1\",\"f809001\":\"1\",\"f809002\":\"0\",\"f770501\":\"0\",\"f606002\":\"1\",\"f606001\":\"1\",\"f201001\":\"42014\",\"f102001\":\"02.14.0001\",\"f830001\":\"60574\",\"f830002\":\"9876\",\"f830003\":\"07.10.0004\",\"f830004\":\"\",\"f609001\":\"1\",\"f804004\":\"10\",\"f804003\":\"5\",\"f804002\":\"17\",\"f9930\":\"2\",\"f804001\":\"5\",\"f9931\":\"-1\",\"f301001\":\"16634\",\"f9932\":\"-1\",\"f9933\":\"-1\",\"f9934\":\"-1\",\"f108001\":\"199017\",\"advertId\":\"57480\",\"f807002\":\"22\",\"f9924\":\"02.14,02.05\",\"f807001\":\"8\",\"f507001\":\"3\",\"f807004\":\"13\",\"f830111\":\"null\",\"f807003\":\"6\",\"f830112\":\"null\",\"f9927\":\"0\",\"f810001\":\"null\",\"f770001\":\"07.10.0057\",\"f830113\":\"null\",\"f9928\":\"0\",\"f810002\":\"null\",\"f830114\":\"null\",\"f9929\":\"1\",\"f770401\":\"0\",\"f9921\":\"\",\"f306001\":\"2\",\"f9922\":\"\",\"f770402\":\"0\",\"f9923\":\"02.01.0003\",\"f604002\":\"2\",\"f604001\":\"2\",\"f501001\":\"Android\",\"f610001\":\"0\",\"chargeType\":\"1\",\"f206001\":\"262\",\"f504001\":\"vivo X9Plus\",\"f601001\":\"6\",\"f601002\":\"6\",\"f303001\":\"28\",\"f114001\":\"118\",\"f607001\":\"0\",\"f114002\":\"120\",\"f406001\":\"0\",\"f206002\":\"260\",\"f811001\":\"103\",\"f403004\":\"0\",\"f830011\":\"{0=, 2=, 3=}\",\"f805001\":\"9\",\"f830012\":\"{0=, 2=, 3=}\",\"f805002\":\"38\",\"f830013\":\"{0=, 2=, 3=}\",\"f805003\":\"7\",\"f830014\":\"{0=, 2=, 3=}\",\"f805004\":\"19\",\"f9701\":\"010402,0201,020101,020103,020105,020305,020308,020309,020503,020504,020506,0206,020601,020602,0207,020702,020705,020706,02070602,020710,020711,02071103,020714,020806,0211,02110101,02110102,021107,021118,021119,021120,021213,021308,0214,021404,02140602,02140603,022406,03010401,03011002,03011003,070202\",\"f602001\":\"6\",\"f115001\":\"0\",\"f205002\":\"55\",\"f205001\":\"27\",\"f701001\":\"1057480\",\"f404007\":\"MOBA,ecommerce,teeneducation,roleplaygame,reading,financialproduct,video,finance,shopping\",\"f808002\":\"0_0,02.01.0003_0,02.14_0,02.05_0\",\"f404002\":\"young\",\"f811002\":\"103\",\"f404003\":\"work\",\"f106001\":\"23124\",\"f506001\":\"1\",\"f404004\":\"milldleschool\",\"f121003\":\"null\",\"f8807\":\"1\",\"f808001\":\"0_1,02.01.0003_1,02.14_1,02.05_1\",\"f8803\":\"1\",\"f605001\":\"1\",\"f605002\":\"1\",\"f112001\":\"05.02.0018\",\"f404001\":\"female\",\"f101001\":\"57480\",\"f503001\":\"4403\",\"time\":\"20200223161544\",\"f302001\":\"16634\",\"f602002\":\"6\"}";
            String f6 = "{\"orderId\":\"taw-587957637840666\",\"f608001\":\"1\",\"f113001\":\"04.03.0013,04.01.0008,04.03.0017\",\"f508002\":\"4\",\"f806001\":\"3\",\"f508001\":\"Redmi\",\"f9914\":\"\",\"f806002\":\"32\",\"f9915\":\"\",\"f806003\":\"3\",\"f830101\":\"null,60574_61649,35169_61649,50959_61649,31572_61649,31233_61649\",\"f9916\":\"02.21.0004&10,02.24.0001&12,02.24.0002&10,02.01.0003&12,02.01.0008&11,02.23.0001&13,02.23.0003&11,02.22.0001&13,02.22.0002&10,02.22.0004&11,02.16&13,02.17&12,02.02&10,02.07&10,02.15&11,02.03&13,02.14&13,02.09&12\",\"f806004\":\"17\",\"f830102\":\"null,9876_9092,323_9092,18114_9092,8220_9092,8220_9092\",\"f9917\":\"02.21.0004&1,02.24.0001&1,02.24.0002&1,02.01.0003&9,02.01.0008&1,02.23.0001&1,02.23.0003&1,02.22.0001&9,02.22.0002&1,02.22.0004&1,02.16&9,02.17&1,02.02&1,02.07&1,02.15&1,02.03&9,02.14&1,02.09&1\",\"f830103\":\"null,07.10.0004_07.10.0057,07.24.0013_07.10.0057,07.19.0011_07.10.0057,07.24.0013_07.10.0057,07.24.0013_07.10.0057\",\"f9918\":\"02.21.0004&1,02.24.0001&1,02.24.0002&1,02.01.0003&1,02.01.0008&1,02.23.0001&1,02.23.0003&1,02.22.0001&1,02.22.0002&1,02.22.0004&1,02.16&1,02.17&1,02.02&1,02.07&1,02.15&1,02.03&1,02.14&1,02.09&1\",\"f830104\":\"null\",\"f9919\":\"02.21.0004&4,02.24.0001&1,02.24.0002&4,02.01.0003&1,02.01.0008&2,02.23.0001&1,02.23.0003&2,02.22.0001&1,02.22.0002&4,02.22.0004&3,02.16&1,02.17&1,02.02&4,02.07&4,02.15&3,02.03&1,02.14&1,02.09&1\",\"f104001\":\"86726\",\"f603002\":\"3\",\"f603001\":\"3\",\"f110001\":\"2\",\"f502001\":\"16\",\"f502002\":\"7\",\"f611001\":\"11\",\"f9902\":\"3692,1857,7797,8678,2857,1205,7856,1194,7795,7901,4760,8130,5826,8001,2851,7902,7886,7893,7866,8852,7589,3726,8755,6053,7606,7860,3895,5794,8747,8780,8446,8709,429,5891,1165,2129,7898,3857,7592,7751,1917\",\"f505001\":\"600-1099\",\"f9906\":\"\",\"f9907\":\"\",\"f9908\":\"0\",\"f770102\":\"3\",\"f809001\":\"1\",\"f809002\":\"1\",\"f770501\":\"0\",\"f606002\":\"1\",\"f606001\":\"1\",\"f201001\":\"42211\",\"f102001\":\"02.14.0001\",\"f830001\":\"60574,35169,50959,31572,31233\",\"f830002\":\"9876,323,18114,8220,8220\",\"f830003\":\"07.10.0004,07.24.0013,07.19.0011,07.24.0013,07.24.0013\",\"f830004\":\"6,21,3,6\",\"f609001\":\"1\",\"f804004\":\"19\",\"f804003\":\"6\",\"f804002\":\"37\",\"f9930\":\"10\",\"f804001\":\"8\",\"f9931\":\"-1\",\"f301001\":\"17530\",\"f9932\":\"-1\",\"f9933\":\"-1\",\"f9934\":\"-1\",\"f108001\":\"327457\",\"advertId\":\"61649\",\"f807002\":\"32\",\"f9924\":\"02.01.0003,02.07,02.01.0008,02.24.0001,02.15,02.23.0003,02.23.0001,02.03,02.14,02.02\",\"f807001\":\"5\",\"f507001\":\"3\",\"f807004\":\"17\",\"f830111\":\"null\",\"f807003\":\"5\",\"f830112\":\"null\",\"f9927\":\"0\",\"f810001\":\"null\",\"f770001\":\"07.10.0057\",\"f830113\":\"null\",\"f9928\":\"0\",\"f810002\":\"null\",\"f830114\":\"null\",\"f9929\":\"8\",\"f770401\":\"0\",\"f9921\":\"\",\"f306001\":\"2\",\"f9922\":\"\",\"f770402\":\"0\",\"f9923\":\"02.22.0001,02.22.0002,02.22.0004,02.24.0002,02.17,02.16,02.21.0004,02.09\",\"f604002\":\"12\",\"f604001\":\"-1\",\"f501001\":\"Android\",\"f610001\":\"0\",\"chargeType\":\"1\",\"f206001\":\"262\",\"f504001\":\"Redmi 4\",\"f601001\":\"-1\",\"f601002\":\"9\",\"f303001\":\"28\",\"f607001\":\"1\",\"f406001\":\"3\",\"f206002\":\"260\",\"f811001\":\"106,204\",\"f403004\":\"0\",\"f830011\":\"{0=, 2=, 3=}\",\"f805001\":\"2\",\"f830012\":\"{0=, 2=, 3=}\",\"f805002\":\"34\",\"f830013\":\"{0=, 2=, 3=}\",\"f805003\":\"3\",\"f830014\":\"{0=, 2=, 3=}\",\"f805004\":\"18\",\"f770302\":\"0\",\"f770301\":\"0\",\"f9701\":\"0201,020101,020105,020110,0204,020408,020601,0207,020706,02070602,020710,020714,0208,020801,021213,021308,021312,0215,021504,021507,0225,10603\",\"f602001\":\"-1\",\"f115001\":\"2\",\"f205002\":\"253\",\"f205001\":\"25\",\"f701001\":\"3061649\",\"f404007\":\"news,earnonline\",\"f808002\":\"02.22.0001_1,02.01.0003_1,02.22.0002_0,02.22.0004_0,02.07_0,02.24.0002_0,02.01.0008_0,02.17_0,02.24.0001_0,02.16_1,02.21.0004_0,02.15_0,02.09_0,0_1,02.23.0003_0,02.23.0001_0,02.03_1,02.14_0,02.02_0\",\"f404002\":\"young\",\"f811002\":\"107\",\"f404003\":\"work\",\"f106001\":\"9092\",\"f506001\":\"1\",\"f121003\":\"null\",\"f8807\":\"1\",\"f808001\":\"02.22.0001_2,02.01.0003_2,02.22.0002_1,02.22.0004_1,02.07_1,02.24.0002_1,02.01.0008_1,02.17_1,02.24.0001_1,02.16_2,02.21.0004_1,02.15_1,02.09_1,0_1,02.23.0003_1,02.23.0001_1,02.03_3,02.14_1,02.02_1\",\"f8803\":\"1\",\"f605001\":\"1\",\"f605002\":\"1\",\"f112001\":\"05.02.0018\",\"f101001\":\"61649\",\"f503001\":\"3301\",\"f770202\":\"4\",\"time\":\"20200223160642\",\"f302001\":\"17530\",\"f602002\":\"17\"}";
            String f7 = "{\"orderId\":\"taw-587957740790771\",\"f608001\":\"0\",\"f113001\":\"04.03.0013,04.01.0008,04.03.0017,04.03.0009\",\"f508002\":\"AL10\",\"f806001\":\"5\",\"f508001\":\"SEA\",\"f9914\":\"\",\"f806002\":\"37\",\"f9915\":\"\",\"f806003\":\"5\",\"f830101\":\"null,61786_61802,61681_61802,62077_61802,62077_61802,48099_61802\",\"f9916\":\"02.20.0001&3,02.24.0001&2,02.01.0003&7,02.01.0008&7,02.23.0001&9,02.23.0003&3,02.22.0001&4,02.22.0006&6,02.16&7,02.07&2,02.03&6,02.09&3\",\"f806004\":\"19\",\"f830102\":\"null,22117_26310,26140_26310,26651_26310,26651_26310,9876_26310\",\"f9917\":\"02.20.0001&1,02.24.0001&1,02.01.0003&1,02.01.0008&4,02.23.0001&1,02.23.0003&1,02.22.0001&1,02.22.0006&1,02.16&1,02.07&1,02.03&1,02.09&1\",\"f830103\":\"null,07.10.0055_07.10.0093\",\"f9918\":\"02.20.0001&1,02.24.0001&1,02.01.0003&1,02.01.0008&1,02.23.0001&1,02.23.0003&1,02.22.0001&1,02.22.0006&1,02.16&1,02.07&1,02.03&1,02.09&1\",\"f830104\":\"null\",\"f9919\":\"02.20.0001&7,02.24.0001&8,02.01.0003&6,02.01.0008&9,02.23.0001&5,02.23.0003&7,02.22.0001&6,02.22.0006&6,02.16&6,02.07&8,02.03&6,02.09&7\",\"f104001\":\"87300\",\"f603002\":\"6\",\"f603001\":\"6\",\"f110001\":\"0\",\"f502001\":\"16\",\"f502002\":\"7\",\"f611001\":\"12\",\"f9902\":\"6228,8435,7088,7962,6047,6675,138,7899,4013,9998,2952,7977,7856,2137,7795,1137,1220,9189,8907,5226,5287,6672,7902,7893,2225,7866,8852,1107,7996,64,7589,10841,4359,3726,7606,1201,7860,3902,3650,11175,8780,9347,3835,11543,7984,3701,5086,3888,7129,10193,1215,10655,5253,7751,5211,9921,2946,5293,3955,2187,410,4556\",\"f9906\":\"\",\"f9907\":\"\",\"f9908\":\"0\",\"f770102\":\"1\",\"f809001\":\"2\",\"f809002\":\"1\",\"f770501\":\"0\",\"f606002\":\"1\",\"f606001\":\"1\",\"f201001\":\"67932\",\"f102001\":\"02.14.0001\",\"f830001\":\"61786,61681,62077,62077,48099\",\"f830002\":\"22117,26140,26651,26651,9876\",\"f830003\":\"07.10.0055\",\"f830004\":\"8,8,8,8\",\"f609001\":\"0\",\"f804004\":\"19\",\"f804003\":\"6\",\"f804002\":\"37\",\"f9930\":\"7\",\"f804001\":\"7\",\"f9931\":\"-1\",\"f301001\":\"18010\",\"f9932\":\"-1\",\"f9933\":\"-1\",\"f9934\":\"-1\",\"f108001\":\"321662\",\"advertId\":\"61802\",\"f807002\":\"20\",\"f9924\":\"02.20.0001,02.23.0003,02.01.0003,02.23.0001,02.03,02.07,02.22.0006\",\"f807001\":\"2\",\"f507001\":\"1\",\"f807004\":\"11\",\"f830111\":\"null\",\"f807003\":\"3\",\"f830112\":\"null\",\"f9927\":\"0\",\"f810001\":\"null\",\"f770001\":\"07.10.0093\",\"f830113\":\"null\",\"f9928\":\"0\",\"f810002\":\"null\",\"f830114\":\"null\",\"f9929\":\"3\",\"f770401\":\"0\",\"f9921\":\"\",\"f306001\":\"2\",\"f9922\":\"\",\"f770402\":\"0\",\"f9923\":\"02.22.0001,02.16,02.09\",\"f604002\":\"9\",\"f604001\":\"9\",\"f501001\":\"Android\",\"f610001\":\"0\",\"chargeType\":\"2\",\"f206001\":\"262\",\"f504001\":\"SEA-AL10\",\"f601001\":\"-1\",\"f601002\":\"10\",\"f303001\":\"28\",\"f607001\":\"0\",\"f406001\":\"1\",\"f206002\":\"260\",\"f811001\":\"106,402\",\"f403004\":\"0\",\"f830011\":\"{0=, 2=, 3=}\",\"f805001\":\"5\",\"f830012\":\"{0=, 2=, 3=}\",\"f805002\":\"37\",\"f830013\":\"{0=, 2=, 3=}\",\"f805003\":\"5\",\"f830014\":\"{0=, 2=, 3=}\",\"f805004\":\"19\",\"f9701\":\"01050304,0201,020101,020105,02020301,020207,020208,020210,020310,020408,020601,0207,020702,020706,02070601,02070602,020710,020711,02071103,020714,021119,021213,021308,021312,0214,021404,022406,0225,022601,022602,0301,030104,03010401,03011002,03011003\",\"f602001\":\"-1\",\"f115001\":\"2\",\"f205002\":\"67\",\"f205001\":\"29\",\"f701001\":\"3061802\",\"f808002\":\"02.22.0001_0,02.01.0003_0,02.07_0,02.01.0008_1,02.22.0006_0,02.24.0001_0,02.16_0,02.09_0,0_1,02.20.0001_0,02.23.0003_0,02.23.0001_0,02.03_0\",\"f811002\":\"106\",\"f404003\":\"workother\",\"f106001\":\"26310\",\"f506001\":\"1\",\"f121003\":\"null\",\"f8807\":\"1\",\"f808001\":\"02.22.0001_1,02.01.0003_1,02.07_1,02.01.0008_9,02.22.0006_1,02.24.0001_1,02.16_1,02.09_1,0_2,02.20.0001_1,02.23.0003_1,02.23.0001_1,02.03_1\",\"f8803\":\"1\",\"f605001\":\"1\",\"f605002\":\"1\",\"f112001\":\"05.02.0018\",\"f101001\":\"61802\",\"f503001\":\"4406\",\"time\":\"20200223160653\",\"f302001\":\"18010\",\"f602002\":\"12\"}";
            String f8 = "{\"orderId\":\"taw-587946021910835\",\"f608001\":\"0\",\"f113001\":\"04.03.0013,04.01.0008,04.03.0017,04.03.0009\",\"f508002\":\"Note4X\",\"f806001\":\"5\",\"f508001\":\"Redmi\",\"f9914\":\"\",\"f806002\":\"35\",\"f9915\":\"\",\"f806003\":\"4\",\"f830101\":\"null,54204_61802,61663_61802,62199_61802\",\"f9916\":\"02.01.0003&2,02.23.0001&2,02.19&2,02.14&3\",\"f806004\":\"18\",\"f830102\":\"null,13566_26310,26239_26310,26239_26310\",\"f9917\":\"02.01.0003&1,02.23.0001&1,02.19&2,02.14&11\",\"f830103\":\"null,07.07.0003_07.10.0093,07.10.0073_07.10.0093\",\"f9918\":\"02.01.0003&1,02.23.0001&1,02.19&1,02.14&2\",\"f830104\":\"null\",\"f9919\":\"02.01.0003&8,02.23.0001&8,02.19&9,02.14&10\",\"f104001\":\"87300\",\"f603002\":\"4\",\"f603001\":\"4\",\"f110001\":\"0\",\"f502001\":\"15\",\"f502002\":\"7\",\"f611001\":\"8\",\"f9902\":\"28,30,31,257,437,645,656,658,661,662,668,670,673,678,679,682,684,695,702,703,712,714,720,725,726,729,731,735,740,747,763,789,802,803,817,818,834,839,848,851,855,860,884,888,891,903,905,906,914,915,918,920,921,923,928,934,935,937,939,948,965,970,979,980,991,992,996,997,1009,1018,1019,1022,1029,1041,1045,1046,1047,1165,1194,1205,1215,2105,2128,2129,2385,2436,2437,2456,2458,2712,2763,2781,3112,3657,3891,3950,4283,4368,4760,4787,4788,4793,4845,4871,4876,4878,4879,4880,4883,4884,4887,4888,4889,4890,4891,4892,4893,4894,4895,4898,4901,4902,4903,4904,4907,4908,4909,4910,4911,4916,4921,4922,4924,4925,4926,4929,4931,4932,4933,4934,4935,4938,4941,4942,4943,4944,4945,4947,4948,4951,4952,4955,4956,4959,4960,4961,4962,4964,4965,4994,5888,6067,6071,6079,6092,6094,6099,6101,6106,6108,6110,6114,6122,6123,6127,6128,6130,6131,6133,6135,6136,6137,6139,6154,6160,6161,6163,6164,6173,6179,6194,6195,6196,6205,6212,6213,6216,6231,7008,7009,7010,7011,7129,7461,7606,7608,7694,7841,7856,7860,7866,7899,7906,7980,8254,8704,8705,8711,8717,8718,8720,8724,8730,8733,8735,8737,8749,8750,8751,8752,8754,8756,8758,8760,8763,8852,9027,9037,9796,9799,9802\",\"f505001\":\"600-1099\",\"f9906\":\"\",\"f9907\":\"\",\"f9908\":\"0\",\"f770102\":\"1\",\"f809001\":\"8\",\"f809002\":\"7\",\"f770501\":\"0\",\"f606002\":\"1\",\"f606001\":\"1\",\"f201001\":\"64631\",\"f102001\":\"02.14.0001\",\"f830001\":\"54204,61663,62199\",\"f830002\":\"13566,26239,26239\",\"f830003\":\"07.07.0003,07.10.0073\",\"f830004\":\"16,1,1\",\"f609001\":\"0\",\"f804004\":\"19\",\"f804003\":\"6\",\"f804002\":\"37\",\"f9930\":\"1\",\"f804001\":\"8\",\"f9931\":\"-1\",\"f301001\":\"17572\",\"f9932\":\"-1\",\"f9933\":\"-1\",\"f9934\":\"-1\",\"f108001\":\"319307\",\"advertId\":\"61802\",\"f807002\":\"36\",\"f9924\":\"02.23.0001\",\"f807001\":\"3\",\"f507001\":\"3\",\"f807004\":\"19\",\"f830111\":\"null\",\"f807003\":\"4\",\"f830112\":\"null\",\"f9927\":\"0\",\"f810001\":\"null\",\"f770001\":\"07.10.0093\",\"f830113\":\"null\",\"f9928\":\"1\",\"f810002\":\"null\",\"f830114\":\"null\",\"f9929\":\"1\",\"f770401\":\"0\",\"f9921\":\"\",\"f306001\":\"2\",\"f9922\":\"02.14\",\"f770402\":\"0\",\"f9923\":\"02.01.0003\",\"f604002\":\"4\",\"f604001\":\"4\",\"f501001\":\"Android\",\"f610001\":\"0\",\"chargeType\":\"2\",\"f206001\":\"262\",\"f504001\":\"Redmi Note 4X\",\"f601001\":\"7\",\"f601002\":\"7\",\"f303001\":\"28\",\"f607001\":\"0\",\"f406001\":\"0\",\"f206002\":\"260\",\"f811001\":\"103,403\",\"f403004\":\"0\",\"f830011\":\"{0=62199, 2=, 3=}\",\"f805001\":\"5\",\"f830012\":\"{0=26239, 2=, 3=}\",\"f805002\":\"34\",\"f830013\":\"{0=, 2=, 3=}\",\"f805003\":\"4\",\"f830014\":\"{0=1, 2=, 3=}\",\"f805004\":\"18\",\"f9701\":\",0201,020101,020105,020207,020208,020305,020307,020308,020601,0207,020702,020706,02070602,020714,0208,020801,02110101,02110102,021120,021213,021308,021701\",\"f602001\":\"7\",\"f115001\":\"2\",\"f205002\":\"55\",\"f205001\":\"27\",\"f701001\":\"3061802\",\"f404007\":\"news,teeneducation,ecommerce,reading,video,shopping\",\"f808002\":\"0_7,02.01.0003_0,02.23.0001_0,02.14_8,02.19_1\",\"f404002\":\"young\",\"f811002\":\"103,302\",\"f404003\":\"student\",\"f106001\":\"26310\",\"f506001\":\"2\",\"f404004\":\"milldleschool\",\"f121003\":\"null\",\"f8807\":\"1\",\"f808001\":\"0_8,02.01.0003_1,02.23.0001_1,02.14_12,02.19_12\",\"f8803\":\"1\",\"f605001\":\"1\",\"f605002\":\"1\",\"f112001\":\"05.02.0018\",\"f101001\":\"61802\",\"f503001\":\"4403\",\"time\":\"20200223155437\",\"f302001\":\"17572\",\"f602002\":\"7\"}";
            String f9 = "{\"orderId\":\"taw-587611737880660\",\"f608001\":\"1\",\"f113001\":\"04.03.0013,04.01.0008,04.03.0017\",\"f508002\":\"PBAT00\",\"f806001\":\"7\",\"f508001\":\"\",\"f9914\":\"\",\"f806002\":\"37\",\"f9915\":\"\",\"f806003\":\"6\",\"f830101\":\"null,60870_61649,60809_61649,59308_61649,62071_61649,61086_61649,60574_61649\",\"f9916\":\"02.01.0003&2,02.01.0008&10,02.19&4,02.14&2\",\"f806004\":\"19\",\"f830102\":\"null,25815_9092,25780_9092,24617_9092,26631_9092,25986_9092,9876_9092\",\"f9917\":\"02.01.0003&1,02.01.0008&9,02.19&3,02.14&2\",\"f830103\":\"null,07.07.0007_07.10.0057,07.24.0001_07.10.0057,07.24.0001_07.10.0057,07.24.0001_07.10.0057,07.10.0004_07.10.0057\",\"f9918\":\"02.01.0003&1,02.01.0008&1,02.19&1,02.14&2\",\"f830104\":\"null\",\"f9919\":\"02.01.0003&8,02.01.0008&11,02.19&10,02.14&10\",\"f104001\":\"86726\",\"f603002\":\"1\",\"f603001\":\"1\",\"f110001\":\"0\",\"f502001\":\"10\",\"f502002\":\"7\",\"f611001\":\"1\",\"f9902\":\"8830,8217,3692,7856,1804,7623,4406,8681,10099,8852,7996,7589,3726,1741,7477,7422,6081,7118,3976,5008,7619,5037,1723,5409,1165,5574,5613,7474,1751,2187\",\"f505001\":\"\u5176\u4ed6\",\"f9906\":\"\",\"f9907\":\"\",\"f9908\":\"0\",\"f770102\":\"1\",\"f809001\":\"10\",\"f809002\":\"2\",\"f770501\":\"0\",\"f606002\":\"10\",\"f606001\":\"99\",\"f201001\":\"68496\",\"f102001\":\"02.14.0001\",\"f830001\":\"60870,60809,59308,62071,61086,60574\",\"f830002\":\"25815,25780,24617,26631,25986,9876\",\"f830003\":\"07.07.0007,07.24.0001,07.24.0001,07.24.0001,07.10.0004\",\"f830004\":\"16,8,8,8,8\",\"f609001\":\"1\",\"f804004\":\"19\",\"f804003\":\"6\",\"f804002\":\"37\",\"f9930\":\"0\",\"f804001\":\"7\",\"f9931\":\"-1\",\"f301001\":\"18085\",\"f9932\":\"-1\",\"f9933\":\"-1\",\"f9934\":\"-1\",\"f108001\":\"320092\",\"advertId\":\"61649\",\"f807002\":\"37\",\"f9924\":\"\",\"f807001\":\"7\",\"f507001\":\"3\",\"f807004\":\"19\",\"f830111\":\"null\",\"f807003\":\"6\",\"f830112\":\"null\",\"f9927\":\"0\",\"f810001\":\"null\",\"f770001\":\"07.10.0057\",\"f830113\":\"null\",\"f9928\":\"3\",\"f810002\":\"null\",\"f830114\":\"null\",\"f9929\":\"1\",\"f770401\":\"0\",\"f9921\":\"\",\"f306001\":\"2\",\"f9922\":\"02.01.0008,02.14,02.19\",\"f770402\":\"0\",\"f9923\":\"02.01.0003\",\"f604002\":\"1\",\"f604001\":\"1\",\"f501001\":\"Android\",\"f610001\":\"0\",\"chargeType\":\"2\",\"f206001\":\"262\",\"f504001\":\"PBAT00\",\"f601001\":\"1\",\"f601002\":\"1\",\"f303001\":\"28\",\"f607001\":\"1\",\"f406001\":\"1\",\"f206002\":\"260\",\"f811001\":\"102,403\",\"f403004\":\"0\",\"f830011\":\"{0=, 2=, 3=}\",\"f805001\":\"7\",\"f830012\":\"{0=, 2=, 3=}\",\"f805002\":\"37\",\"f830013\":\"{0=, 2=, 3=}\",\"f805003\":\"6\",\"f830014\":\"{0=, 2=, 3=}\",\"f805004\":\"19\",\"f9701\":\"0201,020101,020102,020105,0204,020408,020601,0207,020706,02070602,020714,0208,020801,0214,021404,022406,0225\",\"f602001\":\"1\",\"f115001\":\"2\",\"f205002\":\"81\",\"f205001\":\"31\",\"f701001\":\"3061649\",\"f404007\":\"news,ecommerce,financialproduct,video,finance,shopping\",\"f808002\":\"0_2,02.01.0003_0,02.14_13,02.01.0008_1,02.19_1\",\"f811002\":\"103,402\",\"f404003\":\"work\",\"f106001\":\"9092\",\"f506001\":\"1\",\"f121003\":\"null\",\"f8807\":\"1\",\"f808001\":\"0_10,02.01.0003_1,02.14_12,02.01.0008_10,02.19_12\",\"f8803\":\"1\",\"f605001\":\"99\",\"f605002\":\"10\",\"f112001\":\"05.02.0018\",\"f101001\":\"61649\",\"f503001\":\"5111\",\"time\":\"20200223101523\",\"f302001\":\"18085\",\"f602002\":\"1\"}";
            List<String> strList = Arrays.asList(f0, f1, f2, f3, f4, f5, f6, f7, f8, f9);
            for (int i = 0; i < 10; ++i) {
                JSONObject featureMap = JSON.parseObject((String)strList.get(i));
                FM modelCvr = StdModelSave.getModelByKeyFromJedis(key2);
                modelCvr.featureParamsTest((Map)featureMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

