package cn.com.duiba.nezha.alg.feature.coder;


import cn.com.duiba.nezha.alg.feature.vo.Feature2;
import com.alibaba.fastjson.JSON;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.Map;

public class FeatureCoderBase2 {

    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(FeatureCoderBase2.class);


    public static int getVectorSize(List<Integer> pLenList) {
        int ret = 0;
        if (pLenList != null && pLenList.size() > 0) {
            Integer tmp = pLenList.get(pLenList.size() - 1);
            if (tmp != null) {
                ret = tmp;
            }
        }
        return ret;
    }


    public static Feature2 getIdWithSeq(String feature, int fId) throws Exception {
        Feature2 ret = new Feature2(feature, fId);
        return ret;

    }


    public static Feature2 getIdsWithSeq(String feature, int[] sFIds) throws Exception {
        Feature2 ret = new Feature2(feature, sFIds);
        return ret;
    }


    public static Feature2 getValuesWithSeq(String feature, double[] sFIds) throws Exception {
        Feature2 ret = new Feature2(feature, sFIds);
        return ret;
    }


    public static Feature2 getSubIdWithSeq(String feature, String fStr, int fSize) throws Exception {


        int fId = FeatureUtil.getSubFId(feature, fStr, fSize);

        return getIdWithSeq(feature, fId);

    }


    public static Feature2 getSubIdsWithSeq(String feature, String fStr, String seq, int fSize) throws Exception {

        String[] fStrs = FeatureUtil.toFeatures(fStr, seq);
        int[] sFIds = FeatureUtil.getSubFIdsWithSeq(feature, fStrs, fSize);

        return getIdsWithSeq(feature, sFIds);
    }


    public static Feature2 getHashSubIdWithSeq(String feature, String fStr, int fSize) throws Exception {
//        Set<Long> ret = new HashSet<>();
        int[] sFIds = FeatureUtil.getHashSubFIdNotSort(feature, fStr, fSize, 1);
        return getIdsWithSeq(feature, sFIds);
    }


    public static Feature2 getHashSubIdsWithSeq(String feature, String fStr, String seq, int fSize) throws Exception {

        String[] fStrs = FeatureUtil.toFeatures(fStr, seq);

        int[] sFIds = FeatureUtil.getHashSubFIdsWithSeq(feature, fStrs, fSize, 1);

        return getIdsWithSeq(feature, sFIds);
    }


    public static Feature2 getDictSubIdWithSeq(String feature, String fStr, int fSize, Map<String, Integer> fDict) throws Exception {

        int fId = FeatureUtil.getDictSubFId(feature, fStr, fSize, fDict);

        return getIdWithSeq(feature, fId);
    }


    public static Feature2 getDictSubIdsWithSeq(String feature, String fStr, String seq, int fSize, Map<String, Integer> fDict) throws Exception {

        String[] fStrs = FeatureUtil.toFeatures(fStr, seq);

        int[] sFIds = FeatureUtil.getDictSubFIdsWithSeq(feature, fStrs, fSize, fDict);

        return getIdsWithSeq(feature, sFIds);
    }


    public static Feature2 getEmbeddingSubIds(String feature, String fStr, String seq, int fSize) throws Exception {

        String[] fStrs = FeatureUtil.toFeatures(fStr, seq);
        double[] sFIds = FeatureUtil.getEmbeddingValuesWithSeq(fStrs, fSize);
        return getValuesWithSeq(feature, sFIds);

    }


}