package cn.com.duiba.nezha.alg.feature.coder;


import cn.com.duiba.nezha.alg.feature.type.FeatureBaseType;
import cn.com.duiba.nezha.alg.feature.vo.CodeResult;
import cn.com.duiba.nezha.alg.feature.vo.FeatureCodeInfo;
import com.alibaba.fastjson.JSON;

import java.util.*;

public class FeatureCoder extends FeatureCoderBase {


    public static Map<String, List<FeatureBaseType>> cache = new HashMap<>();

    public static CodeResult code(List<FeatureBaseType> list, Map<String, String> featureMap) throws Exception {

        CodeResult codeResult = new CodeResult();

        List<Integer> indices = new ArrayList<>();
        List<Double> values = new ArrayList<>();
        List<String> fields = new ArrayList<>();
        List<Long> pLenList = new ArrayList<>();
        List<Set<Long>> ret = new ArrayList<>();

        for (FeatureBaseType featureBaseType : list) {

            String value = featureMap.getOrDefault(featureBaseType.getName(), null);
            Set<Long> retSub = featureBaseType.code(value, pLenList, indices, values);
            ret.add(retSub);
            for (int i = 0; i < retSub.size(); i++) {
                fields.add(featureBaseType.getName());
            }
//            System.out.println("info="+JSON.toJSONString(info));
//            System.out.println("indices="+JSON.toJSONString(indices));
//            System.out.println("values="+JSON.toJSONString(values));
//            System.out.println("pLenList="+ JSON.toJSONString(pLenList));
        }

        codeResult.setFeature(FeatureCoderBase.toFeature(indices, values, pLenList, fields));
        codeResult.setFeatureSet(ret);
        return codeResult;
    }


    public static void main(String[] args) {
        Map<String, String> featureMap = new HashMap<>();
        featureMap.put("f101001", "3");
        featureMap.put("f102001", "d3,3");
        featureMap.put("f305001", "8");
        featureMap.put("f501001", "UNKONWN");

    }

}
