package cn.com.duiba.nezha.alg.feature.coder;


import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.type.FeatureBaseType;
import cn.com.duiba.nezha.alg.feature.vo.FeatureCode;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import com.alibaba.fastjson.JSON;
import org.slf4j.LoggerFactory;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FeatureCoder3 extends FeatureCoderBase {
    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(FeatureCoder3.class);
    private static int F_MAX_SIZE = 128;

    public static Map tmpMap = new HashMap<>();


    public static <T> Map<T, Map<String, FeatureCode>> codeOfEachFieldWithSeq(List<FeatureBaseType> list, Map<T, FeatureMapDo> sampleMap, Map<String, Map<String, FeatureCode>> tmpCoderCache) throws Exception {

        Map<T, Map<String, FeatureCode>> ret = new HashMap<>();

        if (AssertUtil.isNotEmpty(sampleMap)) {

            for (Map.Entry<T, FeatureMapDo> entry : sampleMap.entrySet()) {

                T key = entry.getKey();
                FeatureMapDo featureMapDo = entry.getValue();

                if (featureMapDo != null) {
                    Map<String, FeatureCode> subRet = codeOfEachFieldWithSeq(list, featureMapDo.getStaticFeatureMap(), featureMapDo.getDynamicFeatureMap(), tmpCoderCache);

                    if (subRet != null) {
                        ret.put(key, subRet);
//                        System.out.println("key=" + key +"，"+ JSON.toJSONString(subRet));
                    }
                }
            }
        }

        return ret;

    }


    public static Map<String, FeatureCode> codeOfEachFieldWithSeq(List<FeatureBaseType> list, Map<String, String> staticFeatureMap, Map<String, String> dynamicFeatureMap, Map<String, Map<String, FeatureCode>> tmpCoderCache) throws Exception {
        Map<String, FeatureCode> ret = new HashMap<>(F_MAX_SIZE);

        if (staticFeatureMap == null) {
            staticFeatureMap = tmpMap;
        }

        if (dynamicFeatureMap == null) {
            dynamicFeatureMap = tmpMap;
        }


        for (FeatureBaseType featureBaseType : list) {

            String fieldName = featureBaseType.getName();

            String value = dynamicFeatureMap.get(fieldName) == null ? staticFeatureMap.get(fieldName) : dynamicFeatureMap.get(fieldName);

            if (tmpCoderCache.get(fieldName) == null) {
                tmpCoderCache.put(fieldName, new HashMap<>());
            }

            if (tmpCoderCache.get(fieldName).get(value) == null) {
                FeatureCode retTmp = featureBaseType.codeWithSeq(value);
                tmpCoderCache.get(fieldName).put(value, retTmp);
            }
            FeatureCode retSub = tmpCoderCache.get(fieldName).get(value);
//            System.out.println(JSON.toJSONString(tmpCoderCache.get(fieldName).get(value)));
            ret.put(fieldName, retSub);

        }

        return ret;
    }


    public static void main(String[] args) {
        Map<String, String> featureMap = new HashMap<>();
//        featureMap.put("f101001", "2");
        featureMap.put("f101002", "null");
        featureMap.put("f101003", "0.5,0.8,0.9,1.0");
        featureMap.put("f305001", "8");
        featureMap.put("f501001", "UNKONWN");
        featureMap.put(null, "2");


        FeatureBaseType featureBaseType1 = new FeatureBaseType();
        featureBaseType1.setCodeType(11);
        featureBaseType1.setName("f101001");
        featureBaseType1.setDenseLen(10000);
        featureBaseType1.setSubLen(1000000);
        featureBaseType1.setHashNums(1);
        featureBaseType1.setSeq(",");

        FeatureBaseType featureBaseType2 = new FeatureBaseType();
        featureBaseType2.setCodeType(21);
        featureBaseType2.setName("f101002");
        featureBaseType2.setDenseLen(10000);
        featureBaseType2.setSubLen(100000);
        featureBaseType2.setHashNums(1);
        featureBaseType2.setSeq(",");


        FeatureBaseType featureBaseType3 = new FeatureBaseType();
        featureBaseType3.setCodeType(41);
        featureBaseType3.setName("f101003");
        featureBaseType3.setDenseLen(100);
        featureBaseType3.setSubLen(3);
        featureBaseType3.setHashNums(1);
        featureBaseType3.setSeq(",");


        List<FeatureBaseType> list = Arrays.asList(featureBaseType1, featureBaseType2, featureBaseType3);

        System.out.println(JSON.toJSONString(featureMap));

        FeatureMapDo featureMapDo = new FeatureMapDo();
        featureMapDo.setStaticFeatureMap(featureMap);
        Map<String, FeatureMapDo> featureMapDoMap = new HashMap<>();

        featureMapDoMap.put("000", featureMapDo);
        try {

//            System.out.println(JSON.toJSONString(FeatureNewCoder2.codeOfEachFieldWithSeq(list, featureMapDoMap)));

//            System.out.println(JSON.toJSONString(FeatureNewCoder2.codeOfEachFieldWithSeq(list, featureMapDoMap)));

//            System.out.println(JSON.toJSONString(FeatureNewCoder2.codeOfEachFieldWithSeqForOne(list, featureMap)));


            Map<Integer, String> map = new HashMap<>();

            Integer key = 10;
            int key2 = 10;
            map.put(key, "1999");

            System.out.println(map.getOrDefault(10, "null"));

        } catch (Exception e) {

            System.out.println(e);

        }


    }

}
