package cn.com.duiba.nezha.alg.feature.type;

import cn.com.duiba.nezha.alg.feature.coder.FeatureCoderBase;

import java.util.List;
import java.util.Set;

public class FeatureHashType extends FeatureBaseType {

    public FeatureHashType(String name, int subLen,int hashNums, String seq) {
        setName(name);
        setSubLen(subLen);
        setHashNums(hashNums);
        setSeq(seq);
    }


    @Override
    public Set<Integer> code(String featureValue, List<Integer> pLenList, List<Integer> indices, List<Double> values) throws Exception {
        Set<Integer> ret = null;

        if (this.seq == null) {
            ret = FeatureCoderBase.getHashSubId(this.name, featureValue, this.subLen, this.hashNums, pLenList, indices, values);
        } else {
            ret = FeatureCoderBase.getHashSubIds(this.name, featureValue, this.seq, this.subLen, this.hashNums, pLenList, indices, values);
        }
        return ret;
    }


}
