
package cn.com.duiba.nezha.alg.feature.vo;

import lombok.Data;

import java.io.Serializable;
import java.util.Map;

@Data
public class SlotActFeature implements Serializable {
    private static final long serialVersionUID = -163060906641491916L;

    private Long slotId;  // 广告位id

    // 发券
    private String launchCntRatioTrade; // f210001 历史不同行业上发券占比
    private String launchCntRatioAccount;   // f210002 历史不同广告主上发券占比
    private String weekLaunchCntRatioTrade; // f210003 一周内不同行业上发券占比
    private String weekLaunchCntRatioAccount;   // f210004  一周内不同广告主上发券占比

    // 点击
    private String clickCntRatioTrade;  // f211001  历史不同行业上点击占比
    private String clickCntRatioAccount;    // f211002  历史不同广告主上点击占比
    private String weekClickCntRatioTrade;  // f211003  一周内不同行业上点击占比
    private String weekClickCntRatioAccount;    // f211004  一周内不同广告主上点击占比

    private String ctrTrade;    // f212001  历史不同行业上点击率
    private String ctrAccount;  // f212002  历史不同广告主上点击率
    private String weekCtrTrade;    // f212003  一周内不同行业上点击率
    private String weekCtrAccount;  // f212004  一周内不同广告主上点击率

    // 前端转化
    private String convertCntRatioTrade;    // f213001  历史不同行业上转化占比
    private String convertCntRatioAccount;  // f213002  历史不同广告主上转化占比
    private String weekConvertCntRatioTrade;    // f213003  一周内不同行业上转化占比
    private String weekConvertCntRatioAccount;  // f213004  一周内不同广告主上转化占比

    private String cvrTrade;    // f214001  历史不同行业上转化率
    private String cvrAccount;  // f214002  历史不同广告主上转化率
    private String weekCvrTrade;    // f214003  一周内不同行业上转化率
    private String weekCvrAccount;  // f214004  一周内不同广告主上转化率

    private String weekExposeTradeCnt; // 一周内不同行业上券曝光数
    private String weekExposeAccountCnt; // 一周内不同广告主上券曝光数
    private String weekExposeAdvertCnt; // 一周内不同广告上券曝光数
    private String weekClickTradeCnt; // 一周内不同行业上有效券点击数
    private String weekClickAccountCnt; // 一周内不同广告主上有效券点击数
    private String weekClickAdvertCnt; // 一周内不同广告上有效券点击数
    private String weekConversionTradeCnt; // 一周内不同行业上转化数
    private String weekConversionAccountCnt; // 一周内不同广告主上转化数
    private String weekConversionAdvertCnt; // 一周内不同广告上转化数

    // 二类电商行为
    // 发券
    private String launchCntRatioCate;  // f220001  历史二类电商不同品类发券数量占比
    private String weekLaunchCntRatioCate;  // f220002  一周内二类电商不同品类发券数量占比

    // 点击
    private String clickCntRatioCate;   // f221001  历史二类电商不同品类点击数量占比
    private String weekClickCntRatioCate;   // f221002  一周内二类电商不同品类点击数量占比

    private String ctrCate; // f221003  历史二类电商不同品类点击率
    private String weekCtrCate; // f221004  一周内二类电商不同品类点击率

    // 转化
    private String convertCntRatioCate; // f222001 历史二类电商不同品类转化数量占比
    private String weekConvertCntRatioCate; // f222002  一周内二类电商不同品类转化数量占比

    private String cvrCate; // f222003  历史二类电商不同品类转化率
    private String weekCvrCate; // f222004  一周内二类电商不同品类转化率
    private String convertAdSet;    // f222005  一周内二类电商转化广告集合（可能过长）

    // 核单
    private String issueCntRatioCate;   // f223001  历史二类电商不同品类核单数量占比
    private String issueCntRatioAccount;    // f223002  历史二类电商不同广告主核单数量占比
    private String weekIssueCntRatioCate;   // f223003  一周内二类电商不同品类核单数量占比
    private String weekIssueCntRatioAccount;    // f223004  一周内二类电商不同广告主核单数量占比

    private String issueRatioCate;  // f223005  历史二类电商不同品类核单率
    private String issueRatioAccount;   // f223006  历史二类电商不同广告主核单率
    private String weekIssueRatioCate;  // f223007  一周内二类电商不同品类核单率
    private String weekIssueRatioAccount;   // f223008  一周内二类电商不同广告主核单率
    private String issueAdSet;  // f223009  历史二类电商核单广告集合

    // 签收
    private String signCntRatioCate;    // f224001  历史二类电商不同品类签收数量占比
    private String signCntRatioAccount; // f224002  历史二类电商不同广告主签收数量占比

    private String signRatioCate;   // f224003  历史二类电商不同品类签收率
    private String signRatioAccount;    // f224004  历史二类电商不同广告主签收率
    private String signAdSet;   // f224005  历史二类电商签收广告集合

    // 消费
    private String priceRegionCntRatio; // f225001  历史不同金额区间数量占比（签收成功）
    private Double avgPrice;    // f225002 历史平均下单实际金额（签收成功）

    private Double zeroClickCntRatio;   // f225003  历史展示金额为0的商品券点击占比
    private Double zeroConvertCntRatio; // f225004  历史展示金额为0的商品前端转化次数占比
    private Double zeroIssueCntRatio;   // f225005  历史展示金额为0的商品出单转化次数占比
    private Double zeroSignCntRatio;    // f225006   历史展示金额为0的商品签收次数占比

    // 风控
    private Double vouchFailedCntRatio; // f226001  历史累计出单失败占比
    private Double weekVouchFailedCntRatio; // f226002  一周内累计出单失败占比
    private Double rejectCntRatio;  // f226003  历史拒付费占比
    private Double weekRejectCntRatio;  // f226004  一周内拒付费占比
    private Double addressExpCntRatio;  // f226005  历史地址异常占比
    private Double weekAddressExpCntRatio;  // f226006  一周内地址异常占比
    private Double numberEmptyCntRatio; // f226007  历史空号/错号占比
    private Double weekNumberEmptyCntRatio; // f226008  一周内空号/错号占比

    // 活动
    private String activityTypeCtr; // f230001	历史不同活动类型上的点击率
    private String weekActivityTypeCtr; // f230002	一周内不同活动类型上的点击率
    private String activityDesignCtr; // f230003	历史不同活动设计风格上的点击率
    private String weekActivityDesignCtr; // f230004	一周内不同活动设计风格上的点击率
    private String activitySceneCtr; // f230005	历史不同活动场景标签上的点击率
    private String weekActivitySceneCtr; // f230006	一周内不同活动场景标签上的点击率
    private String activityFestivalCtr; // f230007	历史不同活动节日标签上的点击率
    private String weekActivityFestivalCtr; // f230008	一周内不同活动节日标签上的点击率
    private String activitySkinCtr; // f230009	历史不同活动皮肤类型上的点击率
    private String weekActivitySkinCtr; // f230010	一周内不同活动皮肤类型上的点击率

    private String activityTypeCvr; // f231001	历史不同活动类型上的转化率
    private String weekActivityTypeCvr; // f231002	一周内不同活动类型上的转化率
    private String activityDesignCvr; // f231003	历史不同活动设计风格上的转化率
    private String weekActivityDesignCvr; // f231004	一周内不同活动设计风格上的转化率
    private String activitySceneCvr; // f231005	历史不同活动场景标签上的转化率
    private String weekActivitySceneCvr; // f231006	一周内不同活动场景标签上的转化率
    private String activityFestivalCvr; // f231007	历史不同活动节日标签上的转化率
    private String weekActivityFestivalCvr; // f231008	一周内不同活动节日标签上的转化率
    private String activitySkinCvr; // f231009	历史不同活动皮肤类型上的转化率
    private String weekActivitySkinCvr; // f231010	一周内不同活动皮肤类型上的转化率



    // 流量活动参与
    private String appSlotActsCateHistClick;   //f230001 历史不同活动类型上的参与率
    private String appSlotActsCateWeekClick;   //f230002 一周内不同活动类型上的参与率
    private Map<String, Double> appSlotActsCateDayClick;   //f230003 当日不同活动类型上的参与率
    private String appSlotMainTitlesHistClick;    //f230004 历史不同主标题上的参与率
    private String appSlotMainTitlesWeekClick;    //f230005 一周内不同主标题上的参与率
    private Map<String, Double> appSlotMainTitlesDayClick;    //f230006 当日不同主标题上的参与率
    private String appSlotSubTitlesHistClick; //f230007 历史不同副标题上的参与率
    private String appSlotSubTitlesWeekClick; //f230008 一周内不同副标题上的参与率
    private Map<String, Double> appSlotSubTitlesDayClick; //f230009 当日不同副标题上的参与率
    private String appSlotPrizeHistClick;  //f230010 历史不同奖品上的参与率
    private String appSlotPrizeWeekClick;  //f230011 一周内不同奖品上的参与率
    private Map<String, Double> appSlotPrizeDayClick;  //f230012 当日不同奖品上的参与率
    private String appSlotSkinCateHistClick;   //f230013 历史不同活动皮肤类型上的参与率
    private String appSlotSkinCateWeekClick;   //f230014 一周内不同活动皮肤类型上的参与率
    private Map<String, Double> appSlotSkinCateDayClick;   //f230015 当日不同活动皮肤类型上的参与率
    private String appSlotMediaCateHistClick; //f230016 历史不同行业标签（媒体）类型上的参与率
    private String appSlotMediaCateWeekClick; //f230017 一周内不同行业标签（二级媒体）类型上的参与率
    private Map<String, Double> appSlotMediaCateDayClick; //f230018 当日不同行业标签（二级媒体）类型上的参与率

    // 流量落地页转化
    private String appSlotActsCateHistOrder;   //f231001 历史不同活动类型上的每UV券点击率
    private String appSlotActsCateWeekOrder;   //f231002 一周内不同活动类型上的每UV券点击率
    private Map<String, Double> appSlotActsCateDayOrder;   //f231003 当日不同活动类型上的每UV券点击率
    private String appSlotMainTitlesHistOrder;    //f231004 历史不同主标题上的每UV券点击率
    private String appSlotMainTitlesWeekOrder;    //f231005 一周内不同主标题上的每UV券点击率
    private Map<String, Double> appSlotMainTitlesDayOrder;    //f231006 当日不同主标题上的每UV券点击率
    private String appSlotSubTitlesHistOrder; //f231007 历史不同副标题上的每UV券点击率
    private String appSlotSubTitlesWeekOrder; //f231008 一周内不同副标题上的每UV券点击率
    private Map<String, Double> appSlotSubTitlesDayOrder; //f231009 当日不同副标题上的每UV券点击率
    private String appSlotPrizeHistOrder;  //f231010 历史不同奖品上的每UV券点击率
    private String appSlotPrizeWeekOrder;  //f231011 一周内不同奖品上的每UV券点击率
    private Map<String, Double> appSlotPrizeDayOrder;  //f231012 当日不同奖品上的每UV券点击率
    private String appSlotSkinCateHistOrder;   //f231013 历史不同活动皮肤类型上的每UV券点击率
    private String appSlotSkinCateWeekOrder;   //f231014 一周内不同活动皮肤类型上的每UV券点击率
    private Map<String, Double> appSlotSkinCateDayOrder;   //f231015 当日不同活动皮肤类型上的每UV券点击率
    private String appSlotMediaCateHistOrder; //f231016 历史不同行业标签（媒体）类型上的每UV券点击率
    private String appSlotMediaCateWeekOrder; //f231017 一周内不同行业标签（二级媒体）类型上的每UV券点击率
    private Map<String, Double> appSlotMediaCateDayOrder; //f231018 当日不同行业标签（二级媒体）类型上的每UV券点击率

    // 广告位UV消耗
    private String appSlotActsCateHistConsumer;   //f232001 历史不同活动类型上的每UV消耗
    private String appSlotActsCateWeekConsumer;   //f232002 一周内不同活动类型上的每UV消耗

    // 流量行为
    private Map<String, Double> dayTradeClickPart;  //f211005	当日不同行业上点击率
    private Map<String, Double> dayAccountClickPart;  //f212006	当日不同广告主上点击率
    private Map<String, Double> dayTradeClickRate; //f212005	当日不同行业上点击率
    private Map<String, Double> dayAccountClickRate; //f212006	当日不同广告主上点击率
    private Map<String, Double> dayTradeOrderPart;  //f213005	当日不同行业上转化率
    private Map<String, Double> dayAccountOrderPart;  //f213005	当日不同广告主上转化率
    private Map<String, Double> dayTradeOrderRate;  //f214005	当日不同行业上转化率
    private Map<String, Double> dayAccountOrderRate;  //f214005	当日不同广告主上转化率
}